/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.broker;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.lagis.broker.LagisBroker;
import java.util.Collection;
import org.apache.log4j.Logger;

public final class CidsBroker
implements ConnectionContextProvider {
    private static CidsBroker instance = null;
    private static final Logger LOG = Logger.getLogger(CidsBroker.class);
    private final ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)this.getClass().getCanonicalName());
    private ConnectionProxy proxy = null;

    private CidsBroker() {
        try {
            this.setProxy(SessionManager.getProxy());
            if (!SessionManager.isInitialized()) {
                SessionManager.init((ConnectionProxy)this.getProxy());
                ClassCacheMultiple.setInstance((String)"LAGIS");
            }
        }
        catch (Throwable e) {
            LOG.fatal((Object)"no connection to the cids server possible. too bad.", e);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private ConnectionProxy getProxy() {
        return this.proxy;
    }

    private void setProxy(ConnectionProxy proxy) {
        this.proxy = proxy;
    }

    public static synchronized CidsBroker getInstance() {
        if (instance == null) {
            instance = new CidsBroker();
        }
        return instance;
    }

    public MetaObject[] getLagisLWMetaObjects(String tabName, String query, final String[] fields, AbstractAttributeRepresentationFormater formatter) {
        if (formatter == null) {
            formatter = new AbstractAttributeRepresentationFormater(){

                public String getRepresentation() {
                    StringBuffer sb = new StringBuffer();
                    for (String attribute : fields) {
                        sb.append(this.getAttribute(attribute.toLowerCase())).append(" ");
                    }
                    return sb.toString().trim();
                }
            };
        }
        try {
            User user = SessionManager.getSession().getUser();
            MetaClass mc = this.getLagisMetaClass(tabName);
            ConnectionProxy proxy = this.getProxy();
            if (mc != null) {
                return proxy.getLightweightMetaObjectsByQuery(mc.getID(), user, query, fields, formatter);
            }
            LOG.error((Object)("Can not find MetaClass for Tablename: " + tabName));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return new MetaObject[0];
    }

    public Collection executeSearch(CidsServerSearch search) throws ConnectionException {
        return this.proxy.customServerSearch(search, this.getConnectionContext());
    }

    public Object executeTask(String taskname, Object body, ServerActionParameter ... params) throws ConnectionException {
        return this.proxy.executeTask(taskname, "LAGIS", body, this.getConnectionContext(), params);
    }

    public MetaClass getLagisMetaClass(String tablename) {
        return this.getMetaClass(tablename, LagisBroker.getInstance().getDomain());
    }

    public MetaClass getMetaClass(String tablename, String domain) {
        try {
            return CidsBean.getMetaClassFromTableName((String)domain, (String)tablename, (ConnectionContext)this.getConnectionContext());
        }
        catch (Exception exception) {
            LOG.error((Object)("couldn't load metaclass for " + tablename), (Throwable)exception);
            return null;
        }
    }

    public MetaObject getLagisMetaObject(int objectId, int classtId) {
        return this.getMetaObject(objectId, classtId, LagisBroker.getInstance().getDomain());
    }

    public MetaObject getMetaObject(int objectId, int classtId, String domain) {
        try {
            ConnectionProxy proxy = this.getProxy();
            return proxy.getMetaObject(objectId, classtId, domain);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)("error in retrieving the metaobject " + objectId + " of classid " + classtId), (Throwable)ex);
            return null;
        }
    }

    public MetaObject[] getLagisMetaObject(String query) {
        return this.getMetaObject(query, LagisBroker.getInstance().getDomain());
    }

    public MetaObject[] getMetaObject(String query, String domain) {
        MetaObject[] mos = null;
        try {
            User user = SessionManager.getSession().getUser();
            ConnectionProxy proxy = this.getProxy();
            mos = proxy.getMetaObjectByQuery(user, query, domain, this.getConnectionContext());
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"error retrieving metaobject by query", (Throwable)ex);
        }
        return mos;
    }
}

