/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.broker;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.remote.AbstractRESTRemoteControlMethod;
import javax.swing.SwingWorker;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

@Path(value="/loadMeldung")
public class LoadMeldungRemoteMethod
extends AbstractRESTRemoteControlMethod {
    private static final Logger LOG = Logger.getLogger(LoadMeldungRemoteMethod.class);
    @Context
    private UriInfo context;

    public LoadMeldungRemoteMethod() {
        super(-1, "/loadMeldung");
    }

    @GET
    @Produces(value={"text/html"})
    public String loadFlurstueck(final @QueryParam(value="id") Integer id) {
        try {
            String host = this.context.getBaseUri().getHost();
            if (!host.equals("localhost") && !host.equals("127.0.0.1")) {
                LOG.info((Object)("Keine Request von remote rechnern m\u00f6glich: " + host));
                return "<html>Es k\u00f6nnen nur Requests vom lokalen Rechner abgesetzt werden. Die gew\u00fcnschte Meldung kann nicht ge\u00f6ffnet werden.</html>";
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim bestimmen des Hosts Request nicht m\u00f6glich", (Throwable)ex);
            return "<html>Der Host konnte nicht bestimmt werden. Die gew\u00fcnschte Meldung kann nicht ge\u00f6ffnet werden.</html>";
        }
        if (LagisBroker.getInstance().isLoggedIn()) {
            new SwingWorker<CidsBean, Void>(){

                @Override
                protected CidsBean doInBackground() throws Exception {
                    return CidsBroker.getInstance().getLagisMetaObject(id, CidsBroker.getInstance().getLagisMetaClass("MELDUNG").getId()).getBean();
                }

                @Override
                protected void done() {
                    try {
                        CidsBean meldungBean = (CidsBean)this.get();
                        LagisApp.getInstance().getMeldungenPanel().showMeldung(null);
                        LagisApp.getInstance().getMeldungenPanel().showMeldung(meldungBean);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }.execute();
            return "<html>Meldung wird in LagIS geladen...</html>";
        }
        return "<html>Meldung kann nicht geladen werden. Benutzer ist noch nicht in LagIS eingeloggt.</html>";
    }
}

