/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.config;

import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserGroup;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.tools.configuration.ConfigAttrProvider;
import org.apache.log4j.Logger;

public final class ConfigAttrProviderImpl
implements ConfigAttrProvider {
    private static final transient Logger LOG = Logger.getLogger(ConfigAttrProviderImpl.class);

    public String getUserConfigAttr(String key) {
        ConnectionSession session = LagisBroker.getInstance().getSession();
        if (session == null) {
            throw new IllegalStateException("no session available");
        }
        try {
            return session.getConnection().getConfigAttr(session.getUser(), key);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)("could not get user config attr for key: " + key), (Throwable)ex);
            return null;
        }
    }

    public String getGroupConfigAttr(String key) {
        ConnectionSession session = LagisBroker.getInstance().getSession();
        if (session == null) {
            throw new IllegalStateException("no session available");
        }
        try {
            User user = session.getUser();
            User queryUser = new User(-1, "", user.getDomain(), user.getUserGroup());
            return session.getConnection().getConfigAttr(queryUser, key);
        }
        catch (ConnectionException e) {
            LOG.error((Object)("could not get group config attr for key: " + key), (Throwable)e);
            return null;
        }
    }

    public String getDomainConfigAttr(String key) {
        ConnectionSession session = LagisBroker.getInstance().getSession();
        if (session == null) {
            throw new IllegalStateException("no session available");
        }
        try {
            User user = session.getUser();
            UserGroup queryUg = new UserGroup(-1, "", user.getUserGroup().getDomain());
            User queryUser = new User(-1, "", user.getDomain(), queryUg);
            return session.getConnection().getConfigAttr(queryUser, key);
        }
        catch (ConnectionException e) {
            LOG.error((Object)("could not get domain config attr for key: " + key), (Throwable)e);
            return null;
        }
    }
}

