/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.editor;

import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.documents.DateDocumentModel;
import de.cismet.lagis.validation.Validatable;
import de.cismet.lagis.validation.Validator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import org.apache.log4j.Logger;

public class DateEditor
extends DefaultCellEditor {
    JTextField txtDate;
    DateFormat dateFormat = LagisBroker.getDateFormatter();
    private final Logger log = Logger.getLogger(this.getClass());
    private Integer minimum;
    private Integer maximum;
    private boolean DEBUG = false;
    private Validator validator;

    public DateEditor() {
        super(new JTextField());
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (DateEditor.this.log.isDebugEnabled()) {
                    DateEditor.this.log.debug((Object)"setValue");
                }
                if (value instanceof Date) {
                    DateEditor.this.txtDate.setText(value != null ? DateEditor.this.dateFormat.format((Date)value) : "");
                } else {
                    DateEditor.this.txtDate.setText(value != null ? value.toString() : "");
                }
            }

            @Override
            public Object getCellEditorValue() {
                return DateEditor.this.txtDate.getText();
            }
        };
        this.txtDate = (JTextField)this.getComponent();
        this.txtDate.setDocument(new DateDocumentModel());
        this.validator = new Validator(this.txtDate);
        this.validator.reSetValidator((Validatable)((Object)this.txtDate.getDocument()));
        DateFormatter dateFormatter = new DateFormatter();
        dateFormatter.setFormat(this.dateFormat);
        this.txtDate.setHorizontalAlignment(0);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"getCellEditorValue");
        }
        JTextField txtDate = (JTextField)this.getComponent();
        String t = txtDate.getText();
        try {
            if (this.validator.getValidationState() == 0 && t != null && t.length() != 0) {
                return this.dateFormat.parse(t);
            }
            return null;
        }
        catch (ParseException exc) {
            this.log.warn((Object)"Fehler beim Parsen des Datum: ", (Throwable)exc);
            return t;
        }
    }

    public int getValidationState() {
        return this.validator.getValidationState();
    }

    public String getText() {
        return this.txtDate.getText();
    }
}

