/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.editor;

import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.documents.AmountDocumentModel;
import de.cismet.lagis.validation.Validatable;
import de.cismet.lagis.validation.Validator;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;

public class EuroEditor
extends DefaultCellEditor {
    NumberFormat nf = NumberFormat.getCurrencyInstance(Locale.GERMANY);
    DecimalFormat df = LagisBroker.getCurrencyFormatter();
    JTextField txtEuro;
    DecimalFormat euroFormat = LagisBroker.getCurrencyFormatter();
    private final Logger log = Logger.getLogger(this.getClass());
    private Integer minimum;
    private Integer maximum;
    private boolean DEBUG = false;
    private Validator validator;

    public EuroEditor() {
        super(new JTextField());
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value instanceof Number) {
                    EuroEditor.this.txtEuro.setText(value != null ? EuroEditor.this.nf.format((Number)value) : "");
                } else {
                    EuroEditor.this.txtEuro.setText(value != null ? value.toString() : "");
                }
            }

            @Override
            public Object getCellEditorValue() {
                return EuroEditor.this.txtEuro.getText();
            }
        };
        this.txtEuro = (JTextField)this.getComponent();
        this.txtEuro.setDocument(new AmountDocumentModel());
        this.validator = new Validator(this.txtEuro);
        this.validator.reSetValidator((Validatable)((Object)this.txtEuro.getDocument()));
        NumberFormatter euroFormatter = new NumberFormatter();
        euroFormatter.setFormat(this.euroFormat);
        this.txtEuro.setHorizontalAlignment(0);
    }

    @Override
    public Object getCellEditorValue() {
        JTextField txtEuro = (JTextField)this.getComponent();
        String t = txtEuro.getText();
        this.validator.validationStateChanged(this);
        try {
            if (this.validator.getValidationState() == 0) {
                return ((AmountDocumentModel)txtEuro.getDocument()).getCurrentAmount();
            }
            return t;
        }
        catch (Exception ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getCellEditorValue: can't parse o: " + t));
            }
            return t;
        }
    }

    public int getValidationState() {
        return this.validator.getValidationState();
    }

    public String getText() {
        return this.txtEuro.getText();
    }
}

