/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisUtils;
import de.cismet.cids.custom.wunda_blau.search.server.BaulastSearchInfo;
import de.cismet.cids.custom.wunda_blau.search.server.CidsBaulastSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.FlurstueckInfo;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.widget.AbstractWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class BaulastenPanel
extends AbstractWidget
implements FlurstueckChangeListener {
    private static final Logger LOG = Logger.getLogger(BaulastenPanel.class);
    private MetaClass mcBaulast;
    private final MetaObjectNode loadingMon = new MetaObjectNode("WUNDA_BLAU", -1, -1, "<html><i>wird geladen...", null, null);
    private final MetaObjectNode errorMon = new MetaObjectNode("WUNDA_BLAU", -1, -1, "<html><i>Fehler beim Laden !", null, null);
    private JButton jButton1;
    private JList<MetaObjectNode> jList1;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;

    public BaulastenPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.loadBaulasten(null);
    }

    @Override
    public void clearComponent() {
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        this.loadBaulasten(newFlurstueck);
        LagisBroker.getInstance().flurstueckChangeFinished(this);
    }

    private void loadBaulasten(final FlurstueckCustomBean flurstueck) {
        final DefaultListModel listModel = (DefaultListModel)this.jList1.getModel();
        listModel.clear();
        listModel.addElement(this.loadingMon);
        if (flurstueck != null) {
            new SwingWorker<Collection<MetaObjectNode>, Void>(){

                @Override
                protected Collection<MetaObjectNode> doInBackground() throws Exception {
                    CidsBean flurstueckSchluessel = (CidsBean)flurstueck.getProperty("fk_flurstueck_schluessel");
                    BaulastSearchInfo searchInfo = new BaulastSearchInfo();
                    String alkisId = AlkisUtils.generateLandparcelCode((int)5, (int)((Integer)flurstueckSchluessel.getProperty("fk_gemarkung.schluessel")), (int)((Integer)flurstueckSchluessel.getProperty("flur")), (int)((Integer)flurstueckSchluessel.getProperty("flurstueck_zaehler")), (int)((Integer)flurstueckSchluessel.getProperty("flurstueck_nenner")));
                    String[] alkisIdParts = alkisId.split("-");
                    Integer gemarkung = Integer.parseInt(alkisIdParts[0].substring(2));
                    String flur = alkisIdParts[1];
                    String[] zaehlerNennerParts = alkisIdParts[2].split("/");
                    String zaehler = Integer.toString(Integer.parseInt(zaehlerNennerParts[0]));
                    String nenner = zaehlerNennerParts.length > 1 ? Integer.toString(Integer.parseInt(zaehlerNennerParts[1])) : "0";
                    FlurstueckInfo fsi = new FlurstueckInfo(gemarkung.intValue(), flur, zaehler, nenner);
                    searchInfo.setFlurstuecke(Arrays.asList(fsi));
                    searchInfo.setResult(CidsBaulastSearchStatement.Result.BAULAST);
                    searchInfo.setBelastet(true);
                    searchInfo.setBeguenstigt(true);
                    searchInfo.setBlattnummer("");
                    searchInfo.setArt("");
                    if (BaulastenPanel.this.mcBaulast == null) {
                        BaulastenPanel.this.mcBaulast = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"alb_baulast");
                    }
                    CidsBaulastSearchStatement search = new CidsBaulastSearchStatement(searchInfo, BaulastenPanel.this.mcBaulast.getId(), -1);
                    return CidsBroker.getInstance().executeSearch((CidsServerSearch)search);
                }

                @Override
                protected void done() {
                    try {
                        listModel.clear();
                        Collection baulastenMons = (Collection)this.get();
                        for (MetaObjectNode baulastMon : baulastenMons) {
                            listModel.addElement(baulastMon);
                        }
                        BaulastenPanel.this.jButton1.setEnabled(!listModel.isEmpty());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"error while executing baulasten search", (Throwable)ex);
                        listModel.addElement(BaulastenPanel.this.errorMon);
                        BaulastenPanel.this.jButton1.setEnabled(false);
                    }
                }
            }.execute();
        }
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton1 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jList1.setModel(new DefaultListModel());
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BaulastenPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton1.setText("Renderer anzeigen");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaulastenPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel4.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showRenderer();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.showRenderer();
        }
    }

    private void showRenderer() {
        if (this.jButton1.isEnabled()) {
            ArrayList<MetaObjectNode> baulastMons = new ArrayList<MetaObjectNode>();
            DefaultListModel listModel = (DefaultListModel)this.jList1.getModel();
            for (int index = 0; index < listModel.getSize(); ++index) {
                if (index < 0) continue;
                MetaObjectNode baulastMon = (MetaObjectNode)listModel.get(index);
                baulastMons.add(baulastMon);
            }
            if (!baulastMons.isEmpty()) {
                if (baulastMons.size() == 1) {
                    MetaObjectNode baulastMon = (MetaObjectNode)baulastMons.iterator().next();
                    if (baulastMon.getClassId() != -1) {
                        LagisApp.getInstance().showRenderer((Node[])baulastMons.toArray(new MetaObjectNode[0]));
                    }
                } else {
                    LagisApp.getInstance().showRenderer((Node[])baulastMons.toArray(new MetaObjectNode[0]));
                }
            }
        }
    }
}

