/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.BaumCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumKategorieAuspraegungCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumNutzungCustomBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import de.cismet.lagis.models.documents.SimpleDocumentModel;
import de.cismet.lagisEE.entity.extension.baum.Baum;
import de.cismet.lagisEE.entity.extension.baum.BaumKategorie;
import de.cismet.lagisEE.entity.extension.baum.BaumKategorieAuspraegung;
import de.cismet.lagisEE.entity.extension.baum.BaumNutzung;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class BaumModel
extends CidsBeanTableModel_Lagis {
    private static final String[] COLUMN_HEADER = new String[]{"Lage", "Baumnummer", "Fl\u00e4che m\u00b2", "Nutzung", "Baumbestand", "Auspr\u00e4gung", "Auftragnehmer", "Erfassungsdatum", "F\u00e4lldatum"};
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class, Integer.class, String.class, BaumNutzung.class, Object.class, String.class, Date.class, Date.class};
    public static final int LAGE_COLUMN = 0;
    public static final int BAUMNUMMER_COLUMN = 1;
    public static final int FLAECHE_COLUMN = 2;
    public static final int ALTE_NUTZUNG_COLUMN = 3;
    public static final int BAUMBESTAND_COLUMN = 4;
    public static final int AUSPRAEGUNG_COLUMN = 5;
    public static final int AUFTRAGNEMER_COLUMN = 6;
    public static final int ERFASSUNGSDATUM_COLUMN = 7;
    public static final int FAELLDATUM_COLUMN = 8;
    private final Logger log = Logger.getLogger(this.getClass());
    private SimpleDocumentModel bemerkungDocumentModel;
    private Baum currentSelectedBaum = null;

    public BaumModel() {
        super(COLUMN_HEADER, COLUMN_CLASSES, BaumCustomBean.class);
        this.initDocumentModels();
    }

    public BaumModel(Collection<BaumCustomBean> baeume) {
        super(COLUMN_HEADER, COLUMN_CLASSES, baeume);
        this.initDocumentModels();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (rowIndex >= this.getRowCount()) {
                this.log.warn((Object)("Cannot access row " + rowIndex + ". There are just " + this.getRowCount() + " rows."));
                return null;
            }
            Baum value = (Baum)this.getCidsBeanAtRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return value.getLage();
                }
                case 1: {
                    return value.getBaumnummer();
                }
                case 2: {
                    if (value.getFlaeche() != null) {
                        return value.getFlaeche().intValue();
                    }
                    return null;
                }
                case 3: {
                    return value.getAlteNutzung();
                }
                case 4: {
                    if (value.getBaumNutzung() != null) {
                        return value.getBaumNutzung().getBaumKategorie();
                    }
                    return null;
                }
                case 5: {
                    if (value.getBaumNutzung() != null && value.getBaumNutzung().getBaumKategorie() != null) {
                        return value.getBaumNutzung().getAusgewaehlteAuspraegung();
                    }
                    return null;
                }
                case 6: {
                    return value.getAuftragnehmer();
                }
                case 7: {
                    return value.getErfassungsdatum();
                }
                case 8: {
                    return value.getFaelldatum();
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            this.log.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void removeCidsBean(int rowIndex) {
        Baum baum = (Baum)this.getCidsBeanAtRow(rowIndex);
        if (baum != null && baum.getGeometry() != null) {
            LagisBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)baum);
        }
        super.removeCidsBean(rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (COLUMN_HEADER.length > columnIndex && this.getRowCount() > rowIndex && this.isInEditMode()) {
            if (columnIndex == 5) {
                Baum currentBaum = (Baum)this.getCidsBeanAtRow(rowIndex);
                return currentBaum != null && currentBaum.getBaumNutzung() != null && currentBaum.getBaumNutzung().getBaumKategorie() != null || currentBaum.getBaumNutzung().getBaumKategorie().getKategorieAuspraegungen() != null && currentBaum.getBaumNutzung().getBaumKategorie().getKategorieAuspraegungen().size() > 0;
            }
            return true;
        }
        return false;
    }

    public ArrayList<Feature> getAllBaumFeatures() {
        ArrayList<Feature> tmp = new ArrayList<Feature>();
        if (this.getCidsBeans() != null) {
            for (Baum baum : this.getCidsBeans()) {
                if (baum.getGeometry() == null) continue;
                tmp.add(baum);
            }
            return tmp;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            Baum value = (Baum)this.getCidsBeanAtRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value.setLage((String)aValue);
                    break;
                }
                case 1: {
                    value.setBaumnummer((String)aValue);
                    break;
                }
                case 2: {
                    if (aValue != null) {
                        value.setFlaeche(((Integer)aValue).doubleValue());
                        break;
                    }
                    value.setFlaeche(null);
                    break;
                }
                case 3: {
                    value.setAlteNutzung((String)aValue);
                    break;
                }
                case 4: {
                    if (aValue != null && aValue instanceof String) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Leersting wurde eingebenen --> entferene Ausgew\u00e4hlte Kategorien+Auspr\u00e4gung");
                        }
                        value.setBaumNutzung(null);
                        return;
                    }
                    if (value.getBaumNutzung() == null) {
                        value.setBaumNutzung(BaumNutzungCustomBean.createNew());
                        value.getBaumNutzung().setBaumKategorie((BaumKategorieCustomBean)aValue);
                        if (aValue == null || ((BaumKategorie)aValue).getKategorieAuspraegungen() == null || ((BaumKategorie)aValue).getKategorieAuspraegungen().size() != 1) break;
                        for (BaumKategorieAuspraegungCustomBean currentAuspraegung : ((BaumKategorie)aValue).getKategorieAuspraegungen()) {
                            value.getBaumNutzung().setAusgewaehlteAuspraegung(currentAuspraegung);
                        }
                    } else {
                        BaumKategorieCustomBean oldKategory = null;
                        oldKategory = value.getBaumNutzung().getBaumKategorie();
                        if (oldKategory != null && aValue != null && !((Object)oldKategory).equals(aValue)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Kategorie hat sich ge\u00e4ndert --> Auspr\u00e4gung ist nicht mehr g\u00fcltig");
                            }
                            value.getBaumNutzung().setAusgewaehlteAuspraegung(null);
                        }
                        value.getBaumNutzung().setBaumKategorie((BaumKategorieCustomBean)aValue);
                        if (aValue == null || ((BaumKategorie)aValue).getKategorieAuspraegungen() == null || ((BaumKategorie)aValue).getKategorieAuspraegungen().size() != 1) break;
                        for (BaumKategorieAuspraegungCustomBean currentAuspraegung : ((BaumKategorie)aValue).getKategorieAuspraegungen()) {
                            value.getBaumNutzung().setAusgewaehlteAuspraegung(currentAuspraegung);
                        }
                    }
                    break;
                }
                case 5: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("set AuspraegungColumn:" + aValue.getClass()));
                    }
                    if (value.getBaumNutzung() == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Nutzung == null --> new BaumNutzung");
                        }
                        value.setBaumNutzung(BaumNutzungCustomBean.createNew());
                        break;
                    }
                    if (aValue != null && aValue instanceof BaumKategorieAuspraegung) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"instance of BaumKategorieAuspraegung");
                        }
                        value.getBaumNutzung().setAusgewaehlteAuspraegung((BaumKategorieAuspraegungCustomBean)aValue);
                        break;
                    }
                    if (aValue != null && aValue instanceof Integer) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"instance of integer");
                        }
                        value.getBaumNutzung().setAusgewaehlteAuspraegung(null);
                        break;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"else");
                    }
                    value.getBaumNutzung().setAusgewaehlteAuspraegung(null);
                    break;
                }
                case 6: {
                    if (aValue != null && ((String)aValue).equals("")) {
                        value.setAuftragnehmer(null);
                        break;
                    }
                    value.setAuftragnehmer((String)aValue);
                    break;
                }
                case 7: {
                    if (!(aValue instanceof Date) && aValue != null) break;
                    value.setErfassungsdatum((Date)aValue);
                    break;
                }
                case 8: {
                    if (!(aValue instanceof Date) && aValue != null) break;
                    value.setFaelldatum((Date)aValue);
                    break;
                }
                default: {
                    this.log.warn((Object)("Keine Spalte f\u00fcr angegebenen Index vorhanden: " + columnIndex));
                    return;
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            this.log.error((Object)("Fehler beim setzen von Daten in dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
        }
    }

    private void initDocumentModels() {
        this.bemerkungDocumentModel = new SimpleDocumentModel(){

            @Override
            public void assignValue(String newValue) {
                if (BaumModel.this.log.isDebugEnabled()) {
                    BaumModel.this.log.debug((Object)"Bemerkung assigned");
                    BaumModel.this.log.debug((Object)("new Value: " + newValue));
                }
                this.valueToCheck = newValue;
                this.fireValidationStateChanged(this);
                if (BaumModel.this.currentSelectedBaum != null && this.getStatus() == 0) {
                    BaumModel.this.currentSelectedBaum.setBemerkung(newValue);
                }
            }
        };
    }

    public void clearSlaveComponents() {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Clear Slave Components");
            }
            this.bemerkungDocumentModel.clear(0, this.bemerkungDocumentModel.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SimpleDocumentModel getBemerkungDocumentModel() {
        return this.bemerkungDocumentModel;
    }

    public void setCurrentSelectedBaum(Baum newBaum) {
        this.currentSelectedBaum = newBaum;
        if (this.currentSelectedBaum != null) {
            try {
                this.bemerkungDocumentModel.clear(0, this.bemerkungDocumentModel.getLength());
                this.bemerkungDocumentModel.insertString(0, this.currentSelectedBaum.getBemerkung(), null);
            }
            catch (BadLocationException ex) {
                this.log.error((Object)"Fehler beim setzen des BemerkungsModells: ", (Throwable)ex);
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"nichts selektiert l\u00f6sche Felder");
            }
            this.clearSlaveComponents();
        }
    }
}

