/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.beans.lagis.DmsUrlCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.UrlBaseCustomBean;
import de.cismet.cids.custom.beans.lagis.UrlCustomBean;
import de.cismet.cids.custom.clientutils.DmsUrlsPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.dialogs.D3Dialog;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DMSPanel
extends AbstractWidget
implements FlurstueckChangeListener,
FlurstueckSaver {
    private static final String WIDGET_NAME = "Dokumenten Panel";
    private static final Logger LOG = Logger.getLogger(DMSPanel.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.RENDERER, (String)DMSPanel.class.getName());
    private FlurstueckCustomBean currentFlurstueck = null;
    private JButton btnAddD3Link;
    private DmsUrlsPanel dmsUrlsPanel1;

    public DMSPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.configureButtons();
        this.dmsUrlsPanel1.initWithConnectionContext(ConnectionContext.createDeprecated());
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            this.clearComponent();
            this.setCursor(Cursor.getDefaultCursor());
            this.currentFlurstueck = newFlurstueck;
            this.dmsUrlsPanel1.setDmsUrls(newFlurstueck.getDokumente());
            this.dmsUrlsPanel1.refresh();
            this.repaint();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurstueckswechsel im FlurstueckPanel: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        this.dmsUrlsPanel1.setEnabled(isEditable);
        this.btnAddD3Link.setEnabled(isEditable);
    }

    @Override
    public synchronized void clearComponent() {
        this.dmsUrlsPanel1.setDmsUrls(null);
        this.dmsUrlsPanel1.refresh();
    }

    private void initComponents() {
        this.dmsUrlsPanel1 = new DmsUrlsPanel("LAGIS");
        this.setLayout(new BorderLayout());
        this.add((Component)this.dmsUrlsPanel1, "Center");
    }

    public ArrayList<JComponent> getCustomButtons() {
        ArrayList<JComponent> tmp = new ArrayList<JComponent>();
        tmp.add(this.btnAddD3Link);
        return tmp;
    }

    private void configureButtons() {
        this.btnAddD3Link = new JButton(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/res/add.png")));
        this.btnAddD3Link.setBorder(null);
        this.btnAddD3Link.setBorderPainted(false);
        this.btnAddD3Link.setEnabled(false);
        this.btnAddD3Link.setToolTipText(NbBundle.getMessage(DMSPanel.class, (String)"DMSPanel.configureButtons().btnAddD3Link.tooltip"));
        this.btnAddD3Link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                D3Dialog dialog = new D3Dialog(StaticSwingTools.getParentFrame((Component)DMSPanel.this), true);
                StaticSwingTools.showDialog((JDialog)dialog);
                if (dialog.getId() == null) {
                    return;
                }
                if (LagisBroker.getInstance().getD3Url() == null) {
                    JOptionPane.showMessageDialog(DMSPanel.this, NbBundle.getMessage(DMSPanel.class, (String)"DMSPanel.configureButtons().showMessageDialog.message"), NbBundle.getMessage(DMSPanel.class, (String)"DMSPanel.configureButtons().showMessageDialog.title"), 0);
                    return;
                }
                if (DMSPanel.this.currentFlurstueck != null) {
                    try {
                        String d3Url = LagisBroker.getInstance().getD3Url();
                        UrlCustomBean url = UrlCustomBean.createNew();
                        DmsUrlCustomBean dmsUrl = DmsUrlCustomBean.createNew();
                        String prot = d3Url.substring(0, d3Url.indexOf("//") + 2);
                        String afterProt = d3Url.substring(d3Url.indexOf("//") + 2);
                        String server = afterProt.substring(0, afterProt.indexOf("/"));
                        String path = afterProt.substring(afterProt.indexOf("/"));
                        UrlBaseCustomBean urlBase = null;
                        MetaClass mcDmsUrl = ClassCacheMultiple.getMetaClass((String)"LAGIS", (String)"url_base", (ConnectionContext)CC);
                        String queryUrlBase = "SELECT " + mcDmsUrl.getID() + ", " + mcDmsUrl.getPrimaryKey() + " FROM " + mcDmsUrl.getTableName() + " WHERE  prot_prefix = '" + prot + "' and server = '" + server + "' and path = '" + path + "'";
                        MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(queryUrlBase, 0, CC);
                        if (mos != null && mos.length > 0) {
                            urlBase = (UrlBaseCustomBean)mos[0].getBean();
                        }
                        if (urlBase == null) {
                            urlBase = UrlBaseCustomBean.createNew();
                            if (!path.endsWith("/")) {
                                path = path + "/";
                            }
                            urlBase.setProtPrefix(prot);
                            urlBase.setServer(server);
                            urlBase.setPath(path);
                        }
                        url.setProperty("object_name", dialog.getId());
                        url.setProperty("url_base_id", urlBase);
                        dmsUrl.setBeschreibung("D3 Link");
                        dmsUrl.setName(dialog.getBezeichnung());
                        dmsUrl.setTyp(100);
                        dmsUrl.setFk_url(url);
                        DMSPanel.this.dmsUrlsPanel1.addDmsUrl((CidsBean)dmsUrl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public boolean isInEditMode() {
        return this.dmsUrlsPanel1.isEnabled();
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Dokumente werden gespeichert");
        }
        this.clearComponent();
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }
}

