/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.SessionManager;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.GemarkungCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereichCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.FeatureNameProvider;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.interfaces.DoneDelegate;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckRequester;
import de.cismet.lagis.models.KeyComboboxModel;
import de.cismet.lagis.thread.ExtendedSwingWorker;
import de.cismet.lagis.thread.WFSRetrieverFactory;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagisEE.entity.core.CustomSelectionStyledFeatureGroupWrapper;
import de.cismet.lagisEE.interfaces.Key;
import de.cismet.lagisEE.util.FlurKey;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class FlurstueckChooser
extends AbstractWidget
implements FlurstueckChangeListener,
FlurstueckRequester,
Configurable {
    public static final String FEATURE_GRP = "Flurst\u00fcck";
    private static final String WIDGET_NAME = "Flurstueck Suchpanel";
    private static final String TOOLBAR_RESPATH = "/de/cismet/lagis/ressource/icons/toolbar/";
    private static final String FILEPATH_FILTERICON_ALL = "/de/cismet/lagis/ressource/icons/toolbar/filter_all.png";
    private static final String FILEPATH_FILTERICON_CURRENT = "/de/cismet/lagis/ressource/icons/toolbar/filter_current.png";
    private static final String FILEPATH_FILTERICON_HISTORIC = "/de/cismet/lagis/ressource/icons/toolbar/filter_historic.png";
    private static final String FILEPATH_FILTERICON_STAEDTISCH = "/de/cismet/lagis/ressource/icons/toolbar/filter_staedtisch.png";
    private static final String FILEPATH_ICON_CURRENT = "/de/cismet/lagis/ressource/icons/toolbar/current.png";
    private static final String FILEPATH_ICON_ABTEILUNGIX = "/de/cismet/lagis/ressource/icons/toolbar/abteilungIX.png";
    private static final String FILEPATH_ICON_ABTEILUNGIX_HISTORIC = "/de/cismet/lagis/ressource/icons/toolbar/historic_abteilungIX.png";
    private static final String FILEPATH_ICON_HISTORIC = "/de/cismet/lagis/ressource/icons/toolbar/historic.png";
    private static final String FILEPATH_ICON_UNKNOWNFLURSTUECK = "/de/cismet/lagis/ressource/icons/toolbar/unkownFlurstueck.png";
    private static final String FILEPATH_ICON_WFSWARN = "/de/cismet/lagis/ressource/icons/FlurstueckPanel/16warn.png";
    public static final Icon ICON_STAEDTISCH = new ImageIcon(FlurstueckChooser.class.getResource("/de/cismet/lagis/ressource/icons/toolbar/current.png"));
    public static final Icon ICON_STAEDTISCH_HISTORIC = new ImageIcon(FlurstueckChooser.class.getResource("/de/cismet/lagis/ressource/icons/toolbar/historic.png"));
    public static final Icon ICON_ABTEILUNGIX = new ImageIcon(FlurstueckChooser.class.getResource("/de/cismet/lagis/ressource/icons/toolbar/abteilungIX.png"));
    public static final Icon ICON_ABTEILUNGIX_HISTORIC = new ImageIcon(FlurstueckChooser.class.getResource("/de/cismet/lagis/ressource/icons/toolbar/historic_abteilungIX.png"));
    public static final Icon ICON_UNKNOWNFLURSTUECK = new ImageIcon(FlurstueckChooser.class.getResource("/de/cismet/lagis/ressource/icons/toolbar/unkownFlurstueck.png"));
    public static final Icon ICON_WFSWARN = new ImageIcon(FlurstueckChooser.class.getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/16warn.png"));
    private static final String FILTER_CURRENT_NAME = "nur aktuelle";
    private static final String FILTER_HISTORIC_NAME = "nur historische";
    private static final String FILTER_ALL_NAME = "alle Flurst\u00fccke";
    private static final String FILTER_ABTEILUNG_IX = "nur Abteilung IX";
    private static final String FILTER_STAEDTISCH = "nur st\u00e4dtische";
    private static final Logger LOG = Logger.getLogger(FlurstueckChooser.class);
    private static final String CONF_FS_CHOOSER = "flurstueckChooser";
    private static final String CONF_RECENT_FS_KEY = "recentFlurstueckSchluessel";
    private static final String CONF_ATTR_FS_KEY_ID = "fsKeyId";
    private boolean cboGemarkungListenerEnabled = true;
    private boolean cboFlurListenerEnabled = true;
    private boolean cboFlurstueckListenerEnabled = true;
    private final Icon icoFilterAll = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/filter_all.png"));
    private final Icon icoFilterCurrent = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/filter_current.png"));
    private final Icon icoFilterHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/filter_historic.png"));
    private final Icon icoFilterStaedtisch = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/filter_staedtisch.png"));
    private final Icon icoCurrent = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/current.png"));
    private final Icon icoHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic.png"));
    private GemarkungRetriever currentGemarkungsRetriever = null;
    private FlurRetriever currentFlurRetriever = null;
    private FlurstueckRetriever currentFlurstueckRetriever = null;
    private SwingWorker currentWFSRetriever = null;
    private AutomaticFlurstueckRetriever currentAutomaticRetriever = null;
    private FlurstueckChecker currentFlurstueckChecker = null;
    private Thread currentGemarkungsWaiter = null;
    private final ReentrantLock automaticRequestLock = new ReentrantLock();
    private Filter filter;
    private Mode currentMode = Mode.SEARCH;
    private final Collection<FlurstueckSchluesselCustomBean> removeFilter = new ArrayList<FlurstueckSchluesselCustomBean>();
    private boolean isFullInitialized = false;
    private FlurstueckCustomBean currentFlurstueckBean;
    private FlurstueckSchluesselCustomBean currentlyCreatedFlurstueckSchluesselBean;
    private Color currentColor;
    private boolean isFlurstueckCandidateValide = false;
    private Boolean isFlurstueckCreateable = false;
    private final ReentrantLock validationMessageLock = new ReentrantLock();
    private String creationValidationMessage = "Bitte vervollst\u00e4ndigen Sie alle Flurst\u00fccke";
    private JButton btnAction;
    private JComboBox cboFilter;
    private JComboBox cboFlur;
    private JComboBox cboFlurstueck;
    private JComboBox cboGemarkung;
    private JPanel panFilter;
    private JPanel panFlur;
    private JPanel panFlurstueck;
    private JPanel panGemarkung;
    private JPanel panTxtFlurstueck;
    private JProgressBar pbFilter;
    private JProgressBar pbFlur;
    private JProgressBar pbFlurstueck;
    private JProgressBar pbGemarkung;
    private JProgressBar pbTxtFlurstueck;
    private JTextField txtFlurstueck;

    public FlurstueckChooser() {
        this(Mode.CONTINUATION);
    }

    public FlurstueckChooser(Mode mode) {
        try {
            this.currentMode = mode;
            this.initComponents();
            this.initRenderer();
            this.configureComponents();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not Create FlurstueckChooser", (Throwable)e);
        }
    }

    public void configure(Element parent) {
        boolean error = false;
        int gemarkungSchluessel = -1;
        int flur = -1;
        int zaehler = -1;
        int nenner = -1;
        if (parent == null) {
            LOG.warn((Object)"There is no local configuration for FlurstueckChooser.");
            error = true;
        } else {
            Element fsChooserCfgElement = parent.getChild(CONF_FS_CHOOSER);
            if (fsChooserCfgElement == null) {
                LOG.warn((Object)"There is no local configuration for FlurstueckChooser.");
                error = true;
            } else {
                Element fsKeyCfgElement = fsChooserCfgElement.getChild(CONF_RECENT_FS_KEY);
                if (fsKeyCfgElement == null) {
                    LOG.warn((Object)"There is no local configuration for current FlurstueckKey.");
                    error = true;
                } else {
                    String fsKeyString = fsKeyCfgElement.getAttributeValue(CONF_ATTR_FS_KEY_ID);
                    if (fsKeyString == null) {
                        LOG.error((Object)"Config element 'recentFlurstueckSchluessel' has no 'fsKeyId' attribute");
                        error = true;
                    } else {
                        try {
                            int id = Integer.parseInt(fsKeyString);
                            FlurstueckSchluesselCustomBean tmpKey = FlurstueckSchluesselCustomBean.createNewById(id);
                            gemarkungSchluessel = tmpKey.getGemarkung().getSchluessel();
                            flur = tmpKey.getFlur();
                            zaehler = tmpKey.getFlurstueckZaehler();
                            nenner = tmpKey.getFlurstueckNenner();
                        }
                        catch (Exception e) {
                            try {
                                String[] splitGemarkungFlurZaehlerNenner = fsKeyString.split("-");
                                String[] splitZaehlerNenner = splitGemarkungFlurZaehlerNenner[2].split("/");
                                gemarkungSchluessel = Integer.parseInt(splitGemarkungFlurZaehlerNenner[0]);
                                flur = Integer.parseInt(splitGemarkungFlurZaehlerNenner[1]);
                                zaehler = Integer.parseInt(splitZaehlerNenner[0]);
                                nenner = Integer.parseInt(splitZaehlerNenner[1]);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                                error = true;
                            }
                        }
                    }
                }
            }
        }
        if (error) {
            gemarkungSchluessel = 3001;
            flur = 117;
            zaehler = 59;
            nenner = 0;
        }
        try {
            FlurstueckSchluesselCustomBean fsKey = (FlurstueckSchluesselCustomBean)CidsBean.createNewCidsBeanFromTableName((String)"LAGIS", (String)"flurstueck_schluessel");
            fsKey.setGemarkung(LagisBroker.getInstance().getGemarkungForKey(gemarkungSchluessel));
            fsKey.setFlur(flur);
            fsKey.setFlurstueckZaehler(zaehler);
            fsKey.setFlurstueckNenner(nenner);
            fsKey.setId(-1);
            LagisBroker.getInstance().completeFlurstueckSchluessel(fsKey);
            this.requestFlurstueck(fsKey);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void masterConfigure(Element parent) {
    }

    public Element getConfiguration() throws NoWriteError {
        Element root = new Element(CONF_FS_CHOOSER);
        if (this.currentFlurstueckBean == null) {
            LOG.warn((Object)"Current Flurstueck is null -> can not create configuration entry for elementrecentFlurstueckSchluessel");
        } else {
            FlurstueckSchluesselCustomBean currentFKey = this.currentFlurstueckBean.getFlurstueckSchluessel();
            if (currentFKey == null) {
                LOG.warn((Object)"Current FlurstueckSchluessel is null -> can not create configuration entry for elementrecentFlurstueckSchluessel");
            } else {
                String string = Integer.toString(currentFKey.getGemarkung().getSchluessel()) + "-" + Integer.toString(currentFKey.getFlur()) + "-" + Integer.toString(currentFKey.getFlurstueckZaehler()) + "/" + Integer.toString(currentFKey.getFlurstueckNenner());
                Element fsKeyElement = new Element(CONF_RECENT_FS_KEY);
                fsKeyElement.setAttribute(CONF_ATTR_FS_KEY_ID, string);
                root.addContent((Content)fsKeyElement);
            }
        }
        return root;
    }

    private void initComponents() {
        this.panTxtFlurstueck = new JPanel();
        this.txtFlurstueck = new JTextField();
        this.pbTxtFlurstueck = new JProgressBar();
        this.btnAction = new JButton();
        this.panGemarkung = new JPanel();
        this.cboGemarkung = new JComboBox();
        this.pbGemarkung = new JProgressBar();
        this.panFlur = new JPanel();
        this.cboFlur = new JComboBox();
        this.pbFlur = new JProgressBar();
        this.panFlurstueck = new JPanel();
        this.cboFlurstueck = new JComboBox();
        this.pbFlurstueck = new JProgressBar();
        this.panFilter = new JPanel();
        this.cboFilter = new JComboBox();
        this.pbFilter = new JProgressBar();
        this.panTxtFlurstueck.setMaximumSize(new Dimension(100, 28));
        this.panTxtFlurstueck.setMinimumSize(new Dimension(100, 28));
        this.panTxtFlurstueck.setPreferredSize(new Dimension(100, 28));
        this.panTxtFlurstueck.setLayout(new BorderLayout());
        this.txtFlurstueck.setToolTipText(FEATURE_GRP);
        this.txtFlurstueck.setEnabled(false);
        this.txtFlurstueck.setMaximumSize(new Dimension(100, 23));
        this.txtFlurstueck.setMinimumSize(new Dimension(100, 23));
        this.txtFlurstueck.setPreferredSize(new Dimension(100, 23));
        this.panTxtFlurstueck.add((Component)this.txtFlurstueck, "North");
        this.pbTxtFlurstueck.setBorderPainted(false);
        this.pbTxtFlurstueck.setMaximumSize(new Dimension(100, 5));
        this.pbTxtFlurstueck.setMinimumSize(new Dimension(100, 5));
        this.pbTxtFlurstueck.setPreferredSize(new Dimension(100, 5));
        this.panTxtFlurstueck.add((Component)this.pbTxtFlurstueck, "South");
        this.setMaximumSize(new Dimension(483, 35));
        this.btnAction.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/flurstueck.png")));
        this.btnAction.setBorder(null);
        this.add(this.btnAction);
        this.panGemarkung.setMaximumSize(new Dimension(100, 28));
        this.panGemarkung.setMinimumSize(new Dimension(100, 28));
        this.panGemarkung.setPreferredSize(new Dimension(100, 28));
        this.panGemarkung.setLayout(new BorderLayout());
        this.cboGemarkung.setEditable(true);
        this.cboGemarkung.setToolTipText("Gemarkung");
        this.cboGemarkung.setEnabled(false);
        this.cboGemarkung.setMaximumSize(new Dimension(100, 23));
        this.cboGemarkung.setMinimumSize(new Dimension(100, 23));
        this.cboGemarkung.setName("cboGemarkung");
        this.cboGemarkung.setPreferredSize(new Dimension(100, 23));
        this.cboGemarkung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckChooser.this.cboGemarkungActionPerformed(evt);
            }
        });
        this.panGemarkung.add((Component)this.cboGemarkung, "Center");
        this.pbGemarkung.setBorderPainted(false);
        this.pbGemarkung.setMaximumSize(new Dimension(90, 5));
        this.pbGemarkung.setMinimumSize(new Dimension(90, 5));
        this.pbGemarkung.setPreferredSize(new Dimension(90, 5));
        this.panGemarkung.add((Component)this.pbGemarkung, "South");
        this.add(this.panGemarkung);
        this.panFlur.setMaximumSize(new Dimension(100, 28));
        this.panFlur.setLayout(new BorderLayout());
        this.cboFlur.setEditable(true);
        this.cboFlur.setToolTipText("Flur");
        this.cboFlur.setEnabled(false);
        this.cboFlur.setMaximumSize(new Dimension(100, 23));
        this.cboFlur.setMinimumSize(new Dimension(100, 23));
        this.cboFlur.setName("cboFlur");
        this.cboFlur.setPreferredSize(new Dimension(100, 23));
        this.cboFlur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckChooser.this.cboFlurActionPerformed(evt);
            }
        });
        this.panFlur.add((Component)this.cboFlur, "Center");
        this.pbFlur.setBorderPainted(false);
        this.pbFlur.setMaximumSize(new Dimension(90, 5));
        this.pbFlur.setMinimumSize(new Dimension(90, 5));
        this.pbFlur.setPreferredSize(new Dimension(90, 5));
        this.panFlur.add((Component)this.pbFlur, "South");
        this.add(this.panFlur);
        this.panFlurstueck.setMaximumSize(new Dimension(100, 23));
        this.panFlurstueck.setLayout(new BorderLayout());
        this.cboFlurstueck.setEditable(true);
        this.cboFlurstueck.setToolTipText(FEATURE_GRP);
        this.cboFlurstueck.setEnabled(false);
        this.cboFlurstueck.setMaximumSize(new Dimension(100, 23));
        this.cboFlurstueck.setMinimumSize(new Dimension(100, 23));
        this.cboFlurstueck.setName("cboFlurstueck");
        this.cboFlurstueck.setPreferredSize(new Dimension(100, 23));
        this.cboFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckChooser.this.cboFlurstueckActionPerformed(evt);
            }
        });
        this.panFlurstueck.add((Component)this.cboFlurstueck, "Center");
        this.pbFlurstueck.setBorderPainted(false);
        this.pbFlurstueck.setMaximumSize(new Dimension(90, 5));
        this.pbFlurstueck.setMinimumSize(new Dimension(90, 5));
        this.pbFlurstueck.setPreferredSize(new Dimension(90, 5));
        this.panFlurstueck.add((Component)this.pbFlurstueck, "South");
        this.add(this.panFlurstueck);
        this.panFilter.setLayout(new BorderLayout());
        this.cboFilter.setModel(new DefaultComboBoxModel<String>(new String[]{FILTER_ALL_NAME, FILTER_HISTORIC_NAME, FILTER_CURRENT_NAME, FILTER_ABTEILUNG_IX, FILTER_STAEDTISCH}));
        this.cboFilter.setToolTipText("Filter: Alle Flurst\u00fccke, nur aktuelle Flurst\u00fccke, nur historische Flurst\u00fccke");
        this.cboFilter.setMaximumSize(new Dimension(130, 23));
        this.cboFilter.setMinimumSize(new Dimension(130, 23));
        this.cboFilter.setPreferredSize(new Dimension(130, 23));
        this.cboFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckChooser.this.cboFilterActionPerformed(evt);
            }
        });
        this.panFilter.add((Component)this.cboFilter, "Center");
        this.pbFilter.setBorderPainted(false);
        this.pbFilter.setMaximumSize(new Dimension(90, 5));
        this.pbFilter.setMinimumSize(new Dimension(90, 5));
        this.pbFilter.setPreferredSize(new Dimension(90, 5));
        this.panFilter.add((Component)this.pbFilter, "South");
        this.add(this.panFilter);
    }

    private void configureComponents() {
        StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboGemarkung);
        StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboFlur);
        StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboFlurstueck);
        FocusListenerImpl focusListener = new FocusListenerImpl();
        this.cboGemarkung.getEditor().getEditorComponent().addFocusListener(focusListener);
        this.cboFlur.getEditor().getEditorComponent().addFocusListener(focusListener);
        this.cboFlurstueck.getEditor().getEditorComponent().addFocusListener(focusListener);
        switch (this.currentMode) {
            case SEARCH: {
                break;
            }
            case CREATION: {
                this.remove(this.panFilter);
                this.filter = Filter.CURRENT;
                this.remove(this.panFlurstueck);
                this.txtFlurstueck.getDocument().addDocumentListener(new DocumentListenerImpl());
                this.panTxtFlurstueck.setVisible(true);
                this.add(this.panTxtFlurstueck);
                break;
            }
            case CONTINUATION: 
            case CONTINUATION_HISTORIC: {
                this.remove(this.panFilter);
                this.filter = this.currentMode == Mode.CONTINUATION ? Filter.CURRENT : Filter.HISTORIC;
            }
        }
        this.txtFlurstueck.setEnabled(false);
        this.currentGemarkungsRetriever = new GemarkungRetriever(GemarkungRetrieverMode.RETRIEVE_GEMARKUNGEN);
        Connection c = SessionManager.getConnection();
        if (c.isConnected()) {
            LagisBroker.getInstance().execute(this.currentGemarkungsRetriever);
        }
    }

    private void initRenderer() {
        this.cboFilter.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value.equals(FlurstueckChooser.FILTER_CURRENT_NAME)) {
                    label.setIcon(FlurstueckChooser.this.icoFilterCurrent);
                } else if (value.equals(FlurstueckChooser.FILTER_HISTORIC_NAME)) {
                    label.setIcon(FlurstueckChooser.this.icoFilterHistoric);
                } else if (value.equals(FlurstueckChooser.FILTER_STAEDTISCH)) {
                    label.setIcon(FlurstueckChooser.this.icoFilterStaedtisch);
                } else if (value.equals(FlurstueckChooser.FILTER_ABTEILUNG_IX)) {
                    label.setIcon(ICON_ABTEILUNGIX);
                } else {
                    label.setIcon(FlurstueckChooser.this.icoFilterAll);
                }
                return label;
            }
        });
        this.cboFlurstueck.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                FlurstueckSchluesselCustomBean valueBean;
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof FlurstueckSchluesselCustomBean && (valueBean = (FlurstueckSchluesselCustomBean)value) != null) {
                    if (valueBean.getGueltigBis() == null) {
                        FlurstueckArtCustomBean flurstueckArt = valueBean.getFlurstueckArt();
                        if (flurstueckArt != null && flurstueckArt.getBezeichnung() != null && flurstueckArt.getBezeichnung().equals("st\u00e4dtisch")) {
                            label.setIcon(FlurstueckChooser.this.icoCurrent);
                        } else {
                            label.setIcon(ICON_ABTEILUNGIX);
                        }
                    } else {
                        label.setIcon(FlurstueckChooser.this.icoHistoric);
                    }
                    return label;
                }
                label.setIcon(ICON_UNKNOWNFLURSTUECK);
                return label;
            }
        });
    }

    @Override
    public void clearComponent() {
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public void setComponentEditable(final boolean isEditable) {
        LagisBroker.warnIfThreadIsNotEDT();
        if (EventQueue.isDispatchThread()) {
            this.setEditable(isEditable);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FlurstueckChooser.this.setEditable(isEditable);
                }
            });
        }
    }

    private void setEditable(boolean isEditable) {
        if (isEditable) {
            this.setHighlightColor(Color.WHITE);
        }
        if (LagisBroker.getInstance().isInEditMode() || !LagisBroker.getInstance().isInEditMode() && !this.cboGemarkung.isEnabled() && this.isFullInitialized) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"enable/disable comboboxes for editmode");
            }
            this.cboGemarkung.setEnabled(!isEditable);
            this.cboFlur.setEnabled(!isEditable);
            this.cboFlurstueck.setEnabled(!isEditable);
            this.cboFilter.setEnabled(!isEditable);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"not switching for editmode");
        }
    }

    private void cboFilterActionPerformed(ActionEvent evt) {
        String value = (String)this.cboFilter.getSelectedItem();
        if (value.equals(FILTER_ALL_NAME)) {
            LOG.info((Object)"Filter alle Flurst\u00fccke ausgew\u00e4hlt");
            this.filter = Filter.ALL;
        } else if (value.equals(FILTER_HISTORIC_NAME)) {
            LOG.info((Object)"Filter nur historische ausgew\u00e4hlt");
            this.filter = Filter.HISTORIC;
        } else if (value.equals(FILTER_ABTEILUNG_IX)) {
            LOG.info((Object)"Filter nur Abteilung IX");
            this.filter = Filter.ABTEILUNG_IX;
        } else if (value.equals(FILTER_STAEDTISCH)) {
            LOG.info((Object)"Filter nur staedtische");
            this.filter = Filter.STAEDTISCH;
        } else {
            LOG.info((Object)"Filter nur aktuelle ausgew\u00e4hlt");
            this.filter = Filter.CURRENT;
        }
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        if (currentFlurstueck != null) {
            this.doAutomaticRequest(1, currentFlurstueck.getFlurstueckSchluessel());
        } else {
            this.doAutomaticRequest(2, null);
        }
    }

    private void setPropertyChangeListener(SwingWorker worker) {
        try {
            this.automaticRequestLock.lock();
            if (this.currentAutomaticRetriever != null && worker != null) {
                worker.addPropertyChangeListener(this.currentAutomaticRetriever);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim setzen des PropertyChangeListeners", (Throwable)ex);
        }
        finally {
            this.automaticRequestLock.unlock();
        }
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            boolean isNoGeometryAssigned = true;
            boolean hasManyVerwaltungsbereiche = false;
            if (newFlurstueck.getVerwaltungsbereiche() == null || newFlurstueck.getVerwaltungsbereiche() != null && newFlurstueck.getVerwaltungsbereiche().size() < 2 || newFlurstueck.getFlurstueckSchluessel() != null || newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt() != null || !newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt().equals("st\u00e4dtisch")) {
                Object verwaltungsbereich;
                LOG.info((Object)"Keine Verwaltungsgeometrien oder weniger als 2 vorhanden --> WFS");
                if (newFlurstueck.getVerwaltungsbereiche() != null && newFlurstueck.getVerwaltungsbereiche().size() == 1 && (verwaltungsbereich = newFlurstueck.getVerwaltungsbereiche().iterator().next()) != null && ((VerwaltungsbereichCustomBean)verwaltungsbereich).getGeometry() != null) {
                    LagisBroker.getInstance().flurstueckChangeFinished(this);
                    return;
                }
            } else if (newFlurstueck.getVerwaltungsbereiche() != null) {
                hasManyVerwaltungsbereiche = true;
                LOG.info((Object)"mehr als 2 Verwaltungsbereiche");
                isNoGeometryAssigned = true;
                for (VerwaltungsbereichCustomBean currentBereich : newFlurstueck.getVerwaltungsbereiche()) {
                    if (currentBereich.getGeometry() != null) {
                        isNoGeometryAssigned = false;
                    }
                    if (isNoGeometryAssigned) continue;
                    LagisBroker.getInstance().flurstueckChangeFinished(this);
                    return;
                }
            } else {
                LOG.error((Object)"Nicht definierter Fall");
                LagisBroker.getInstance().flurstueckChangeFinished(this);
            }
            if (this.currentWFSRetriever != null && !this.currentWFSRetriever.isDone()) {
                this.currentWFSRetriever.cancel(false);
                this.currentWFSRetriever = null;
            }
            HashMap<Integer, Boolean> properties = new HashMap<Integer, Boolean>();
            properties.put(0, hasManyVerwaltungsbereiche);
            properties.put(1, isNoGeometryAssigned);
            this.currentWFSRetriever = WFSRetrieverFactory.getInstance().getWFSRetriever(newFlurstueck.getFlurstueckSchluessel(), new WFSRequestJobDone(), properties);
            LagisBroker.getInstance().execute(this.currentWFSRetriever);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurst\u00fcckchange FlurstueckChooser --> Keine Geometrie wird abgerufen", (Throwable)ex);
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    private synchronized void setHighlightColor(Color color) {
        LagisBroker.warnIfThreadIsNotEDT();
        this.currentColor = color;
        this.cboGemarkung.getEditor().getEditorComponent().setBackground(color);
        this.cboFlur.getEditor().getEditorComponent().setBackground(color);
        this.cboFlurstueck.getEditor().getEditorComponent().setBackground(color);
        this.txtFlurstueck.setBackground(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAutomaticRequest(int mode, final FlurstueckSchluesselCustomBean key) {
        LagisBroker.warnIfThreadIsNotEDT();
        Color oldColor = this.currentColor;
        if (this.currentAutomaticRetriever != null && !this.currentAutomaticRetriever.isDone()) {
            this.currentAutomaticRetriever.cancel(false);
            this.currentAutomaticRetriever = null;
        }
        if (1 == mode || 3 == mode || 0 == mode && key != null) {
            try {
                this.cboGemarkungListenerEnabled = false;
                this.cboFlurListenerEnabled = false;
                this.cboFlurstueckListenerEnabled = false;
                this.automaticRequestLock.lock();
                try {
                    this.currentAutomaticRetriever = new AutomaticFlurstueckRetriever(mode, key, oldColor);
                    LagisBroker.getInstance().execute(this.currentAutomaticRetriever);
                }
                finally {
                    this.automaticRequestLock.unlock();
                }
                if (this.currentGemarkungsRetriever != null && !this.currentGemarkungsRetriever.isDone() && this.currentGemarkungsRetriever.getMode() != GemarkungRetrieverMode.RETRIEVE_GEMARKUNGEN) {
                    this.currentGemarkungsWaiter.interrupt();
                    this.currentGemarkungsWaiter = null;
                    this.currentGemarkungsRetriever.cancel(false);
                    this.currentGemarkungsRetriever = null;
                } else if (this.currentGemarkungsRetriever != null && !this.currentGemarkungsRetriever.isDone() && this.currentGemarkungsRetriever.getMode() == GemarkungRetrieverMode.RETRIEVE_GEMARKUNGEN) {
                    if (this.currentGemarkungsWaiter != null) {
                        this.currentGemarkungsWaiter.interrupt();
                        this.currentGemarkungsWaiter = null;
                    }
                    this.currentGemarkungsWaiter = new Thread(){

                        @Override
                        public void run() {
                            while (!FlurstueckChooser.this.currentGemarkungsRetriever.isDone()) {
                                if (this.isInterrupted()) {
                                    return;
                                }
                                try {
                                    8.sleep(100L);
                                }
                                catch (InterruptedException ex) {
                                    return;
                                }
                            }
                            if (this.isInterrupted()) {
                                return;
                            }
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FlurstueckChooser.this.cboGemarkung.setSelectedItem(key.getGemarkung());
                                    FlurstueckChooser.this.currentGemarkungsRetriever = null;
                                    FlurstueckChooser.this.currentGemarkungsRetriever = new GemarkungRetriever(GemarkungRetrieverMode.RETRIEVE_AUTOMATIC, null, key.getGemarkung());
                                    FlurstueckChooser.this.setPropertyChangeListener(FlurstueckChooser.this.currentGemarkungsRetriever);
                                    LagisBroker.getInstance().execute(FlurstueckChooser.this.currentGemarkungsRetriever);
                                }
                            });
                        }
                    };
                    this.currentGemarkungsWaiter.start();
                    return;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler in AutomaticRequest FilterAcion --> setze Listener", (Throwable)ex);
                this.cboGemarkungListenerEnabled = true;
                this.cboFlurListenerEnabled = true;
                this.cboFlurstueckListenerEnabled = true;
            }
            this.cboGemarkung.setSelectedItem(key.getGemarkung());
            this.currentGemarkungsRetriever = new GemarkungRetriever(GemarkungRetrieverMode.RETRIEVE_AUTOMATIC, null, key.getGemarkung());
            this.setPropertyChangeListener(this.currentGemarkungsRetriever);
            LagisBroker.getInstance().execute(this.currentGemarkungsRetriever);
        } else if (2 == mode && key == null && this.cboFlur.isEnabled()) {
            this.cboFlur.setSelectedItem(this.cboFlur.getSelectedItem());
        }
    }

    public FlurstueckSchluesselCustomBean getCurrentFlurstueckSchluessel() {
        if (this.currentMode == Mode.CREATION && this.currentlyCreatedFlurstueckSchluesselBean != null) {
            return this.currentlyCreatedFlurstueckSchluesselBean;
        }
        if (this.currentFlurstueckBean != null && this.currentFlurstueckBean.getFlurstueckSchluessel() != null) {
            return this.currentFlurstueckBean.getFlurstueckSchluessel();
        }
        Object selectedFlurstueckSchluessel = this.cboFlurstueck.getSelectedItem();
        if (selectedFlurstueckSchluessel != null && selectedFlurstueckSchluessel instanceof FlurstueckSchluesselCustomBean) {
            FlurstueckSchluesselCustomBean selectedFlurstueckSchluesselBean = (FlurstueckSchluesselCustomBean)selectedFlurstueckSchluessel;
            FlurstueckSchluesselCustomBean key = FlurstueckSchluesselCustomBean.createNew();
            key.setGemarkung(selectedFlurstueckSchluesselBean.getGemarkung());
            key.setFlur(selectedFlurstueckSchluesselBean.getFlur());
            key.setFlurstueckZaehler(selectedFlurstueckSchluesselBean.getFlurstueckZaehler());
            key.setFlurstueckNenner(selectedFlurstueckSchluesselBean.getFlurstueckNenner());
            key.setId(selectedFlurstueckSchluesselBean.getId());
            return key;
        }
        return null;
    }

    public Mode getMode() {
        return this.currentMode;
    }

    @Override
    public void requestFlurstueck(FlurstueckSchluesselCustomBean key) {
        this.doAutomaticRequest(0, key);
    }

    @Override
    public void updateFlurstueckKeys() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        Object currentKey = this.cboFlurstueck.getSelectedItem();
        if (currentFlurstueck != null) {
            this.doAutomaticRequest(1, currentFlurstueck.getFlurstueckSchluessel());
        } else if (currentKey != null && currentKey instanceof FlurstueckSchluesselCustomBean) {
            this.doAutomaticRequest(1, (FlurstueckSchluesselCustomBean)currentKey);
        } else {
            this.doAutomaticRequest(2, null);
        }
    }

    public void addRemoveFilter(FlurstueckSchluesselCustomBean key) {
        this.removeFilter.add(key);
    }

    public void removeRemoveFilter(FlurstueckSchluesselCustomBean key) {
        this.removeFilter.remove(key);
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public String getValidationMessage() {
        if (this.currentMode == Mode.SEARCH) {
            if (this.currentFlurstueckBean != null) {
                return "Es wurde ein Flurst\u00fcck ausgew\u00e4\u00e4hlt";
            }
            return "Es wurde kein Flurst\u00fcck ausgew\u00e4hlt";
        }
        if (this.currentMode == Mode.CONTINUATION || this.currentMode == Mode.CONTINUATION_HISTORIC) {
            if (this.currentFlurstueckBean != null) {
                return "Aktuell ausgew\u00e4hltes Flurst\u00fcck vollst\u00e4ndig.";
            }
            return "Bitte vervollst\u00e4ndigen Sie alle Flurst\u00fccke";
        }
        if (this.currentMode == Mode.CREATION) {
            return this.creationValidationMessage;
        }
        return "Unbekannter Modus";
    }

    @Override
    public int getStatus() {
        if (this.currentMode == Mode.SEARCH) {
            if (this.currentFlurstueckBean != null) {
                return 0;
            }
            return 2;
        }
        if (this.currentMode == Mode.CONTINUATION || this.currentMode == Mode.CONTINUATION_HISTORIC) {
            if (this.currentFlurstueckBean != null) {
                return 0;
            }
            return 2;
        }
        if (this.currentMode == Mode.CREATION) {
            if (this.isFlurstueckCreateable.booleanValue() && this.isFlurstueckCandidateValide) {
                return 0;
            }
            return 2;
        }
        return 2;
    }

    private void checkIfFlurstueckIsAlreadyInDatabase(FlurstueckSchluesselCustomBean key, boolean isFlurstueckValide) {
        if (this.currentFlurstueckChecker != null && !this.currentFlurstueckChecker.isDone()) {
            this.currentFlurstueckChecker.cancel(false);
            this.currentFlurstueckChecker = null;
        }
        this.currentFlurstueckChecker = new FlurstueckChecker(key, isFlurstueckValide);
        LagisBroker.getInstance().execute(this.currentFlurstueckChecker);
    }

    private void cboGemarkungActionPerformed(ActionEvent evt) {
        if (this.cboGemarkungListenerEnabled) {
            Object selectedItem = this.cboGemarkung.getSelectedItem();
            if (this.currentGemarkungsRetriever != null && !this.currentGemarkungsRetriever.isDone()) {
                this.currentGemarkungsRetriever.cancel(false);
                this.currentGemarkungsRetriever = null;
            } else if (this.currentGemarkungsRetriever != null && this.currentGemarkungsRetriever.isDone() && this.currentGemarkungsRetriever.wasResolved) {
                this.currentGemarkungsRetriever = new GemarkungRetriever(GemarkungRetrieverMode.RETRIEVE_WITH_RESOLVED, evt, this.currentGemarkungsRetriever.selectedGemarkung);
                LagisBroker.getInstance().execute(this.currentGemarkungsRetriever);
                return;
            }
            this.currentGemarkungsRetriever = new GemarkungRetriever(GemarkungRetrieverMode.RETRIEVE_FLURE, evt, selectedItem);
            LagisBroker.getInstance().execute(this.currentGemarkungsRetriever);
        }
    }

    private void cboFlurActionPerformed(ActionEvent evt) {
        if (this.cboFlurListenerEnabled) {
            Object selectedItem = this.cboFlur.getSelectedItem();
            if (this.currentFlurRetriever != null && !this.currentFlurRetriever.isDone()) {
                this.currentFlurRetriever.cancel(false);
                this.currentFlurRetriever = null;
            }
            this.currentFlurRetriever = new FlurRetriever(0, evt, selectedItem);
            LagisBroker.getInstance().execute(this.currentFlurRetriever);
        }
    }

    private void cboFlurstueckActionPerformed(ActionEvent evt) {
        if (this.cboFlurstueckListenerEnabled) {
            Object selectedItem = this.cboFlurstueck.getSelectedItem();
            if (this.currentFlurstueckRetriever != null && !this.currentFlurstueckRetriever.isDone()) {
                this.currentFlurstueckRetriever.cancel(false);
                this.currentFlurstueckRetriever = null;
            }
            if (this.currentWFSRetriever != null && !this.currentWFSRetriever.isDone()) {
                this.currentWFSRetriever.cancel(false);
                this.currentWFSRetriever = null;
            }
            this.currentFlurstueckRetriever = new FlurstueckRetriever(0, evt, selectedItem);
            LagisBroker.getInstance().execute(this.currentFlurstueckRetriever);
        }
    }

    public void addComboBoxListener(ActionListener listener) {
        this.cboGemarkung.addActionListener(listener);
        this.cboFlur.addActionListener(listener);
        this.cboFlurstueck.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.cboGemarkung.removeActionListener(listener);
        this.cboFlur.removeActionListener(listener);
        this.cboFlurstueck.removeActionListener(listener);
    }

    public void setStatus(Status status) {
        this.btnAction.setIcon(FlurstueckChooser.getIcon(status));
    }

    public static Status identifyStatus(FlurstueckSchluesselCustomBean flurstueckSchluessel) {
        FlurstueckArtCustomBean flurstuecksArt = flurstueckSchluessel.getFlurstueckArt();
        if (flurstuecksArt != null && flurstuecksArt.getBezeichnung().equals("st\u00e4dtisch")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Art des Flurst\u00fccks ist St\u00e4dtisch");
            }
            if (flurstueckSchluessel.getGueltigBis() != null) {
                return Status.STAEDTISCH_HISTORIC;
            }
            return Status.STAEDTISCH;
        }
        if (flurstuecksArt != null && flurstuecksArt.getBezeichnung().equals("Abteilung IX")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Art des Flurst\u00fccks ist Abteilung IX");
            }
            if (flurstueckSchluessel.getGueltigBis() != null) {
                return Status.ABTEILUNG_IX_HISTORIC;
            }
            return Status.ABTEILUNG_IX;
        }
        LOG.warn((Object)"Art des Flurst\u00fccks nicht bekannt");
        return null;
    }

    public static Icon getIcon(Status status) {
        if (status != null) {
            switch (status) {
                case STAEDTISCH_HISTORIC: {
                    return ICON_STAEDTISCH_HISTORIC;
                }
                case STAEDTISCH: {
                    return ICON_STAEDTISCH;
                }
                case ABTEILUNG_IX_HISTORIC: {
                    return ICON_ABTEILUNGIX_HISTORIC;
                }
                case ABTEILUNG_IX: {
                    return ICON_ABTEILUNGIX;
                }
                case UNKNOWN_FLURSTUECK: {
                    return ICON_UNKNOWNFLURSTUECK;
                }
                case WFS_WARN: {
                    return ICON_WFSWARN;
                }
            }
        }
        return ICON_UNKNOWNFLURSTUECK;
    }

    private class FlurtstueckNamedStyledFeature
    extends DefaultStyledFeature
    implements FeatureNameProvider {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    class DocumentListenerImpl
    implements DocumentListener {
        DocumentListenerImpl() {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean = FlurstueckSchluesselCustomBean.createNew();
            Object currentFlur = FlurstueckChooser.this.cboFlur.getSelectedItem();
            if (currentFlur != null && currentFlur instanceof FlurKey) {
                FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean.setGemarkung(((FlurKey)currentFlur).getGemarkung());
                FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean.setFlur(((FlurKey)currentFlur).getFlurId());
                String text = FlurstueckChooser.this.txtFlurstueck.getText();
                if (text != null) {
                    if (text.length() != 0) {
                        String[] tokens = text.split("/");
                        try {
                            switch (tokens.length) {
                                case 1: {
                                    FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                                    FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean.setFlurstueckNenner(0);
                                    FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                                    FlurstueckChooser.this.txtFlurstueck.setToolTipText(FlurstueckChooser.FEATURE_GRP);
                                    FlurstueckChooser.this.creationValidationMessage = "Flurst\u00fcck ist valide";
                                    FlurstueckChooser.this.isFlurstueckCandidateValide = true;
                                    FlurstueckChooser.this.checkIfFlurstueckIsAlreadyInDatabase(FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean, true);
                                    break;
                                }
                                case 2: {
                                    FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                                    FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean.setFlurstueckNenner(Integer.parseInt(tokens[1]));
                                    FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                                    FlurstueckChooser.this.txtFlurstueck.setToolTipText(FlurstueckChooser.FEATURE_GRP);
                                    FlurstueckChooser.this.creationValidationMessage = "Flurst\u00fcck ist valide";
                                    FlurstueckChooser.this.isFlurstueckCandidateValide = true;
                                    FlurstueckChooser.this.checkIfFlurstueckIsAlreadyInDatabase(FlurstueckChooser.this.currentlyCreatedFlurstueckSchluesselBean, true);
                                    break;
                                }
                                default: {
                                    LOG.warn((Object)"Falsche Eingabe erwarted wird ein Flurstueck ohne oder mit Nenner z.B. 10\n");
                                    FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                                    FlurstueckChooser.this.txtFlurstueck.setToolTipText("Es ist nur ein Teiler / erlaubt");
                                    FlurstueckChooser.this.creationValidationMessage = FlurstueckChooser.this.txtFlurstueck.getToolTipText();
                                    FlurstueckChooser.this.isFlurstueckCandidateValide = false;
                                    FlurstueckChooser.this.fireValidationStateChanged(this);
                                    break;
                                }
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Fehler beim parsen des Flurst\u00fcck Z\u00e4hler/Nenner", (Throwable)ex);
                            FlurstueckChooser.this.txtFlurstueck.setToolTipText("Kein g\u00fcltiger Flurst\u00fccksname. G\u00fcltige Namen sind z.B. 3, 3/0 , 3/15");
                            FlurstueckChooser.this.creationValidationMessage = FlurstueckChooser.this.txtFlurstueck.getToolTipText();
                            FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                            FlurstueckChooser.this.isFlurstueckCandidateValide = false;
                            FlurstueckChooser.this.fireValidationStateChanged(this);
                        }
                    } else {
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                        FlurstueckChooser.this.txtFlurstueck.setToolTipText("Bitte geben Sie ein Flurst\u00fcck ein.");
                        FlurstueckChooser.this.creationValidationMessage = FlurstueckChooser.this.txtFlurstueck.getToolTipText();
                        FlurstueckChooser.this.isFlurstueckCreateable = false;
                        FlurstueckChooser.this.fireValidationStateChanged(this);
                    }
                }
            } else {
                FlurstueckChooser.this.isFlurstueckCandidateValide = false;
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.removeUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    class FocusListenerImpl
    implements FocusListener {
        FocusListenerImpl() {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    public class AutomaticFlurstueckRetriever
    extends SwingWorker<Void, Void>
    implements PropertyChangeListener {
        public static final int FLURSTUECK_REQUEST_MODE = 0;
        public static final int FILTER_ACTION_MODE = 1;
        public static final int SET_BOXES_ACCORDING_TO_CONTENT_MODE = 2;
        public static final int COPY_CONTENT_MODE = 3;
        private final Color initialColor;
        private int mode;
        private FlurstueckSchluesselCustomBean key;
        private boolean isFinished = false;

        public AutomaticFlurstueckRetriever(int mode, FlurstueckSchluesselCustomBean key) {
            this(mode, key, null);
        }

        public AutomaticFlurstueckRetriever(int mode, FlurstueckSchluesselCustomBean key, Color initialColor) {
            this.key = key;
            this.mode = mode;
            this.initialColor = initialColor;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                if (this.key == null) {
                    return null;
                }
                while (!this.isCancelled() && !this.isFinished) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Fehler beim automatischen abrufen eines Flurst\u00fccks.", (Throwable)e);
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            if (this.key != null && !this.isFinished) {
                LOG.warn((Object)"Fehler beim automatischen Request (done)");
            }
            FlurstueckChooser.this.cboGemarkungListenerEnabled = true;
            FlurstueckChooser.this.cboFlurListenerEnabled = true;
            FlurstueckChooser.this.cboFlurstueckListenerEnabled = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof GemarkungRetriever && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                if (FlurstueckChooser.this.currentFlurRetriever != null && !FlurstueckChooser.this.currentFlurRetriever.isDone()) {
                    FlurstueckChooser.this.currentFlurRetriever.cancel(false);
                    FlurstueckChooser.this.currentFlurRetriever = null;
                }
                FlurKey newFlur = new FlurKey(this.key.getGemarkung(), this.key.getFlur());
                FlurstueckChooser.this.cboFlur.setSelectedItem(newFlur);
                FlurstueckChooser.this.currentFlurRetriever = new FlurRetriever(1, null, newFlur);
                FlurstueckChooser.this.setPropertyChangeListener(FlurstueckChooser.this.currentFlurRetriever);
                LagisBroker.getInstance().execute(FlurstueckChooser.this.currentFlurRetriever);
            } else if (evt.getSource() instanceof FlurRetriever && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                if (0 == this.mode || FlurstueckChooser.this.filter != Filter.CURRENT && FlurstueckChooser.this.filter != Filter.HISTORIC || FlurstueckChooser.this.filter == Filter.CURRENT && this.key.getGueltigBis() == null || FlurstueckChooser.this.filter == Filter.HISTORIC && this.key.getGueltigBis() != null) {
                    if (FlurstueckChooser.this.currentFlurstueckRetriever != null && !FlurstueckChooser.this.currentFlurstueckRetriever.isDone()) {
                        FlurstueckChooser.this.currentFlurstueckRetriever.cancel(false);
                        FlurstueckChooser.this.currentFlurstueckRetriever = null;
                    }
                    if (FlurstueckChooser.this.currentWFSRetriever != null && !FlurstueckChooser.this.currentWFSRetriever.isDone()) {
                        FlurstueckChooser.this.currentWFSRetriever.cancel(false);
                        FlurstueckChooser.this.currentWFSRetriever = null;
                    }
                    FlurstueckChooser.this.cboFlurstueck.setSelectedItem(this.key);
                    FlurstueckChooser.this.cboGemarkung.setSelectedItem(this.key.getGemarkung());
                    if (0 == this.mode) {
                        FlurstueckChooser.this.currentFlurstueckRetriever = new FlurstueckRetriever(1, null, this.key);
                        FlurstueckChooser.this.setPropertyChangeListener(FlurstueckChooser.this.currentFlurstueckRetriever);
                        LagisBroker.getInstance().execute(FlurstueckChooser.this.currentFlurstueckRetriever);
                    } else {
                        if (this.mode == 3) {
                            FlurstueckChooser.this.cboFlurstueck.requestFocus();
                        }
                        if (this.initialColor != null) {
                            FlurstueckChooser.this.setHighlightColor(this.initialColor);
                        } else {
                            LOG.warn((Object)"Kann die Farbe nicht mehr darstellen == null");
                        }
                        this.isFinished = true;
                    }
                } else {
                    LagisBroker.getInstance().fireFlurstueckChanged(null);
                    this.isFinished = true;
                }
            } else if (evt.getSource() instanceof FlurstueckRetriever && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                this.isFinished = true;
            } else {
                LOG.warn((Object)"Kein Propertychange auf das geh\u00f6rt wird");
            }
        }

        public int getMode() {
            return this.mode;
        }
    }

    private class WFSRequestJobDone
    implements DoneDelegate<Geometry, Void> {
        private static final int HAS_MANY_VERWALTUNGSBEREICHE = 0;
        private static final int IS_NO_GEOMETRY_ASSIGNED = 1;

        private WFSRequestJobDone() {
        }

        @Override
        public void jobDone(ExtendedSwingWorker<Geometry, Void> worker, HashMap<Integer, Boolean> properties) {
            try {
                if (worker.isCancelled()) {
                    LagisBroker.getInstance().flurstueckChangeFinished(FlurstueckChooser.this);
                    return;
                }
                Geometry result = (Geometry)worker.get();
                if (result != null) {
                    result.setSRID(25832);
                    LOG.info((Object)("CurrentWFSGeometry SRS=" + result.getSRID() + " " + result));
                }
                LagisBroker.getInstance().setCurrentWFSGeometry(result);
                if (result == null) {
                    LOG.warn((Object)"could not retrieve WFS geometry");
                    LagisBroker.getInstance().flurstueckChangeFinished(FlurstueckChooser.this);
                    return;
                }
                if (worker.hadErrors()) {
                    FlurstueckChooser.this.btnAction.setToolTipText(worker.getErrorMessage());
                    FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                    FlurstueckChooser.this.setStatus(Status.WFS_WARN);
                    LagisBroker.getInstance().flurstueckChangeFinished(FlurstueckChooser.this);
                    return;
                }
                FlurstueckChooser.this.btnAction.setToolTipText("");
                if (worker.getKeyObject() != null && worker.getKeyObject() instanceof FlurstueckSchluesselCustomBean) {
                    FlurstueckSchluesselCustomBean flurstueckKey = (FlurstueckSchluesselCustomBean)worker.getKeyObject();
                    if (flurstueckKey.getId() == null || flurstueckKey.getId() == -1) {
                        LagisBroker.getInstance().setCurrentFlurstueckSchluessel(flurstueckKey, true);
                    }
                    Object tmpFeature = null;
                    if (properties != null) {
                        boolean isNoGeometryAssigned;
                        boolean hasManyVerwaltungsbereiche = properties.get(0) != null ? properties.get(0) : false;
                        boolean bl = isNoGeometryAssigned = properties.get(1) != null ? properties.get(1) : false;
                        if (!hasManyVerwaltungsbereiche && isNoGeometryAssigned) {
                            tmpFeature = new FlurtstueckNamedStyledFeature();
                            tmpFeature.setEditable(false);
                            ((DefaultStyledFeature)tmpFeature).setCanBeSelected(false);
                            FlurstueckArtCustomBean flurstueckArt = flurstueckKey.getFlurstueckArt();
                            DefaultStyledFeature styledFeature = tmpFeature;
                            String flurstueckArtBez = flurstueckArt != null ? flurstueckArt.getBezeichnung() : null;
                            Date gueltigBis = flurstueckKey.getGueltigBis();
                            if (flurstueckArt == null) {
                                styledFeature.setFillingPaint((Paint)LagisBroker.UNKNOWN_FILLING_COLOR);
                            } else if ("st\u00e4dtisch".equals(flurstueckArtBez) && gueltigBis == null) {
                                styledFeature.setFillingPaint((Paint)LagisBroker.STADT_FILLING_COLOR);
                            } else if (gueltigBis != null && ("st\u00e4dtisch".equals(flurstueckArtBez) || "Abteilung IX".equals(flurstueckArtBez))) {
                                styledFeature.setFillingPaint((Paint)LagisBroker.HISTORIC_FLURSTUECK_COLOR);
                            } else if ("Abteilung IX".equals(flurstueckArtBez)) {
                                styledFeature.setFillingPaint((Paint)LagisBroker.ABTEILUNG_IX_FILLING_COLOR);
                            } else {
                                styledFeature.setFillingPaint((Paint)LagisBroker.UNKNOWN_FILLING_COLOR);
                            }
                            tmpFeature.setGeometry(result);
                            tmpFeature.setName(flurstueckKey.getKeyString());
                            tmpFeature = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)tmpFeature, FlurstueckChooser.FEATURE_GRP, FlurstueckChooser.FEATURE_GRP);
                        } else if (hasManyVerwaltungsbereiche && isNoGeometryAssigned) {
                            tmpFeature = new PureNewFeature(result);
                            tmpFeature.setEditable(true);
                            ((PureNewFeature)tmpFeature).setCanBeSelected(true);
                        } else {
                            LOG.warn((Object)"Nicht vorgesehner Fall !! --> Der Karte wird nichts hinzugef\u00fcgt!");
                        }
                    } else {
                        LOG.error((Object)"Properties sind null --> kann kein Feature hinzuf\u00fcgen");
                    }
                    if (tmpFeature != null) {
                        LagisBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(tmpFeature);
                    }
                } else {
                    LagisBroker.getInstance().setCurrentWFSGeometry(null);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim abrufen der WFS Geometrie (done)", (Throwable)ex);
                LagisBroker.getInstance().setCurrentWFSGeometry(null);
            }
            LagisBroker.getInstance().flurstueckChangeFinished(FlurstueckChooser.this);
        }
    }

    class FlurstueckChecker
    extends SwingWorker<Boolean, Void> {
        private FlurstueckSchluesselCustomBean keyToCheck;
        private boolean isFlurstueckCandidateValide;
        private boolean hadErrors;
        private String errorMessage;

        public FlurstueckChecker(FlurstueckSchluesselCustomBean keyToCheck, boolean isFlurstueckCandidateValide) {
            this.keyToCheck = keyToCheck;
            this.isFlurstueckCandidateValide = isFlurstueckCandidateValide;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            try {
                if (this.isCancelled()) {
                    return null;
                }
                if (this.isFlurstueckCandidateValide) {
                    this.keyToCheck = LagisBroker.getInstance().completeFlurstueckSchluessel(this.keyToCheck);
                    return this.keyToCheck != null;
                }
                return false;
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim checken des Flurstuecks: " + ex));
                this.hadErrors = true;
                this.errorMessage = "Fehler beim pr\u00fcfen des Flurst\u00fccks";
                return false;
            }
        }

        @Override
        protected void done() {
            try {
                if (this.isCancelled()) {
                    return;
                }
                if (this.hadErrors) {
                    FlurstueckChooser.this.txtFlurstueck.setToolTipText(this.errorMessage);
                    FlurstueckChooser.this.isFlurstueckCreateable = false;
                    return;
                }
                if (this.isFlurstueckCandidateValide) {
                    Boolean keyAlreadyExisiting = (Boolean)this.get();
                    if (keyAlreadyExisiting.booleanValue()) {
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                        FlurstueckChooser.this.txtFlurstueck.setToolTipText("Flurst\u00fcck ist bereits vorhanden");
                        FlurstueckChooser.this.isFlurstueckCreateable = false;
                        FlurstueckChooser.this.creationValidationMessage = FlurstueckChooser.this.txtFlurstueck.getToolTipText();
                        FlurstueckChooser.this.fireValidationStateChanged(this);
                    } else {
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.SUCCESSFUL_COLOR);
                        FlurstueckChooser.this.txtFlurstueck.setToolTipText("Flurst\u00fcck ist noch nicht vorhanden und kann angelegt werden");
                        FlurstueckChooser.this.creationValidationMessage = FlurstueckChooser.this.txtFlurstueck.getToolTipText();
                        FlurstueckChooser.this.isFlurstueckCreateable = true;
                        FlurstueckChooser.this.fireValidationStateChanged(this);
                    }
                } else {
                    FlurstueckChooser.this.txtFlurstueck.setToolTipText("Der Flurst\u00fccksschl\u00fcssel ist nicht valide");
                    FlurstueckChooser.this.creationValidationMessage = FlurstueckChooser.this.txtFlurstueck.getToolTipText();
                    FlurstueckChooser.this.isFlurstueckCreateable = false;
                    FlurstueckChooser.this.fireValidationStateChanged(this);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim checken des Flurst\u00fccks (done)", (Throwable)ex);
                FlurstueckChooser.this.isFlurstueckCreateable = false;
                FlurstueckChooser.this.fireValidationStateChanged(this);
            }
            FlurstueckChooser.this.validationMessageLock.lock();
            try {
                FlurstueckChooser.this.creationValidationMessage = FlurstueckChooser.this.txtFlurstueck.getToolTipText();
            }
            finally {
                FlurstueckChooser.this.validationMessageLock.unlock();
            }
        }
    }

    class FlurstueckRetriever
    extends SwingWorker<FlurstueckCustomBean, Void> {
        private static final int RETRIEVE_NORMAL_MODE = 0;
        private static final int RETRIEVE_AUTOMATIC_MODE = 1;
        private int mode;
        private boolean isAutoComplete = false;
        private FlurstueckSchluesselCustomBean selectedFlurstueck;
        private String errorMessage = null;
        private boolean hadErrors = false;
        private boolean isFlurstueckInDatabase = true;
        private final Object selectedItem;
        private final ActionEvent event;

        public FlurstueckRetriever(int mode, ActionEvent event, Object selectedItem) {
            this.mode = mode;
            this.event = event;
            this.selectedItem = selectedItem;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected FlurstueckCustomBean doInBackground() throws Exception {
            try {
                block38: {
                    block37: {
                        FlurKey currentFlur;
                        if (this.mode != 1 && !(this.event.getSource() instanceof JComboBox)) {
                            LOG.warn((Object)"Eventsource nicht bekannt");
                            this.selectedFlurstueck = null;
                            return null;
                        }
                        if (this.mode == 1 || this.event.getActionCommand().equals("comboBoxChanged")) {
                            if (this.mode == 1 || (this.event.getModifiers() & 0x10) != 0 || this.event.getModifiers() != 0 && (this.event.getModifiers() & 0x40) != 0) {
                                if (!(this.selectedItem instanceof FlurstueckSchluesselCustomBean)) {
                                    this.selectedFlurstueck = null;
                                    return null;
                                }
                                this.selectedFlurstueck = (FlurstueckSchluesselCustomBean)this.selectedItem;
                                if (this.isCancelled()) {
                                    return null;
                                }
                                break block37;
                            } else {
                                this.isAutoComplete = true;
                                this.selectedFlurstueck = null;
                                return null;
                            }
                        }
                        if (!this.event.getActionCommand().equals("comboBoxEdited")) {
                            this.selectedFlurstueck = null;
                            return null;
                        }
                        this.selectedFlurstueck = FlurstueckSchluesselCustomBean.createNew();
                        Object tmpFlur = FlurstueckChooser.this.cboFlur.getSelectedItem();
                        if (tmpFlur instanceof FlurKey) {
                            currentFlur = (FlurKey)tmpFlur;
                        } else if (tmpFlur instanceof String) {
                            currentFlur = new FlurKey((GemarkungCustomBean)FlurstueckChooser.this.cboGemarkung.getSelectedItem(), (Integer)Integer.parseInt((String)tmpFlur));
                        } else {
                            LOG.warn((Object)"Unbekanntes Objekt in cboFlur");
                            currentFlur = null;
                        }
                        if (currentFlur == null) {
                            this.selectedFlurstueck = null;
                            return null;
                        }
                        this.selectedFlurstueck.setGemarkung(currentFlur.getGemarkung());
                        this.selectedFlurstueck.setFlur(currentFlur.getFlurId());
                        String flurstueck = FlurstueckChooser.this.cboFlurstueck.getEditor().getItem().toString();
                        if (this.isCancelled()) {
                            return null;
                        }
                        if (flurstueck != null && flurstueck.length() > 0) {
                            try {
                                String[] tokens = flurstueck.split("/");
                                switch (tokens.length) {
                                    case 1: {
                                        this.selectedFlurstueck.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                                        this.selectedFlurstueck.setFlurstueckNenner(0);
                                        break;
                                    }
                                    case 2: {
                                        this.selectedFlurstueck.setFlurstueckZaehler(Integer.parseInt(tokens[0]));
                                        this.selectedFlurstueck.setFlurstueckNenner(Integer.parseInt(tokens[1]));
                                        break;
                                    }
                                    default: {
                                        LOG.warn((Object)"Falsche Eingabe erwarted wird ein Flurstueck ohne oder mit Nenner z.B. 10\n");
                                        this.selectedFlurstueck = null;
                                        return null;
                                    }
                                }
                            }
                            catch (NumberFormatException ex) {
                                LOG.error((Object)"Fehler beim parsen des Flurst\u00fcckSchl\u00fcssels", (Throwable)ex);
                                this.hadErrors = true;
                                this.errorMessage = "Format des Flurst\u00fccksz\u00e4hler/-nenner stimmt nicht (Zahl/Zahl)";
                                this.selectedFlurstueck = null;
                                return null;
                            }
                        } else {
                            if (flurstueck != null && flurstueck.equals("")) {
                                this.selectedFlurstueck = null;
                                return null;
                            }
                            LOG.warn((Object)"Unbekannter Fall");
                            this.selectedFlurstueck = null;
                            return null;
                        }
                    }
                    if (this.isCancelled()) {
                        return null;
                    }
                    FlurstueckSchluesselCustomBean tmpKey = LagisBroker.getInstance().completeFlurstueckSchluessel(this.selectedFlurstueck);
                    if (this.isCancelled()) {
                        return null;
                    }
                    if (tmpKey != null) {
                        this.selectedFlurstueck = tmpKey;
                    }
                    if (this.selectedFlurstueck.getId() != null && this.selectedFlurstueck.getId() != -1) {
                        FlurstueckCustomBean flurstueck;
                        if (FlurstueckChooser.this.currentMode == Mode.SEARCH) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FlurstueckChooser.this.pbFlurstueck.setIndeterminate(true);
                                    FlurstueckChooser.this.pbTxtFlurstueck.setIndeterminate(true);
                                }
                            });
                            if (!LagisBroker.getInstance().isInEditMode()) {
                                if (this.isCancelled()) {
                                    return null;
                                }
                                flurstueck = LagisBroker.getInstance().retrieveFlurstueck(this.selectedFlurstueck);
                                if (this.isCancelled()) {
                                    return null;
                                }
                                if (flurstueck != null) {
                                    return flurstueck;
                                }
                                this.selectedFlurstueck = null;
                                return null;
                            }
                            if (this.isCancelled()) {
                                return null;
                            }
                            break block38;
                        } else {
                            flurstueck = LagisBroker.getInstance().retrieveFlurstueck(this.selectedFlurstueck);
                            if (flurstueck != null) {
                                return flurstueck;
                            }
                            this.selectedFlurstueck = null;
                            return null;
                        }
                    }
                    if (FlurstueckChooser.this.currentMode != Mode.CONTINUATION && FlurstueckChooser.this.currentMode != Mode.CONTINUATION_HISTORIC) {
                        FlurstueckCustomBean container = FlurstueckCustomBean.createNew();
                        container.setFlurstueckSchluessel(this.selectedFlurstueck);
                        this.isFlurstueckInDatabase = false;
                        return container;
                    }
                    this.hadErrors = true;
                    this.errorMessage = "Das eingegebene Flurst\u00fcck existiert nicht";
                    return null;
                }
                JOptionPane.showMessageDialog(LagisApp.getInstance(), "Das Flurst\u00fcck kann nur gewechselt werden wenn alle \u00c4nderungen gespeichert oder verworfen worden sind.", "Wechseln nicht m\u00f6glich", 2);
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Abrufen des Flurst\u00fccks", (Throwable)ex);
                this.hadErrors = true;
                this.errorMessage = "Flurst\u00fcck konnte nicht abgerufen werden";
            }
            this.selectedFlurstueck = null;
            return null;
        }

        @Override
        protected void done() {
            try {
                FlurstueckChooser.this.pbFlurstueck.setIndeterminate(false);
                FlurstueckChooser.this.pbTxtFlurstueck.setIndeterminate(false);
                if (this.isAutoComplete) {
                    return;
                }
                if (this.isCancelled()) {
                    return;
                }
                if (this.selectedFlurstueck != null && !this.hadErrors) {
                    FlurstueckCustomBean result = (FlurstueckCustomBean)this.get();
                    FlurstueckChooser.this.currentFlurstueckBean = result;
                    if (result != null) {
                        if (this.isFlurstueckInDatabase) {
                            FlurstueckChooser.this.setHighlightColor(LagisBroker.SUCCESSFUL_COLOR);
                            if (FlurstueckChooser.this.currentMode == Mode.SEARCH) {
                                LagisBroker.getInstance().fireFlurstueckChanged(result);
                            }
                        } else if (FlurstueckChooser.this.currentMode == Mode.SEARCH) {
                            FlurstueckChooser.this.setHighlightColor(LagisBroker.UNKOWN_COLOR);
                            LagisBroker.getInstance().setCurrentFlurstueckSchluessel(result.getFlurstueckSchluessel(), true);
                            LagisBroker.getInstance().resetWidgets();
                            LagisBroker.getInstance().getMappingComponent().getFeatureCollection().removeAllFeatures();
                            if (FlurstueckChooser.this.currentWFSRetriever != null && !FlurstueckChooser.this.currentWFSRetriever.isDone()) {
                                FlurstueckChooser.this.currentWFSRetriever.cancel(false);
                                FlurstueckChooser.this.currentWFSRetriever = null;
                            }
                            HashMap<Integer, Boolean> properties = new HashMap<Integer, Boolean>();
                            properties.put(0, false);
                            properties.put(1, true);
                            FlurstueckChooser.this.currentWFSRetriever = WFSRetrieverFactory.getInstance().getWFSRetriever(result.getFlurstueckSchluessel(), new WFSRequestJobDone(), properties);
                            LagisBroker.getInstance().execute(FlurstueckChooser.this.currentWFSRetriever);
                        }
                    }
                } else if (this.hadErrors) {
                    FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                    FlurstueckChooser.this.btnAction.setToolTipText(this.errorMessage);
                } else {
                    FlurstueckChooser.this.btnAction.setToolTipText("");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim abrufen des Flurst\u00fccks (done)", (Throwable)ex);
                FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
            }
            FlurstueckChooser.this.fireValidationStateChanged(FlurstueckChooser.this);
        }
    }

    class FlurRetriever
    extends SwingWorker<List<Key>, Void> {
        private static final int RETRIEVE_NORMAL_MODE = 0;
        private static final int RETRIEVE_AUTOMATIC_MODE = 1;
        private int mode;
        private boolean isAutoComplete = false;
        private FlurKey selectedFlur;
        private String errorMessage = null;
        private boolean hadErrors = false;
        private final Object selectedItem;
        private final ActionEvent event;
        private boolean flurWasCreated = false;

        public FlurRetriever(int mode, ActionEvent event, Object selectedItem) {
            this.mode = mode;
            this.event = event;
            this.selectedItem = selectedItem;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected List<Key> doInBackground() throws Exception {
            try {
                block21: {
                    block22: {
                        if (1 != this.mode && !(this.event.getSource() instanceof JComboBox)) {
                            LOG.warn((Object)"Eventsource nicht bekannt");
                            this.selectedFlur = null;
                            return null;
                        }
                        if (1 == this.mode || this.event.getActionCommand().equals("comboBoxChanged")) {
                            if (1 == this.mode || (this.event.getModifiers() & 0x10) != 0 || this.event.getModifiers() != 0 && (this.event.getModifiers() & 0x40) != 0) {
                                if (!(this.selectedItem instanceof FlurKey)) {
                                    this.selectedFlur = null;
                                    return null;
                                }
                                this.selectedFlur = (FlurKey)this.selectedItem;
                                if (this.isCancelled()) {
                                    return null;
                                }
                                break block21;
                            } else {
                                this.isAutoComplete = true;
                                this.selectedFlur = null;
                                return null;
                            }
                        }
                        if (!this.event.getActionCommand().equals("comboBoxEdited")) {
                            this.selectedFlur = null;
                            return null;
                        }
                        String flurInput = ((JComboBox)this.event.getSource()).getEditor().getItem().toString();
                        try {
                            if (flurInput != null && flurInput.equals("")) {
                                this.selectedFlur = null;
                                return null;
                            }
                            GemarkungCustomBean currentGemarkung = (GemarkungCustomBean)FlurstueckChooser.this.cboGemarkung.getSelectedItem();
                            if (currentGemarkung == null) {
                                this.selectedFlur = null;
                                return null;
                            }
                            this.selectedFlur = new FlurKey(currentGemarkung, (Integer)Integer.parseInt(flurInput));
                            KeyComboboxModel flurModel = (KeyComboboxModel)FlurstueckChooser.this.cboFlur.getModel();
                            if (FlurstueckChooser.this.currentMode == Mode.SEARCH || FlurstueckChooser.this.currentMode == Mode.CREATION) {
                                if (!flurModel.contains(this.selectedFlur)) {
                                    this.flurWasCreated = true;
                                }
                                break block22;
                            }
                            if (!flurModel.contains(this.selectedFlur)) {
                                this.hadErrors = true;
                                this.errorMessage = "Der eingegebene Flur existiert nicht";
                                return null;
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Fehler beim erstellen des FlurKeys --> keine M\u00f6glichkeit Flurst\u00fccke zu bestimmen", (Throwable)ex);
                            this.hadErrors = true;
                            this.errorMessage = "Fehlerhaftes Format des Flurs.";
                            this.selectedFlur = null;
                            return null;
                        }
                    }
                    if (this.isCancelled()) {
                        return null;
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FlurstueckChooser.this.pbFlur.setIndeterminate(true);
                    }
                });
                this.selectedFlur.setCurrentFilterEnabled(FlurstueckChooser.this.filter == Filter.CURRENT);
                this.selectedFlur.setHistoricFilterEnabled(FlurstueckChooser.this.filter == Filter.HISTORIC);
                this.selectedFlur.setAbteilungXIFilterEnabled(FlurstueckChooser.this.filter == Filter.ABTEILUNG_IX);
                this.selectedFlur.setStaedtischFilterEnabled(FlurstueckChooser.this.filter == Filter.STAEDTISCH);
                Collection<Key> flurKeys = LagisBroker.getInstance().getDependingKeysForKey(this.selectedFlur);
                if (this.isCancelled()) {
                    return null;
                }
                if (flurKeys == null) {
                    return new ArrayList<Key>();
                }
                if (this.isCancelled()) {
                    return null;
                }
                ArrayList<Key> flurKeyList = new ArrayList<Key>(flurKeys);
                if (this.isCancelled()) {
                    return null;
                }
                Collections.sort(flurKeyList);
                return flurKeyList;
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Abrufen der Flurst\u00fccke", (Throwable)ex);
                this.selectedFlur = null;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            block23: {
                try {
                    FlurstueckChooser.this.pbFlur.setIndeterminate(false);
                    if (this.isAutoComplete) {
                        FlurstueckChooser.this.cboFlurstueck.setModel(new KeyComboboxModel());
                        Boolean bl = FlurstueckChooser.this.isFlurstueckCreateable;
                        synchronized (bl) {
                            FlurstueckChooser.this.isFlurstueckCreateable = false;
                        }
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                        FlurstueckChooser.this.txtFlurstueck.setText("");
                        FlurstueckChooser.this.cboFlurstueck.setEnabled(false);
                        FlurstueckChooser.this.txtFlurstueck.setEnabled(false);
                        return;
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                    if (this.selectedFlur != null && !this.hadErrors) {
                        KeyComboboxModel flurModel = (KeyComboboxModel)FlurstueckChooser.this.cboFlur.getModel();
                        if (FlurstueckChooser.this.currentMode == Mode.CREATION && this.flurWasCreated) {
                            flurModel.addElement(this.selectedFlur);
                        }
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                        KeyComboboxModel model = new KeyComboboxModel((List)this.get());
                        Iterator it = FlurstueckChooser.this.removeFilter.iterator();
                        while (it.hasNext()) {
                            model.removeElement(it.next());
                        }
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                        FlurstueckChooser.this.cboFlurstueck.setModel(model);
                        FlurstueckChooser.this.cboFlurstueck.setEnabled(true);
                        FlurstueckChooser.this.txtFlurstueck.setEnabled(true);
                        if (FlurstueckChooser.this.currentAutomaticRetriever == null || FlurstueckChooser.this.currentAutomaticRetriever.isDone() || FlurstueckChooser.this.currentAutomaticRetriever.isCancelled()) {
                            if (FlurstueckChooser.this.currentMode == Mode.CREATION) {
                                FlurstueckChooser.this.txtFlurstueck.requestFocus();
                            } else {
                                FlurstueckChooser.this.cboFlurstueck.requestFocus();
                            }
                        } else if (FlurstueckChooser.this.currentAutomaticRetriever != null && FlurstueckChooser.this.currentAutomaticRetriever.getMode() == 3) {
                            FlurstueckChooser.this.cboFlurstueck.requestFocus();
                        }
                        break block23;
                    }
                    if (this.hadErrors) {
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                        FlurstueckChooser.this.btnAction.setToolTipText(this.errorMessage);
                    } else {
                        FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                        FlurstueckChooser.this.btnAction.setToolTipText("");
                    }
                    Boolean flurModel = FlurstueckChooser.this.isFlurstueckCreateable;
                    synchronized (flurModel) {
                        FlurstueckChooser.this.isFlurstueckCreateable = false;
                    }
                    FlurstueckChooser.this.txtFlurstueck.setText("");
                    FlurstueckChooser.this.cboFlurstueck.setModel(new KeyComboboxModel());
                    FlurstueckChooser.this.cboFlurstueck.setEnabled(false);
                    FlurstueckChooser.this.txtFlurstueck.setEnabled(false);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim setzten der Flurst\u00fccke (done)", (Throwable)ex);
                    FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                    Boolean bl = FlurstueckChooser.this.isFlurstueckCreateable;
                    synchronized (bl) {
                        FlurstueckChooser.this.isFlurstueckCreateable = false;
                    }
                    FlurstueckChooser.this.txtFlurstueck.setText("");
                    FlurstueckChooser.this.cboFlurstueck.setModel(new KeyComboboxModel());
                    FlurstueckChooser.this.cboFlurstueck.setEnabled(false);
                    FlurstueckChooser.this.txtFlurstueck.setEnabled(false);
                }
            }
        }
    }

    class GemarkungRetriever
    extends SwingWorker<List<Key>, Void> {
        private GemarkungRetrieverMode mode;
        private ActionEvent event;
        private Object selectedItem;
        private GemarkungCustomBean selectedGemarkung;
        private boolean wasResolved = false;
        private boolean hadErrors = false;
        private boolean isAutoComplete = false;
        private String errorMessage = null;

        public GemarkungRetriever(GemarkungRetrieverMode mode) {
            this(mode, null, null);
        }

        public GemarkungRetriever(GemarkungRetrieverMode mode, ActionEvent event, Object selectedItem) {
            this.mode = mode;
            this.event = event;
            this.selectedItem = selectedItem;
        }

        @Override
        protected List<Key> doInBackground() throws Exception {
            try {
                if (this.mode == GemarkungRetrieverMode.RETRIEVE_GEMARKUNGEN) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    Collection<GemarkungCustomBean> gemKeys = LagisBroker.getInstance().getGemarkungsKeys();
                    if (this.isCancelled()) {
                        return null;
                    }
                    ArrayList<GemarkungCustomBean> gemKeyList = null;
                    if (gemKeys != null) {
                        gemKeyList = new ArrayList<GemarkungCustomBean>(gemKeys);
                        if (this.isCancelled()) {
                            return null;
                        }
                        Collections.sort(gemKeyList);
                    }
                    if (gemKeyList == null) {
                        gemKeyList = new ArrayList();
                    }
                    return gemKeyList;
                }
                if ((this.mode == GemarkungRetrieverMode.RETRIEVE_FLURE || GemarkungRetrieverMode.RETRIEVE_WITH_RESOLVED == this.mode) && this.event != null || this.mode == GemarkungRetrieverMode.RETRIEVE_AUTOMATIC) {
                    if (this.mode == GemarkungRetrieverMode.RETRIEVE_AUTOMATIC || this.event.getSource() instanceof JComboBox) {
                        if (this.mode == GemarkungRetrieverMode.RETRIEVE_AUTOMATIC || this.event.getActionCommand().equals("comboBoxChanged") || this.mode == GemarkungRetrieverMode.RETRIEVE_WITH_RESOLVED) {
                            if (this.mode == GemarkungRetrieverMode.RETRIEVE_AUTOMATIC || (this.event.getModifiers() & 0x10) != 0 || this.event.getModifiers() != 0 && (this.event.getModifiers() & 0x40) != 0 || this.mode == GemarkungRetrieverMode.RETRIEVE_WITH_RESOLVED) {
                                if (this.selectedItem instanceof GemarkungCustomBean) {
                                    this.selectedGemarkung = (GemarkungCustomBean)this.selectedItem;
                                    if (this.isCancelled()) {
                                        return null;
                                    }
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            FlurstueckChooser.this.pbGemarkung.setIndeterminate(true);
                                        }
                                    });
                                    Collection<Key> flurKeys = LagisBroker.getInstance().getDependingKeysForKey(this.selectedGemarkung);
                                    if (this.isCancelled()) {
                                        return null;
                                    }
                                    if (flurKeys != null) {
                                        if (this.isCancelled()) {
                                            return null;
                                        }
                                        ArrayList<Key> flurKeyList = new ArrayList<Key>(flurKeys);
                                        if (this.isCancelled()) {
                                            return null;
                                        }
                                        Collections.sort(flurKeyList);
                                        return flurKeyList;
                                    }
                                    return new ArrayList<Key>();
                                }
                                this.selectedGemarkung = null;
                                return null;
                            }
                            this.isAutoComplete = true;
                            this.selectedGemarkung = null;
                            return null;
                        }
                        if (this.event.getActionCommand().equals("comboBoxEdited")) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FlurstueckChooser.this.pbGemarkung.setIndeterminate(true);
                                }
                            });
                            String gemInput = ((JComboBox)this.event.getSource()).getEditor().getItem().toString();
                            try {
                                if (this.isCancelled()) {
                                    return null;
                                }
                                this.selectedGemarkung = LagisBroker.getInstance().getGemarkungForKey(Integer.parseInt(gemInput));
                                if (this.isCancelled()) {
                                    return null;
                                }
                            }
                            catch (NumberFormatException ex) {
                                if (gemInput != null && gemInput.equals("")) {
                                    this.selectedGemarkung = null;
                                    return null;
                                }
                                this.selectedGemarkung = GemarkungCustomBean.createNew();
                                this.selectedGemarkung.setBezeichnung(gemInput);
                                if (this.isCancelled()) {
                                    return null;
                                }
                                this.selectedGemarkung = LagisBroker.getInstance().completeGemarkung(this.selectedGemarkung);
                            }
                            if (this.selectedGemarkung != null && this.selectedGemarkung.getId() != null && this.selectedGemarkung.getId() != -1) {
                                this.wasResolved = true;
                                return null;
                            }
                            this.hadErrors = true;
                            this.errorMessage = "Unbekannte Gemarkung";
                            this.selectedGemarkung = null;
                            return null;
                        }
                        this.selectedGemarkung = null;
                        return null;
                    }
                    LOG.warn((Object)"Eventsource nicht bekannt");
                    this.selectedGemarkung = null;
                    return null;
                }
                LOG.warn((Object)"unkown mode oder Event == null oder selectedItem == null");
                this.selectedGemarkung = null;
                return null;
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Abrufen der Gemarkungen/Flure", (Throwable)ex);
                return null;
            }
        }

        @Override
        protected void done() {
            block17: {
                try {
                    FlurstueckChooser.this.pbGemarkung.setIndeterminate(false);
                    if (this.isAutoComplete) {
                        FlurstueckChooser.this.cboFlur.setModel(new KeyComboboxModel());
                        FlurstueckChooser.this.cboFlur.setEnabled(false);
                        return;
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                    if (GemarkungRetrieverMode.RETRIEVE_GEMARKUNGEN == this.mode) {
                        try {
                            FlurstueckChooser.this.cboGemarkung.setModel(new KeyComboboxModel((List)this.get()));
                            FlurstueckChooser.this.cboGemarkung.setEnabled(true);
                            FlurstueckChooser.this.isFullInitialized = true;
                            if (FlurstueckChooser.this.currentGemarkungsWaiter == null) {
                                FlurstueckChooser.this.cboGemarkung.requestFocus();
                            }
                            break block17;
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Fehler beim setzten der Gemarkungen", (Throwable)ex);
                        }
                        break block17;
                    }
                    if (this.mode == GemarkungRetrieverMode.RETRIEVE_FLURE || this.mode == GemarkungRetrieverMode.RETRIEVE_WITH_RESOLVED || this.mode == GemarkungRetrieverMode.RETRIEVE_AUTOMATIC) {
                        if (this.selectedGemarkung != null) {
                            if (!this.wasResolved) {
                                FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                                FlurstueckChooser.this.cboFlur.setModel(new KeyComboboxModel((List)this.get()));
                                FlurstueckChooser.this.cboFlur.setEnabled(true);
                                if (this.mode != GemarkungRetrieverMode.RETRIEVE_AUTOMATIC) {
                                    FlurstueckChooser.this.cboFlur.requestFocus();
                                }
                            } else {
                                FlurstueckChooser.this.cboGemarkungListenerEnabled = false;
                                FlurstueckChooser.this.cboGemarkung.setSelectedItem(this.selectedGemarkung);
                                FlurstueckChooser.this.cboGemarkungListenerEnabled = true;
                                FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                                FlurstueckChooser.this.cboGemarkungActionPerformed(this.event);
                            }
                        } else {
                            if (this.hadErrors) {
                                FlurstueckChooser.this.btnAction.setToolTipText(this.errorMessage);
                                FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                            } else {
                                FlurstueckChooser.this.setHighlightColor(LagisBroker.ACCEPTED_COLOR);
                                FlurstueckChooser.this.btnAction.setToolTipText("");
                            }
                            FlurstueckChooser.this.cboFlur.setModel(new KeyComboboxModel());
                            FlurstueckChooser.this.cboFlur.setEnabled(false);
                        }
                    } else {
                        LOG.warn((Object)"unkown mode");
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim setzten der Gemarkung/Flure (done)", (Throwable)ex);
                    FlurstueckChooser.this.setHighlightColor(LagisBroker.ERROR_COLOR);
                    FlurstueckChooser.this.cboFlur.setModel(new KeyComboboxModel());
                    FlurstueckChooser.this.cboFlur.setEnabled(false);
                }
            }
        }

        public GemarkungRetrieverMode getMode() {
            return this.mode;
        }
    }

    private static enum Filter {
        ALL,
        HISTORIC,
        ABTEILUNG_IX,
        STAEDTISCH,
        CURRENT;

    }

    private static enum GemarkungRetrieverMode {
        RETRIEVE_GEMARKUNGEN,
        RETRIEVE_FLURE,
        RETRIEVE_WITH_RESOLVED,
        RETRIEVE_AUTOMATIC;

    }

    public static enum Status {
        STAEDTISCH_HISTORIC,
        STAEDTISCH,
        ABTEILUNG_IX_HISTORIC,
        ABTEILUNG_IX,
        UNKNOWN_FLURSTUECK,
        WFS_WARN;

    }

    public static enum Mode {
        SEARCH,
        CONTINUATION,
        CREATION,
        CONTINUATION_HISTORIC;

    }
}

