/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.FlurstueckeTableModel;
import de.cismet.lagis.renderer.FlurstueckSchluesselCellRenderer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class FlurstueckeByAktenzeichenSearchPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(FlurstueckeByAktenzeichenSearchPanel.class);
    private static final String ANZAHL = "Anzahl:";
    private static final Icon ICON_VERTRAG = new ImageIcon(FlurstueckeByAktenzeichenSearchPanel.class.getResource("/de/cismet/lagis/ressource/icons/toolbar/Aktenzeichensuche3.png"));
    private static final Icon ICON_MIPA = new ImageIcon(FlurstueckeByAktenzeichenSearchPanel.class.getResource("/de/cismet/lagis/ressource/icons/toolbar/Aktenzeichensuche4.png"));
    private final FlurstueckeTableModel tableModel = new FlurstueckeTableModel();
    private FlurstueckSchluesselSearcher currentSearcher = null;
    private final By by;
    private JButton btnCancel;
    private JButton btnSearch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAnzahl;
    private JPanel panStatus;
    private JProgressBar pbrSearchProgress;
    private JTable tblAktenzeichen;
    private JTextField tfdAktenzeichen;

    public FlurstueckeByAktenzeichenSearchPanel() {
        this(By.VERTRAG);
    }

    public FlurstueckeByAktenzeichenSearchPanel(By by) {
        this.by = by;
        this.initComponents();
        this.configureComponent();
    }

    public String getTitle() {
        switch (this.by) {
            case VERTRAG: {
                return "Suche Flurst\u00fccke nach Aktenzeichen (Vertrag)";
            }
            case MIPA: {
                return "Suche Flurst\u00fccke nach Aktenzeichen (Vermietung/Verpachtung)";
            }
        }
        return "Suche Flurst\u00fccke nach Aktenzeichen";
    }

    public Icon getIcon() {
        switch (this.by) {
            case VERTRAG: {
                return ICON_VERTRAG;
            }
            case MIPA: {
                return ICON_MIPA;
            }
        }
        return null;
    }

    private void configureComponent() {
        this.setSearchActive(false);
        this.tblAktenzeichen.setModel(this.tableModel);
        this.tblAktenzeichen.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FlurstueckSchluesselCustomBean key;
                Object source = e.getSource();
                if (e.getClickCount() > 1 && (key = FlurstueckeByAktenzeichenSearchPanel.this.tableModel.getFlurstueckSchluesselAtRow(((JXTable)FlurstueckeByAktenzeichenSearchPanel.this.tblAktenzeichen).convertRowIndexToModel(FlurstueckeByAktenzeichenSearchPanel.this.tblAktenzeichen.getSelectedRow()))) != null) {
                    LagisBroker.getInstance().loadFlurstueck(key);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tblAktenzeichen.setDefaultRenderer(FlurstueckSchluesselCustomBean.class, new FlurstueckSchluesselCellRenderer());
        ((JXTable)this.tblAktenzeichen).getColumnModel().getColumn(0).setPreferredWidth(50);
        ((JXTable)this.tblAktenzeichen).getColumnModel().getColumn(0).setMaxWidth(50);
        ((JXTable)this.tblAktenzeichen).getColumnModel().getColumn(0).setMinWidth(50);
    }

    private void initComponents() {
        this.panStatus = new JPanel();
        this.pbrSearchProgress = new JProgressBar();
        this.jPanel1 = new JPanel();
        this.lblAnzahl = new JLabel();
        this.tfdAktenzeichen = new JTextField();
        this.jLabel1 = new JLabel();
        this.btnSearch = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblAktenzeichen = new JXTable();
        this.btnCancel = new JButton();
        this.pbrSearchProgress.setBorder(null);
        this.pbrSearchProgress.setBorderPainted(false);
        this.lblAnzahl.setText(ANZAHL);
        this.lblAnzahl.setMaximumSize(new Dimension(47, 20));
        this.lblAnzahl.setMinimumSize(new Dimension(47, 20));
        this.lblAnzahl.setPreferredSize(new Dimension(47, 22));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lblAnzahl, -2, 68, -2).addContainerGap(44, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblAnzahl, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout panStatusLayout = new GroupLayout(this.panStatus);
        this.panStatus.setLayout(panStatusLayout);
        panStatusLayout.setHorizontalGroup(panStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panStatusLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(265, Short.MAX_VALUE)).addGroup(panStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panStatusLayout.createSequentialGroup().addContainerGap(228, Short.MAX_VALUE).addComponent(this.pbrSearchProgress, -2, 155, -2))));
        panStatusLayout.setVerticalGroup(panStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(panStatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panStatusLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.pbrSearchProgress, -2, 14, -2).addContainerGap(18, Short.MAX_VALUE))));
        this.tfdAktenzeichen.setMinimumSize(new Dimension(150, 27));
        this.tfdAktenzeichen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckeByAktenzeichenSearchPanel.this.tfdAktenzeichenActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Aktenzeichen:");
        this.btnSearch.setText("Start");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckeByAktenzeichenSearchPanel.this.btnSearchActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Ergebnis: ");
        this.tblAktenzeichen.setModel(new DefaultTableModel(new Object[0][], new String[]{"Art", "Flurst\u00fcck"}));
        this.jScrollPane1.setViewportView(this.tblAktenzeichen);
        if (this.tblAktenzeichen.getColumnModel().getColumnCount() > 0) {
            this.tblAktenzeichen.getColumnModel().getColumn(0).setMinWidth(50);
            this.tblAktenzeichen.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.tblAktenzeichen.getColumnModel().getColumn(0).setMaxWidth(50);
        }
        this.btnCancel.setText("Abbrechen");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckeByAktenzeichenSearchPanel.this.btnCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 383, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnSearch, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 91, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(6, 6, 6).addComponent(this.tfdAktenzeichen, -1, 287, Short.MAX_VALUE)).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 383, Short.MAX_VALUE).addComponent(this.jLabel2).addComponent(this.panStatus, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.btnCancel, this.btnSearch);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfdAktenzeichen, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSearch).addComponent(this.btnCancel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 188, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panStatus, -2, 22, -2)));
    }

    private void btnSearchActionPerformed(ActionEvent evt) {
        this.setSearchActive(true);
        this.currentSearcher = new FlurstueckSchluesselSearcher(this.tfdAktenzeichen.getText().trim());
        LagisBroker.getInstance().execute(this.currentSearcher);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setSearchActive(false);
        this.currentSearcher.cancel(true);
    }

    private void tfdAktenzeichenActionPerformed(ActionEvent evt) {
        this.setSearchActive(true);
        this.currentSearcher = new FlurstueckSchluesselSearcher(this.tfdAktenzeichen.getText().trim());
        LagisBroker.getInstance().execute(this.currentSearcher);
    }

    private void setSearchActive(boolean isSearchActive) {
        this.tableModel.removeAllFlurstueckSchluessel();
        this.pbrSearchProgress.setIndeterminate(isSearchActive);
        this.btnSearch.setEnabled(!isSearchActive);
        this.btnCancel.setEnabled(isSearchActive);
        this.tfdAktenzeichen.setEditable(!isSearchActive);
        this.setResultCount(-1);
        if (isSearchActive) {
            this.btnCancel.requestFocusInWindow();
        } else {
            this.btnSearch.requestFocusInWindow();
        }
    }

    private void setResultCount(int count) {
        if (count < 0) {
            this.lblAnzahl.setText(ANZAHL);
        } else {
            this.lblAnzahl.setText(ANZAHL + count);
        }
    }

    class FlurstueckSchluesselSearcher
    extends SwingWorker<Collection<FlurstueckSchluesselCustomBean>, Void> {
        private final String aktenzeichenSearchPattern;

        public FlurstueckSchluesselSearcher(String aktenzeichenSearchPattern) {
            this.aktenzeichenSearchPattern = aktenzeichenSearchPattern;
        }

        @Override
        protected Collection<FlurstueckSchluesselCustomBean> doInBackground() throws Exception {
            Collection<FlurstueckSchluesselCustomBean> result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Suche nach Flurst\u00fccken mit dem Aktenzeichen: " + this.aktenzeichenSearchPattern));
            }
            switch (FlurstueckeByAktenzeichenSearchPanel.this.by) {
                case VERTRAG: {
                    result = LagisBroker.getInstance().getFlurstueckSchluesselByVertragAktenzeichen(this.aktenzeichenSearchPattern);
                    break;
                }
                case MIPA: {
                    result = LagisBroker.getInstance().getFlurstueckSchluesselByMipaAktenzeichen(this.aktenzeichenSearchPattern);
                    break;
                }
                default: {
                    return new HashSet<FlurstueckSchluesselCustomBean>();
                }
            }
            if (result != null && result.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Suche brachte ein Ergebnis. Anzahl FlurstueckSchluessel: " + result.size()));
                }
                return result;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Suche brachte kein Ergebnis");
            }
            return new HashSet<FlurstueckSchluesselCustomBean>();
        }

        @Override
        protected void done() {
            block3: {
                try {
                    FlurstueckeByAktenzeichenSearchPanel.this.setSearchActive(false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"FlurstueckSchluesselSearcher done()");
                    }
                    FlurstueckeByAktenzeichenSearchPanel.this.tableModel.refreshTableModel((Collection)this.get());
                    FlurstueckeByAktenzeichenSearchPanel.this.setResultCount(FlurstueckeByAktenzeichenSearchPanel.this.tableModel.getFlurstueckSchluesselCount());
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Fehler bei der Suche nach Flurst\u00fccken mit dem Aktenzeichen: " + this.aktenzeichenSearchPattern), (Throwable)ex);
                }
            }
        }
    }

    public static enum By {
        VERTRAG,
        MIPA;

    }
}

