/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.FXWebViewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import netscape.javascript.JSObject;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class HistoryPanel
extends AbstractWidget
implements FlurstueckChangeListener,
Configurable {
    private static HistoryPanel instance;
    private static final Logger LOG;
    private Timer levelTimer = new Timer();
    private HashMap<String, Integer> nodeToKeyMap = new HashMap();
    private boolean callBackInited = false;
    private JPanel webViewPanel = new JPanel(new BorderLayout());
    private FXWebViewPanel webView;
    private JComboBox cbxHistoryOptions;
    private JComboBox cbxHistoryOptions1;
    private JComboBox cbxHistoryType;
    private JCheckBox ckxHoldFlurstueck;
    private JCheckBox ckxScaleToFit;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JLabel lblDatumEnt;
    private JLabel lblDatumEntWert;
    private JLabel lblDatumHist;
    private JLabel lblDatumHistWert;
    private JLabel lblDatumLSB;
    private JLabel lblDatumLSBWert;
    private JLabel lblVisulaization;
    private JPanel panHistInfo;
    private JPanel panInformation;
    private JPanel panOptions;
    private JSpinner sprLevels;
    private JSpinner sprLevels1;

    public HistoryPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        boolean sibblingOptionsEnabled = StaticDebuggingTools.checkHomeForFile((String)"cismetLagisSibblingOptionsEnabled");
        this.sprLevels1.setVisible(sibblingOptionsEnabled);
        this.cbxHistoryOptions1.setVisible(sibblingOptionsEnabled);
        SpinnerNumberModel sprLevelModel = new SpinnerNumberModel(1, 1, 100, 1);
        this.sprLevels.setModel(sprLevelModel);
        this.sprLevels.setEnabled(false);
        SpinnerNumberModel sprLevelModel1 = new SpinnerNumberModel(0, 0, 100, 1);
        this.sprLevels1.setModel(sprLevelModel1);
        this.sprLevels1.setEnabled(false);
        this.add((Component)this.webViewPanel, "Center");
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HistoryPanel.this.webView = new FXWebViewPanel();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HistoryPanel.this.webViewPanel.add((Component)HistoryPanel.this.webView, "Center");
                            try {
                                String s = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("dagreTemplate.html"));
                                HistoryPanel.this.webView.loadContent(s);
                            }
                            catch (Exception e) {
                                LOG.fatal((Object)e, (Throwable)e);
                            }
                        }
                    });
                }
            }.start();
        }
        catch (Exception e) {
            LOG.error((Object)"Error during initialization of HistoryPanel", (Throwable)e);
        }
        instance = this;
    }

    public void fstckClicked(String info) {
        this.setHtmlLoading();
        Integer hit = this.nodeToKeyMap.get(info);
        if (hit != null && !LagisBroker.getInstance().getCurrentFlurstueck().getId().equals(hit)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Neuer Schl\u00fcssel ist != null");
            }
            try {
                MetaObject mo = CidsBroker.getInstance().getMetaObject(hit, CidsBean.getMetaClassFromTableName((String)"LAGIS", (String)"flurstueck_schluessel").getID(), "LAGIS");
                LagisBroker.getInstance().loadFlurstueck((FlurstueckSchluesselCustomBean)mo.getBean());
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Neuer Schl\u00fcssel == null oder gleich oder toString == null");
        }
    }

    public static HistoryPanel getInstance() {
        if (instance == null) {
            instance = new HistoryPanel();
        }
        return instance;
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    public void refresh() {
        if (LagisBroker.getInstance().getCurrentFlurstueck() == null) {
            return;
        }
        this.setHtmlLoading();
        this.updateInformation();
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"FlurstueckSearchPanel --> setComponentEditable finished");
        }
    }

    @Override
    public String getWidgetName() {
        return "History Panel";
    }

    @Override
    public synchronized void clearComponent() {
    }

    private void setHtmlLoading() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    HistoryPanel.this.webView.getWebEngine().executeScript("loading();");
                }
                catch (Exception e) {
                    LOG.error((Object)"Error when executing script loading();", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        this.levelTimer.cancel();
        this.setHtmlLoading();
        this.updateInformation();
        if (this.nodeToKeyMap.get(newFlurstueck.toString()) != null && this.ckxHoldFlurstueck.isSelected()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flurst\u00fcck ist bereits in der Historie vorhanden und hold ist aktiviert --> kein update");
            }
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Flurst\u00fcckchanged HistoryPanel");
            }
            try {
                LagisBroker.HistoryType type;
                int levelSibblingCount;
                LagisBroker.HistorySibblingLevel levelSibbling;
                int levelCount;
                LagisBroker.HistoryLevel level;
                try {
                    if (!this.callBackInited) {
                        Thread.sleep(1000L);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    JSObject jsobj = (JSObject)HistoryPanel.this.webView.getWebEngine().executeScript("window");
                                    jsobj.setMember("java", HistoryPanel.this);
                                    LOG.info((Object)"Callback steht zur Verf\u00fcgung");
                                    HistoryPanel.this.callBackInited = true;
                                }
                                catch (Exception e) {
                                    LOG.error((Object)"Callback steht nicht zur Verf\u00fcgung", (Throwable)e);
                                }
                            }
                        });
                        this.setHtmlLoading();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error in Backgroundthread", (Throwable)e);
                }
                this.clearComponent();
                LOG.info((Object)"Konstruiere Flurst\u00fcckhistoriengraph");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Erstelle Historien Anfrage:");
                }
                if (this.cbxHistoryOptions.getSelectedItem().equals("Direkte Vorg\u00e4nger/Nachfolger")) {
                    level = LagisBroker.HistoryLevel.DIRECT_RELATIONS;
                    levelCount = 0;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"nur angrenzendte Flurst\u00fccke");
                    }
                } else if (this.cbxHistoryOptions.getSelectedItem().equals("Begrenzte Tiefe")) {
                    level = LagisBroker.HistoryLevel.CUSTOM;
                    levelCount = ((Number)this.sprLevels.getValue()).intValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("begrentze Tiefe mit " + levelCount + " Stufen"));
                    }
                } else {
                    level = LagisBroker.HistoryLevel.All;
                    levelCount = 0;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Alle Levels");
                    }
                }
                if (this.cbxHistoryOptions1.getSelectedItem().equals("Geschwister")) {
                    levelSibbling = LagisBroker.HistorySibblingLevel.SIBBLING_ONLY;
                    levelSibblingCount = 0;
                } else if (this.cbxHistoryOptions1.getSelectedItem().equals("Geschwister, vollst\u00e4ndig")) {
                    levelSibbling = LagisBroker.HistorySibblingLevel.FULL;
                    levelSibblingCount = 0;
                } else if (this.cbxHistoryOptions1.getSelectedItem().equals("Geschwister, begrenzte Tiefe")) {
                    levelSibbling = LagisBroker.HistorySibblingLevel.CUSTOM;
                    levelSibblingCount = ((Number)this.sprLevels1.getValue()).intValue();
                } else {
                    levelSibbling = LagisBroker.HistorySibblingLevel.NONE;
                    levelSibblingCount = 0;
                }
                if (this.cbxHistoryType.getSelectedItem().equals("Nur Nachfolger")) {
                    type = LagisBroker.HistoryType.SUCCESSOR;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"nur Nachfolger");
                    }
                } else if (this.cbxHistoryType.getSelectedItem().equals("Nur Vorg\u00e4nger")) {
                    type = LagisBroker.HistoryType.PREDECESSOR;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"nur Vorg\u00e4nger");
                    }
                } else {
                    type = LagisBroker.HistoryType.BOTH;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Vorg\u00e4nger/Nachfolger");
                    }
                }
                this.nodeToKeyMap = new HashMap();
                String dotGraphRepresentation = LagisBroker.getInstance().getHistoryGraph(newFlurstueck, level, levelCount, levelSibbling, levelSibblingCount, type, this.nodeToKeyMap);
                String rawscript = "var graphInput='" + dotGraphRepresentation + "'; draw(graphInput);";
                final String script = rawscript.replaceAll("\n", "");
                LOG.info((Object)("script to run:" + script));
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HistoryPanel.this.webView.getWebEngine().executeScript(script);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error when executing script " + script), (Throwable)e);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim laden der Flurst\u00fccksHistory");
            }
            finally {
                LagisBroker.getInstance().flurstueckChangeFinished(this);
            }
        }
    }

    private void updateInformation() {
        if (LagisBroker.getInstance().getCurrentFlurstueck() != null && LagisBroker.getInstance().getCurrentFlurstueck().getFlurstueckSchluessel() != null) {
            FlurstueckSchluesselCustomBean currentKey = LagisBroker.getInstance().getCurrentFlurstueck().getFlurstueckSchluessel();
            if (currentKey.getGueltigBis() == null && currentKey.getDatumLetzterStadtbesitz() != null) {
                this.lblDatumLSBWert.setText(LagisBroker.getDateFormatter().format(currentKey.getDatumLetzterStadtbesitz()));
                this.lblDatumLSBWert.setToolTipText(currentKey.getDatumLetzterStadtbesitz().toString());
            } else {
                this.lblDatumLSBWert.setText("Keine Angabe");
                this.lblDatumLSBWert.setToolTipText("");
            }
            if (currentKey.getGueltigBis() != null) {
                this.lblDatumHistWert.setText(LagisBroker.getDateFormatter().format(currentKey.getGueltigBis()));
                this.lblDatumHistWert.setToolTipText(currentKey.getGueltigBis().toString());
            } else {
                this.lblDatumHistWert.setText("Keine Angabe");
                this.lblDatumHistWert.setToolTipText("");
            }
            if (currentKey.getEntstehungsDatum() != null) {
                this.lblDatumEntWert.setText(LagisBroker.getDateFormatter().format(currentKey.getEntstehungsDatum()));
                this.lblDatumEntWert.setToolTipText(currentKey.getEntstehungsDatum().toString());
            } else {
                this.lblDatumEntWert.setText("Keine Angabe");
                this.lblDatumEntWert.setToolTipText("");
            }
        } else {
            LOG.warn((Object)"Flurst\u00fcckschl\u00fcssel ist == null");
            this.lblDatumEntWert.setText("Keine Angabe");
            this.lblDatumEntWert.setToolTipText("");
            this.lblDatumHistWert.setText("Keine Angabe");
            this.lblDatumHistWert.setToolTipText("");
        }
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.panHistInfo = new JPanel();
        this.panOptions = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblVisulaization = new JLabel();
        this.jPanel1 = new JPanel();
        this.cbxHistoryOptions = new JComboBox();
        this.sprLevels = new JSpinner();
        this.cbxHistoryType = new JComboBox();
        this.cbxHistoryOptions1 = new JComboBox();
        this.sprLevels1 = new JSpinner();
        this.jPanel2 = new JPanel();
        this.ckxScaleToFit = new JCheckBox();
        this.ckxHoldFlurstueck = new JCheckBox();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.panInformation = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.lblDatumEnt = new JLabel();
        this.lblDatumEntWert = new JLabel();
        this.lblDatumHist = new JLabel();
        this.lblDatumHistWert = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblDatumLSB = new JLabel();
        this.lblDatumLSBWert = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.panHistInfo.setLayout(new GridBagLayout());
        this.panOptions.setBorder(BorderFactory.createTitledBorder(""));
        this.panOptions.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setText("Optionen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 1, 0, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.lblVisulaization.setText("Darstellung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.jPanel3.add((Component)this.lblVisulaization, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.cbxHistoryOptions.setModel(new DefaultComboBoxModel<String>(new String[]{"Direkte Vorg\u00e4nger/Nachfolger", "Vollst\u00e4ndig", "Begrenzte Tiefe"}));
        this.cbxHistoryOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.cbxHistoryOptionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.cbxHistoryOptions, gridBagConstraints);
        this.sprLevels.setMinimumSize(new Dimension(60, 1));
        this.sprLevels.setPreferredSize(new Dimension(60, 1));
        this.sprLevels.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HistoryPanel.this.sprLevelsStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.sprLevels, gridBagConstraints);
        this.cbxHistoryType.setModel(new DefaultComboBoxModel<String>(new String[]{"Alle Flurst\u00fccke", "Nur Nachfolger", "Nur Vorg\u00e4nger"}));
        this.cbxHistoryType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.cbxHistoryTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.cbxHistoryType, gridBagConstraints);
        this.cbxHistoryOptions1.setModel(new DefaultComboBoxModel<String>(new String[]{"keine Geschwister", "Geschwister", "Geschwister, vollst\u00e4ndig", "Geschwister, begrenzte Tiefe"}));
        this.cbxHistoryOptions1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.cbxHistoryOptions1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.cbxHistoryOptions1, gridBagConstraints);
        this.sprLevels1.setMinimumSize(new Dimension(60, 1));
        this.sprLevels1.setPreferredSize(new Dimension(60, 1));
        this.sprLevels1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HistoryPanel.this.sprLevels1StateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.jPanel1.add((Component)this.sprLevels1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.ckxScaleToFit.setSelected(true);
        this.ckxScaleToFit.setText("an Bildschimgr\u00f6\u00dfe anpassen");
        this.ckxScaleToFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.ckxScaleToFitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = -5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.ckxScaleToFit, gridBagConstraints);
        this.ckxHoldFlurstueck.setText("Historie halten");
        this.ckxHoldFlurstueck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryPanel.this.ckxHoldFlurstueckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.ckxHoldFlurstueck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.filler4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.filler3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panOptions.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panHistInfo.add((Component)this.panOptions, gridBagConstraints);
        this.panInformation.setBorder(BorderFactory.createTitledBorder(""));
        this.panInformation.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel3.setText("Informationen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this.lblDatumEnt.setText("Entstehung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.jPanel4.add((Component)this.lblDatumEnt, gridBagConstraints);
        this.lblDatumEntWert.setText("Keine Angabe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel4.add((Component)this.lblDatumEntWert, gridBagConstraints);
        this.lblDatumHist.setText("Historisch seit:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.jPanel4.add((Component)this.lblDatumHist, gridBagConstraints);
        this.lblDatumHistWert.setText("Keine Angabe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel4.add((Component)this.lblDatumHistWert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.filler2, gridBagConstraints);
        this.lblDatumLSB.setText("Letzter Statdbesitz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.jPanel4.add((Component)this.lblDatumLSB, gridBagConstraints);
        this.lblDatumLSBWert.setText("Keine Angabe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel4.add((Component)this.lblDatumLSBWert, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panInformation.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.panHistInfo.add((Component)this.panInformation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.jPanel5.add((Component)this.panHistInfo, gridBagConstraints);
        this.add((Component)this.jPanel5, "South");
    }

    private void ckxScaleToFitActionPerformed(ActionEvent evt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    HistoryPanel.this.webView.getWebEngine().executeScript("setFitToScreen(" + HistoryPanel.this.ckxScaleToFit.isSelected() + ");");
                }
                catch (Exception e) {
                    LOG.error((Object)"Error during executing setFitToScreen ", (Throwable)e);
                }
            }
        });
    }

    private void cbxHistoryOptionsActionPerformed(ActionEvent evt) {
        if ("Begrenzte Tiefe".equals(this.cbxHistoryOptions.getSelectedItem())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Begrentzte Tiefe ausgew\u00e4hlt");
            }
            this.levelTimer = new Timer();
            this.levelTimer.schedule((TimerTask)new delayedRefresh(), 2000L);
            this.sprLevels.setEnabled(true);
        } else {
            this.sprLevels.setValue(1);
            this.sprLevels.setEnabled(false);
            this.levelTimer.cancel();
            this.refresh();
        }
    }

    private void cbxHistoryTypeActionPerformed(ActionEvent evt) {
        boolean nurNachfolger = "Nur Nachfolger".equals(this.cbxHistoryType.getSelectedItem());
        this.cbxHistoryOptions1.setEnabled(!nurNachfolger);
        this.sprLevels1.setEnabled(nurNachfolger);
        if (nurNachfolger) {
            this.cbxHistoryOptions1.setSelectedItem("keine Geschwister");
            this.sprLevels1.setValue(0);
        }
        this.refresh();
    }

    private void sprLevelsStateChanged(ChangeEvent evt) {
        this.levelTimer.cancel();
        this.levelTimer = new Timer();
        this.levelTimer.schedule((TimerTask)new delayedRefresh(), 1500L);
    }

    private void ckxHoldFlurstueckActionPerformed(ActionEvent evt) {
    }

    private void cbxHistoryOptions1ActionPerformed(ActionEvent evt) {
        if (this.cbxHistoryOptions1.getSelectedItem().equals("Geschwister, begrenzte Tiefe")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Geschwister, begrenzte Tiefe Tiefe ausgew\u00e4hlt");
            }
            this.levelTimer = new Timer();
            this.levelTimer.schedule((TimerTask)new delayedRefresh(), 2000L);
            this.sprLevels1.setEnabled(true);
        } else {
            this.sprLevels1.setEnabled(false);
            this.sprLevels1.setValue(0);
            this.levelTimer.cancel();
            this.refresh();
        }
    }

    private void sprLevels1StateChanged(ChangeEvent evt) {
        this.levelTimer.cancel();
        this.levelTimer = new Timer();
        this.levelTimer.schedule((TimerTask)new delayedRefresh(), 1500L);
    }

    public void configure(Element parent) {
    }

    public Element getConfiguration() {
        return null;
    }

    public void masterConfigure(Element parent) {
    }

    static {
        LOG = Logger.getLogger(HistoryPanel.class);
    }

    private class delayedRefresh
    extends TimerTask {
        private delayedRefresh() {
        }

        @Override
        public void run() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoryPanel.this.refresh();
                }
            });
        }
    }
}

