/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.KassenzeichenCustomBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.lagis.broker.CidsBroker;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.tables.KassenzeichenTable;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.models.KassenzeichenTableModel;
import de.cismet.lagis.renderer.DateRenderer;
import de.cismet.lagis.renderer.KassenzeichenRenderer;
import de.cismet.lagis.util.LagISUtils;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.verdis.server.search.KassenzeichenGeomSearch;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.openide.util.NbBundle;

public class KassenzeichenPanel
extends AbstractWidget
implements FlurstueckChangeListener,
FlurstueckSaver {
    private static final Logger LOG = Logger.getLogger(KassenzeichenPanel.class);
    private static KassenzeichenPanel INSTANCE;
    private final KassenzeichenTableModel tableModel = new KassenzeichenTableModel();
    private JButton btnAddKassenzeichen;
    private JButton btnMagicAddKassenzeichen;
    private JButton btnRemoveKassenzeichen;
    private JToggleButton btnSort;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTable tKassenzeichen;

    private KassenzeichenPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        TableSelectionUtils.crossReferenceModelAndTable(this.tableModel, (KassenzeichenTable)((Object)this.tKassenzeichen));
        this.tKassenzeichen.setDefaultRenderer(Integer.class, new KassenzeichenRenderer());
        this.tKassenzeichen.setDefaultRenderer(Date.class, new DateRenderer());
        ((KassenzeichenTable)((Object)this.tKassenzeichen)).setSortButton(this.btnSort);
        ((JXTable)this.tKassenzeichen).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER});
    }

    public static KassenzeichenPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KassenzeichenPanel();
        }
        return INSTANCE;
    }

    public JTable getTable() {
        return this.tKassenzeichen;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tKassenzeichen = new KassenzeichenTable();
        this.jPanel3 = new JPanel();
        this.btnAddKassenzeichen = new JButton();
        this.btnRemoveKassenzeichen = new JButton();
        this.btnSort = new JToggleButton();
        this.btnMagicAddKassenzeichen = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 100));
        this.tKassenzeichen.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tKassenzeichen.setModel(this.tableModel);
        this.tKassenzeichen.setToolTipText(NbBundle.getMessage(KassenzeichenPanel.class, (String)"KassenzeichenPanel.tKassenzeichen.toolTipText"));
        this.tKassenzeichen.setMinimumSize(new Dimension(225, 48));
        this.tKassenzeichen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                KassenzeichenPanel.this.tKassenzeichenMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tKassenzeichen);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnAddKassenzeichen.setAction(((KassenzeichenTable)((Object)this.tKassenzeichen)).getAddAction());
        this.btnAddKassenzeichen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddKassenzeichen.setBorder(null);
        this.btnAddKassenzeichen.setBorderPainted(false);
        this.btnAddKassenzeichen.setMaximumSize(new Dimension(25, 25));
        this.btnAddKassenzeichen.setMinimumSize(new Dimension(25, 25));
        this.btnAddKassenzeichen.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.btnAddKassenzeichen, gridBagConstraints);
        this.btnRemoveKassenzeichen.setAction(((KassenzeichenTable)((Object)this.tKassenzeichen)).getRemoveAction());
        this.btnRemoveKassenzeichen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveKassenzeichen.setBorder(null);
        this.btnRemoveKassenzeichen.setBorderPainted(false);
        this.btnRemoveKassenzeichen.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveKassenzeichen.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveKassenzeichen.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel3.add((Component)this.btnRemoveKassenzeichen, gridBagConstraints);
        this.btnSort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.btnSort.setToolTipText(NbBundle.getMessage(KassenzeichenPanel.class, (String)"KassenzeichenPanel.btnSort.toolTipText"));
        this.btnSort.setBorderPainted(false);
        this.btnSort.setContentAreaFilled(false);
        this.btnSort.setMaximumSize(new Dimension(25, 25));
        this.btnSort.setMinimumSize(new Dimension(25, 25));
        this.btnSort.setPreferredSize(new Dimension(25, 25));
        this.btnSort.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel3.add((Component)this.btnSort, gridBagConstraints);
        this.btnSort.addItemListener(((KassenzeichenTable)((Object)this.tKassenzeichen)).getSortItemListener());
        this.btnMagicAddKassenzeichen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/addMagic.png")));
        this.btnMagicAddKassenzeichen.setBorder(null);
        this.btnMagicAddKassenzeichen.setBorderPainted(false);
        this.btnMagicAddKassenzeichen.setMaximumSize(new Dimension(25, 25));
        this.btnMagicAddKassenzeichen.setMinimumSize(new Dimension(25, 25));
        this.btnMagicAddKassenzeichen.setPreferredSize(new Dimension(25, 25));
        this.btnMagicAddKassenzeichen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KassenzeichenPanel.this.btnMagicAddKassenzeichenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.btnMagicAddKassenzeichen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void tKassenzeichenMouseClicked(MouseEvent evt) {
        int rowAtPoint;
        if (evt.getClickCount() > 1 && (rowAtPoint = this.tKassenzeichen.rowAtPoint(new Point(evt.getX(), evt.getY()))) != -1 && this.tableModel.getCidsBeanAtRow(((JXTable)this.tKassenzeichen).convertRowIndexToModel(rowAtPoint)) != null) {
            KassenzeichenCustomBean kassenzeichenEintrag = (KassenzeichenCustomBean)this.tableModel.getCidsBeanAtRow(((JXTable)this.tKassenzeichen).convertRowIndexToModel(rowAtPoint));
            MetaClass mcKassenzeichen = CidsBroker.getInstance().getMetaClass("kassenzeichen", "VERDIS_GRUNDIS");
            String query = "SELECT " + mcKassenzeichen.getId() + ", id, kassenzeichennummer8 FROM kassenzeichen WHERE kassenzeichennummer8 = " + kassenzeichenEintrag.getKassenzeichennummer() + ";";
            MetaObject[] mos = CidsBroker.getInstance().getMetaObject(query, "VERDIS_GRUNDIS");
            if (mos != null && mos.length >= 1) {
                MetaObject mo = mos[0];
                LagisBroker.getInstance().openKassenzeichenInVerdis(mo.getBean());
            }
        }
    }

    private void btnMagicAddKassenzeichenActionPerformed(ActionEvent evt) {
        Geometry geometry = LagisBroker.getInstance().getCurrentWFSGeometry().buffer(-0.05);
        final KassenzeichenGeomSearch search = new KassenzeichenGeomSearch();
        search.setGeometry(geometry);
        this.setComponentEditable(false);
        new SwingWorker<Collection, Void>(){

            @Override
            protected Collection doInBackground() throws Exception {
                return CidsBroker.getInstance().executeSearch((CidsServerSearch)search);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                if (LagisBroker.getInstance().isInEditMode()) {
                    try {
                        Collection kassenzeichenNumern = (Collection)this.get();
                        for (Integer kassenzeichenNummer : kassenzeichenNumern) {
                            ((KassenzeichenTable)((Object)KassenzeichenPanel.this.tKassenzeichen)).addNewKassenzeichen(kassenzeichenNummer);
                        }
                    }
                    catch (Exception ex) {
                        LOG.fatal((Object)ex, (Throwable)ex);
                    }
                    finally {
                        KassenzeichenPanel.this.setComponentEditable(true);
                    }
                }
            }
        }.execute();
    }

    @Override
    public void clearComponent() {
        this.tableModel.refreshTableModel(null);
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        this.btnAddKassenzeichen.setEnabled(isEditable);
        this.btnMagicAddKassenzeichen.setEnabled(isEditable);
        this.btnRemoveKassenzeichen.setEnabled(isEditable);
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            LOG.info((Object)"FlurstueckChanged");
            this.clearComponent();
            this.tableModel.refreshTableModel(newFlurstueck.getN_kassenzeichen());
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurst\u00fcckswechsel: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        LagISUtils.makeCollectionContainSameAsOtherCollection(flurstueck.getN_kassenzeichen(), this.tableModel.getCidsBeans());
    }
}

