/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaMerkmalCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaNutzungCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.editor.DateEditor;
import de.cismet.lagis.gui.checkbox.JCheckBoxList;
import de.cismet.lagis.gui.copypaste.Copyable;
import de.cismet.lagis.gui.copypaste.Pasteable;
import de.cismet.lagis.gui.panels.MiPaMerkmalCheckBox;
import de.cismet.lagis.gui.tables.MipaTable;
import de.cismet.lagis.gui.tables.RemoveActionHelper;
import de.cismet.lagis.interfaces.FeatureSelectionChangedListener;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.interfaces.GeometrySlotProvider;
import de.cismet.lagis.interfaces.LagisBrokerPropertyChangeListener;
import de.cismet.lagis.models.DefaultUniqueListModel;
import de.cismet.lagis.models.MiPaModel;
import de.cismet.lagis.renderer.DateRenderer;
import de.cismet.lagis.renderer.FlurstueckSchluesselRenderer;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.utillity.GeometrySlotInformation;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.CustomSelectionStyledFeatureGroupWrapper;
import de.cismet.lagisEE.entity.core.FlurstueckSchluessel;
import de.cismet.lagisEE.entity.extension.vermietung.MiPa;
import de.cismet.lagisEE.entity.extension.vermietung.MiPaKategorie;
import de.cismet.tools.CurrentStackTrace;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class MiPaPanel
extends AbstractWidget
implements FlurstueckChangeListener,
FlurstueckSaver,
MouseListener,
ListSelectionListener,
ItemListener,
GeometrySlotProvider,
FeatureSelectionChangedListener,
FeatureCollectionListener,
TableModelListener,
Copyable,
Pasteable,
RemoveActionHelper,
LagisBrokerPropertyChangeListener {
    private static final String PROVIDER_NAME = "MiPa";
    private static final String WIDGET_ICON = "/de/cismet/lagis/ressource/icons/mipa.png";
    private static final Logger LOG = Logger.getLogger(MiPaPanel.class);
    private boolean isFlurstueckEditable = true;
    private boolean isInEditMode = false;
    private final MiPaModel tableModel = new MiPaModel();
    private final Icon copyDisplayIcon;
    private boolean listenerEnabled = true;
    private Map<MipaCustomBean, Collection<FlurstueckSchluesselCustomBean>> crossreferences;
    private JButton btnAddMiPa;
    private JButton btnRemoveMiPa;
    private JButton btnUndo;
    private JScrollPane cpMiPa;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane2;
    private JList lstCrossRefs;
    private JList lstMerkmale;
    private JPanel panBemerkung;
    private JPanel panBemerkungTitled;
    private JPanel panMerkmale;
    private JPanel panMerkmaleTitled;
    private JPanel panQuerverweise;
    private JPanel panQuerverweiseTitled;
    private JScrollPane spBemerkung;
    private JScrollPane spMerkmale;
    private JTextArea taBemerkung;
    private JTable tblMipa;
    private JToggleButton tbtnSort;
    private BindingGroup bindingGroup;

    public MiPaPanel(String widgetName) {
        this(widgetName, WIDGET_ICON);
    }

    public MiPaPanel(String widgetName, String iconPath) {
        this.initComponents();
        this.setWidgetName(widgetName);
        this.setWidgetIcon(iconPath);
        this.configureComponents();
        this.setOpaqueRecursive(this.jPanel1.getComponents());
        this.copyDisplayIcon = new ImageIcon(this.getClass().getResource(WIDGET_ICON));
        LagisBroker.getInstance().addWfsFlurstueckGeometryChangeListener(this);
    }

    private void setOpaqueRecursive(Component[] components) {
        for (Component currentComp : components) {
            if (currentComp instanceof Container) {
                this.setOpaqueRecursive(((Container)currentComp).getComponents());
            }
            if (!(currentComp instanceof JComponent)) continue;
            ((JComponent)currentComp).setOpaque(false);
        }
    }

    private void configureComponents() {
        TableSelectionUtils.crossReferenceModelAndTable(this.tableModel, (MipaTable)((Object)this.tblMipa));
        this.tblMipa.setDefaultEditor(Date.class, new DateEditor());
        this.tblMipa.setDefaultRenderer(Date.class, new DateRenderer());
        this.tblMipa.addMouseListener(this);
        HighlightPredicate noGeometryPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                int displayedIndex = componentAdapter.row;
                int modelIndex = ((JXTable)MiPaPanel.this.tblMipa).convertRowIndexToModel(displayedIndex);
                MiPa mp = (MiPa)MiPaPanel.this.tableModel.getCidsBeanAtRow(modelIndex);
                return mp != null && mp.getGeometry() == null;
            }
        };
        ColorHighlighter noGeometryHighlighter = new ColorHighlighter(noGeometryPredicate, LagisBroker.GREY, null);
        HighlightPredicate contractExpiredPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                int displayedIndex = componentAdapter.row;
                int modelIndex = ((JXTable)MiPaPanel.this.tblMipa).convertRowIndexToModel(displayedIndex);
                MiPa mp = (MiPa)MiPaPanel.this.tableModel.getCidsBeanAtRow(modelIndex);
                return mp != null && mp.getVertragsende() != null && mp.getVertragsbeginn() != null && mp.getVertragsende().getTime() < System.currentTimeMillis();
            }
        };
        ColorHighlighter contractExpiredHighlighter = new ColorHighlighter(contractExpiredPredicate, LagisBroker.SUCCESSFUL_COLOR, null);
        ((JXTable)this.tblMipa).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER, contractExpiredHighlighter, noGeometryHighlighter});
        Comparator dateComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -1 * ((Date)o1).compareTo((Date)o2);
            }
        };
        ((JXTable)this.tblMipa).getColumnExt(6).setComparator(dateComparator);
        ((JXTable)this.tblMipa).setSortOrder(6, SortOrder.ASCENDING);
        this.tblMipa.getSelectionModel().addListSelectionListener(this);
        ((JXTable)this.tblMipa).setColumnControlVisible(true);
        ((JXTable)this.tblMipa).setHorizontalScrollEnabled(true);
        TableColumn tc = this.tblMipa.getColumnModel().getColumn(3);
        JComboBox<MiPaKategorie> combo = new JComboBox<MiPaKategorie>();
        combo.setBorder(new EmptyBorder(0, 0, 0, 0));
        combo.setEditable(true);
        Collection<MipaKategorieCustomBean> alleKategorien = LagisBroker.getInstance().getAllMiPaKategorien();
        for (MiPaKategorie miPaKategorie : alleKategorien) {
            combo.addItem(miPaKategorie);
        }
        AutoCompleteDecorator.decorate(combo);
        tc.setCellEditor((TableCellEditor)new ComboBoxCellEditor(combo));
        ((JXTable)this.tblMipa).packAll();
        this.taBemerkung.setDocument(this.tableModel.getBemerkungDocumentModel());
        this.enableSlaveComponents(false);
        Collection<MipaMerkmalCustomBean> miPaMerkmale = LagisBroker.getInstance().getAllMiPaMerkmale();
        ArrayList<MiPaMerkmalCheckBox> arrayList = new ArrayList<MiPaMerkmalCheckBox>();
        if (miPaMerkmale != null && miPaMerkmale.size() > 0) {
            for (MipaMerkmalCustomBean currentMerkmal : miPaMerkmale) {
                if (currentMerkmal == null || currentMerkmal.getBezeichnung() == null) continue;
                MiPaMerkmalCheckBox newMerkmalCheckBox = new MiPaMerkmalCheckBox(currentMerkmal);
                this.setOpaqueRecursive(newMerkmalCheckBox.getComponents());
                newMerkmalCheckBox.setOpaque(false);
                newMerkmalCheckBox.addItemListener(this);
                arrayList.add(newMerkmalCheckBox);
            }
        }
        this.lstMerkmale.setListData(arrayList.toArray());
        this.lstCrossRefs.setCellRenderer(new FlurstueckSchluesselRenderer());
        this.lstCrossRefs.setModel(new DefaultUniqueListModel());
        this.lstCrossRefs.setSelectionMode(0);
        this.lstCrossRefs.addMouseListener(this);
        this.lstCrossRefs.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String s = null;
                s = value instanceof FlurstueckSchluessel ? ((FlurstueckSchluessel)value).getKeyString() : value.toString();
                this.setText(s);
                this.setOpaque(false);
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                return this;
            }
        });
        PCanvas pc = LagisBroker.getInstance().getMappingComponent().getSelectedObjectPresenter();
        pc.setBackground(this.getBackground());
        LagisBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
        this.tableModel.addTableModelListener(this);
    }

    @Override
    public void clearComponent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"clearComponent", (Throwable)new CurrentStackTrace());
        }
        this.tableModel.clearSlaveComponents();
        this.deselectAllListEntries();
        this.tableModel.refreshTableModel(new HashSet());
        this.lstCrossRefs.setModel(new DefaultUniqueListModel());
        if (EventQueue.isDispatchThread()) {
            this.lstCrossRefs.updateUI();
            this.lstCrossRefs.repaint();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MiPaPanel.this.lstCrossRefs.updateUI();
                    MiPaPanel.this.lstCrossRefs.repaint();
                }
            });
        }
    }

    public void deselectAllListEntries() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"deselect all entries", (Throwable)new CurrentStackTrace());
        }
        for (int i = 0; i < this.lstMerkmale.getModel().getSize(); ++i) {
            MiPaMerkmalCheckBox currentCheckBox = (MiPaMerkmalCheckBox)this.lstMerkmale.getModel().getElementAt(i);
            currentCheckBox.removeItemListener(this);
            currentCheckBox.setSelected(false);
            currentCheckBox.addItemListener(this);
        }
    }

    @Override
    public void refresh(Object arg0) {
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (this.isFlurstueckEditable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MiPARessortWidget --> setComponentEditable");
            }
            this.isInEditMode = isEditable;
            this.tableModel.setInEditMode(isEditable);
            TableCellEditor currentEditor = this.tblMipa.getCellEditor();
            if (currentEditor != null) {
                currentEditor.cancelCellEditing();
            }
            if (isEditable && this.tblMipa.getSelectedRow() != -1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Editable und TabellenEintrag ist gew\u00e4hlt");
                }
                this.btnRemoveMiPa.setEnabled(true);
                this.enableSlaveComponents(isEditable);
            } else if (!isEditable) {
                this.deselectAllListEntries();
                this.enableSlaveComponents(isEditable);
                this.btnRemoveMiPa.setEnabled(isEditable);
            }
            this.btnAddMiPa.setEnabled(isEditable);
            this.tableModel.setInEditMode(isEditable);
            this.btnUndo.setEnabled(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MiPARessortWidget --> setComponentEditable finished");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch Vermietung & Verpachtungen k\u00f6nnen nicht editiert werden");
        }
    }

    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            LOG.info((Object)"FlurstueckChanged");
            this.clearComponent();
            FlurstueckArtCustomBean flurstueckArt = newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt();
            if (flurstueckArt != null && flurstueckArt.getBezeichnung().equals("st\u00e4dtisch")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist st\u00e4dtisch und kann editiert werden");
                }
                this.isFlurstueckEditable = true;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch und kann nicht editiert werden");
                }
                this.isFlurstueckEditable = false;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurst\u00fcckswechsel: ", (Throwable)ex);
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentMipas".equals(evt.getPropertyName())) {
            final Collection mipas = (Collection)evt.getNewValue();
            this.tableModel.refreshTableModel(mipas);
            Collection<Feature> features = this.tableModel.getAllMiPaFeatures();
            MappingComponent mappingComp = LagisBroker.getInstance().getMappingComponent();
            FeatureCollection featureCollection = mappingComp.getFeatureCollection();
            if (features != null) {
                for (Object currentFeature : features) {
                    if (currentFeature == null) continue;
                    if (this.isWidgetReadOnly()) {
                        ((MiPa)currentFeature).setModifiable(false);
                    }
                    currentFeature = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)currentFeature, PROVIDER_NAME, PROVIDER_NAME);
                    featureCollection.addFeature(currentFeature);
                }
            }
            ((JXTable)this.tblMipa).packAll();
            DefaultListModel<String> loadingModel = new DefaultListModel<String>();
            loadingModel.addElement("werden geladen...");
            this.lstCrossRefs.setModel(loadingModel);
            new SwingWorker<Map<MipaCustomBean, Collection<FlurstueckSchluesselCustomBean>>, Void>(){

                @Override
                protected Map<MipaCustomBean, Collection<FlurstueckSchluesselCustomBean>> doInBackground() throws Exception {
                    return LagisBroker.getInstance().getCrossreferencesForMiPas(mipas);
                }

                @Override
                protected void done() {
                    try {
                        MiPaPanel.this.crossreferences = (Map)this.get();
                        int selectedIndex = MiPaPanel.this.tblMipa.getSelectedRow();
                        if (MiPaPanel.this.crossreferences != null && MiPaPanel.this.crossreferences.size() > 0 && selectedIndex >= 0) {
                            MipaCustomBean selectedMiPa = (MipaCustomBean)MiPaPanel.this.tableModel.getCidsBeanAtRow(((JXTable)MiPaPanel.this.tblMipa).convertRowIndexToModel(selectedIndex));
                            Collection keys = (Collection)MiPaPanel.this.crossreferences.get(selectedMiPa);
                            if (keys != null) {
                                MiPaPanel.this.lstCrossRefs.setModel(new DefaultUniqueListModel(keys));
                            }
                        } else {
                            MiPaPanel.this.lstCrossRefs.setModel(new DefaultUniqueListModel());
                        }
                        ((JXTable)MiPaPanel.this.tblMipa).packAll();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        MiPaPanel.this.lstCrossRefs.setModel(null);
                    }
                }
            }.execute();
        }
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        List<MipaCustomBean> mipas = LagisBroker.getInstance().getCurrentMipas();
        for (MipaCustomBean mipaCustomBean : this.tableModel.getCidsBeans()) {
            if (mipas.contains(mipaCustomBean)) continue;
            mipas.add(mipaCustomBean);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        FlurstueckSchluesselCustomBean key;
        Object source = e.getSource();
        if (source instanceof JXTable) {
            int selecetdRow;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Mit maus auf MiPaTabelle geklickt");
            }
            if ((selecetdRow = this.tblMipa.getSelectedRow()) != -1) {
                if (this.isInEditMode) {
                    this.enableSlaveComponents(true);
                    this.btnRemoveMiPa.setEnabled(true);
                } else {
                    this.enableSlaveComponents(false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Liste ausgeschaltet");
                    }
                    if (selecetdRow == -1) {
                        this.deselectAllListEntries();
                    }
                }
            } else {
                this.btnRemoveMiPa.setEnabled(false);
            }
        } else if (source instanceof JList && e.getClickCount() > 1 && (key = (FlurstueckSchluesselCustomBean)this.lstCrossRefs.getSelectedValue()) != null) {
            LagisBroker.getInstance().loadFlurstueck(key);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void enableSlaveComponents(boolean isEnabled) {
        this.taBemerkung.setEditable(isEnabled);
        this.lstMerkmale.setEnabled(isEnabled);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"SelectionChanged MiPa");
        }
        this.lstCrossRefs.setModel(new DefaultUniqueListModel());
        int viewIndex = this.tblMipa.getSelectedRow();
        if (viewIndex != -1) {
            if (this.isInEditMode) {
                this.btnRemoveMiPa.setEnabled(true);
            } else {
                this.btnRemoveMiPa.setEnabled(false);
            }
            int index = ((JXTable)this.tblMipa).convertRowIndexToModel(viewIndex);
            if (index != -1 && this.tblMipa.getSelectedRowCount() <= 1) {
                Collection<MipaMerkmalCustomBean> merkmale;
                MipaCustomBean selectedMiPa = (MipaCustomBean)this.tableModel.getCidsBeanAtRow(index);
                this.tableModel.setCurrentSelectedMipa(selectedMiPa);
                if (selectedMiPa != null) {
                    Collection<FlurstueckSchluesselCustomBean> keys;
                    if (this.crossreferences != null && (keys = this.crossreferences.get(selectedMiPa)) != null) {
                        this.lstCrossRefs.setModel(new DefaultUniqueListModel(keys));
                    }
                    if (selectedMiPa.getGeometry() == null && LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SetBackgroundEnabled abgeschaltet: ", (Throwable)new CurrentStackTrace());
                    }
                }
                if ((merkmale = selectedMiPa.getMiPaMerkmal()) != null) {
                    for (int i = 0; i < this.lstMerkmale.getModel().getSize(); ++i) {
                        MiPaMerkmalCheckBox currentCheckBox = (MiPaMerkmalCheckBox)this.lstMerkmale.getModel().getElementAt(i);
                        if (currentCheckBox != null && currentCheckBox.getMiPaMerkmal() != null && merkmale.contains(currentCheckBox.getMiPaMerkmal())) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Merkmal ist in MiPa vorhanden");
                            }
                            currentCheckBox.removeItemListener(this);
                            currentCheckBox.setSelected(true);
                            currentCheckBox.addItemListener(this);
                            this.lstMerkmale.repaint();
                            continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Merkmal ist nicht in MiPa vorhanden");
                        }
                        currentCheckBox.removeItemListener(this);
                        currentCheckBox.setSelected(false);
                        currentCheckBox.addItemListener(this);
                        this.lstMerkmale.repaint();
                    }
                }
                if (this.isInEditMode) {
                    this.enableSlaveComponents(this.isInEditMode);
                } else {
                    this.enableSlaveComponents(this.isInEditMode);
                }
            }
        } else {
            this.btnRemoveMiPa.setEnabled(false);
            this.deselectAllListEntries();
            this.tableModel.clearSlaveComponents();
            this.enableSlaveComponents(false);
            return;
        }
        ((MipaTable)((Object)this.tblMipa)).valueChanged_updateFeatures(this, e);
        ((JXTable)this.tblMipa).packAll();
    }

    @Override
    public int getStatus() {
        if (this.tblMipa.getCellEditor() != null) {
            this.validationMessage = "Bitte vollenden Sie alle \u00c4nderungen bei den Vermietungen und Verpachtungen.";
            return 2;
        }
        ArrayList miPas = (ArrayList)this.tableModel.getCidsBeans();
        if (miPas != null || miPas.size() > 0) {
            for (MiPa currentMiPa : miPas) {
                if (currentMiPa != null && (currentMiPa.getMiPaNutzung() == null || currentMiPa.getMiPaNutzung().getMiPaKategorie() == null)) {
                    this.validationMessage = "Alle Vermietungen und Verpachtungen m\u00fcssen eine Nutzung (Kategorie) enthalten";
                    return 2;
                }
                if (currentMiPa != null && (currentMiPa.getNutzer() == null || currentMiPa.getNutzer().equals(""))) {
                    this.validationMessage = "Alle Vermietungen und Verpachtungen m\u00fcssen einen Nutzer besitzen.";
                    return 2;
                }
                if (currentMiPa != null && currentMiPa.getVertragsbeginn() == null) {
                    this.validationMessage = "Alle Vermietungen und Verpachtungen m\u00fcssen ein Vertragsbeginn besitzen.";
                    return 2;
                }
                if (currentMiPa != null && currentMiPa.getLage() == null) {
                    this.validationMessage = "Alle Vermietungen und Verpachtungen m\u00fcssen eine Lage besitzen.";
                    return 2;
                }
                if (currentMiPa != null && currentMiPa.getAktenzeichen() == null) {
                    this.validationMessage = "Alle Vermietungen und Verpachtungen m\u00fcssen ein Aktenzeichen besitzen.";
                    return 2;
                }
                if (currentMiPa == null || currentMiPa.getVertragsbeginn() == null || currentMiPa.getVertragsende() == null || currentMiPa.getVertragsbeginn().compareTo(currentMiPa.getVertragsende()) <= 0) continue;
                this.validationMessage = "Das Datum des Vertragsbeginns muss vor dem Datum des Vertragsende liegen.";
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Item State of MiPAMerkmal Changed " + e));
        }
        MiPaMerkmalCheckBox checkBox = (MiPaMerkmalCheckBox)e.getSource();
        if (this.tblMipa.getSelectedRow() != -1) {
            MiPa miPa = (MiPa)this.tableModel.getCidsBeanAtRow(((JXTable)this.tblMipa).convertRowIndexToModel(this.tblMipa.getSelectedRow()));
            if (miPa != null) {
                Collection<MipaMerkmalCustomBean> merkmale = miPa.getMiPaMerkmal();
                if (merkmale == null) {
                    LOG.info((Object)"neues Hibernateset f\u00fcr Merkmale angelegt");
                    merkmale = new HashSet<MipaMerkmalCustomBean>();
                }
                if (e.getStateChange() == 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Checkbox wurde selektiert --> f\u00fcge es zum Set hinzu");
                    }
                    merkmale.add(checkBox.getMiPaMerkmal());
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Checkbox wurde deselektiert --> l\u00f6sche es aus Set");
                    }
                    merkmale.remove(checkBox.getMiPaMerkmal());
                }
            } else {
                LOG.warn((Object)"Kann merkmals\u00e4nderung nicht speichern da kein Eintrag unter diesem Index im Modell vorhanden ist");
            }
        } else {
            LOG.warn((Object)"Kann merkmals\u00e4nderung nicht speichern da kein Eintrag selektiert ist");
        }
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    private String getIdentifierString(MiPa mipa) {
        String idValue1 = mipa.getLage();
        MipaNutzungCustomBean idValue2 = mipa.getMiPaNutzung();
        StringBuffer identifier = new StringBuffer();
        if (idValue1 != null) {
            identifier.append(idValue1);
        } else {
            identifier.append("keine Lage");
        }
        if (idValue2 != null && idValue2.getMiPaKategorie() != null) {
            identifier.append(" - " + idValue2.getMiPaKategorie());
        } else {
            identifier.append(" - keine Nutzung");
        }
        if (idValue2 != null && idValue2.getAusgewaehlteNummer() != null) {
            identifier.append(" - Nr. " + idValue2.getAusgewaehlteNummer());
        }
        return identifier.toString();
    }

    @Override
    public Vector<GeometrySlotInformation> getSlotInformation() {
        Vector<GeometrySlotInformation> result = new Vector<GeometrySlotInformation>();
        if (this.isWidgetReadOnly()) {
            return result;
        }
        int rowCount = this.tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            MiPa currentMiPa = (MiPa)this.tableModel.getCidsBeanAtRow(i);
            if (currentMiPa.getGeometry() != null) continue;
            result.add(new GeometrySlotInformation(this.getProviderName(), this.getIdentifierString(currentMiPa), currentMiPa, this));
        }
        return result;
    }

    @Override
    public void featureSelectionChanged(Collection<Feature> features) {
        ((MipaTable)((Object)this.tblMipa)).featureSelectionChanged(this, features, MipaCustomBean.class);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel2 = new JPanel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.cpMiPa = new JScrollPane();
        this.tblMipa = new MipaTable();
        this.jPanel3 = new JPanel();
        this.btnAddMiPa = new JButton();
        this.btnRemoveMiPa = new JButton();
        this.tbtnSort = new JToggleButton();
        this.btnUndo = new JButton();
        this.jPanel1 = new JPanel();
        this.panQuerverweise = new JPanel();
        this.panQuerverweiseTitled = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCrossRefs = new JList();
        this.jLabel2 = new JLabel();
        this.panMerkmale = new JPanel();
        this.panMerkmaleTitled = new JPanel();
        this.spMerkmale = new JScrollPane();
        this.lstMerkmale = new JCheckBoxList();
        this.jLabel1 = new JLabel();
        this.panBemerkung = new JPanel();
        this.panBemerkungTitled = new JPanel();
        this.spBemerkung = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.jLabel3 = new JLabel();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane2, -1, 148, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane2, -1, 126, Short.MAX_VALUE).addContainerGap()));
        this.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.cpMiPa.setBorder(null);
        this.tblMipa.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}}, new String[]{"Nummer", "Lage", "Fl\u00e4che m\u00b2", "Nutzung", "Nutzer", "Vertragsbeginn", "Vertragsende"}));
        this.cpMiPa.setViewportView(this.tblMipa);
        ((MipaTable)((Object)this.tblMipa)).setSortButton(this.tbtnSort);
        ((MipaTable)((Object)this.tblMipa)).setUndoButton(this.btnUndo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.cpMiPa, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.btnAddMiPa.setAction(((MipaTable)((Object)this.tblMipa)).getAddAction());
        this.btnAddMiPa.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddMiPa.setBorder(null);
        this.btnAddMiPa.setBorderPainted(false);
        this.btnAddMiPa.setMaximumSize(new Dimension(25, 25));
        this.btnAddMiPa.setMinimumSize(new Dimension(25, 25));
        this.btnAddMiPa.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.btnAddMiPa, gridBagConstraints);
        this.btnRemoveMiPa.setAction(((MipaTable)((Object)this.tblMipa)).getRemoveAction());
        this.btnRemoveMiPa.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveMiPa.setBorder(null);
        this.btnRemoveMiPa.setBorderPainted(false);
        this.btnRemoveMiPa.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveMiPa.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveMiPa.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel3.add((Component)this.btnRemoveMiPa, gridBagConstraints);
        this.tbtnSort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSort.setToolTipText("Sortierung An / Aus");
        this.tbtnSort.setBorderPainted(false);
        this.tbtnSort.setContentAreaFilled(false);
        this.tbtnSort.setMaximumSize(new Dimension(25, 25));
        this.tbtnSort.setMinimumSize(new Dimension(25, 25));
        this.tbtnSort.setPreferredSize(new Dimension(25, 25));
        this.tbtnSort.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel3.add((Component)this.tbtnSort, gridBagConstraints);
        this.tbtnSort.addItemListener(((MipaTable)((Object)this.tblMipa)).getSortItemListener());
        this.btnUndo.setAction(((MipaTable)((Object)this.tblMipa)).getUndoAction());
        this.btnUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/undo.png")));
        this.btnUndo.setBorder(null);
        this.btnUndo.setBorderPainted(false);
        this.btnUndo.setFocusPainted(false);
        this.btnUndo.setMaximumSize(new Dimension(25, 25));
        this.btnUndo.setMinimumSize(new Dimension(25, 25));
        this.btnUndo.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel3.add((Component)this.btnUndo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.jPanel4.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(24, 100));
        this.jPanel1.setPreferredSize(new Dimension(314, 100));
        this.jPanel1.setLayout(new GridBagLayout());
        this.panQuerverweise.setBorder(BorderFactory.createEtchedBorder());
        this.panQuerverweise.setOpaque(false);
        this.panQuerverweise.setLayout(new GridBagLayout());
        this.panQuerverweiseTitled.setOpaque(false);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setOpaque(false);
        this.lstCrossRefs.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.lstCrossRefs.setOpaque(false);
        this.jScrollPane1.setViewportView(this.lstCrossRefs);
        GroupLayout panQuerverweiseTitledLayout = new GroupLayout(this.panQuerverweiseTitled);
        this.panQuerverweiseTitled.setLayout(panQuerverweiseTitledLayout);
        panQuerverweiseTitledLayout.setHorizontalGroup(panQuerverweiseTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE));
        panQuerverweiseTitledLayout.setVerticalGroup(panQuerverweiseTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 61, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panQuerverweise.add((Component)this.panQuerverweiseTitled, gridBagConstraints);
        this.jLabel2.setText("Querverweise:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panQuerverweise.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel1.add((Component)this.panQuerverweise, gridBagConstraints);
        this.panMerkmale.setBorder(BorderFactory.createEtchedBorder());
        this.panMerkmale.setOpaque(false);
        this.panMerkmale.setLayout(new GridBagLayout());
        this.panMerkmaleTitled.setOpaque(false);
        this.spMerkmale.setBorder(null);
        this.spMerkmale.setOpaque(false);
        this.lstMerkmale.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.lstMerkmale.setOpaque(false);
        this.spMerkmale.setViewportView(this.lstMerkmale);
        GroupLayout panMerkmaleTitledLayout = new GroupLayout(this.panMerkmaleTitled);
        this.panMerkmaleTitled.setLayout(panMerkmaleTitledLayout);
        panMerkmaleTitledLayout.setHorizontalGroup(panMerkmaleTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spMerkmale, -2, 0, Short.MAX_VALUE));
        panMerkmaleTitledLayout.setVerticalGroup(panMerkmaleTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spMerkmale, -1, 61, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panMerkmale.add((Component)this.panMerkmaleTitled, gridBagConstraints);
        this.jLabel1.setText("Merkmale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panMerkmale.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)this.panMerkmale, gridBagConstraints);
        this.panBemerkung.setBorder(BorderFactory.createEtchedBorder());
        this.panBemerkung.setOpaque(false);
        this.panBemerkung.setLayout(new GridBagLayout());
        this.panBemerkungTitled.setOpaque(false);
        this.spBemerkung.setOpaque(false);
        this.taBemerkung.setColumns(20);
        this.taBemerkung.setLineWrap(true);
        this.taBemerkung.setRows(3);
        this.taBemerkung.setWrapStyleWord(true);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.taBemerkung, (Property)ELProperty.create((String)"${editable}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"opaque"));
        this.bindingGroup.addBinding((Binding)binding);
        this.spBemerkung.setViewportView(this.taBemerkung);
        GroupLayout panBemerkungTitledLayout = new GroupLayout(this.panBemerkungTitled);
        this.panBemerkungTitled.setLayout(panBemerkungTitledLayout);
        panBemerkungTitledLayout.setHorizontalGroup(panBemerkungTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spBemerkung, -2, 0, Short.MAX_VALUE));
        panBemerkungTitledLayout.setVerticalGroup(panBemerkungTitledLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spBemerkung, -1, 61, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.panBemerkung.add((Component)this.panBemerkungTitled, gridBagConstraints);
        this.jLabel3.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.panBemerkung.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.panBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 11, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void updateWidgetUi() {
        this.tblMipa.repaint();
        this.lstCrossRefs.repaint();
        this.lstMerkmale.repaint();
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featureCollectionChanged() {
        this.updateWidgetUi();
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
        this.updateWidgetUi();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        ((JXTable)this.tblMipa).packAll();
    }

    @Override
    public List<BasicEntity> getCopyData() {
        ArrayList allMiPas = (ArrayList)this.tableModel.getCidsBeans();
        ArrayList<BasicEntity> result = new ArrayList<BasicEntity>(allMiPas.size());
        for (MipaCustomBean mipa : allMiPas) {
            MipaCustomBean tmp = MipaCustomBean.createNew();
            tmp.setAktenzeichen(mipa.getAktenzeichen());
            tmp.setBemerkung(mipa.getBemerkung());
            tmp.setCanBeSelected(mipa.canBeSelected());
            tmp.setEditable(mipa.isEditable());
            tmp.setFillingPaint(mipa.getFillingPaint());
            tmp.setFlaeche(mipa.getFlaeche());
            Geometry geom = mipa.getGeometry();
            if (geom != null) {
                tmp.setGeometry((Geometry)geom.clone());
            }
            tmp.setHighlightingEnabled(mipa.isHighlightingEnabled());
            tmp.setLage(mipa.getLage());
            tmp.setLinePaint(mipa.getLinePaint());
            tmp.setLineWidth(mipa.getLineWidth());
            tmp.setMiPaMerkmal(mipa.getMiPaMerkmal());
            tmp.setMiPaNutzung(mipa.getMiPaNutzung());
            tmp.setModifiable(mipa.isModifiable());
            tmp.setNutzer(mipa.getNutzer());
            tmp.setPointAnnotationSymbol(mipa.getPointAnnotationSymbol());
            tmp.setTransparency(mipa.getTransparency());
            tmp.setVertragsbeginn(mipa.getVertragsbeginn());
            tmp.setVertragsende(mipa.getVertragsende());
            tmp.hide(mipa.isHidden());
            result.add(tmp);
        }
        return result;
    }

    @Override
    public void paste(BasicEntity item) {
        if (item == null) {
            throw new NullPointerException("Given data item must not be null");
        }
        if (item instanceof MiPa) {
            List<? extends CidsBean> residentMiPas = this.tableModel.getCidsBeans();
            if (residentMiPas.contains(item)) {
                LOG.warn((Object)("MiPa " + item + " does already exist in Flurst\u00fcck " + LagisBroker.getInstance().getCurrentFlurstueck()));
            } else {
                this.tableModel.addCidsBean((MipaCustomBean)item);
                MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
                CustomSelectionStyledFeatureGroupWrapper f = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)item, PROVIDER_NAME, PROVIDER_NAME);
                mc.getFeatureCollection().addFeature((Feature)f);
                mc.setGroupLayerVisibility(PROVIDER_NAME, true);
                this.tableModel.fireTableDataChanged();
            }
        }
    }

    @Override
    public void pasteAll(List<BasicEntity> dataList) {
        if (dataList == null) {
            throw new NullPointerException("Given list of MiPa items must not be null");
        }
        if (dataList.isEmpty()) {
            return;
        }
        ArrayList residentMiPas = (ArrayList)this.tableModel.getCidsBeans();
        int rowCountBefore = this.tableModel.getRowCount();
        MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
        FeatureCollection featCollection = mc.getFeatureCollection();
        for (BasicEntity entity : dataList) {
            if (!(entity instanceof MiPa)) continue;
            if (residentMiPas.contains(entity)) {
                LOG.warn((Object)("Verwaltungsbereich " + entity + " does already exist in Flurst\u00fcck " + LagisBroker.getInstance().getCurrentFlurstueck()));
                continue;
            }
            this.tableModel.addCidsBean((MipaCustomBean)entity);
            CustomSelectionStyledFeatureGroupWrapper f = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)entity, PROVIDER_NAME, PROVIDER_NAME);
            featCollection.addFeature((Feature)f);
        }
        if (rowCountBefore == this.tableModel.getRowCount()) {
            LOG.warn((Object)("No MiPa items were added from input list " + dataList));
        } else {
            this.tableModel.fireTableDataChanged();
            mc.setGroupLayerVisibility(PROVIDER_NAME, true);
        }
    }

    @Override
    public String getDisplayName(BasicEntity entity) {
        if (entity instanceof MiPa) {
            MiPa mipa = (MiPa)((Object)entity);
            return this.getProviderName() + " - " + this.getIdentifierString(mipa);
        }
        return "unbekannt";
    }

    @Override
    public Icon getDisplayIcon() {
        return this.copyDisplayIcon;
    }

    @Override
    public boolean knowsDisplayName(BasicEntity entity) {
        return entity instanceof MiPa;
    }

    @Override
    public void duringRemoveAction(Object source) {
        this.enableSlaveComponents(false);
        this.deselectAllListEntries();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"liste ausgeschaltet");
        }
    }

    @Override
    public void afterRemoveAction(Object source) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isFeatureSelectionChangedEnabled() {
        return this.listenerEnabled;
    }

    @Override
    public void setFeatureSelectionChangedEnabled(boolean listenerEnabled) {
        this.listenerEnabled = listenerEnabled;
    }
}

