/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import de.cismet.tools.gui.jbands.interfaces.Section;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class NKFBandMember
extends JLabel
implements Section,
BandMember,
BandMemberSelectable {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private double from = 0.0;
    private double to = 0.0;
    private final Date date;
    private boolean selected = false;
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private final Border unselectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createBevelBorder(0));
    private final Border selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createBevelBorder(1));

    public NKFBandMember(double from, double to, Date date) {
        this.from = from;
        this.to = to;
        this.date = date;
        if (date != null) {
            this.setText(DATE_FORMAT.format(date));
        } else {
            this.setText("Aktuelle Nutzungen");
        }
        this.setBorder(this.unselectedBorder);
        this.setHorizontalAlignment(0);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(this.unselectedBorder);
        }
        for (Listener listener : this.listeners) {
            listener.memberSelected(selected);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isSelectable() {
        return true;
    }

    public BandMember getBandMember() {
        return this;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setFrom(double from) {
        this.from = from;
    }

    public void setTo(double to) {
        this.to = to;
    }

    public double getMax() {
        return this.from < this.to ? this.to : this.from;
    }

    public double getMin() {
        return this.from < this.to ? this.from : this.to;
    }

    public JComponent getBandMemberComponent() {
        return this;
    }

    public double getFrom() {
        return this.from;
    }

    public double getTo() {
        return this.to;
    }

    public Date getDate() {
        return this.date;
    }

    public static interface Listener {
        public void memberSelected(boolean var1);
    }
}

