/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.panels;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.GeomCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeCustomBean;
import de.cismet.cids.custom.beans.lagis.StrassenfrontCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltendeDienststelleCustomBean;
import de.cismet.cids.custom.beans.lagis.VerwaltungsbereichCustomBean;
import de.cismet.cids.custom.beans.lagis.ZusatzRolleArtCustomBean;
import de.cismet.cids.custom.beans.lagis.ZusatzRolleCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.wfsforms.WFSFormAdress;
import de.cismet.cismap.commons.wfsforms.WFSFormsListAndComboBoxModel;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.editor.FlaecheEditor;
import de.cismet.lagis.gui.copypaste.Copyable;
import de.cismet.lagis.gui.copypaste.Pasteable;
import de.cismet.lagis.gui.dialogs.VerwaltungsbereicheHistorieDialog;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.gui.tables.AbstractCidsBeanTable_Lagis;
import de.cismet.lagis.gui.tables.StrassenfrontTable;
import de.cismet.lagis.gui.tables.VerwaltungsTable;
import de.cismet.lagis.gui.tables.ZusatzRolleTable;
import de.cismet.lagis.interfaces.FeatureSelectionChangedListener;
import de.cismet.lagis.interfaces.FlurstueckChangeListener;
import de.cismet.lagis.interfaces.FlurstueckSaver;
import de.cismet.lagis.interfaces.GeometrySlotProvider;
import de.cismet.lagis.interfaces.LagisBrokerPropertyChangeListener;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import de.cismet.lagis.models.documents.SimpleDocumentModel;
import de.cismet.lagis.renderer.FlaecheRenderer;
import de.cismet.lagis.renderer.VerwaltendeDienststelleRenderer;
import de.cismet.lagis.util.TableSelectionUtils;
import de.cismet.lagis.utillity.GeometrySlotInformation;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import de.cismet.lagis.validation.Validator;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagisEE.entity.basic.BasicEntity;
import de.cismet.lagisEE.entity.core.CustomSelectionStyledFeatureGroupWrapper;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.historybutton.DefaultHistoryModel;
import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import de.cismet.tools.gui.historybutton.JHistoryButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdom.Element;

public class VerwaltungsPanel
extends AbstractWidget
implements GeometrySlotProvider,
FlurstueckSaver,
FlurstueckChangeListener,
FeatureSelectionChangedListener,
ListSelectionListener,
Configurable,
ValidationStateChangedListener,
FeatureCollectionListener,
HistoryModelListener,
Copyable,
Pasteable {
    public static final String PROVIDER_NAME = "Verwaltende Dienstelle";
    private static final String WIDGET_NAME = "Verwaltungspanel";
    private static final String COPY_DISPLAY_ICON = "/de/cismet/lagis/ressource/icons/verwaltungsbereich16.png";
    private static final VerwaltungsPanel INSTANCE = new VerwaltungsPanel();
    private static final Logger LOG = Logger.getLogger(VerwaltungsPanel.class);
    protected boolean historyEnabled = true;
    private final Icon icoWFSSizeGood = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/wfs_green.png"));
    private final Icon icoWFSSizeBad = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/wfs_red.png"));
    private final Icon icoWFSSizeTolerated = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/wfs_yellow.png"));
    private final Icon icoWFSLoad = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/exec.png"));
    private final Icon icoWFSWarn = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/16warn.png"));
    private final Icon icoBelastung = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/belastung.png"));
    private final Icon icoRecht = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/recht.png"));
    private final Icon icoRebeExpired = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/rebeExpired.png"));
    private final Validator valTxtBemerkung;
    private SimpleDocumentModel bemerkungDocumentModel;
    private final VerwaltungsTable.Model verwaltungsTableModel = new VerwaltungsTable.Model();
    private final ZusatzRolleTable.Model zusatzRolleTableModel = new ZusatzRolleTable.Model();
    private final StrassenfrontTable.Model strassenfrontTableModel = new StrassenfrontTable.Model();
    private boolean isInEditMode = false;
    private final VerwaltendeDienststelleRenderer vdRenderer = new VerwaltendeDienststelleRenderer();
    private boolean isFlurstueckEditable = true;
    private final JLabel lblLastModification;
    private JHistoryButton hbBack;
    private JHistoryButton hbFwd;
    private final DefaultHistoryModel historyModel = new DefaultHistoryModel();
    private Vector<Validator> validators = new Vector();
    private final Icon copyDisplayIcon = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/verwaltungsbereich16.png"));
    private boolean listenerEnabled = true;
    private JButton btnAddStrassenfront;
    private JButton btnAddVerwaltung;
    private JButton btnAddZusatzRolle;
    private JButton btnHistorie;
    private JButton btnRemoveStrassenfront;
    private JButton btnRemoveVerwaltung;
    private JButton btnRemoveZusatzRolle;
    private JButton btnUndo;
    private JCheckBox cbSperre;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lblBelastungen;
    private JLabel lblBemSperre;
    private JLabel lblRechte;
    private JLabel lblWFSInfo;
    private JTable tNutzung;
    private JTable tStrassenfront;
    private JTable tZusatzRolle;
    private JToggleButton tbtnSort;
    private JTextArea txtBemerkung;

    private VerwaltungsPanel() {
        this.setIsCoreWidget(true);
        this.initComponents();
        this.configureTable();
        this.valTxtBemerkung = new Validator(this.txtBemerkung);
        this.initModels();
        this.lblLastModification = new JLabel();
        this.lblLastModification.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/goto.png")));
        this.lblLastModification.setOpaque(false);
        this.historyModel.addHistoryModelListener((HistoryModelListener)this);
        this.configureButtons();
        LagisBroker.getInstance().addWfsFlurstueckGeometryChangeListener(new LagisBrokerPropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("currentWFSGeometry".equals(evt.getPropertyName())) {
                    final Geometry currentGeometry = (Geometry)evt.getNewValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (currentGeometry == null) {
                                VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSWarn);
                                VerwaltungsPanel.this.lblWFSInfo.setToolTipText("Keine WFS Geometrie vorhanden");
                                VerwaltungsPanel.this.verwaltungsTableModel.setCurrentWFSSize(0.0);
                            } else {
                                VerwaltungsPanel.this.verwaltungsTableModel.setCurrentWFSSize(currentGeometry.getArea());
                            }
                        }
                    });
                } else if ("currentWFSGeometryError".equals(evt.getPropertyName())) {
                    final Exception ex = (Exception)evt.getNewValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LOG.error((Object)"Fehler beim abrufen der Geometrie", (Throwable)ex);
                            VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSWarn);
                            VerwaltungsPanel.this.lblWFSInfo.setToolTipText("Fehler beim vergleichen der Fl\u00e4chen");
                            VerwaltungsPanel.this.verwaltungsTableModel.setCurrentWFSSize(0.0);
                        }
                    });
                } else if ("currentRebes".equals(evt.getPropertyName())) {
                    final Collection currentRebes = (Collection)evt.getNewValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VerwaltungsPanel.this.refreshReBeIcons(currentRebes);
                        }
                    });
                }
            }
        });
    }

    public static VerwaltungsPanel getInstance() {
        return INSTANCE;
    }

    public JTable getNutzungTable() {
        return this.tNutzung;
    }

    @Override
    public List<BasicEntity> getCopyData() {
        ArrayList allVBs = (ArrayList)this.verwaltungsTableModel.getCidsBeans();
        ArrayList<BasicEntity> result = new ArrayList<BasicEntity>(allVBs.size());
        for (VerwaltungsbereichCustomBean vb : allVBs) {
            try {
                VerwaltungsbereichCustomBean tmp = VerwaltungsbereichCustomBean.createNew();
                tmp.setDienststelle(vb.getDienststelle());
                Geometry geom = vb.getGeometry();
                if (geom != null) {
                    tmp.setGeometry((Geometry)geom.clone());
                }
                tmp.setEditable(vb.isEditable());
                tmp.hide(vb.isHidden());
                tmp.setModifiable(vb.isModifiable());
                result.add(tmp);
            }
            catch (Exception ex) {
                LOG.error((Object)"error creating bean for verwaltungsbereiche", (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public void paste(BasicEntity item) {
        if (item == null) {
            throw new NullPointerException("Given data item must not be null");
        }
        if (item instanceof VerwaltungsbereichCustomBean) {
            ArrayList residentVBs = (ArrayList)this.verwaltungsTableModel.getCidsBeans();
            if (residentVBs.contains(item)) {
                LOG.warn((Object)("Verwaltungsbereich " + item + " does already exist in Flurst\u00fcck " + LagisBroker.getInstance().getCurrentFlurstueck()));
            } else {
                this.verwaltungsTableModel.addCidsBean((VerwaltungsbereichCustomBean)item);
                this.verwaltungsTableModel.fireTableDataChanged();
                MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
                CustomSelectionStyledFeatureGroupWrapper f = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)item, PROVIDER_NAME, PROVIDER_NAME);
                mc.getFeatureCollection().addFeature((Feature)f);
                mc.setGroupLayerVisibility(PROVIDER_NAME, true);
            }
        }
    }

    @Override
    public void pasteAll(List<BasicEntity> dataList) {
        if (dataList == null) {
            throw new NullPointerException("Given list of Verwaltungsbereich items must not be null");
        }
        if (dataList.isEmpty()) {
            return;
        }
        ArrayList residentVBs = (ArrayList)this.verwaltungsTableModel.getCidsBeans();
        int rowCountBefore = this.verwaltungsTableModel.getRowCount();
        MappingComponent mc = LagisBroker.getInstance().getMappingComponent();
        FeatureCollection featCollection = mc.getFeatureCollection();
        for (BasicEntity entity : dataList) {
            if (!(entity instanceof VerwaltungsbereichCustomBean)) continue;
            if (residentVBs.contains(entity)) {
                LOG.warn((Object)("Verwaltungsbereich " + entity + " does already exist in Flurst\u00fcck " + LagisBroker.getInstance().getCurrentFlurstueck()));
                continue;
            }
            this.verwaltungsTableModel.addCidsBean((VerwaltungsbereichCustomBean)entity);
            CustomSelectionStyledFeatureGroupWrapper f = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)entity, PROVIDER_NAME, PROVIDER_NAME);
            featCollection.addFeature((Feature)f);
        }
        if (rowCountBefore == this.verwaltungsTableModel.getRowCount()) {
            LOG.warn((Object)("No Verwaltungsbereich items were added from input list " + dataList));
        } else {
            this.verwaltungsTableModel.fireTableDataChanged();
            mc.setGroupLayerVisibility(PROVIDER_NAME, true);
        }
    }

    public ArrayList<JComponent> getCustomButtons() {
        ArrayList<JComponent> tmp = new ArrayList<JComponent>();
        tmp.add(this.lblLastModification);
        tmp.add((JComponent)this.hbBack);
        tmp.add((JComponent)this.hbFwd);
        return tmp;
    }

    private void configureButtons() {
        this.hbBack = JHistoryButton.getDefaultJHistoryButton((int)2, (int)4, (HistoryModel)this.historyModel);
        this.hbFwd = JHistoryButton.getDefaultJHistoryButton((int)1, (int)4, (HistoryModel)this.historyModel);
        this.hbBack.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.hbBack.setOpaque(false);
        this.hbFwd.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.hbFwd.setOpaque(false);
    }

    public void backStatusChanged() {
    }

    public void forwardStatusChanged() {
    }

    public void historyActionPerformed() {
    }

    public void historyChanged() {
        if (this.historyModel != null && this.historyModel.getCurrentElement() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("historyChanged:" + this.historyModel.getCurrentElement().toString()));
            }
            if (this.historyModel.getCurrentElement() != null && !this.historyModel.getCurrentElement().equals(LagisBroker.getInstance().getCurrentFlurstueck())) {
                LagisBroker.getInstance().loadFlurstueck(((FlurstueckCustomBean)this.historyModel.getCurrentElement()).getFlurstueckSchluessel());
            }
        }
    }

    private void configureTable() {
        TableSelectionUtils.crossReferenceModelAndTable(this.verwaltungsTableModel, (VerwaltungsTable)((Object)this.tNutzung));
        JComboBox<VerwaltendeDienststelleCustomBean> cboVD = new JComboBox<VerwaltendeDienststelleCustomBean>(new Vector<VerwaltendeDienststelleCustomBean>(LagisBroker.getInstance().getAllVerwaltendeDienstellen()));
        cboVD.setEditable(true);
        cboVD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerwaltungsPanel.this.cboVDActionPerformed();
            }
        });
        this.tNutzung.setDefaultRenderer(VerwaltendeDienststelleCustomBean.class, this.vdRenderer);
        this.tNutzung.setDefaultRenderer(Integer.class, new FlaecheRenderer());
        this.tNutzung.setDefaultEditor(VerwaltendeDienststelleCustomBean.class, (TableCellEditor)new ComboBoxCellEditor(cboVD));
        this.tNutzung.setDefaultEditor(Integer.class, new FlaecheEditor());
        this.tNutzung.getSelectionModel().addListSelectionListener(this);
        TableSelectionUtils.crossReferenceModelAndTable(this.strassenfrontTableModel, (AbstractCidsBeanTable_Lagis)((Object)this.tStrassenfront));
        TableSelectionUtils.crossReferenceModelAndTable(this.zusatzRolleTableModel, (AbstractCidsBeanTable_Lagis)((Object)this.tZusatzRolle));
        WFSFormAdress wfsSF = (WFSFormAdress)LagisApp.getInstance().getWfsFormFactory().getForms().get("strassen");
        wfsSF.initWFSForm();
        final WFSFormsListAndComboBoxModel cbModel = (WFSFormsListAndComboBoxModel)((JComboBox)wfsSF.getListComponentByName("cboAllStreets")).getModel();
        cbModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ArrayList<String> strassen = new ArrayList<String>();
                strassen.add(null);
                for (int index = 0; index < cbModel.getSize(); ++index) {
                    strassen.add(String.valueOf(cbModel.getElementAt(index)));
                }
                final JComboBox<String> cboSF = new JComboBox<String>(strassen.toArray(new String[0]));
                cboSF.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        return super.getListCellRendererComponent(list, value != null ? value : "<html><i> keine ", index, isSelected, cellHasFocus);
                    }
                });
                cboSF.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VerwaltungsPanel.this.tStrassenfront.setValueAt(cboSF.getSelectedItem(), VerwaltungsPanel.this.tStrassenfront.getSelectedRow(), 0);
                    }
                });
                StaticSwingTools.decorateWithFixedAutoCompleteDecorator(cboSF);
                VerwaltungsPanel.this.tStrassenfront.setDefaultEditor(String.class, (TableCellEditor)new ComboBoxCellEditor(cboSF));
                VerwaltungsPanel.this.tStrassenfront.getSelectionModel().addListSelectionListener(VerwaltungsPanel.this);
            }
        });
        JComboBox<VerwaltendeDienststelleCustomBean> cboZRD = new JComboBox<VerwaltendeDienststelleCustomBean>(LagisBroker.getInstance().getAllVerwaltendeDienstellen().toArray(new VerwaltendeDienststelleCustomBean[0]));
        cboZRD.setEditable(true);
        cboZRD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerwaltungsPanel.this.cboZRDActionPerformed();
            }
        });
        JComboBox<ZusatzRolleArtCustomBean> cboZRA = new JComboBox<ZusatzRolleArtCustomBean>(new Vector<ZusatzRolleArtCustomBean>(LagisBroker.getInstance().getAllZusatzRolleArten()));
        cboZRA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerwaltungsPanel.this.cboZRAActionPerformed();
            }
        });
        this.tZusatzRolle.setDefaultRenderer(VerwaltendeDienststelleCustomBean.class, this.vdRenderer);
        this.tZusatzRolle.setDefaultRenderer(ZusatzRolleArtCustomBean.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setEnabled(true);
                return component;
            }
        });
        this.tZusatzRolle.setDefaultEditor(VerwaltendeDienststelleCustomBean.class, (TableCellEditor)new ComboBoxCellEditor(cboZRD));
        this.tZusatzRolle.setDefaultEditor(ZusatzRolleArtCustomBean.class, (TableCellEditor)new ComboBoxCellEditor(cboZRA));
        this.tZusatzRolle.getSelectionModel().addListSelectionListener(this);
        HighlightPredicate noGeometryPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                try {
                    int displayedIndex = componentAdapter.row;
                    int modelIndex = ((JXTable)VerwaltungsPanel.this.tNutzung).convertRowIndexToModel(displayedIndex);
                    VerwaltungsbereichCustomBean g = (VerwaltungsbereichCustomBean)VerwaltungsPanel.this.verwaltungsTableModel.getCidsBeanAtRow(modelIndex);
                    return (g == null || g != null && g.getGeometry() == null) && VerwaltungsPanel.this.verwaltungsTableModel.getCidsBeans() != null && VerwaltungsPanel.this.verwaltungsTableModel.getRowCount() != 1;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim Highlighting test noGeometry", (Throwable)ex);
                    return false;
                }
            }
        };
        ColorHighlighter noGeometryHighlighter = new ColorHighlighter(noGeometryPredicate, LagisBroker.GREY, null);
        HighlightPredicate geometrySizeDifferentPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Teste Geometriegr\u00f6\u00dfe");
                    }
                    if (LagisBroker.getInstance().getCurrentWFSGeometry() == null) {
                        if (!VerwaltungsPanel.this.lblWFSInfo.getIcon().equals(VerwaltungsPanel.this.icoWFSWarn)) {
                            VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSLoad);
                            VerwaltungsPanel.this.lblWFSInfo.setToolTipText("WFS Geometrie wird geladen");
                        }
                        return true;
                    }
                    double currentGeometrySize = LagisBroker.getInstance().getCurrentWFSGeometry().getArea();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Gr\u00f6\u00dfe WFS Geometrie: " + currentGeometrySize));
                    }
                    double geomSum = 0.0;
                    int counter = 0;
                    for (Feature currentFeature : VerwaltungsPanel.this.verwaltungsTableModel.getAllVerwaltungsFeatures()) {
                        Geometry tmpGeometry = currentFeature.getGeometry();
                        if (LagisBroker.getInstance().getCurrentWFSGeometry() != null) {
                            geomSum += tmpGeometry.getArea();
                        }
                        ++counter;
                    }
                    if (counter < 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"es ist nur ein Verwaltungsbereich vorhanden --> automatische WFS gr\u00f6\u00dfe --> keine \u00dcberpr\u00fcfung");
                        }
                        VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSSizeGood);
                        VerwaltungsPanel.this.lblWFSInfo.setToolTipText("Automatische Zuordnung");
                        return false;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Summe aller Verwaltungsbereiche: " + geomSum));
                    }
                    double diff = (double)((int)(Math.abs(currentGeometrySize - geomSum) * 100.0)) / 100.0;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Differenz = " + diff));
                    }
                    if (diff == 0.0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Fl\u00e4chen sind gleich");
                        }
                        VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSSizeGood);
                        VerwaltungsPanel.this.lblWFSInfo.setToolTipText("Summe der Angelegten Fl\u00e4chen, sind gleich der WFS Fl\u00e4che");
                        return false;
                    }
                    if (diff <= 1.0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Fl\u00e4chen sind fast gleich");
                        }
                        VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSSizeTolerated);
                        VerwaltungsPanel.this.lblWFSInfo.setToolTipText("Summe der Angelegten Fl\u00e4chen, sind fast gleich der WFS Fl\u00e4che. Differenz <= 1 m\u00b2: " + diff);
                        return false;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Fl\u00e4chen sind nicht gleich");
                    }
                    VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSSizeBad);
                    VerwaltungsPanel.this.lblWFSInfo.setToolTipText("Unterschiedliche Fl\u00e4chen. WFS: " + (int)Math.round(currentGeometrySize) + "m\u00b2 Verwaltungsbereiche: " + (int)Math.round(geomSum) + "m\u00b2");
                    return true;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Fehler beim Highlight test geometrySize", (Throwable)ex);
                    VerwaltungsPanel.this.lblWFSInfo.setIcon(VerwaltungsPanel.this.icoWFSWarn);
                    VerwaltungsPanel.this.lblWFSInfo.setToolTipText("Fehler beim vergleichen der Fl\u00e4chen");
                    return true;
                }
            }
        };
        ColorHighlighter geometrySizeDifferentHighlighter = new ColorHighlighter(geometrySizeDifferentPredicate, LagisBroker.ERROR_COLOR, null);
        ((JXTable)this.tNutzung).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER, noGeometryHighlighter, geometrySizeDifferentHighlighter});
        ((JXTable)this.tNutzung).setSortOrder(0, SortOrder.ASCENDING);
        ((JXTable)this.tNutzung).packAll();
        ((VerwaltungsTable)((Object)this.tNutzung)).setSortButton(this.tbtnSort);
        ((VerwaltungsTable)((Object)this.tNutzung)).setUndoButton(this.btnUndo);
        ((JXTable)this.tZusatzRolle).setHighlighters(new Highlighter[]{LagisBroker.ALTERNATE_ROW_HIGHLIGHTER});
        ((JXTable)this.tZusatzRolle).setSortOrder(0, SortOrder.ASCENDING);
        ((JXTable)this.tZusatzRolle).packAll();
    }

    private void initModels() {
        this.bemerkungDocumentModel = new SimpleDocumentModel(){

            @Override
            public void assignValue(String newValue) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Bemerkung assigned");
                    LOG.debug((Object)("new Value: " + newValue));
                }
                this.valueToCheck = newValue;
                this.fireValidationStateChanged(this);
                if (LagisBroker.getInstance().getCurrentFlurstueck() != null && this.getStatus() == 0 || this.getStatus() == 1) {
                    LOG.info((Object)"Entit\u00e4t wirklich ge\u00e4ndert");
                    LagisBroker.getInstance().getCurrentFlurstueck().setBemerkung(newValue);
                }
            }
        };
        this.txtBemerkung.setDocument(this.bemerkungDocumentModel);
        this.valTxtBemerkung.reSetValidator(this.bemerkungDocumentModel);
        this.validators.add(this.valTxtBemerkung);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flurstueckChanged(FlurstueckCustomBean newFlurstueck) {
        try {
            Boolean isGesperrt;
            FlurstueckArtCustomBean flurstueckArt;
            LOG.info((Object)"FlurstueckChanged");
            this.strassenfrontTableModel.setCidsBeans(newFlurstueck != null ? (List)newFlurstueck.getN_strassenfronten() : null);
            this.zusatzRolleTableModel.setCidsBeans(newFlurstueck != null ? (List)newFlurstueck.getN_zusatz_rollen() : null);
            this.btnHistorie.setEnabled(!newFlurstueck.getVerwaltungsbereicheHistorie().isEmpty());
            this.clearComponent();
            if (newFlurstueck.getFlurstueckSchluessel().getLetzter_bearbeiter() != null && newFlurstueck.getFlurstueckSchluessel().getLetzte_bearbeitung() != null) {
                this.lblLastModification.setToolTipText(newFlurstueck.getFlurstueckSchluessel().getLetzter_bearbeiter() + " am " + LagisBroker.getDateFormatter().format(newFlurstueck.getFlurstueckSchluessel().getLetzte_bearbeitung()));
            } else if (newFlurstueck.getFlurstueckSchluessel().getLetzter_bearbeiter() != null) {
                this.lblLastModification.setToolTipText(newFlurstueck.getFlurstueckSchluessel().getLetzter_bearbeiter());
            } else {
                this.lblLastModification.setToolTipText("Unbekannt");
            }
            if (newFlurstueck.getFlurstueckSchluessel() != null) {
                this.historyModel.addToHistory((Object)newFlurstueck);
            }
            if ((flurstueckArt = newFlurstueck.getFlurstueckSchluessel().getFlurstueckArt()) != null && flurstueckArt.getBezeichnung().equals("st\u00e4dtisch")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist st\u00e4dtisch und kann editiert werden");
                }
                this.isFlurstueckEditable = true;
            } else if (flurstueckArt != null && flurstueckArt.getBezeichnung().equals("Abteilung IX")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch und kann nicht editiert werden (Abteilung IX)");
                }
                this.isFlurstueckEditable = false;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch und kann nicht editiert werden");
                }
                this.isFlurstueckEditable = false;
            }
            if (newFlurstueck.getVerwaltungsbereiche() != null || newFlurstueck.getVerwaltungsbereiche() != null && newFlurstueck.getVerwaltungsbereiche().size() == 0) {
                this.lblWFSInfo.setIcon(this.icoWFSSizeGood);
                this.lblWFSInfo.setToolTipText("Keine Verwaltungsbereiche vorhanden");
            }
            if (this.isFlurstueckEditable) {
                this.tNutzung.setVisible(true);
            } else {
                this.tNutzung.setVisible(false);
            }
            String bemerkung = newFlurstueck.getBemerkung();
            if (bemerkung != null) {
                this.bemerkungDocumentModel.insertString(0, bemerkung, null);
            }
            if ((isGesperrt = Boolean.valueOf(newFlurstueck.getFlurstueckSchluessel().getIstGesperrt())) != null) {
                this.cbSperre.setSelected(isGesperrt);
                String sperrentext = newFlurstueck.getFlurstueckSchluessel().getBemerkungSperre();
                if (sperrentext != null) {
                    this.lblBemSperre.setText(sperrentext);
                } else {
                    this.lblBemSperre.setText("");
                }
            } else {
                this.cbSperre.setSelected(false);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anzahl verwaltungsbereiche: " + newFlurstueck.getVerwaltungsbereiche().size()));
            }
            ArrayList<VerwaltungsbereichCustomBean> verwaltungsbereiche = new ArrayList<VerwaltungsbereichCustomBean>();
            for (VerwaltungsbereichCustomBean verwaltungsbereich : newFlurstueck.getVerwaltungsbereiche()) {
                GeomCustomBean geomBean;
                if (verwaltungsbereich.getFk_geom() == null) {
                    geomBean = null;
                } else {
                    geomBean = GeomCustomBean.createNew();
                    geomBean.setGeo_field(verwaltungsbereich.getFk_geom().getGeo_field());
                }
                VerwaltungsbereichCustomBean newVerwaltungsbereich = VerwaltungsbereichCustomBean.createNew();
                newVerwaltungsbereich.setFk_verwaltende_dienststelle(verwaltungsbereich.getFk_verwaltende_dienststelle());
                newVerwaltungsbereich.setFk_geom(geomBean);
                verwaltungsbereiche.add(newVerwaltungsbereich);
            }
            this.verwaltungsTableModel.refreshTableModel(verwaltungsbereiche);
            this.zusatzRolleTableModel.refreshTableModel(newFlurstueck.getN_zusatz_rollen());
            this.strassenfrontTableModel.refreshTableModel(newFlurstueck.getN_strassenfronten());
            if (this.isFlurstueckEditable) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<Feature> features = VerwaltungsPanel.this.verwaltungsTableModel.getAllVerwaltungsFeatures();
                        if (features != null) {
                            for (Feature currentFeature : features) {
                                if (currentFeature == null) continue;
                                if (VerwaltungsPanel.this.isWidgetReadOnly()) {
                                    ((VerwaltungsbereichCustomBean)currentFeature).setModifiable(false);
                                }
                                CustomSelectionStyledFeatureGroupWrapper tmp = new CustomSelectionStyledFeatureGroupWrapper((StyledFeature)currentFeature, VerwaltungsPanel.PROVIDER_NAME, VerwaltungsPanel.PROVIDER_NAME);
                                LagisBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)tmp);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Flurst\u00fcckswechsel: ", (Throwable)ex);
        }
        finally {
            LagisBroker.getInstance().flurstueckChangeFinished(this);
        }
    }

    private void refreshReBeIcons(Collection<RebeCustomBean> rebes) {
        try {
            Iterator<RebeCustomBean> it = rebes.iterator();
            boolean allRechteExpired = true;
            boolean oneRechtExisiting = false;
            boolean allBelastungenExpired = true;
            boolean oneBelastungExisiting = false;
            Date currentDate = new Date();
            while (it.hasNext()) {
                RebeCustomBean curReBe = it.next();
                boolean curReBeArt = curReBe.getIstRecht();
                if (curReBeArt) {
                    if (curReBe.getDatumLoeschung() == null || curReBe.getDatumLoeschung() != null && currentDate.compareTo(curReBe.getDatumLoeschung()) <= 0) {
                        allRechteExpired = false;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)this.lblRechte);
                        LOG.debug((Object)"aktuelle ReBe ist recht");
                    }
                    oneRechtExisiting = true;
                    continue;
                }
                if (curReBe.getDatumLoeschung() == null || curReBe.getDatumLoeschung() != null && currentDate.compareTo(curReBe.getDatumLoeschung()) <= 0) {
                    allBelastungenExpired = false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.lblBelastungen);
                }
                oneBelastungExisiting = true;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"aktuelle ReBe ist Belastung");
            }
            if (allBelastungenExpired) {
                this.lblBelastungen.setIcon(this.icoRebeExpired);
                this.lblBelastungen.setToolTipText("Alle Belastungen sind gel\u00f6scht");
            } else {
                this.lblBelastungen.setIcon(this.icoBelastung);
                this.lblBelastungen.setToolTipText("Es sind Belastungen vorhanden");
            }
            if (allRechteExpired) {
                this.lblRechte.setIcon(this.icoRebeExpired);
                this.lblRechte.setToolTipText("Alle Rechte sind gel\u00f6scht");
            } else {
                this.lblRechte.setIcon(this.icoRecht);
                this.lblRechte.setToolTipText("Es sind Rechte vorhanden");
            }
            if (oneBelastungExisiting) {
                this.lblBelastungen.setVisible(true);
            }
            if (oneRechtExisiting) {
                this.lblRechte.setVisible(true);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim setzen der Rebe Icons", (Throwable)ex);
            this.clearReBeIcons();
        }
    }

    private void clearReBeIcons() {
        this.lblRechte.setVisible(false);
        this.lblBelastungen.setVisible(false);
    }

    @Override
    public void setComponentEditable(boolean isEditable) {
        if (this.isFlurstueckEditable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Verwaltung --> setComponentEditable");
            }
            this.isInEditMode = isEditable;
            this.txtBemerkung.setEditable(isEditable);
            this.cbSperre.setEnabled(isEditable);
            TableCellEditor currentNutzungEditor = this.tNutzung.getCellEditor();
            if (currentNutzungEditor != null) {
                currentNutzungEditor.cancelCellEditing();
            }
            this.btnAddVerwaltung.setEnabled(isEditable);
            if (isEditable && this.tNutzung.getSelectedRow() != -1) {
                this.btnRemoveVerwaltung.setEnabled(true);
            } else if (!isEditable) {
                this.btnRemoveVerwaltung.setEnabled(false);
            }
            this.verwaltungsTableModel.setInEditMode(isEditable);
            TableCellEditor currentRolleEditor = this.tZusatzRolle.getCellEditor();
            if (currentRolleEditor != null) {
                currentRolleEditor.cancelCellEditing();
            }
            this.tZusatzRolle.setEnabled(isEditable);
            this.btnAddZusatzRolle.setEnabled(isEditable);
            if (isEditable && this.tZusatzRolle.getSelectedRow() != -1) {
                this.btnRemoveZusatzRolle.setEnabled(true);
            } else if (!isEditable) {
                this.btnRemoveZusatzRolle.setEnabled(false);
            }
            this.zusatzRolleTableModel.setInEditMode(isEditable);
            this.btnAddStrassenfront.setEnabled(isEditable);
            if (isEditable && this.tStrassenfront.getSelectedRow() != -1) {
                this.btnRemoveStrassenfront.setEnabled(true);
            } else if (!isEditable) {
                this.btnRemoveStrassenfront.setEnabled(false);
            }
            this.strassenfrontTableModel.setInEditMode(isEditable);
            this.btnUndo.setEnabled(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Verwaltung --> setComponentEditable finished");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Flurst\u00fcck ist nicht st\u00e4dtisch Verwaltungen k\u00f6nnen nicht editiert werden");
        }
    }

    @Override
    public synchronized void clearComponent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Clear Verwaltungspanel");
        }
        this.clearReBeIcons();
        this.lblLastModification.setToolTipText(null);
        this.cbSperre.setSelected(false);
        try {
            this.bemerkungDocumentModel.clear(0, this.bemerkungDocumentModel.getLength());
        }
        catch (BadLocationException ex) {
            LOG.warn((Object)"Fehler beim cleanen der Komponente", (Throwable)ex);
        }
        this.lblBemSperre.setText("");
        this.verwaltungsTableModel.refreshTableModel(new HashSet());
        this.zusatzRolleTableModel.refreshTableModel(new HashSet());
        this.strassenfrontTableModel.refreshTableModel(new HashSet());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Clear Verwaltungspanel beendet");
        }
    }

    @Override
    public Vector<GeometrySlotInformation> getSlotInformation() {
        Vector<GeometrySlotInformation> result = new Vector<GeometrySlotInformation>();
        if (this.isWidgetReadOnly()) {
            return result;
        }
        int rowCount = this.verwaltungsTableModel.getRowCount();
        if (rowCount == 1 || !this.isFlurstueckEditable) {
            return result;
        }
        for (int i = 0; i < rowCount; ++i) {
            VerwaltungsbereichCustomBean currentBereich = (VerwaltungsbereichCustomBean)this.verwaltungsTableModel.getCidsBeanAtRow(i);
            if (currentBereich == null || currentBereich.getGeometry() != null) continue;
            Object idValue1 = this.verwaltungsTableModel.getValueAt(i, 0);
            Object idValue2 = this.verwaltungsTableModel.getValueAt(i, 1);
            String identifer = idValue1 != null && idValue2 != null ? idValue1.toString() + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + idValue2.toString() : (idValue1 != null ? idValue1.toString() + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + "Kein Verwaltungsgebrauch" : (idValue2 != null ? "Kein Ressort" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + idValue2.toString() : "Kein Ressort" + GeometrySlotInformation.getSLOT_IDENTIFIER_SEPARATOR() + "Kein Verwaltungsgebrauch"));
            result.add(new GeometrySlotInformation(this.getProviderName(), identifer, currentBereich, this));
        }
        return result;
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    @Override
    public void refresh(Object refreshObject) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Verwaltungsbereich refreshed");
        }
        CidsBeanTableModel_Lagis model = (CidsBeanTableModel_Lagis)this.tNutzung.getModel();
        model.fireTableDataChanged();
        this.tNutzung.repaint();
    }

    @Override
    public void updateFlurstueckForSaving(FlurstueckCustomBean flurstueck) {
        this.verwaltungsTableModel.fillFlaechen();
        flurstueck.setVerwaltungsbereiche(this.verwaltungsTableModel.getCidsBeans());
        ArrayList<ZusatzRolleCustomBean> oldRollen = new ArrayList<ZusatzRolleCustomBean>(flurstueck.getN_zusatz_rollen());
        List<? extends CidsBean> newRollen = this.zusatzRolleTableModel.getCidsBeans();
        for (ZusatzRolleCustomBean zusatzRolleCustomBean : newRollen) {
            if (oldRollen.contains(zusatzRolleCustomBean)) continue;
            flurstueck.getN_zusatz_rollen().add(zusatzRolleCustomBean);
            oldRollen.remove(zusatzRolleCustomBean);
        }
        for (ZusatzRolleCustomBean zusatzRolleCustomBean : oldRollen) {
            if (newRollen.contains(zusatzRolleCustomBean)) continue;
            flurstueck.getN_zusatz_rollen().remove(zusatzRolleCustomBean);
        }
        ArrayList<StrassenfrontCustomBean> oldFronten = new ArrayList<StrassenfrontCustomBean>(flurstueck.getN_strassenfronten());
        List<? extends CidsBean> list = this.strassenfrontTableModel.getCidsBeans();
        for (StrassenfrontCustomBean strassenfrontCustomBean : list) {
            if (oldFronten.contains(strassenfrontCustomBean)) continue;
            flurstueck.getN_strassenfronten().add(strassenfrontCustomBean);
            oldFronten.remove(strassenfrontCustomBean);
        }
        for (StrassenfrontCustomBean strassenfrontCustomBean : oldFronten) {
            if (list.contains(strassenfrontCustomBean)) continue;
            flurstueck.getN_strassenfronten().remove(strassenfrontCustomBean);
        }
    }

    @Override
    public String getWidgetName() {
        return WIDGET_NAME;
    }

    @Override
    public synchronized void featureSelectionChanged(Collection<Feature> features) {
        ((VerwaltungsTable)((Object)this.tNutzung)).featureSelectionChanged(this, features, VerwaltungsbereichCustomBean.class);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.tNutzung.getSelectionModel())) {
            this.btnRemoveVerwaltung.setEnabled(this.tNutzung.getSelectedRow() != -1 && this.isInEditMode);
            if (this.tNutzung.getSelectedRow() != -1) {
                ((VerwaltungsTable)((Object)this.tNutzung)).valueChanged_updateFeatures(this, e);
            }
            this.setFeatureSelectionChangedEnabled(true);
        } else if (e.getSource().equals(this.tZusatzRolle.getSelectionModel())) {
            this.btnRemoveZusatzRolle.setEnabled(this.tZusatzRolle.getSelectedRow() != -1 && this.isInEditMode);
            this.setFeatureSelectionChangedEnabled(true);
        } else if (e.getSource().equals(this.tStrassenfront.getSelectionModel())) {
            this.btnRemoveStrassenfront.setEnabled(this.tStrassenfront.getSelectedRow() != -1 && this.isInEditMode);
            this.setFeatureSelectionChangedEnabled(true);
        }
    }

    public Element getConfiguration() {
        return null;
    }

    public void masterConfigure(Element parent) {
        try {
            Element htmlTooltip = parent.getChild("HTMLTooltips");
            List tooltips = htmlTooltip.getChildren();
            for (Element tmpTooltip : tooltips) {
                if (!tmpTooltip.getChild("id").getText().equals("Verwaltendedienststelle")) continue;
                Element copy = (Element)tmpTooltip.clone();
                copy.detach();
                this.vdRenderer.setHTMLTooltip(copy);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim lesen der htmlTooltips", (Throwable)ex);
        }
    }

    public void configure(Element parent) {
    }

    @Override
    public Icon getWidgetIcon() {
        return null;
    }

    @Override
    public int getStatus() {
        try {
            if (this.tNutzung.getCellEditor() != null) {
                this.validationMessage = "Bitte vollenden Sie alle \u00c4nderungen bei den Verwaltungsbereichen.";
                return 2;
            }
            for (Validator current : this.validators) {
                if (current.getValidationState() == 0) continue;
                this.validationMessage = current.getValidationMessage();
                return 2;
            }
            ArrayList allVerwaltung = (ArrayList)this.verwaltungsTableModel.getCidsBeans();
            for (VerwaltungsbereichCustomBean current : allVerwaltung) {
                if (allVerwaltung.size() == 1 && current != null && current.getGeometry() != null) {
                    this.validationMessage = "Wenn ein Verwaltungsbereich vorhanden ist, dann darf\ndiesem keine Geometrie zugeordnet sein.";
                    return 2;
                }
                if (current.getDienststelle() == null) {
                    this.validationMessage = "F\u00fcr jeden Verwaltungsbereich muss die Dienstellefestgelegt werden.";
                    return 2;
                }
                if (allVerwaltung.size() <= 1 || current != null && current.getGeometry() != null) continue;
                this.validationMessage = "Wenn mehr als zwei Verwaltungsbereiche vorhanden sind,\nm\u00fcssen allen Bereichen Geometrien zugeordnet werden.";
                return 2;
            }
            return 0;
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim validieren des Verwaltungsbereichs");
            this.validationMessage = "Es ist ein Fehler beim validieren der Verwaltungsbereiche aufgetreten.";
            return 2;
        }
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        this.fireValidationStateChanged(validatedObject);
        this.tNutzung.repaint();
    }

    public void featureCollectionChanged() {
        this.tNutzung.repaint();
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Features Removed");
        }
        this.tNutzung.repaint();
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"FeaturesChanges Verwaltung");
        }
        this.tNutzung.repaint();
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
        this.tNutzung.repaint();
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        this.tNutzung.repaint();
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
        this.tNutzung.repaint();
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        this.tNutzung.repaint();
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.btnAddVerwaltung = new JButton();
        this.btnRemoveVerwaltung = new JButton();
        this.btnUndo = new JButton();
        this.tbtnSort = new JToggleButton();
        this.btnHistorie = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tNutzung = new VerwaltungsTable();
        this.jSeparator3 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.tZusatzRolle = new ZusatzRolleTable();
        this.jPanel8 = new JPanel();
        this.jLabel3 = new JLabel();
        this.btnAddZusatzRolle = new JButton();
        this.btnRemoveZusatzRolle = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jPanel9 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.tStrassenfront = new StrassenfrontTable();
        this.jPanel10 = new JPanel();
        this.jLabel6 = new JLabel();
        this.btnAddStrassenfront = new JButton();
        this.btnRemoveStrassenfront = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.txtBemerkung = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jPanel7 = new JPanel();
        this.lblBemSperre = new JLabel();
        this.jLabel4 = new JLabel();
        this.cbSperre = new JCheckBox();
        this.lblBelastungen = new JLabel();
        this.lblWFSInfo = new JLabel();
        this.lblRechte = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel3.setMaximumSize(new Dimension(10, 10));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.btnAddVerwaltung.setAction(((VerwaltungsTable)((Object)this.tNutzung)).getAddAction());
        this.btnAddVerwaltung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddVerwaltung.setBorder(null);
        this.btnAddVerwaltung.setBorderPainted(false);
        this.btnAddVerwaltung.setMaximumSize(new Dimension(25, 25));
        this.btnAddVerwaltung.setMinimumSize(new Dimension(25, 25));
        this.btnAddVerwaltung.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.btnAddVerwaltung, gridBagConstraints);
        this.btnRemoveVerwaltung.setAction(((VerwaltungsTable)((Object)this.tNutzung)).getRemoveAction());
        this.btnRemoveVerwaltung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveVerwaltung.setBorder(null);
        this.btnRemoveVerwaltung.setBorderPainted(false);
        this.btnRemoveVerwaltung.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveVerwaltung.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveVerwaltung.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel2.add((Component)this.btnRemoveVerwaltung, gridBagConstraints);
        this.btnUndo.setAction(((VerwaltungsTable)((Object)this.tNutzung)).getUndoAction());
        this.btnUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/undo.png")));
        this.btnUndo.setToolTipText("R\u00fcckg\u00e4ngig machen");
        this.btnUndo.setBorderPainted(false);
        this.btnUndo.setMaximumSize(new Dimension(25, 25));
        this.btnUndo.setMinimumSize(new Dimension(25, 25));
        this.btnUndo.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.btnUndo, gridBagConstraints);
        this.tbtnSort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort.png")));
        this.tbtnSort.setToolTipText("Sortierung An / Aus");
        this.tbtnSort.setBorderPainted(false);
        this.tbtnSort.setContentAreaFilled(false);
        this.tbtnSort.setMaximumSize(new Dimension(25, 25));
        this.tbtnSort.setMinimumSize(new Dimension(25, 25));
        this.tbtnSort.setPreferredSize(new Dimension(25, 25));
        this.tbtnSort.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/sort_selected.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.tbtnSort, gridBagConstraints);
        this.tbtnSort.addItemListener(((VerwaltungsTable)((Object)this.tNutzung)).getSortItemListener());
        this.btnHistorie.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/history.png")));
        this.btnHistorie.setToolTipText("Historie der Verwaltungsbereiche");
        this.btnHistorie.setBorderPainted(false);
        this.btnHistorie.setContentAreaFilled(false);
        this.btnHistorie.setMaximumSize(new Dimension(25, 25));
        this.btnHistorie.setMinimumSize(new Dimension(25, 25));
        this.btnHistorie.setPreferredSize(new Dimension(25, 25));
        this.btnHistorie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerwaltungsPanel.this.btnHistorieActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel2.add((Component)this.btnHistorie, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel5.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tNutzung.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tNutzung.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3"}));
        this.jScrollPane1.setViewportView(this.tNutzung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.jPanel4.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setText("zus\u00e4tzliche Rollen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane3.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tZusatzRolle.setAutoCreateRowSorter(true);
        this.tZusatzRolle.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tZusatzRolle.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2"}));
        this.jScrollPane3.setViewportView(this.tZusatzRolle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel8.add((Component)this.jLabel3, gridBagConstraints);
        this.btnAddZusatzRolle.setAction(((ZusatzRolleTable)((Object)this.tZusatzRolle)).getAddAction());
        this.btnAddZusatzRolle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddZusatzRolle.setBorder(null);
        this.btnAddZusatzRolle.setBorderPainted(false);
        this.btnAddZusatzRolle.setMaximumSize(new Dimension(25, 25));
        this.btnAddZusatzRolle.setMinimumSize(new Dimension(25, 25));
        this.btnAddZusatzRolle.setPreferredSize(new Dimension(25, 25));
        this.btnAddZusatzRolle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerwaltungsPanel.this.btnAddZusatzRolleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel8.add((Component)this.btnAddZusatzRolle, gridBagConstraints);
        this.btnRemoveZusatzRolle.setAction(((ZusatzRolleTable)((Object)this.tZusatzRolle)).getRemoveAction());
        this.btnRemoveZusatzRolle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveZusatzRolle.setBorder(null);
        this.btnRemoveZusatzRolle.setBorderPainted(false);
        this.btnRemoveZusatzRolle.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveZusatzRolle.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveZusatzRolle.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel8.add((Component)this.btnRemoveZusatzRolle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.jPanel4.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.jLabel5.setText("Stra\u00dfenfronten:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel9.add((Component)this.jLabel5, gridBagConstraints);
        this.jScrollPane4.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tStrassenfront.setAutoCreateRowSorter(true);
        this.tStrassenfront.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.tStrassenfront.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2"}));
        this.jScrollPane4.setViewportView(this.tStrassenfront);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel9.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel10.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.jLabel6, gridBagConstraints);
        this.btnAddStrassenfront.setAction(((StrassenfrontTable)((Object)this.tStrassenfront)).getAddAction());
        this.btnAddStrassenfront.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/add.png")));
        this.btnAddStrassenfront.setBorder(null);
        this.btnAddStrassenfront.setBorderPainted(false);
        this.btnAddStrassenfront.setMaximumSize(new Dimension(25, 25));
        this.btnAddStrassenfront.setMinimumSize(new Dimension(25, 25));
        this.btnAddStrassenfront.setPreferredSize(new Dimension(25, 25));
        this.btnAddStrassenfront.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerwaltungsPanel.this.btnAddStrassenfrontActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel10.add((Component)this.btnAddStrassenfront, gridBagConstraints);
        this.btnRemoveStrassenfront.setAction(((StrassenfrontTable)((Object)this.tStrassenfront)).getRemoveAction());
        this.btnRemoveStrassenfront.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/buttons/remove.png")));
        this.btnRemoveStrassenfront.setBorder(null);
        this.btnRemoveStrassenfront.setBorderPainted(false);
        this.btnRemoveStrassenfront.setMaximumSize(new Dimension(25, 25));
        this.btnRemoveStrassenfront.setMinimumSize(new Dimension(25, 25));
        this.btnRemoveStrassenfront.setPreferredSize(new Dimension(25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jPanel10.add((Component)this.btnRemoveStrassenfront, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel9.add((Component)this.jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.jPanel4.add((Component)this.jSeparator4, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.txtBemerkung.setColumns(20);
        this.txtBemerkung.setLineWrap(true);
        this.txtBemerkung.setRows(1);
        this.jScrollPane2.setViewportView(this.txtBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel1.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel7.add((Component)this.lblBemSperre, gridBagConstraints);
        this.jLabel4.setText("Sperre:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel7.add((Component)this.jLabel4, gridBagConstraints);
        this.cbSperre.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSperre.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VerwaltungsPanel.this.cbSperreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel7.add((Component)this.cbSperre, gridBagConstraints);
        this.lblBelastungen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/belastung.png")));
        this.lblBelastungen.setToolTipText("Es sind Belastungen vorhanden");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel7.add((Component)this.lblBelastungen, gridBagConstraints);
        this.lblWFSInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/wfs_green.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel7.add((Component)this.lblWFSInfo, gridBagConstraints);
        this.lblRechte.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/FlurstueckPanel/recht.png")));
        this.lblRechte.setToolTipText("Es sind Rechte vorhanden");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel7.add((Component)this.lblRechte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private void cbSperreActionPerformed(ActionEvent evt) {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        if (currentFlurstueck != null) {
            boolean isGesperrt = this.cbSperre.isSelected();
            if (isGesperrt) {
                String answer = null;
                while (answer == null || answer.trim().length() == 0) {
                    answer = JOptionPane.showInputDialog(this, (Object)"Bitte eine Bemerkung zur Sperre angeben.");
                    if (answer != null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Sperre setzen abgebrochen");
                    }
                    this.cbSperre.setSelected(false);
                    return;
                }
                currentFlurstueck.getFlurstueckSchluessel().setIstGesperrt(isGesperrt);
                currentFlurstueck.getFlurstueckSchluessel().setBemerkungSperre(answer);
                this.lblBemSperre.setText(answer);
            } else {
                this.lblBemSperre.setText("");
                currentFlurstueck.getFlurstueckSchluessel().setIstGesperrt(isGesperrt);
                currentFlurstueck.getFlurstueckSchluessel().setBemerkungSperre("");
            }
            currentFlurstueck.getFlurstueckSchluessel().setIstGesperrt(isGesperrt);
        } else {
            LOG.error((Object)"Kann Sperre nicht setzen Flurstueck ist null");
        }
    }

    private void btnHistorieActionPerformed(ActionEvent evt) {
        VerwaltungsbereicheHistorieDialog verwaltungsHistorieDialog = new VerwaltungsbereicheHistorieDialog(LagisBroker.getInstance().getCurrentFlurstueck());
        verwaltungsHistorieDialog.pack();
        StaticSwingTools.showDialog((JDialog)verwaltungsHistorieDialog);
    }

    private void btnAddZusatzRolleActionPerformed(ActionEvent evt) {
    }

    private void btnAddStrassenfrontActionPerformed(ActionEvent evt) {
    }

    private void cboVDActionPerformed() {
        TableCellEditor currentEditor;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"cboVerwaltungActionPerformed");
        }
        if ((currentEditor = this.tNutzung.getCellEditor()) != null) {
            currentEditor.stopCellEditing();
        }
        for (Feature feature : LagisBroker.getInstance().getMappingComponent().getFeatureCollection().getSelectedFeatures()) {
            LagisBroker.getInstance().getMappingComponent().getFeatureCollection().reconsiderFeature(feature);
        }
    }

    private void cboZRDActionPerformed() {
        TableCellEditor currentEditor = this.tZusatzRolle.getCellEditor();
        if (currentEditor != null) {
            currentEditor.stopCellEditing();
        }
    }

    private void cboZRAActionPerformed() {
        TableCellEditor currentEditor = this.tZusatzRolle.getCellEditor();
        if (currentEditor != null) {
            currentEditor.stopCellEditing();
        }
    }

    @Override
    public String getDisplayName(BasicEntity entity) {
        if (entity instanceof VerwaltungsbereichCustomBean) {
            VerwaltungsbereichCustomBean vb = (VerwaltungsbereichCustomBean)entity;
            return "Verwaltende Dienststelle - " + vb.getDienststelle().toString() + " - " + vb.getFlaeche() + "m\u00b2";
        }
        return "unbekannt";
    }

    @Override
    public Icon getDisplayIcon() {
        return this.copyDisplayIcon;
    }

    @Override
    public boolean knowsDisplayName(BasicEntity entity) {
        return entity instanceof VerwaltungsbereichCustomBean;
    }

    @Override
    public boolean isFeatureSelectionChangedEnabled() {
        return this.listenerEnabled;
    }

    @Override
    public void setFeatureSelectionChangedEnabled(boolean listenerEnabled) {
        this.listenerEnabled = listenerEnabled;
    }
}

