/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.tables;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.StyledFeatureGroupWrapper;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.interfaces.FeatureSelectionChangedListener;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public abstract class AbstractCidsBeanTable_Lagis
extends JXTable
implements ListSelectionListener {
    private static final Logger LOG = Logger.getLogger(AbstractCidsBeanTable_Lagis.class);
    private int previously_sorted_column_index = 0;
    private SortOrder previously_used_sort_order = SortOrder.ASCENDING;
    private JToggleButton tbtnSort;
    private JButton btnUndo;
    private AbstractAction addAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractCidsBeanTable_Lagis.this.btnAddActionPerformed(e);
        }
    };

    public AbstractCidsBeanTable_Lagis() {
        this.getSelectionModel().addListSelectionListener(this);
    }

    public Action getAddAction() {
        return this.addAction;
    }

    public Action getRemoveAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCidsBeanTable_Lagis.this.btnRemoveActionPerformed(e);
            }
        };
    }

    public Action getUndoAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCidsBeanTable_Lagis.this.btnUndoActionPerformed(e);
            }
        };
    }

    public ItemListener getSortItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AbstractCidsBeanTable_Lagis.this.tbtnSortItemStateChanged(evt);
            }
        };
    }

    protected void btnAddActionPerformed(ActionEvent evt) {
        if (this.tbtnSort != null) {
            this.tbtnSort.setSelected(true);
        }
        this.setSortable(false);
        this.addNewItem();
    }

    protected void fireItemAdded() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.selectAndScrollToLastRow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractCidsBeanTable_Lagis.this.selectAndScrollToLastRow();
                }
            });
        }
        this.execAfterItemAdded();
    }

    private void selectAndScrollToLastRow() {
        AbstractCidsBeanTable_Lagis table = this;
        table.setRowSelectionInterval(table.getRowCount() - 1, table.getRowCount() - 1);
        table.scrollRectToVisible(table.getCellRect(table.getRowCount() - 1, 0, true));
    }

    protected abstract void addNewItem();

    protected void execAfterItemAdded() {
    }

    protected void btnRemoveActionPerformed(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            int modelRow = this.convertRowIndexToModel(selectedRow);
            this.removeItem(modelRow);
        }
        this.execAfterItemRemoved();
    }

    protected abstract void removeItem(int var1);

    protected void execAfterItemRemoved() {
    }

    protected void tbtnSortItemStateChanged(ItemEvent evt) {
        if (this.tbtnSort.isSelected()) {
            this.previously_sorted_column_index = this.getSortedColumn() != null ? this.getSortedColumn().getModelIndex() : 0;
            this.previously_used_sort_order = this.getSortOrder(this.previously_sorted_column_index);
            this.setSortable(false);
        } else {
            this.setSortable(true);
            this.setSortOrder(this.previously_sorted_column_index, this.previously_used_sort_order);
        }
        this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), 0, true));
    }

    public void setSortButton(JToggleButton sortButton) {
        this.tbtnSort = sortButton;
    }

    public JToggleButton getSortButton() {
        return this.tbtnSort;
    }

    private void btnUndoActionPerformed(ActionEvent e) {
        ((CidsBeanTableModel_Lagis)this.getModel()).restoreSelectedCidsBean();
    }

    public JButton getUndoButton() {
        return this.btnUndo;
    }

    public void setUndoButton(JButton btnUndo) {
        this.btnUndo = btnUndo;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this.btnUndo != null) {
            if (!((CidsBeanTableModel_Lagis)this.getModel()).isInEditMode() || this.getSelectedRow() == -1) {
                this.btnUndo.setEnabled(false);
            } else {
                this.btnUndo.setEnabled(true);
            }
        }
    }

    public void valueChanged_updateFeatures(FeatureSelectionChangedListener panel, ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        panel.setFeatureSelectionChangedEnabled(false);
        int[] selectedRows = this.getSelectedRows();
        MappingComponent mappingComp = LagisBroker.getInstance().getMappingComponent();
        boolean firstIteration = true;
        for (int row : this.getSelectedRows()) {
            int index = this.convertRowIndexToModel(row);
            if (index == -1) continue;
            StyledFeature selectedCidsBean = (StyledFeature)((CidsBeanTableModel_Lagis)this.getModel()).getCidsBeanAtRow(index);
            if (selectedCidsBean.getGeometry() != null) {
                if (firstIteration) {
                    mappingComp.getFeatureCollection().select((Feature)selectedCidsBean);
                    firstIteration = false;
                    continue;
                }
                mappingComp.getFeatureCollection().addToSelection((Feature)selectedCidsBean);
                continue;
            }
            if (selectedRows.length != 1) continue;
            mappingComp.getFeatureCollection().unselectAll();
        }
        panel.setFeatureSelectionChangedEnabled(true);
    }

    public void featureSelectionChanged(ListSelectionListener panel, Collection<Feature> features, Class<? extends CidsBean> cidsbeanClass) {
        if (features.isEmpty()) {
            return;
        }
        this.getSelectionModel().removeListSelectionListener(panel);
        for (Feature feature : features) {
            Feature wrappedFeature = feature instanceof StyledFeatureGroupWrapper ? ((StyledFeatureGroupWrapper)feature).getFeature() : feature;
            if (!cidsbeanClass.isInstance(wrappedFeature)) continue;
            int index = ((CidsBeanTableModel_Lagis)this.getModel()).getIndexOfCidsBean((CidsBean)wrappedFeature);
            if (index != -1 && LagisBroker.getInstance().getMappingComponent().getFeatureCollection().isSelected(feature)) {
                int displayedIndex = this.convertRowIndexToView(index);
                this.getSelectionModel().addSelectionInterval(displayedIndex, displayedIndex);
                Rectangle tmp = this.getCellRect(displayedIndex, 0, true);
                if (tmp == null) continue;
                this.scrollRectToVisible(tmp);
                continue;
            }
            this.getSelectionModel().clearSelection();
        }
        this.getSelectionModel().addListSelectionListener(panel);
    }
}

