/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.tables;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class CidsBeanSupport {
    private static final Logger LOG = Logger.getLogger(CidsBeanSupport.class);

    public static CidsBean deepcloneCidsBean(CidsBean cidsBean) throws Exception {
        if (cidsBean == null) {
            return null;
        }
        CidsBean cloneBean = cidsBean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        CidsBeanSupport.deepcopyAllProperties(cidsBean, cloneBean);
        return cloneBean;
    }

    public static void deepcopyAllProperties(CidsBean sourceBean, CidsBean targetBean) throws Exception {
        if (sourceBean == null || targetBean == null) {
            return;
        }
        for (String propName : sourceBean.getPropertyNames()) {
            Object o = sourceBean.getProperty(propName);
            if (propName.toLowerCase().equals("id")) {
                int id = (Integer)sourceBean.getProperty("id");
                targetBean.setProperty("id", (Object)id);
                targetBean.getMetaObject().setID(id);
                continue;
            }
            if (o instanceof CidsBean) {
                targetBean.setProperty(propName, (Object)CidsBeanSupport.deepcloneCidsBean((CidsBean)o));
                continue;
            }
            if (o instanceof Collection) {
                List list = (List)o;
                ArrayList<CidsBean> newList = new ArrayList<CidsBean>();
                for (CidsBean tmpBean : list) {
                    newList.add(CidsBeanSupport.deepcloneCidsBean(tmpBean));
                }
                targetBean.setProperty(propName, newList);
                continue;
            }
            if (o instanceof Geometry) {
                targetBean.setProperty(propName, ((Geometry)o).clone());
                continue;
            }
            if (o instanceof Float) {
                targetBean.setProperty(propName, (Object)new Float(o.toString()));
                continue;
            }
            if (o instanceof Boolean) {
                targetBean.setProperty(propName, (Object)new Boolean(o.toString()));
                continue;
            }
            if (o instanceof Long) {
                targetBean.setProperty(propName, (Object)new Long(o.toString()));
                continue;
            }
            if (o instanceof Double) {
                targetBean.setProperty(propName, (Object)new Double(o.toString()));
                continue;
            }
            if (o instanceof Integer) {
                targetBean.setProperty(propName, (Object)new Integer(o.toString()));
                continue;
            }
            if (o instanceof Date) {
                targetBean.setProperty(propName, ((Date)o).clone());
                continue;
            }
            if (o instanceof String) {
                targetBean.setProperty(propName, o);
                continue;
            }
            if (o instanceof Timestamp) {
                targetBean.setProperty(propName, (Object)new Timestamp(((Timestamp)o).getTime()));
                continue;
            }
            if (o != null) {
                LOG.error((Object)("unknown property type: " + o.getClass().getName()));
            }
            targetBean.setProperty(propName, o);
        }
    }

    public static void copyAllProperties(CidsBean sourceBean, CidsBean targetBean) throws Exception {
        if (sourceBean == null || targetBean == null) {
            return;
        }
        for (String propName : sourceBean.getPropertyNames()) {
            Object o = sourceBean.getProperty(propName);
            targetBean.setProperty(propName, o);
        }
    }
}

