/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.gui.tables;

import de.cismet.cids.custom.beans.lagis.VerwaltendeDienststelleCustomBean;
import de.cismet.cids.custom.beans.lagis.ZusatzRolleArtCustomBean;
import de.cismet.cids.custom.beans.lagis.ZusatzRolleCustomBean;
import de.cismet.lagis.gui.tables.AbstractCidsBeanTable_Lagis;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import java.util.Set;
import org.apache.log4j.Logger;

public class ZusatzRolleTable
extends AbstractCidsBeanTable_Lagis {
    private static final Logger LOG = Logger.getLogger(ZusatzRolleTable.class);
    private static final String[] COLUMN_NAMES = new String[]{"Dienststelle", "Rolle"};
    private static final Class[] COLUMN_CLASSES = new Class[]{VerwaltendeDienststelleCustomBean.class, ZusatzRolleArtCustomBean.class};

    @Override
    protected void addNewItem() {
        try {
            ZusatzRolleCustomBean zusatzRolle = ZusatzRolleCustomBean.createNew();
            ((Model)this.getModel()).addCidsBean(zusatzRolle);
            this.fireItemAdded();
        }
        catch (Exception ex) {
            LOG.error((Object)"error creating bean for zusatzrolle", (Throwable)ex);
        }
    }

    @Override
    protected void removeItem(int modelRow) {
        ((Model)this.getModel()).removeCidsBean(modelRow);
    }

    public static class Model
    extends CidsBeanTableModel_Lagis {
        public Model() {
            super(COLUMN_NAMES, COLUMN_CLASSES, ZusatzRolleCustomBean.class);
        }

        public Model(Set<ZusatzRolleCustomBean> zusatzRollen) {
            super(COLUMN_NAMES, COLUMN_CLASSES, zusatzRollen);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ausgew\u00e4hlte zeile/spalte" + rowIndex + "/" + columnIndex));
                }
                ZusatzRolleCustomBean vZusatzRolle = (ZusatzRolleCustomBean)this.getCidsBeanAtRow(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return vZusatzRolle.getFk_dienststelle();
                    }
                    case 1: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("aktueller Gebrauch: " + vZusatzRolle.getFk_art()));
                        }
                        return vZusatzRolle.getFk_art();
                    }
                }
                return "Spalte ist nicht definiert";
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
                return null;
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            try {
                ZusatzRolleCustomBean vZusatzRolle = (ZusatzRolleCustomBean)this.getCidsBeanAtRow(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        vZusatzRolle.setFk_dienststelle((VerwaltendeDienststelleCustomBean)aValue);
                        break;
                    }
                    case 1: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Setze Wert: " + aValue));
                        }
                        vZusatzRolle.setFk_art((ZusatzRolleArtCustomBean)aValue);
                        break;
                    }
                    default: {
                        LOG.warn((Object)("Keine Spalte f\u00fcr angegebenen Index vorhanden: " + columnIndex));
                        return;
                    }
                }
                this.fireTableDataChangedAndKeepSelection();
            }
            catch (Exception ex) {
                LOG.error((Object)("Fehler beim setzen von Daten in dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            }
        }
    }
}

