/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public abstract class AbstractCidsBeanTableModel
extends AbstractTableModel {
    private static final transient Logger LOG = Logger.getLogger(AbstractCidsBeanTableModel.class);
    private List<CidsBean> cidsBeans;
    private final String[] columnNames;
    private final Class[] columnClasses;
    private final List<CidsBean> removedCidsBeans = new ArrayList<CidsBean>();

    protected AbstractCidsBeanTableModel(String[] columnNames, Class[] columnClasses) {
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.isInColumnBounds(column) ? this.columnNames[column] : null;
    }

    public Class getColumnClass(int column) {
        return this.isInColumnBounds(column) ? this.columnClasses[column] : null;
    }

    public List<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public void setCidsBeans(List<CidsBean> cidsBeans) {
        this.removedCidsBeans.clear();
        this.cidsBeans = cidsBeans;
        this.fireTableDataChanged();
    }

    public CidsBean getCidsBeanAtRow(int row) {
        return this.isInRowBounds(row) ? this.cidsBeans.get(row) : null;
    }

    @Override
    public int getRowCount() {
        if (this.cidsBeans == null) {
            return 0;
        }
        return this.cidsBeans.size();
    }

    public Collection<CidsBean> getCidsBeansByIndices(int[] modelIndices) {
        ArrayList<CidsBean> cidsBeans = new ArrayList<CidsBean>();
        for (int i = 0; i < modelIndices.length; ++i) {
            cidsBeans.add(this.getCidsBeanByIndex(modelIndices[i]));
        }
        return cidsBeans;
    }

    public CidsBean getCidsBeanByIndex(int modelIndex) {
        if (this.cidsBeans == null) {
            return null;
        }
        try {
            return this.cidsBeans.get(modelIndex);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("CidsBean at index " + modelIndex + " not found. will return null"), (Throwable)e);
            }
            return null;
        }
    }

    public int getIndexByCidsBean(CidsBean cidsBean) {
        if (this.cidsBeans == null) {
            return -1;
        }
        try {
            return this.cidsBeans.indexOf(cidsBean);
        }
        catch (Exception e) {
            LOG.error((Object)"error in getIndexByCidsBean(). will return -1", (Throwable)e);
            return -1;
        }
    }

    public boolean isInRowBounds(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.getRowCount();
    }

    public boolean isInColumnBounds(int columnIndex) {
        return columnIndex >= 0 && columnIndex < this.getColumnCount();
    }

    public void addCidsBean(CidsBean cidsBean) {
        if (this.cidsBeans != null) {
            this.cidsBeans.add(cidsBean);
            this.fireTableDataChanged();
        }
    }

    public void removeCidsBean(CidsBean cidsBean) {
        try {
            this.cidsBeans.remove(cidsBean);
            this.removedCidsBeans.add(cidsBean);
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            LOG.error((Object)"error while deleting bean", (Throwable)ex);
        }
    }

    public List<CidsBean> getRemovedCidsBeans() {
        return new ArrayList<CidsBean>(this.removedCidsBeans);
    }
}

