/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.tables.AbstractCidsBeanTable_Lagis;
import de.cismet.lagis.gui.tables.CidsBeanSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public abstract class CidsBeanTableModel_Lagis
extends AbstractTableModel {
    private static final Logger LOG = Logger.getLogger(CidsBeanTableModel_Lagis.class);
    private List<? extends CidsBean> cidsBeans;
    private final Map<Integer, CidsBean> beanBackups = new HashMap<Integer, CidsBean>();
    private final String[] columnNames;
    private final Class[] columnClasses;
    private boolean inEditMode = false;
    private AbstractCidsBeanTable_Lagis table;
    private final HashMap<CidsBean, CidsFeature> featureMap = new HashMap();

    protected <T extends CidsBean> CidsBeanTableModel_Lagis(String[] columnNames, Class[] columnClasses, Class<T> cidsBeanClass) {
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        this.cidsBeans = new ArrayList<CidsBean>();
    }

    protected <T extends CidsBean> CidsBeanTableModel_Lagis(String[] columnNames, Class[] columnClasses, Collection<T> cidsBeans) {
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
        try {
            this.cidsBeans = new ArrayList<T>(cidsBeans);
            for (CidsBean bean : cidsBeans) {
                this.backupBean(bean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim anlegen des Models", (Throwable)ex);
            this.cidsBeans = new ArrayList<CidsBean>();
        }
    }

    @Override
    public int getRowCount() {
        return this.cidsBeans.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public Class getColumnClass(int column) {
        return this.columnClasses[column];
    }

    public <C extends CidsBean> void addCidsBean(C cidsbean) {
        this.cidsBeans.add(cidsbean);
        this.backupBean(cidsbean);
        this.fireTableDataChangedAndKeepSelection();
    }

    public void removeCidsBean(int rowIndex) {
        this.unbackupBean(this.cidsBeans.get(rowIndex));
        this.cidsBeans.remove(rowIndex);
        this.fireTableDataChanged();
    }

    public <C extends CidsBean> C getCidsBeanAtRow(int rowIndex) {
        return (C)this.cidsBeans.get(rowIndex);
    }

    public <C extends CidsBean> int getIndexOfCidsBean(C cidsBean) {
        return this.cidsBeans.indexOf(cidsBean);
    }

    public void clearCidsBeans() {
        this.cidsBeans.clear();
        this.clearBackups();
    }

    public <C extends CidsBean> void addAllCidsBeans(Collection<C> newCidsBeans) {
        this.cidsBeans.addAll(newCidsBeans);
        for (CidsBean bean : newCidsBeans) {
            this.backupBean(bean);
        }
    }

    public List<? extends CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public <T extends CidsBean> void setCidsBeans(List<T> cidsBeans) {
        this.clearBackups();
        this.cidsBeans = cidsBeans;
        for (CidsBean bean : cidsBeans) {
            this.backupBean(bean);
        }
        this.fireTableDataChanged();
    }

    public boolean isInEditMode() {
        return this.inEditMode;
    }

    public void setInEditMode(boolean isInEditMode) {
        this.inEditMode = isInEditMode;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnNames.length > columnIndex && this.cidsBeans.size() > rowIndex && this.inEditMode;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setTable(AbstractCidsBeanTable_Lagis table) {
        this.table = table;
    }

    public <T extends CidsBean> void refreshTableModel(Collection<T> cidsbeans) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Refresh des BeschlussTableModell");
            }
            if (cidsbeans != null) {
                this.setCidsBeans(new ArrayList<T>(cidsbeans));
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Beschl\u00fcssevektor == null --> Erstelle Vektor.");
                }
                this.setCidsBeans(new ArrayList());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim refreshen des Models", (Throwable)ex);
            this.setCidsBeans(new ArrayList());
        }
        this.fireTableDataChanged();
    }

    public void fireTableDataChangedAndKeepSelection() {
        int selection_index_view = this.table.getSelectedRow();
        int selection_model_tmp = -1;
        if (selection_index_view > -1) {
            selection_model_tmp = this.table.convertRowIndexToModel(selection_index_view);
        }
        final int selection_index_model = selection_model_tmp;
        this.fireTableDataChanged();
        if (SwingUtilities.isEventDispatchThread()) {
            this.resetSelection(selection_index_model);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CidsBeanTableModel_Lagis.this.resetSelection(selection_index_model);
                }
            });
        }
    }

    private void resetSelection(int selection_index_model) {
        if (selection_index_model == -1 || selection_index_model >= this.getRowCount()) {
            this.table.clearSelection();
        } else {
            int selection_index_view = this.table.convertRowIndexToView(selection_index_model);
            this.table.setRowSelectionInterval(selection_index_view, selection_index_view);
            this.table.scrollRectToVisible(this.table.getCellRect(selection_index_view, 0, true));
        }
    }

    public void clearBackups() {
        this.beanBackups.clear();
    }

    public final void backupBean(CidsBean cidsBean) {
        try {
            int id = (Integer)cidsBean.getProperty("id");
            CidsBean backupBean = CidsBeanSupport.deepcloneCidsBean(cidsBean);
            this.beanBackups.put(id, backupBean);
        }
        catch (Exception ex) {
            LOG.error((Object)"error while making backup of bean", (Throwable)ex);
        }
    }

    public void unbackupBean(CidsBean cidsBean) {
        this.beanBackups.remove((Integer)cidsBean.getProperty("id"));
    }

    public void restoreSelectedCidsBean() {
        Object cidsBean = this.getCidsBeanAtRow(this.table.convertRowIndexToModel(this.table.getSelectedRow()));
        this.restoreBean((CidsBean)cidsBean);
        this.fireTableDataChanged();
    }

    public void restoreBean(CidsBean cidsBean) {
        try {
            CidsBean backupBean = this.beanBackups.get((Integer)cidsBean.getProperty("id"));
            CidsBeanSupport.deepcopyAllProperties(backupBean, cidsBean);
            if (cidsBean instanceof Feature && ((Feature)cidsBean).getGeometry() != null) {
                LagisBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)cidsBean);
                LagisBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)cidsBean);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while making backup of bean", (Throwable)ex);
        }
    }

    public CidsFeature createCidsFeature(CidsBean cidsBean) {
        if (cidsBean == null) {
            return null;
        }
        CidsFeature cidsFeature = new CidsFeature(cidsBean.getMetaObject());
        cidsFeature.setEditable(this.isInEditMode());
        this.featureMap.put(cidsBean, cidsFeature);
        return cidsFeature;
    }
}

