/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import java.util.Collection;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class FlurstueckeTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_HEADER = new String[]{"Art", "Flurst\u00fcck"};
    private final Logger log = Logger.getLogger(this.getClass());
    private Vector<FlurstueckSchluesselCustomBean> flurstueckSchluessel;
    private boolean isInEditMode = false;
    private final Icon icoStaedtisch = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/current.png"));
    private final Icon icoStaedtischHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic.png"));
    private final Icon icoAbteilungIX = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/abteilungIX.png"));
    private final Icon icoAbteilungIXHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic_abteilungIX.png"));
    private final Icon icoUnknownFlurstueck = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/unkownFlurstueck.png"));

    public FlurstueckeTableModel() {
        this.flurstueckSchluessel = new Vector();
    }

    public FlurstueckeTableModel(Collection<FlurstueckSchluesselCustomBean> flurstueckSchluessel) {
        try {
            this.flurstueckSchluessel = new Vector<FlurstueckSchluesselCustomBean>(flurstueckSchluessel);
        }
        catch (Exception ex) {
            this.log.error((Object)"Fehler beim anlegen des Models", (Throwable)ex);
            this.flurstueckSchluessel = new Vector();
        }
    }

    public void refreshTableModel(Collection<FlurstueckSchluesselCustomBean> flurstueckSchluessel) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Refresh des FlurstueckTableModell");
            }
            this.flurstueckSchluessel = new Vector<FlurstueckSchluesselCustomBean>(flurstueckSchluessel);
        }
        catch (Exception ex) {
            this.log.error((Object)"Fehler beim refreshen des Models", (Throwable)ex);
            this.flurstueckSchluessel = new Vector();
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            FlurstueckSchluesselCustomBean schluessel = this.flurstueckSchluessel.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    FlurstueckArtCustomBean art = schluessel.getFlurstueckArt();
                    if (art != null && art.getBezeichnung() != null && art.getBezeichnung().equals("st\u00e4dtisch")) {
                        if (schluessel.getGueltigBis() != null) {
                            return this.icoStaedtischHistoric;
                        }
                        return this.icoStaedtisch;
                    }
                    if (art != null && art.getBezeichnung() != null && art.getBezeichnung().equals("Abteilung IX")) {
                        if (schluessel.getGueltigBis() != null) {
                            return this.icoAbteilungIXHistoric;
                        }
                        return this.icoAbteilungIX;
                    }
                    return this.icoUnknownFlurstueck;
                }
                case 1: {
                    return schluessel;
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            this.log.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public int getRowCount() {
        return this.flurstueckSchluessel.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADER.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_HEADER[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Icon.class;
            }
            case 1: {
                return FlurstueckSchluesselCustomBean.class;
            }
        }
        this.log.warn((Object)"Die gew\u00fcnschte Spalte exitiert nicht, es kann keine Klasse zur\u00fcck geliefert werden");
        return null;
    }

    public Vector<FlurstueckSchluesselCustomBean> getFlurstueckSchluessel() {
        return this.flurstueckSchluessel;
    }

    public void addFlurstueckSchluessel(FlurstueckSchluesselCustomBean schluessel) {
        this.flurstueckSchluessel.add(schluessel);
        this.fireTableDataChanged();
    }

    public FlurstueckSchluesselCustomBean getFlurstueckSchluesselAtRow(int rowIndex) {
        return this.flurstueckSchluessel.get(rowIndex);
    }

    public void removeFlurstueckSchluessel(int rowIndex) {
        this.flurstueckSchluessel.remove(rowIndex);
        this.fireTableDataChanged();
    }

    public void removeAllFlurstueckSchluessel() {
        this.flurstueckSchluessel.clear();
        this.fireTableDataChanged();
    }

    public int getFlurstueckSchluesselCount() {
        return this.flurstueckSchluessel.size();
    }
}

