/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.custom.beans.lagis.KostenCustomBean;
import de.cismet.cids.custom.beans.lagis.KostenartCustomBean;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class KostenTableModel
extends CidsBeanTableModel_Lagis {
    private static final String[] COLUMN_NAMES = new String[]{"Kostenart", "Betrag", "Anweisung"};
    private static final Class[] COLUMN_CLASSES = new Class[]{KostenartCustomBean.class, Double.class, Date.class};
    private static final Logger LOG = Logger.getLogger(KostenTableModel.class);

    public KostenTableModel() {
        super(COLUMN_NAMES, COLUMN_CLASSES, KostenCustomBean.class);
    }

    public KostenTableModel(Collection<KostenCustomBean> kosten) {
        super(COLUMN_NAMES, COLUMN_CLASSES, kosten);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            KostenCustomBean value = (KostenCustomBean)this.getCidsBeans().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return value.getKostenart();
                }
                case 1: {
                    return value.getBetrag();
                }
                case 2: {
                    return value.getDatum();
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            KostenCustomBean value = (KostenCustomBean)this.getCidsBeans().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value.setKostenart((KostenartCustomBean)aValue);
                    break;
                }
                case 1: {
                    value.setBetrag((Double)aValue);
                }
                case 2: {
                    value.setDatum((Date)aValue);
                }
                default: {
                    LOG.warn((Object)("Keine Spalte f\u00fcr angegebenen Index vorhanden: " + columnIndex));
                    return;
                }
            }
            this.fireTableDataChangedAndKeepSelection();
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim setzem der Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
        }
    }
}

