/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.custom.beans.lagis.MipaCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaNutzungCustomBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import de.cismet.lagis.models.documents.SimpleDocumentModel;
import de.cismet.lagisEE.entity.extension.vermietung.MiPa;
import de.cismet.lagisEE.entity.extension.vermietung.MiPaKategorie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class MiPaModel
extends CidsBeanTableModel_Lagis {
    private static final String[] COLUMN_HEADER = new String[]{"Lage", "Aktenzeichen", "Fl\u00e4che m\u00b2", "Nutzung", "Nutzer", "Vertragsbeginn", "Vertragsende"};
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class, Integer.class, MiPaKategorie.class, String.class, Date.class, Date.class};
    public static final int LAGE_COLUMN = 0;
    public static final int AKTENZEICHEN_COLUMN = 1;
    public static final int FLAECHE_COLUMN = 2;
    public static final int NUTZUNG_COLUMN = 3;
    public static final int NUTZER_COLUMN = 4;
    public static final int VERTRAGS_BEGINN_COLUMN = 5;
    public static final int VERTRAGS_ENDE_COLUMN = 6;
    private static final Logger LOG = Logger.getLogger(MiPaModel.class);
    private SimpleDocumentModel bemerkungDocumentModel;
    private MiPa currentSelectedMiPa = null;

    public MiPaModel() {
        super(COLUMN_HEADER, COLUMN_CLASSES, MipaCustomBean.class);
        this.initDocumentModels();
    }

    public MiPaModel(Collection<MipaCustomBean> miPas) {
        super(COLUMN_HEADER, COLUMN_CLASSES, miPas);
        this.initDocumentModels();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (rowIndex >= this.getRowCount()) {
                LOG.warn((Object)("Cannot access row " + rowIndex + ". There are just " + this.getRowCount() + " rows"));
                return null;
            }
            MiPa value = (MiPa)this.getCidsBeanAtRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return value.getLage();
                }
                case 1: {
                    return value.getAktenzeichen();
                }
                case 2: {
                    if (value.getFlaeche() != null) {
                        return value.getFlaeche().intValue();
                    }
                    return null;
                }
                case 3: {
                    if (value.getMiPaNutzung() != null) {
                        return value.getMiPaNutzung().getMiPaKategorie();
                    }
                    return null;
                }
                case 4: {
                    return value.getNutzer();
                }
                case 5: {
                    return value.getVertragsbeginn();
                }
                case 6: {
                    return value.getVertragsende();
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void removeCidsBean(int rowIndex) {
        try {
            MipaCustomBean miPa = (MipaCustomBean)this.getCidsBeanAtRow(rowIndex);
            if (miPa != null && miPa.getGeometry() != null) {
                LagisBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)miPa);
            }
            miPa.delete();
            super.removeCidsBean(rowIndex);
        }
        catch (Exception ex) {
            LOG.error((Object)"An error occurred while removing MiPa from MipaTableModel", (Throwable)ex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return COLUMN_HEADER.length > columnIndex && this.getRowCount() > rowIndex && this.isInEditMode();
    }

    public Collection<Feature> getAllMiPaFeatures() {
        ArrayList<Feature> mipaFeatures = new ArrayList<Feature>();
        if (this.getCidsBeans() != null) {
            for (MipaCustomBean mipaCustomBean : this.getCidsBeans()) {
                if (mipaCustomBean.getGeometry() == null) continue;
                mipaFeatures.add(mipaCustomBean);
            }
            return mipaFeatures;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            MiPa value = (MiPa)this.getCidsBeanAtRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value.setLage((String)aValue);
                    break;
                }
                case 1: {
                    value.setAktenzeichen((String)aValue);
                    break;
                }
                case 2: {
                    if (aValue != null) {
                        value.setFlaeche(((Integer)aValue).doubleValue());
                        break;
                    }
                    value.setFlaeche(null);
                    break;
                }
                case 3: {
                    if (value.getMiPaNutzung() == null) {
                        value.setMiPaNutzung(MipaNutzungCustomBean.createNew());
                        value.getMiPaNutzung().setMiPaKategorie((MipaKategorieCustomBean)aValue);
                        break;
                    }
                    MipaKategorieCustomBean oldKategory = null;
                    oldKategory = value.getMiPaNutzung().getMiPaKategorie();
                    if (oldKategory != null && aValue != null && !((Object)oldKategory).equals(aValue)) {
                        value.getMiPaNutzung().setAusgewaehlteNummer(null);
                    }
                    value.getMiPaNutzung().setMiPaKategorie((MipaKategorieCustomBean)aValue);
                    break;
                }
                case 4: {
                    value.setNutzer((String)aValue);
                    break;
                }
                case 5: {
                    if (!(aValue instanceof Date) && aValue != null) break;
                    value.setVertragsbeginn((Date)aValue);
                    break;
                }
                case 6: {
                    if (!(aValue instanceof Date) && aValue != null) break;
                    value.setVertragsende((Date)aValue);
                    break;
                }
                default: {
                    LOG.warn((Object)("Keine Spalte f\u00fcr angegebenen Index vorhanden: " + columnIndex));
                    return;
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim setzen von Daten in dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
        }
    }

    private void initDocumentModels() {
        this.bemerkungDocumentModel = new SimpleDocumentModel(){

            @Override
            public void assignValue(String newValue) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Bemerkung assigned");
                    LOG.debug((Object)("new Value: " + newValue));
                }
                this.valueToCheck = newValue;
                this.fireValidationStateChanged(this);
                if (MiPaModel.this.currentSelectedMiPa != null && this.getStatus() == 0) {
                    MiPaModel.this.currentSelectedMiPa.setBemerkung(newValue);
                }
            }
        };
    }

    public void clearSlaveComponents() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Clear Slave Components");
            }
            this.bemerkungDocumentModel.clear(0, this.bemerkungDocumentModel.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SimpleDocumentModel getBemerkungDocumentModel() {
        return this.bemerkungDocumentModel;
    }

    public void setCurrentSelectedMipa(MiPa newMiPa) {
        this.currentSelectedMiPa = newMiPa;
        if (this.currentSelectedMiPa != null) {
            try {
                this.bemerkungDocumentModel.clear(0, this.bemerkungDocumentModel.getLength());
                this.bemerkungDocumentModel.insertString(0, this.currentSelectedMiPa.getBemerkung(), null);
            }
            catch (BadLocationException ex) {
                LOG.error((Object)"Fehler beim setzen des BemerkungsModells: ", (Throwable)ex);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"nichts selektiert l\u00f6sche Felder");
            }
            this.clearSlaveComponents();
        }
    }
}

