/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.custom.beans.lagis.RebeArtCustomBean;
import de.cismet.cids.custom.beans.lagis.RebeCustomBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReBeTableModel
extends CidsBeanTableModel_Lagis {
    private static final String[] COLUMN_HEADER = new String[]{"ist Recht", "Art", "Art des Rechts", "Nummer", "Eintragung Datum", "L\u00f6schung Datum", "Bemerkung"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, RebeArtCustomBean.class, String.class, String.class, Date.class, Date.class, String.class};
    private static final Logger LOG = Logger.getLogger(ReBeTableModel.class);
    private boolean isReBeKindSwitchAllowed = true;

    public ReBeTableModel() {
        super(COLUMN_HEADER, COLUMN_CLASSES, RebeCustomBean.class);
    }

    public ReBeTableModel(Collection<RebeCustomBean> reBe) {
        super(COLUMN_HEADER, COLUMN_CLASSES, reBe);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            RebeCustomBean value = (RebeCustomBean)this.getCidsBeanAtRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return value.getIstRecht();
                }
                case 1: {
                    return value.getReBeArt();
                }
                case 2: {
                    return value.getBeschreibung();
                }
                case 3: {
                    return value.getNummer();
                }
                case 4: {
                    return value.getDatumEintragung();
                }
                case 5: {
                    return value.getDatumLoeschung();
                }
                case 6: {
                    return value.getBemerkung();
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void removeCidsBean(int rowIndex) {
        try {
            RebeCustomBean reBe = (RebeCustomBean)this.getCidsBeanAtRow(rowIndex);
            if (reBe != null && reBe.getGeometry() != null) {
                LagisBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)reBe);
            }
            reBe.delete();
            super.removeCidsBean(rowIndex);
        }
        catch (Exception ex) {
            LOG.error((Object)"An error occurred while removing ReBe from RebeTableModel", (Throwable)ex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return COLUMN_HEADER.length > columnIndex && this.getRowCount() > rowIndex && this.isInEditMode() && this.isReBeKindSwitchAllowed;
        }
        return COLUMN_HEADER.length > columnIndex && this.getRowCount() > rowIndex && this.isInEditMode();
    }

    public ArrayList<Feature> getAllReBeFeatures() {
        ArrayList<Feature> tmp = new ArrayList<Feature>();
        ArrayList resBes = (ArrayList)this.getCidsBeans();
        if (resBes != null) {
            for (RebeCustomBean curReBe : resBes) {
                if (curReBe.getGeometry() == null) continue;
                tmp.add(curReBe);
            }
            return tmp;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            RebeCustomBean value = (RebeCustomBean)this.getCidsBeanAtRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value.setIstRecht((Boolean)aValue);
                    break;
                }
                case 1: {
                    value.setReBeArt((RebeArtCustomBean)aValue);
                    break;
                }
                case 2: {
                    value.setBeschreibung((String)aValue);
                    break;
                }
                case 3: {
                    value.setNummer((String)aValue);
                    break;
                }
                case 4: {
                    if (!(aValue instanceof Date) && aValue != null) break;
                    value.setDatumEintragung((Date)aValue);
                    break;
                }
                case 5: {
                    if (!(aValue instanceof Date) && aValue != null) break;
                    value.setDatumLoeschung((Date)aValue);
                    break;
                }
                case 6: {
                    value.setBemerkung((String)aValue);
                    break;
                }
                default: {
                    LOG.warn((Object)("Keine Spalte f\u00fcr angegebenen Index vorhanden: " + columnIndex));
                    return;
                }
            }
            this.fireTableDataChangedAndKeepSelection();
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim setzen von Daten in dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
        }
    }

    public boolean isIsReBeKindSwitchAllowed() {
        return this.isReBeKindSwitchAllowed;
    }

    public void setIsReBeKindSwitchAllowed(boolean isReBeKindSwitchAllowed) {
        this.isReBeKindSwitchAllowed = isReBeKindSwitchAllowed;
    }
}

