/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models;

import de.cismet.cids.custom.beans.lagis.VertragCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragsartCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.tables.VertraegeTable;
import de.cismet.lagis.models.CidsBeanTableModel_Lagis;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class VertraegeTableModel
extends CidsBeanTableModel_Lagis {
    private static final String[] COLUMN_NAMES = new String[]{"Vertragsart", "Aktenzeichen", "Quadratmeterpreis", "Kaufpreis (i. NK)"};
    private static final Class[] COLUMN_CLASSES = new Class[]{VertragsartCustomBean.class, String.class, Double.class, Double.class};
    private static final Logger LOG = Logger.getLogger(VertraegeTableModel.class);
    private DecimalFormat df = LagisBroker.getCurrencyFormatter();

    public VertraegeTableModel() {
        super(COLUMN_NAMES, COLUMN_CLASSES, VertragCustomBean.class);
        this.setCidsBeans(new ArrayList());
    }

    public VertraegeTableModel(Collection<VertragCustomBean> vertraege) {
        super(COLUMN_NAMES, COLUMN_CLASSES, vertraege);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            VertragCustomBean vertrag = (VertragCustomBean)this.getCidsBeanAtRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    VertragsartCustomBean art = vertrag.getVertragsart();
                    if (art != null) {
                        return art.getBezeichnung();
                    }
                    return null;
                }
                case 1: {
                    return vertrag.getAktenzeichen();
                }
                case 2: {
                    Double qPreis = vertrag.getQuadratmeterpreis();
                    return qPreis != null ? this.df.format(qPreis) : null;
                }
                case 3: {
                    Double gPreis = vertrag.getGesamtpreis();
                    return gPreis != null ? this.df.format(gPreis) : null;
                }
            }
            return "Spalte ist nicht definiert";
        }
        catch (Exception ex) {
            LOG.error((Object)("Fehler beim abrufen von Daten aus dem Modell: Zeile: " + rowIndex + " Spalte" + columnIndex), (Throwable)ex);
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void restoreBean(CidsBean cidsBean) {
        super.restoreBean(cidsBean);
        ((VertraegeTable)((Object)this.getTable())).emulateMouseClicked();
    }
}

