/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models.documents;

import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.documents.SimpleDocumentModel;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class AmountDocumentModel
extends SimpleDocumentModel {
    private static final String EURO = "\u20ac";
    NumberFormat nf = LagisBroker.getCurrencyFormatter();
    Double currentAmount;
    private final Logger log = Logger.getLogger(this.getClass());

    @Override
    public void assignValue(String newValue) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("new Value: " + newValue));
        }
        this.valueToCheck = newValue;
        this.fireValidationStateChanged(this);
    }

    public void assignValue(Double amount) {
        this.currentAmount = amount;
    }

    public Double getCurrentAmount() {
        return this.currentAmount;
    }

    @Override
    public int getStatus() {
        if (this.valueToCheck != null) {
            if (this.valueToCheck.matches(".*(\\.\\.\\.*).*") || this.valueToCheck.matches(".*(\\...?\\.).*") || this.valueToCheck.matches(".*(\\.,).*") || this.valueToCheck.matches("^\\.")) {
                this.statusDescription = "Es d\u00fcrfen nicht mehrere Punke unmittelbar aufeinander folgen!";
                return 2;
            }
            try {
                Number betrag = this.nf.parse(this.valueToCheck);
                this.statusDescription = "";
                this.assignValue(betrag.doubleValue());
                return 0;
            }
            catch (Exception ex1) {
                this.log.warn((Object)"Fehler Betrag parsen: Betrag hat nicht die Form ##0,00 \u20ac ", (Throwable)ex1);
                try {
                    Number betrag = this.nf.parse(this.valueToCheck.trim() + " " + EURO);
                    this.statusDescription = "";
                    this.assignValue(betrag.doubleValue());
                    return 0;
                }
                catch (Exception ex2) {
                    this.log.warn((Object)"Fehler Betrag parsen: Betrag hat nicht die Form ##0,00", (Throwable)ex2);
                    if (this.valueToCheck.length() == 0) {
                        this.statusDescription = "";
                        Double nullDouble = null;
                        this.assignValue(nullDouble);
                        this.log.warn((Object)"Betrag ist null");
                        return 0;
                    }
                    this.statusDescription = "Falsches Format";
                    return 2;
                }
            }
        }
        if (this.valueToCheck == null) {
            this.statusDescription = "";
            return 0;
        }
        this.statusDescription = "Falsches Format: Bitte einen Betrag in der Form 1.222,00 \u20ac eingeben";
        return 2;
    }
}

