/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models.documents;

import de.cismet.lagis.validation.Validatable;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.Component;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SimpleDocumentModel
extends PlainDocument
implements Validatable {
    protected String statusDescription = "";
    protected String valueToCheck = null;
    Vector listeners = new Vector();

    public boolean acceptChanges(String newValue) {
        return true;
    }

    public void assignValue(String newValue) {
    }

    public void insertNewString(String string, AttributeSet attributes) throws BadLocationException {
        if (string == null) {
            return;
        }
        super.remove(0, this.getLength());
        this.insertString(0, string, null);
    }

    @Override
    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuffer currentBuffer = new StringBuffer(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        if (this.acceptChanges(newValue)) {
            this.assignValue(newValue);
            super.insertString(offset, string, attributes);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        StringBuffer currentBuffer = new StringBuffer(this.getText(0, this.getLength()));
        currentBuffer.delete(offs, offs + len);
        String newValue = currentBuffer.toString();
        if (this.acceptChanges(newValue)) {
            this.assignValue(newValue);
            super.remove(offs, len);
        }
    }

    public void clear(int offs, int len) throws BadLocationException {
        StringBuffer currentBuffer = new StringBuffer(this.getText(0, this.getLength()));
        currentBuffer.delete(offs, offs + len);
        String newValue = currentBuffer.toString();
        if (this.acceptChanges(newValue)) {
            super.remove(offs, len);
        }
    }

    @Override
    public void removeValidationStateChangedListener(ValidationStateChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void addValidationStateChangedListener(ValidationStateChangedListener l) {
        this.listeners.add(l);
    }

    @Override
    public String getValidationMessage() {
        return this.statusDescription;
    }

    @Override
    public int getStatus() {
        if (this.valueToCheck != null && this.valueToCheck.length() <= 255) {
            this.statusDescription = "";
            return 0;
        }
        if (this.valueToCheck == null) {
            this.statusDescription = "";
            return 0;
        }
        this.statusDescription = "Ein Text muss weniger als 255 Zeichen haben";
        return 2;
    }

    @Override
    public void fireValidationStateChanged(Object validatedObject) {
        for (ValidationStateChangedListener v : this.listeners) {
            v.validationStateChanged(this);
        }
    }

    @Override
    public void showAssistent(Component parent) {
    }
}

