/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.models.documents;

import de.cismet.cids.custom.beans.lagis.BeschlussCustomBean;
import de.cismet.cids.custom.beans.lagis.KostenCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragCustomBean;
import de.cismet.cids.custom.beans.lagis.VertragsartCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.models.BeschluesseTableModel;
import de.cismet.lagis.models.KostenTableModel;
import de.cismet.lagis.models.VertraegeTableModel;
import de.cismet.lagis.models.documents.AmountDocumentModel;
import de.cismet.lagis.models.documents.DateDocumentModel;
import de.cismet.lagis.models.documents.SimpleDocumentModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class VertragDocumentModelContainer
implements MouseListener,
ActionListener {
    private static final Logger LOG = Logger.getLogger(VertragDocumentModelContainer.class);
    private final DecimalFormat df = LagisBroker.getCurrencyFormatter();
    private final DateFormat dateFormatter = LagisBroker.getDateFormatter();
    private VertragCustomBean currentSelectedVertrag = null;
    private VertraegeTableModel vertraegeTableModel;
    private AmountDocumentModel kaufpreisDocumentModel;
    private AmountDocumentModel quadPreisDocumentModel;
    private SimpleDocumentModel voreigentuemerDocumentModel;
    private SimpleDocumentModel aktenzeichenDocumentModel;
    private DateDocumentModel auflassungDocumentModel;
    private DateDocumentModel eintragungDocumentModel;
    private SimpleDocumentModel bemerkungDocumentModel;
    private DefaultComboBoxModel vertragsartComboBoxModel;
    private KostenTableModel kostenTableModel;
    private BeschluesseTableModel beschluesseTableModel;

    public VertragDocumentModelContainer(VertraegeTableModel vertraegeTableModel) {
        this.vertraegeTableModel = vertraegeTableModel;
        this.initDocumentModels();
    }

    private void initDocumentModels() {
        this.kaufpreisDocumentModel = new AmountDocumentModel(){

            @Override
            public void assignValue(Double betrag) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"amount assinged");
                }
                if (VertragDocumentModelContainer.this.currentSelectedVertrag != null) {
                    VertragDocumentModelContainer.this.currentSelectedVertrag.setGesamtpreis(betrag);
                    VertragDocumentModelContainer.this.vertraegeTableModel.fireTableDataChangedAndKeepSelection();
                }
            }
        };
        this.quadPreisDocumentModel = new AmountDocumentModel(){

            @Override
            public void assignValue(Double betrag) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"amount assinged");
                }
                if (VertragDocumentModelContainer.this.currentSelectedVertrag != null) {
                    VertragDocumentModelContainer.this.currentSelectedVertrag.setQuadratmeterpreis(betrag);
                    VertragDocumentModelContainer.this.vertraegeTableModel.fireTableDataChangedAndKeepSelection();
                }
            }
        };
        this.auflassungDocumentModel = new DateDocumentModel(){

            @Override
            public void assignValue(Date date) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Date assinged");
                }
                if (VertragDocumentModelContainer.this.currentSelectedVertrag != null) {
                    VertragDocumentModelContainer.this.currentSelectedVertrag.setDatumAuflassung(date);
                }
            }
        };
        this.eintragungDocumentModel = new DateDocumentModel(){

            @Override
            public void assignValue(Date date) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Date assinged");
                }
                if (VertragDocumentModelContainer.this.currentSelectedVertrag != null) {
                    VertragDocumentModelContainer.this.currentSelectedVertrag.setDatumEintragung(date);
                }
            }
        };
        this.voreigentuemerDocumentModel = new SimpleDocumentModel(){

            @Override
            public void assignValue(String newValue) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"voreigentuemer assigned");
                    LOG.debug((Object)("new Value: " + newValue));
                }
                this.valueToCheck = newValue;
                this.fireValidationStateChanged(this);
                if (VertragDocumentModelContainer.this.currentSelectedVertrag != null && this.getStatus() == 0) {
                    VertragDocumentModelContainer.this.currentSelectedVertrag.setVertragspartner(newValue);
                }
            }
        };
        this.aktenzeichenDocumentModel = new SimpleDocumentModel(){

            @Override
            public void assignValue(String newValue) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"aktenzeichen assigned");
                    LOG.debug((Object)("new Value: " + newValue));
                }
                this.valueToCheck = newValue;
                this.fireValidationStateChanged(this);
                if (VertragDocumentModelContainer.this.currentSelectedVertrag != null && this.getStatus() == 0) {
                    VertragDocumentModelContainer.this.currentSelectedVertrag.setAktenzeichen(newValue);
                    VertragDocumentModelContainer.this.vertraegeTableModel.fireTableDataChangedAndKeepSelection();
                }
            }
        };
        this.bemerkungDocumentModel = new SimpleDocumentModel(){

            @Override
            public void assignValue(String newValue) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Bemerkung assigned");
                    LOG.debug((Object)("new Value: " + newValue));
                }
                this.valueToCheck = newValue;
                this.fireValidationStateChanged(this);
                if (VertragDocumentModelContainer.this.currentSelectedVertrag != null && this.getStatus() == 0) {
                    VertragDocumentModelContainer.this.currentSelectedVertrag.setBemerkung(newValue);
                }
            }
        };
        Collection<VertragsartCustomBean> vertragsarten = LagisBroker.getInstance().getAllVertragsarten();
        this.vertragsartComboBoxModel = vertragsarten != null ? new DefaultComboBoxModel<VertragsartCustomBean>(new Vector<VertragsartCustomBean>(vertragsarten)) : new DefaultComboBoxModel();
        this.beschluesseTableModel = new BeschluesseTableModel();
        this.kostenTableModel = new KostenTableModel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.currentSelectedVertrag != null) {
            this.currentSelectedVertrag.setVertragsart((VertragsartCustomBean)this.vertragsartComboBoxModel.getSelectedItem());
            this.vertraegeTableModel.fireTableDataChangedAndKeepSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("source: " + source));
        }
        if (source instanceof JXTable) {
            JXTable table = (JXTable)source;
            int currentRow = table.getSelectedRow();
            this.selectRow(currentRow);
        }
    }

    public void selectRow(int row) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Row: " + row));
        }
        if (row != -1) {
            final JXTable table = (JXTable)this.vertraegeTableModel.getTable();
            final int currentColumn = table.getSelectedColumn();
            final int modelRow = table.convertRowIndexToModel(row);
            this.currentSelectedVertrag = (VertragCustomBean)this.vertraegeTableModel.getCidsBeanAtRow(modelRow);
            try {
                this.kaufpreisDocumentModel.clear(0, this.kaufpreisDocumentModel.getLength());
                if (this.currentSelectedVertrag.getGesamtpreis() != null) {
                    this.kaufpreisDocumentModel.insertString(0, this.df.format(this.currentSelectedVertrag.getGesamtpreis()), null);
                } else {
                    this.kaufpreisDocumentModel.insertString(0, "", null);
                }
                this.auflassungDocumentModel.clear(0, this.auflassungDocumentModel.getLength());
                if (this.currentSelectedVertrag.getDatumAuflassung() != null) {
                    this.auflassungDocumentModel.insertString(0, this.dateFormatter.format(this.currentSelectedVertrag.getDatumAuflassung()), null);
                } else {
                    this.auflassungDocumentModel.insertString(0, "", null);
                }
                this.eintragungDocumentModel.clear(0, this.eintragungDocumentModel.getLength());
                if (this.currentSelectedVertrag.getDatumEintragung() != null) {
                    this.eintragungDocumentModel.insertString(0, this.dateFormatter.format(this.currentSelectedVertrag.getDatumEintragung()), null);
                } else {
                    this.eintragungDocumentModel.insertString(0, "", null);
                }
                this.voreigentuemerDocumentModel.clear(0, this.voreigentuemerDocumentModel.getLength());
                this.voreigentuemerDocumentModel.insertString(0, this.currentSelectedVertrag.getVertragspartner(), null);
                this.aktenzeichenDocumentModel.clear(0, this.aktenzeichenDocumentModel.getLength());
                this.aktenzeichenDocumentModel.insertString(0, this.currentSelectedVertrag.getAktenzeichen(), null);
                this.bemerkungDocumentModel.clear(0, this.bemerkungDocumentModel.getLength());
                this.bemerkungDocumentModel.insertString(0, this.currentSelectedVertrag.getBemerkung(), null);
                this.quadPreisDocumentModel.clear(0, this.quadPreisDocumentModel.getLength());
                if (this.currentSelectedVertrag.getQuadratmeterpreis() != null) {
                    this.quadPreisDocumentModel.insertString(0, this.df.format(this.currentSelectedVertrag.getQuadratmeterpreis()), null);
                } else {
                    this.quadPreisDocumentModel.insertString(0, "", null);
                }
                this.vertragsartComboBoxModel.setSelectedItem(this.currentSelectedVertrag.getVertragsart());
                this.kostenTableModel.refreshTableModel(this.currentSelectedVertrag.getKosten());
                this.beschluesseTableModel.refreshTableModel(this.currentSelectedVertrag.getBeschluesse());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        table.changeSelection(table.convertRowIndexToView(modelRow), currentColumn, false, false);
                    }
                });
            }
            catch (BadLocationException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"nichts selektiert l\u00f6sche Felder");
            }
            this.currentSelectedVertrag = null;
            this.clearComponents();
        }
    }

    public VertragCustomBean getCurrentSelectedVertrag() {
        return this.currentSelectedVertrag;
    }

    public AmountDocumentModel getKaufpreisDocumentModel() {
        return this.kaufpreisDocumentModel;
    }

    public void updateTableModel(VertraegeTableModel vertraegeTableModel) {
        this.vertraegeTableModel = vertraegeTableModel;
        if (vertraegeTableModel.getRowCount() > 0) {
            this.selectRow(0);
        }
    }

    public void clearComponents() {
        try {
            this.kaufpreisDocumentModel.clear(0, this.kaufpreisDocumentModel.getLength());
            this.quadPreisDocumentModel.clear(0, this.quadPreisDocumentModel.getLength());
            this.voreigentuemerDocumentModel.clear(0, this.voreigentuemerDocumentModel.getLength());
            this.aktenzeichenDocumentModel.clear(0, this.aktenzeichenDocumentModel.getLength());
            this.auflassungDocumentModel.clear(0, this.auflassungDocumentModel.getLength());
            this.eintragungDocumentModel.clear(0, this.eintragungDocumentModel.getLength());
            this.bemerkungDocumentModel.clear(0, this.bemerkungDocumentModel.getLength());
            this.kostenTableModel.refreshTableModel(null);
            this.beschluesseTableModel.refreshTableModel(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DateDocumentModel getAuflassungDocumentModel() {
        return this.auflassungDocumentModel;
    }

    public DateDocumentModel getEintragungDocumentModel() {
        return this.eintragungDocumentModel;
    }

    public SimpleDocumentModel getVoreigentuemerDocumentModel() {
        return this.voreigentuemerDocumentModel;
    }

    public SimpleDocumentModel getAktenzeichenDocumentModel() {
        return this.aktenzeichenDocumentModel;
    }

    public SimpleDocumentModel getBemerkungDocumentModel() {
        return this.bemerkungDocumentModel;
    }

    public AmountDocumentModel getQuadPreisDocumentModel() {
        return this.quadPreisDocumentModel;
    }

    public DefaultComboBoxModel getVertragsartComboBoxModel() {
        return this.vertragsartComboBoxModel;
    }

    public KostenTableModel getKostenTableModel() {
        return this.kostenTableModel;
    }

    public void addNewBeschluss() {
        if (this.currentSelectedVertrag != null) {
            try {
                BeschlussCustomBean beschlussBean = BeschlussCustomBean.createNew();
                this.beschluesseTableModel.addCidsBean(beschlussBean);
                this.currentSelectedVertrag.getBeschluesse().add(beschlussBean);
                this.beschluesseTableModel.fireTableDataChanged();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Neuer Beschluss angelegt");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"error creating beschluss bean", (Throwable)ex);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Es konnte kein Beschluss angelegt werden --> currentSelected Vertrag = null");
        }
    }

    public void addNewKosten() {
        if (this.currentSelectedVertrag != null) {
            KostenCustomBean kostenBean = KostenCustomBean.createNew();
            this.kostenTableModel.addCidsBean(kostenBean);
            this.currentSelectedVertrag.getKosten().add(kostenBean);
            this.kostenTableModel.fireTableDataChanged();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Neue Kosten angelegt");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Es konnten keine neue Kosten angelegt werden --> currentSelected Vertrag = null");
        }
    }

    public void addNewVertrag() {
        VertragCustomBean newVertrag = VertragCustomBean.createNew();
        newVertrag.setVertragsart((VertragsartCustomBean)this.vertragsartComboBoxModel.getElementAt(0));
        this.vertraegeTableModel.addCidsBean(newVertrag);
    }

    public void removeKosten(int kostenIndex) {
        if (this.currentSelectedVertrag != null || kostenIndex == -1) {
            KostenCustomBean kostenBean = (KostenCustomBean)this.kostenTableModel.getCidsBeanAtRow(kostenIndex);
            this.kostenTableModel.removeCidsBean(kostenIndex);
            this.currentSelectedVertrag.getKosten().remove(kostenBean);
            this.kostenTableModel.fireTableDataChanged();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Kosten wurden entfernt");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Kosten konnten nicht entfernt werden --> currentSelected Vertrag = null oder wert = -1");
        }
    }

    public void removeBeschluss(int beschlussIndex) {
        if (this.currentSelectedVertrag != null || beschlussIndex == -1) {
            BeschlussCustomBean beschlussBean = (BeschlussCustomBean)this.beschluesseTableModel.getCidsBeanAtRow(beschlussIndex);
            this.beschluesseTableModel.removeCidsBean(beschlussIndex);
            this.currentSelectedVertrag.getBeschluesse().remove(beschlussBean);
            this.beschluesseTableModel.fireTableDataChanged();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Beschluss wurde entfernt");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Beschluss konnten nicht entfernt werden --> currentSelected Vertrag = null oder wert = -1");
        }
    }

    public boolean isVertragSelected() {
        return this.currentSelectedVertrag != null;
    }

    public BeschluesseTableModel getBeschluesseTableModel() {
        return this.beschluesseTableModel;
    }
}

