/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public abstract class ADataSource<T>
implements JRDataSource {
    protected static final String YES = "Ja";
    protected static final String NO = "Nein";
    protected static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat(",##0.00");
    protected static final DecimalFormat INTEGER_FORMAT = new DecimalFormat("#,##0");
    protected static final DateFormat DF = DateFormat.getDateInstance(2, Locale.GERMANY);
    protected T currentItem;
    protected List<T> items;
    protected int end;
    protected int currentIndex;

    public ADataSource() {
        this.init(this.retrieveData());
    }

    public ADataSource(List<T> items) {
        this.init(items);
    }

    private void init(List<T> items) {
        if (items == null) {
            throw new NullPointerException();
        }
        this.items = items;
        this.end = this.items.size() - 1;
        this.currentIndex = -1;
    }

    public boolean hasData() {
        return !this.items.isEmpty();
    }

    protected abstract List<T> retrieveData();

    public boolean next() throws JRException {
        if (this.currentIndex == this.end) {
            return false;
        }
        ++this.currentIndex;
        this.currentItem = this.items.get(this.currentIndex);
        return true;
    }

    public Object getFieldValue(JRField jrf) throws JRException {
        if (jrf == null) {
            throw new NullPointerException("Given JRField is null");
        }
        String fieldName = jrf.getName();
        if (fieldName == null) {
            throw new NullPointerException("Retrieved field name is null");
        }
        return this.getFieldValue(fieldName);
    }

    protected String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DF.format(date);
    }

    protected String formatNumber(Integer number) {
        if (number == null) {
            return null;
        }
        return INTEGER_FORMAT.format(number);
    }

    protected String formatNumber(Double number) {
        if (number == null) {
            return null;
        }
        return DOUBLE_FORMAT.format(number);
    }

    protected String formatBoolean(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? YES : NO;
    }

    protected abstract Object getFieldValue(String var1) throws JRException;
}

