/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import de.cismet.cids.custom.beans.lagis.BaumCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.BaumNutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class BaumDateiDataSource
extends ADataSource<BaumCustomBean>
implements JRDataSource {
    private static final String JR_LAGE = "lage";
    private static final String JR_BAUM_NR = "baumnr";
    private static final String JR_BAUM_BEST = "baumbestand";
    private static final String JR_AUFTR_NEHMER = "auftragnehmer";
    private static final String JR_ERFASSUNG = "erfassung";
    private static final String JR_FAELL_DATUM = "faelldatum";

    public BaumDateiDataSource() {
    }

    public BaumDateiDataSource(List<BaumCustomBean> baeumeList) {
        super(baeumeList);
    }

    @Override
    protected List<BaumCustomBean> retrieveData() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        Collection<BaumCustomBean> baeumeSet = currentFlurstueck.getBaeume();
        return new ArrayList<BaumCustomBean>(baeumeSet);
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_LAGE.equals(fieldName)) {
            return ((BaumCustomBean)this.currentItem).getLage();
        }
        if (JR_BAUM_NR.equals(fieldName)) {
            return ((BaumCustomBean)this.currentItem).getBaumnummer();
        }
        if (JR_BAUM_BEST.equals(fieldName)) {
            BaumNutzungCustomBean nutzung = ((BaumCustomBean)this.currentItem).getBaumNutzung();
            if (nutzung == null) {
                return null;
            }
            BaumKategorieCustomBean category = nutzung.getBaumKategorie();
            if (category == null) {
                return null;
            }
            return category.getBezeichnung();
        }
        if (JR_AUFTR_NEHMER.equals(fieldName)) {
            return ((BaumCustomBean)this.currentItem).getAuftragnehmer();
        }
        if (JR_ERFASSUNG.equals(fieldName)) {
            return super.formatDate(((BaumCustomBean)this.currentItem).getErfassungsdatum());
        }
        if (JR_FAELL_DATUM.equals(fieldName)) {
            return super.formatDate(((BaumCustomBean)this.currentItem).getFaelldatum());
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

