/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class FlurstueckSchluesselDataSource
extends ADataSource<FlurstueckSchluesselCustomBean>
implements JRDataSource {
    private static final String JR_GEMARKUNG = "gemarkung";
    private static final String JR_FLUR = "flur";
    private static final String JR_FLURSTUECK = "flurstueck";

    public FlurstueckSchluesselDataSource() {
    }

    public FlurstueckSchluesselDataSource(List<FlurstueckSchluesselCustomBean> fsKeyList) {
        super(fsKeyList);
    }

    @Override
    protected List<FlurstueckSchluesselCustomBean> retrieveData() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        ArrayList<FlurstueckSchluesselCustomBean> fsKeys = new ArrayList<FlurstueckSchluesselCustomBean>(1);
        fsKeys.add(currentFlurstueck.getFlurstueckSchluessel());
        return fsKeys;
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_GEMARKUNG.equals(fieldName)) {
            return ((FlurstueckSchluesselCustomBean)this.currentItem).getGemarkung().getBezeichnung();
        }
        if (JR_FLUR.equals(fieldName)) {
            return String.valueOf(((FlurstueckSchluesselCustomBean)this.currentItem).getFlur());
        }
        if (JR_FLURSTUECK.equals(fieldName)) {
            return ((FlurstueckSchluesselCustomBean)this.currentItem).getFlurstueckZaehler() + "/" + ((FlurstueckSchluesselCustomBean)this.currentItem).getFlurstueckNenner();
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

