/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.datasource;

import de.cismet.cids.custom.beans.lagis.MipaCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaKategorieCustomBean;
import de.cismet.cids.custom.beans.lagis.MipaNutzungCustomBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.report.datasource.ADataSource;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class MiPaDataSource
extends ADataSource<MipaCustomBean>
implements JRDataSource {
    private static final String JR_LAGE = "lage";
    private static final String JR_AKTZ = "aktz";
    private static final String JR_NUTZUNG = "nutzung";
    private static final String JR_NUTZER = "nutzer";
    private static final String JR_BEGINN = "beginn";
    private static final String JR_ENDE = "ende";

    public MiPaDataSource() {
    }

    public MiPaDataSource(List<MipaCustomBean> mipaList) {
        super(mipaList);
    }

    @Override
    protected List<MipaCustomBean> retrieveData() {
        List<MipaCustomBean> mipaSet = LagisBroker.getInstance().getCurrentMipas();
        return new ArrayList<MipaCustomBean>(mipaSet);
    }

    @Override
    protected Object getFieldValue(String fieldName) throws JRException {
        if (JR_LAGE.equals(fieldName)) {
            return ((MipaCustomBean)this.currentItem).getLage();
        }
        if (JR_AKTZ.equals(fieldName)) {
            return ((MipaCustomBean)this.currentItem).getAktenzeichen();
        }
        if (JR_NUTZUNG.equals(fieldName)) {
            MipaNutzungCustomBean nutzung = ((MipaCustomBean)this.currentItem).getMiPaNutzung();
            if (nutzung == null) {
                return null;
            }
            MipaKategorieCustomBean category = nutzung.getMiPaKategorie();
            if (category == null) {
                return null;
            }
            return category.getBezeichnung();
        }
        if (JR_NUTZER.equals(fieldName)) {
            return ((MipaCustomBean)this.currentItem).getNutzer();
        }
        if (JR_BEGINN.equals(fieldName)) {
            return super.formatDate(((MipaCustomBean)this.currentItem).getVertragsbeginn());
        }
        if (JR_ENDE.equals(fieldName)) {
            return super.formatDate(((MipaCustomBean)this.currentItem).getVertragsende());
        }
        throw new IllegalArgumentException("Field " + fieldName + " is not supported in this report");
    }
}

