/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.printing;

import de.cismet.cismap.commons.gui.printing.JasperReportDownload;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.checkbox.IconCheckBox;
import de.cismet.lagis.report.datasource.ADataSource;
import de.cismet.lagis.report.datasource.BaumDateiDataSource;
import de.cismet.lagis.report.datasource.EmptyDataSource;
import de.cismet.lagis.report.datasource.MiPaDataSource;
import de.cismet.lagis.report.datasource.NutzungenDataSource;
import de.cismet.lagis.report.datasource.ReBeDataSource;
import de.cismet.lagis.report.datasource.VorgaengeDataSource;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.lagis.widget.RessortFactory;
import de.cismet.tools.gui.FXWebViewPanel;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import netscape.javascript.JSObject;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public final class ReportPrintingWidget
extends JDialog {
    private static final double DPI_FACTOR = 8.333333333333334;
    private static final int HISTORY_IMAGE_WIDTH = 545;
    private static final int HISTORY_IMAGE_HEIGHT = 211;
    private static final String PERM_KEY_BAUM = "Baumdatei";
    private static final String PERM_KEY_MIPA = "Vermietung/Verpachtung";
    private static final String PARAM_NUTZUNGEN = "param_nutzungen";
    private static final String PARAM_REBE = "param_rebe";
    private static final String PARAM_VORGAENGE = "param_vorgaenge";
    private static final String PARAM_HISTORY = "param_history";
    private static final String PARAM_MIPA = "param_mipa";
    private static final String PARAM_BAUMDATEI = "param_baumdatei";
    private static final String PARAM_NOTIZEN = "param_notizen";
    private static final String REPORT_MASTER = "/de/cismet/lagis/reports/FlurstueckDetailsReport.jasper";
    private static final Logger LOG = Logger.getLogger(ReportPrintingWidget.class);
    private static final String TEMPLATE;
    private FXWebViewPanel myWeb = null;
    private final String graphContent;
    private final Component parentComponent;
    private final HashMap<String, String> paramMap;
    private IconCheckBox baumdateiCheckBox;
    private JButton cmdCancel;
    private JButton cmdOk;
    private Box.Filler filler1;
    private IconCheckBox historieCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lbl1;
    private JLabel lbl2;
    private IconCheckBox mipaCheckBox;
    private IconCheckBox notizenCheckBox;
    private JTextPane notizenTextArea;
    private IconCheckBox nutzungenCheckBox;
    private JPanel panDesc;
    private JPanel panLoadAndInscribe;
    private IconCheckBox rebeCheckBox;
    private JScrollPane scpLoadingStatus;
    private JTextField txt1;
    private JTextField txt2;
    private IconCheckBox vorgaengeCheckBox;

    public ReportPrintingWidget(Frame frame, boolean modal) {
        super(frame, modal);
        this.parentComponent = frame;
        this.initComponents();
        this.panDesc.setBackground(new Color(216, 228, 248));
        this.getRootPane().setDefaultButton(this.cmdOk);
        this.notizenTextArea.requestFocus();
        this.initCheckBoxes();
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ReportPrintingWidget.this.close();
            }
        });
        this.paramMap = new HashMap(7);
        this.handleParamMap(PARAM_HISTORY, true);
        this.handleParamMap(PARAM_NOTIZEN, true);
        this.checkDetailAvailability();
        this.initHistory();
        this.graphContent = ReportPrintingWidget.getGraphContent();
    }

    private static String getGraphContent() {
        String graphString;
        try {
            graphString = LagisBroker.getInstance().getHistoryGraph(LagisBroker.getInstance().getCurrentFlurstueck(), LagisBroker.HistoryLevel.DIRECT_RELATIONS, 0, LagisBroker.HistorySibblingLevel.NONE, 0, LagisBroker.HistoryType.BOTH, null);
        }
        catch (Exception ex) {
            graphString = "digraph G{\"Fehler beim Ermitteln der Historie\"}";
            LOG.error((Object)"Error when craeting Historygraph", (Throwable)ex);
        }
        return TEMPLATE.replaceAll("__graphString__", graphString.replaceAll("\n", ""));
    }

    private void initHistory() {
        try {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    ReportPrintingWidget.this.myWeb = new FXWebViewPanel();
                    LOG.info((Object)"FXWebViewPanel inited");
                    return null;
                }

                @Override
                protected void done() {
                    Dimension dim = new Dimension(4541, 1758);
                    ReportPrintingWidget.this.myWeb.setVisible(true);
                    ReportPrintingWidget.this.myWeb.setSize(dim);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ReportPrintingWidget.this.myWeb.getWebEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                                public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                                    if (newValue == Worker.State.SUCCEEDED) {
                                        JSObject jsobj = (JSObject)ReportPrintingWidget.this.myWeb.getWebEngine().executeScript("window");
                                        jsobj.setMember("java", ReportPrintingWidget.this);
                                    }
                                }
                            });
                            ReportPrintingWidget.this.myWeb.loadContent(ReportPrintingWidget.this.graphContent);
                        }
                    });
                }
            }.execute();
        }
        catch (Exception exception) {
            LOG.error((Object)"Error while filling template", (Throwable)exception);
        }
    }

    public void pageRendered(String zoomlevel) {
        final double zl = Double.parseDouble(zoomlevel);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (zl < 1.0) {
                    ReportPrintingWidget.this.myWeb.setSize(new Dimension((int)(4541.666666666667 / zl), (int)(1758.3333333333335 / zl)));
                    ReportPrintingWidget.this.myWeb.loadContent(ReportPrintingWidget.this.graphContent);
                } else {
                    SnapshotParameters params = new SnapshotParameters();
                    WritableImage snapshot = ReportPrintingWidget.this.myWeb.getWebView().snapshot(params, null);
                    BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)snapshot, null);
                    LagisBroker.getInstance().setHistoryImage(renderedImage);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReportPrintingWidget.this.cmdOk.setEnabled(true);
                        }
                    });
                }
            }
        });
    }

    private void initCheckBoxes() {
        this.baumdateiCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget.this.baumdateiCheckBoxActionPerformed(ae);
            }
        });
        this.historieCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget.this.historieCheckBoxActionPerformed(ae);
            }
        });
        this.mipaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget.this.mipaCheckBoxActionPerformed(ae);
            }
        });
        this.notizenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget.this.notizenCheckBoxActionPerformed(ae);
            }
        });
        this.nutzungenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget.this.nutzungenCheckBoxActionPerformed(ae);
            }
        });
        this.rebeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget.this.rebeCheckBoxActionPerformed(ae);
            }
        });
        this.vorgaengeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportPrintingWidget.this.vorgaengeCheckBoxActionPerformed(ae);
            }
        });
    }

    private void checkDetailAvailability() {
        RessortFactory ressortFactory = RessortFactory.getInstance();
        HashMap<String, AbstractWidget> ressorts = ressortFactory.getRessorts();
        ADataSource ds = new BaumDateiDataSource();
        this.handleDetail(PARAM_BAUMDATEI, this.baumdateiCheckBox, ds.hasData());
        this.handlePermission(this.baumdateiCheckBox, ressorts.containsKey(PERM_KEY_BAUM));
        ds = new MiPaDataSource();
        this.handleDetail(PARAM_MIPA, this.mipaCheckBox, ds.hasData());
        this.handlePermission(this.mipaCheckBox, ressorts.containsKey(PERM_KEY_MIPA));
        ds = new NutzungenDataSource();
        this.handleDetail(PARAM_NUTZUNGEN, this.nutzungenCheckBox, ds.hasData());
        ds = new ReBeDataSource();
        this.handleDetail(PARAM_REBE, this.rebeCheckBox, ds.hasData());
        ds = new VorgaengeDataSource();
        this.handleDetail(PARAM_VORGAENGE, this.vorgaengeCheckBox, ds.hasData());
    }

    private void handlePermission(IconCheckBox checkBox, boolean hasPermission) {
        boolean released = checkBox.isSelected() && hasPermission;
        checkBox.setEnabled(released);
        checkBox.setSelected(released);
        if (!hasPermission) {
            checkBox.setToolTipText(ResourceBundle.getBundle("de/cismet/lagis/report/printing/Bundle").getString("ReportPrintingWidget.handleDetail(String,JCheckBox,enabled).checkBox.toolTipText.nopermission"));
        }
    }

    private void handleDetail(String param, IconCheckBox checkBox, boolean hasData) {
        this.handleParamMap(param, hasData);
        checkBox.setEnabled(hasData);
        checkBox.setSelected(hasData);
        if (!hasData) {
            checkBox.setToolTipText(ResourceBundle.getBundle("de/cismet/lagis/report/printing/Bundle").getString("ReportPrintingWidget.handleDetail(String,JCheckBox,enabled).checkBox.toolTipText.nodata"));
        }
    }

    private void handleParamMap(String param, boolean isSelected) {
        if (isSelected) {
            this.paramMap.put(param, param);
        } else {
            this.paramMap.remove(param);
        }
    }

    private void close() {
        super.setVisible(false);
        super.dispose();
    }

    public ReportPrintingWidget cloneWithNewParent(boolean modal, Frame component) {
        ReportPrintingWidget newWidget = new ReportPrintingWidget(component, modal);
        return newWidget;
    }

    private void initComponents() {
        this.lbl1 = new JLabel();
        this.txt1 = new JTextField();
        this.lbl2 = new JLabel();
        this.txt2 = new JTextField();
        this.panDesc = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.panLoadAndInscribe = new JPanel();
        this.scpLoadingStatus = new JScrollPane();
        this.notizenTextArea = new JTextPane();
        this.nutzungenCheckBox = new IconCheckBox();
        this.rebeCheckBox = new IconCheckBox();
        this.vorgaengeCheckBox = new IconCheckBox();
        this.mipaCheckBox = new IconCheckBox();
        this.baumdateiCheckBox = new IconCheckBox();
        this.historieCheckBox = new IconCheckBox();
        this.notizenCheckBox = new IconCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.cmdCancel = new JButton();
        this.cmdOk = new JButton();
        this.jLabel6 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.lbl1.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.lbl1.text"));
        this.txt1.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.txt1.text"));
        this.lbl2.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.lbl2.text"));
        this.txt2.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.txt2.text"));
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.title"));
        this.setMinimumSize(new Dimension(720, 0));
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ReportPrintingWidget.this.formComponentShown(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panDesc.setBackground(SystemColor.inactiveCaptionText);
        this.panDesc.setMaximumSize(new Dimension(Short.MAX_VALUE, 240));
        this.panDesc.setPreferredSize(new Dimension(160, 240));
        this.panDesc.setLayout(new BorderLayout());
        this.jPanel2.setOpaque(false);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/frameprint.png")));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(23, 23, 23).add((Component)this.jLabel5).addContainerGap(39, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(89, Short.MAX_VALUE).add((Component)this.jLabel5).add(23, 23, 23)));
        this.panDesc.add((Component)this.jPanel2, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.3;
        this.getContentPane().add((Component)this.panDesc, gridBagConstraints);
        this.panLoadAndInscribe.setMaximumSize(new Dimension(Short.MAX_VALUE, 240));
        this.panLoadAndInscribe.setPreferredSize(new Dimension(450, 240));
        this.panLoadAndInscribe.setLayout(new GridBagLayout());
        this.scpLoadingStatus.setMinimumSize(new Dimension(26, 29));
        this.scpLoadingStatus.setPreferredSize(new Dimension(8, 29));
        this.notizenTextArea.setMinimumSize(new Dimension(0, 50));
        this.notizenTextArea.setPreferredSize(new Dimension(6, 50));
        this.scpLoadingStatus.setViewportView(this.notizenTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new Insets(7, 5, 0, 5);
        this.panLoadAndInscribe.add((Component)this.scpLoadingStatus, gridBagConstraints);
        this.nutzungenCheckBox.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/sum.png")));
        this.nutzungenCheckBox.setSelected(true);
        this.nutzungenCheckBox.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.nutzungenCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        this.panLoadAndInscribe.add((Component)this.nutzungenCheckBox, gridBagConstraints);
        this.rebeCheckBox.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/findgreen.png")));
        this.rebeCheckBox.setSelected(true);
        this.rebeCheckBox.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.rebeCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        this.panLoadAndInscribe.add((Component)this.rebeCheckBox, gridBagConstraints);
        this.vorgaengeCheckBox.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/documents.png")));
        this.vorgaengeCheckBox.setSelected(true);
        this.vorgaengeCheckBox.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.vorgaengeCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        this.panLoadAndInscribe.add((Component)this.vorgaengeCheckBox, gridBagConstraints);
        this.mipaCheckBox.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/ressort.png")));
        this.mipaCheckBox.setSelected(true);
        this.mipaCheckBox.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.mipaCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        this.panLoadAndInscribe.add((Component)this.mipaCheckBox, gridBagConstraints);
        this.baumdateiCheckBox.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/ressort.png")));
        this.baumdateiCheckBox.setSelected(true);
        this.baumdateiCheckBox.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.baumdateiCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        this.panLoadAndInscribe.add((Component)this.baumdateiCheckBox, gridBagConstraints);
        this.historieCheckBox.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/ressort.png")));
        this.historieCheckBox.setSelected(true);
        this.historieCheckBox.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.historieCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        this.panLoadAndInscribe.add((Component)this.historieCheckBox, gridBagConstraints);
        this.notizenCheckBox.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/titlebar/note_edit.png")));
        this.notizenCheckBox.setSelected(true);
        this.notizenCheckBox.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget1.notizenCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(22, 0, 0, 0);
        this.panLoadAndInscribe.add((Component)this.notizenCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 0.3;
        this.panLoadAndInscribe.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.panLoadAndInscribe, gridBagConstraints);
        this.jSeparator3.setMinimumSize(new Dimension(510, 6));
        this.jSeparator3.setPreferredSize(new Dimension(100, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.jSeparator4.setMinimumSize(new Dimension(165, 6));
        this.jSeparator4.setPreferredSize(new Dimension(174, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jSeparator4, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(400, 39));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.cmdCancel.setMnemonic('A');
        this.cmdCancel.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.cmdCancel.text"));
        this.cmdCancel.setMaximumSize(new Dimension(100, 29));
        this.cmdCancel.setMinimumSize(new Dimension(100, 29));
        this.cmdCancel.setPreferredSize(new Dimension(100, 29));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPrintingWidget.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cmdCancel);
        this.cmdOk.setMnemonic('O');
        this.cmdOk.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.cmdOk.text"));
        this.cmdOk.setEnabled(false);
        this.cmdOk.setMaximumSize(new Dimension(100, 29));
        this.cmdOk.setMinimumSize(new Dimension(100, 29));
        this.cmdOk.setPreferredSize(new Dimension(100, 29));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportPrintingWidget.this.cmdOkActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cmdOk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(0, 9, 0, 9);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(200, 6));
        this.jSeparator1.setPreferredSize(new Dimension(200, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jSeparator2.setBackground(new Color(216, 228, 248));
        this.jSeparator2.setMaximumSize(new Dimension(160, Short.MAX_VALUE));
        this.jSeparator2.setMinimumSize(new Dimension(160, 6));
        this.jSeparator2.setOpaque(true);
        this.jSeparator2.setPreferredSize(new Dimension(160, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabel1.setBackground(new Color(216, 228, 248));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText(NbBundle.getMessage(ReportPrintingWidget.class, (String)"ReportPrintingWidget.jLabel1.text"));
        this.jLabel1.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.weightx = 0.3;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JasperReportDownload.JasperReportDataSourceGenerator dataSourceGenerator = new JasperReportDownload.JasperReportDataSourceGenerator(){

                    public JRDataSource generateDataSource() {
                        return new EmptyDataSource(1);
                    }
                };
                JasperReportDownload.JasperReportParametersGenerator parametersGenerator = new JasperReportDownload.JasperReportParametersGenerator(){

                    public Map generateParamters() {
                        if (ReportPrintingWidget.this.notizenCheckBox.isSelected()) {
                            ReportPrintingWidget.this.paramMap.put(ReportPrintingWidget.PARAM_NOTIZEN, ReportPrintingWidget.this.notizenTextArea.getText());
                        }
                        return ReportPrintingWidget.this.paramMap;
                    }
                };
                if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)((Frame)ReportPrintingWidget.this.parentComponent))) {
                    String jobname = DownloadManagerDialog.getInstance().getJobName();
                    DownloadManager.instance().add((Download)new JasperReportDownload(ReportPrintingWidget.REPORT_MASTER, parametersGenerator, dataSourceGenerator, jobname, "Lagis-Druck", "lagis_flurstueck_details"));
                }
                ReportPrintingWidget.this.setVisible(false);
            }
        });
    }

    private void vorgaengeCheckBoxActionPerformed(ActionEvent evt) {
        this.handleParamMap(PARAM_VORGAENGE, this.vorgaengeCheckBox.isSelected());
    }

    private void nutzungenCheckBoxActionPerformed(ActionEvent evt) {
        this.handleParamMap(PARAM_NUTZUNGEN, this.nutzungenCheckBox.isSelected());
    }

    private void rebeCheckBoxActionPerformed(ActionEvent evt) {
        this.handleParamMap(PARAM_REBE, this.rebeCheckBox.isSelected());
    }

    private void notizenCheckBoxActionPerformed(ActionEvent evt) {
        boolean isSelected = this.notizenCheckBox.isSelected();
        this.notizenTextArea.setEnabled(isSelected);
        if (isSelected) {
            this.notizenTextArea.setBackground(Color.WHITE);
        } else {
            this.notizenTextArea.setBackground(this.getBackground());
        }
        this.handleParamMap(PARAM_NOTIZEN, isSelected);
    }

    private void mipaCheckBoxActionPerformed(ActionEvent evt) {
        this.handleParamMap(PARAM_MIPA, this.mipaCheckBox.isSelected());
    }

    private void baumdateiCheckBoxActionPerformed(ActionEvent evt) {
        this.handleParamMap(PARAM_BAUMDATEI, this.baumdateiCheckBox.isSelected());
    }

    private void historieCheckBoxActionPerformed(ActionEvent evt) {
        this.handleParamMap(PARAM_HISTORY, this.historieCheckBox.isSelected());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReportPrintingWidget rpw = new ReportPrintingWidget((Frame)new JFrame(), true);
                rpw.pack();
                rpw.setVisible(true);
            }
        });
    }

    static {
        String tmp = null;
        try {
            tmp = IOUtils.toString((InputStream)ReportPrintingWidget.class.getResourceAsStream("dagreReportingTemplate.html"));
        }
        catch (IOException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        TEMPLATE = tmp;
    }
}

