/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.report.scriptlet;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.wizard.GeometryWorker;
import java.awt.Image;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import org.apache.log4j.Logger;

public class LoadWMSLayer
extends JRDefaultScriptlet {
    private static final Logger LOG = Logger.getLogger(LoadWMSLayer.class);
    private static final String GETMAP_REQUEST = "http://s10221.wuppertal-intra.de:7098/alkis/services?&VERSION=1.1.1&REQUEST=GetMap&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&BBOX=<cismap:boundingBox>&SRS=EPSG:25832&FORMAT=image/png&TRANSPARENT=TRUE&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=alkomf&STYLES=default";
    private static final int MAP_DPI = 300;
    private static final int IMG_HEIGHT = 296;
    private static final int IMG_WIDTH = 542;
    private Polygon bbox;

    protected void retrieveData() {
        FlurstueckCustomBean currentFlurstueck = LagisBroker.getInstance().getCurrentFlurstueck();
        FlurstueckSchluesselCustomBean fsKey = currentFlurstueck.getFlurstueckSchluessel();
        ArrayList<FlurstueckSchluesselCustomBean> fsList = new ArrayList<FlurstueckSchluesselCustomBean>(1);
        fsList.add(fsKey);
        GeometryWorker worker = new GeometryWorker(fsList);
        Object result = worker.call();
        Geometry currentGeom = (Geometry)result.get(fsKey);
        this.bbox = (Polygon)currentGeom.getEnvelope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image generateMap() {
        this.retrieveData();
        ReentrantLock lock = new ReentrantLock();
        SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(GETMAP_REQUEST));
        HeadlessMapProvider mapProvider = new HeadlessMapProvider();
        mapProvider.addLayer((RetrievalServiceLayer)swms);
        mapProvider.setCenterMapOnResize(true);
        XBoundingBox boundingBox = new XBoundingBox((Geometry)this.bbox);
        mapProvider.setBoundingBox(boundingBox);
        Future f = mapProvider.getImage(72, 300, 542.0, 296.0);
        lock.lock();
        try {
            Image image = (Image)f.get();
            return image;
        }
        catch (Exception t) {
            LOG.error((Object)"Error occurred while retrieving WMS image", (Throwable)t);
        }
        finally {
            lock.unlock();
        }
        return null;
    }
}

