/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class SortedList<T>
extends LinkedList<T> {
    Comparator<T> comparator;

    public SortedList(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean add(T e) {
        boolean result = super.add(e);
        Collections.sort(this, this.comparator);
        return result;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        Collections.sort(this, this.comparator);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = super.addAll(c);
        Collections.sort(this, this.comparator);
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = super.addAll(index, c);
        Collections.sort(this, this.comparator);
        return result;
    }

    @Override
    public T remove(int index) {
        Object result = super.remove(index);
        Collections.sort(this, this.comparator);
        return (T)result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        Collections.sort(this, this.comparator);
        return result;
    }

    @Override
    public T set(int index, T element) {
        T result = super.set(index, element);
        Collections.sort(this, this.comparator);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = super.removeAll(c);
        Collections.sort(this, this.comparator);
        return result;
    }
}

