/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.widget;

import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.interfaces.NoPermissionsWidget;
import de.cismet.lagis.interfaces.Widget;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import de.cismet.lagis.widget.RessortFactory;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class AbstractWidget
extends JPanel
implements Widget {
    protected static final Icon DEFAULT_ICON = new ImageIcon(AbstractWidget.class.getResource("/de/cismet/lagis/ressource/icons/titlebar/ressort.png"));
    protected Icon widgetIcon;
    protected String widgetName = "Ressort";
    protected String validationMessage = "Die Komponente ist valide";
    private final Logger log = Logger.getLogger(this.getClass());
    private boolean isCoreWidget = false;
    private boolean isAlwaysWritable = false;
    private final ArrayList<ValidationStateChangedListener> validationListeners = new ArrayList();

    @Override
    public String getWidgetName() {
        return this.widgetName;
    }

    public void setWidgetName(String widgetName) {
        this.widgetName = widgetName;
    }

    @Override
    public Icon getWidgetIcon() {
        if (this.widgetIcon != null) {
            return this.widgetIcon;
        }
        this.widgetIcon = DEFAULT_ICON;
        return DEFAULT_ICON;
    }

    public void setWidgetIcon(String iconName) {
        try {
            this.widgetIcon = new ImageIcon(this.getClass().getResource(iconName));
        }
        catch (Exception ex) {
            this.log.warn((Object)"Fehler beim setzen des Icons: ", (Throwable)ex);
            this.widgetIcon = DEFAULT_ICON;
        }
    }

    @Override
    public abstract void clearComponent();

    @Override
    public abstract void refresh(Object var1);

    @Override
    public abstract void setComponentEditable(boolean var1);

    @Override
    public String getValidationMessage() {
        return this.validationMessage;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public void fireValidationStateChanged(Object validatedObject) {
        for (ValidationStateChangedListener listener : this.validationListeners) {
            listener.validationStateChanged(validatedObject);
        }
    }

    @Override
    public void removeValidationStateChangedListener(ValidationStateChangedListener l) {
        this.validationListeners.remove(l);
    }

    @Override
    public void addValidationStateChangedListener(ValidationStateChangedListener l) {
        this.validationListeners.add(l);
    }

    @Override
    public void showAssistent(Component parent) {
    }

    @Override
    public boolean isWidgetReadOnly() {
        HashMap<Widget, Boolean> ressortPermissions;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"isWidgetReadOnly()");
        }
        if (this instanceof NoPermissionsWidget) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"NoPermissionsWidget");
            }
            return false;
        }
        if (this.isCoreWidget() && !LagisBroker.getInstance().isCoreReadOnlyMode()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Core");
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Kein Core Widget oder CoreIstReadOnly");
        }
        if ((ressortPermissions = RessortFactory.getInstance().getRessortPermissions()) != null) {
            Boolean isReadOnly;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Widget Ressortpermissions vorhanden : " + ressortPermissions));
            }
            if ((isReadOnly = ressortPermissions.get(this)) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Widget Ressortpermissions vorhanden.: " + isReadOnly));
                }
                return isReadOnly != false;
            }
            this.log.info((Object)"Keine Ressortpermission f\u00fcr Widget vorhanden vorhanden und kein CoreWidget oder CoreReadonly ist aktiviert. --> readonly");
            return true;
        }
        this.log.info((Object)"Keine Widget Ressortpermissions vorhanden. und kein CoreWidget oder CoreReadonly ist aktiviert --> readonly");
        return true;
    }

    public boolean isCoreWidget() {
        return this.isCoreWidget;
    }

    public void setIsCoreWidget(boolean isCoreWidget) {
        this.isCoreWidget = isCoreWidget;
    }
}

