/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.widget;

import de.cismet.lagis.interfaces.Widget;
import de.cismet.lagis.widget.AbstractWidget;
import de.cismet.tools.configuration.Configurable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class RessortFactory
implements Configurable {
    private static final Logger LOG = Logger.getLogger(RessortFactory.class);
    private static RessortFactory INSTANCE;
    private final HashMap<String, AbstractWidget> ressorts = new HashMap();
    private final HashMap<Widget, Boolean> ressortPermissions = new HashMap();

    private RessortFactory() {
    }

    public static RessortFactory getInstance() {
        if (INSTANCE == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"RessortFactory initalized");
            }
            INSTANCE = new RessortFactory();
        }
        return INSTANCE;
    }

    public Element getConfiguration() {
        Element ret = new Element("cismapWFSFormsPreferences");
        return ret;
    }

    public void masterConfigure(Element parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RessortFactory MasterConfigure");
        }
        try {
            Element ressortWidgets = (Element)((Element)parent.clone()).getChild("RessortWidgets").detach();
            List list = ressortWidgets.getChildren("RessortWidget");
            for (Element e : list) {
                try {
                    AbstractWidget ressort;
                    String className;
                    Class<?> formClass;
                    Constructor<?> constructor;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Versuche Widget anzulegen: " + e.getChild("widgetName").getText()));
                    }
                    if ((constructor = (formClass = Class.forName(className = e.getChild("className").getText())).getConstructor(String.class)) == null) {
                        constructor = formClass.getConstructor(String.class, String.class);
                        ressort = (AbstractWidget)constructor.newInstance(e.getChild("widgetName").getText(), e.getChild("widgetIcon").getText());
                    } else {
                        ressort = (AbstractWidget)constructor.newInstance(e.getChild("widgetName").getText());
                    }
                    Attribute isReadonly = e.getAttribute("readonly");
                    if (isReadonly != null) {
                        if (isReadonly.getValue() != null && isReadonly.getValue().equals("true")) {
                            this.ressortPermissions.put(ressort, true);
                        } else {
                            this.ressortPermissions.put(ressort, false);
                        }
                    } else {
                        this.ressortPermissions.put(ressort, true);
                    }
                    this.ressorts.put(ressort.getWidgetName(), ressort);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Ressort Widget " + ressort.getWidgetName() + " hinzugef\u00fcgt"));
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Fehler beim erstellen eines Widgets", t);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim MasterConfigure Ressort (z.B. keine Widgets vorhanden)", (Throwable)ex);
        }
    }

    public void configure(Element parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RessortFactory configure");
        }
    }

    public HashMap<String, AbstractWidget> getRessorts() {
        return this.ressorts;
    }

    public HashMap<Widget, Boolean> getRessortPermissions() {
        return this.ressortPermissions;
    }
}

