/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.thread.WFSByKeyWorkerThread;
import de.cismet.lagis.thread.WFSRetrieverFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class GeometryWorker
implements Callable<Map<FlurstueckSchluesselCustomBean, Geometry>> {
    private static final WFSRetrieverFactory WFS_RETR_FACTORY = WFSRetrieverFactory.getInstance();
    private static final Logger LOG = Logger.getLogger(GeometryWorker.class);
    private Exception lastException;
    private final List<FlurstueckSchluesselCustomBean> fsKeys;
    private final ArrayList<Runnable> preExeListeners;
    private final ArrayList<IPostExecutionListener> postExeListeners;
    private final HashMap<FlurstueckSchluesselCustomBean, Geometry> geometriesMap;

    public GeometryWorker(List<FlurstueckSchluesselCustomBean> fsKeys) {
        if (fsKeys == null) {
            throw new NullPointerException("Given list of FlurstueckSchluesser must not be null");
        }
        if (fsKeys.isEmpty()) {
            throw new IllegalArgumentException("Given list of FlurstueckSchluesser must be greater than zero");
        }
        this.fsKeys = new ArrayList<FlurstueckSchluesselCustomBean>(fsKeys);
        this.geometriesMap = new HashMap(fsKeys.size());
        this.preExeListeners = new ArrayList();
        this.postExeListeners = new ArrayList();
    }

    public void addPreExecutionListener(Runnable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.preExeListeners.add(listener);
    }

    public void addPostExecutionListener(IPostExecutionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.postExeListeners.add(listener);
    }

    private void notifyPreExecutionListener() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"notify pre-execution listeners");
        }
        for (Runnable listener : this.preExeListeners) {
            listener.run();
        }
    }

    private void notifyPostExecutionListenerAboutSuccess() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"notify post-execution listeners");
        }
        for (IPostExecutionListener listener : this.postExeListeners) {
            listener.done((Map)this.geometriesMap.clone());
        }
    }

    private void notifyPostExecutionListenerAboutError(Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"notify post-execution listeners about error", (Throwable)this.lastException);
        }
        for (IPostExecutionListener listener : this.postExeListeners) {
            listener.doneWithErrors(this.lastException);
        }
    }

    @Override
    public Map<FlurstueckSchluesselCustomBean, Geometry> call() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"GeometryWorker doInBackground");
        }
        try {
            this.notifyPreExecutionListener();
            for (FlurstueckSchluesselCustomBean currentKey : this.fsKeys) {
                WFSByKeyWorkerThread currentWorker = (WFSByKeyWorkerThread)WFS_RETR_FACTORY.getWFSRetriever(currentKey, null, null);
                currentWorker.execute();
                Geometry currentGeom = (Geometry)currentWorker.get();
                this.geometriesMap.put(currentWorker.getFlurstueckKey(), currentGeom);
            }
            this.notifyPostExecutionListenerAboutSuccess();
            return this.geometriesMap;
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while checking geometry: ", (Throwable)ex);
            this.notifyPostExecutionListenerAboutError(ex);
            return null;
        }
    }

    public static interface IPostExecutionListener {
        public void done(Map<FlurstueckSchluesselCustomBean, Geometry> var1);

        public void doneWithErrors(Exception var1);
    }
}

