/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import de.cismet.cids.custom.beans.lagis.FlurstueckArtCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.Insets;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardController;

public class ChangeKindActionPanel
extends JPanel
implements ValidationStateChangedListener,
ChangeListener {
    public static final String KEY_CHANGE_CANDIDATE = "changeCandidate";
    public static final String KEY_NEW_KIND = "newKind";
    private final Logger log = Logger.getLogger(this.getClass());
    private final WizardController wizardController;
    private final Map wizardData;
    private final ButtonGroup rbGroup;
    private boolean isDeactivated = true;
    private final Icon icoStaedtisch = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/current.png"));
    private final Icon icoAbteilungIX = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/abteilungIX.png"));
    private final Icon icoStaedtischHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic.png"));
    private final Icon icoAbteilungIXHistoric = new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic_abteilungIX.png"));
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JLabel lblAbteilungIX;
    private JLabel lblStaedtisch;
    private FlurstueckChooser panChangeKind;
    private JRadioButton rbAbteilungIX;
    private JRadioButton rbStaedtisch;

    public ChangeKindActionPanel(WizardController wizardController, Map wizardData) {
        this.initComponents();
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        wizardController.setProblem("Bitte w\u00e4hlen Sie das Flurst\u00fcck aus, dessen Art ge\u00e4ndert werden soll");
        this.panChangeKind.addValidationStateChangedListener(this);
        this.rbGroup = new ButtonGroup();
        this.rbGroup.add(this.rbStaedtisch);
        this.rbGroup.add(this.rbAbteilungIX);
        this.rbStaedtisch.getModel().addChangeListener(this);
        this.rbAbteilungIX.getModel().addChangeListener(this);
        this.rbStaedtisch.setEnabled(false);
        this.rbAbteilungIX.setEnabled(false);
        this.panChangeKind.requestFlurstueck(LagisBroker.getInstance().getCurrentFlurstueckSchluessel());
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        if (this.panChangeKind.getStatus() != 0) {
            this.wizardController.setProblem(this.panChangeKind.getValidationMessage());
            this.rbStaedtisch.setEnabled(false);
            this.rbAbteilungIX.setEnabled(false);
            this.isDeactivated = true;
            return;
        }
        try {
            if (this.isDeactivated || validatedObject != null && validatedObject instanceof FlurstueckChooser) {
                this.isDeactivated = false;
                this.rbStaedtisch.setEnabled(true);
                this.rbAbteilungIX.setEnabled(true);
                if (this.panChangeKind.getCurrentFlurstueckSchluessel().getFlurstueckArt().getBezeichnung().equals("st\u00e4dtisch")) {
                    this.rbAbteilungIX.setSelected(true);
                } else {
                    this.rbStaedtisch.setSelected(true);
                }
            }
            if (this.rbStaedtisch.isSelected() || this.rbAbteilungIX.isSelected()) {
                FlurstueckArtCustomBean newArt = null;
                if (this.rbStaedtisch.getModel().equals(this.rbGroup.getSelection())) {
                    if (this.panChangeKind.getCurrentFlurstueckSchluessel().getFlurstueckArt().getBezeichnung().equals("st\u00e4dtisch")) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Flurst\u00fcck ist st\u00e4dtisch");
                        }
                        this.wizardController.setProblem("Flurst\u00fcck ist bereits st\u00e4dtisch");
                        return;
                    }
                    for (FlurstueckArtCustomBean currentArt : LagisBroker.getInstance().getAllFlurstueckArten()) {
                        if (!currentArt.getBezeichnung().equals("st\u00e4dtisch")) continue;
                        newArt = currentArt;
                    }
                } else if (this.rbAbteilungIX.getModel().equals(this.rbGroup.getSelection())) {
                    if (this.panChangeKind.getCurrentFlurstueckSchluessel().getFlurstueckArt().getBezeichnung().equals("Abteilung IX")) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Flurst\u00fcck ist Abteilung IX zugeordnet");
                        }
                        this.wizardController.setProblem("Flurst\u00fcck ist bereits Abteilung IX zugeordnet");
                        return;
                    }
                    for (FlurstueckArtCustomBean currentArt : LagisBroker.getInstance().getAllFlurstueckArten()) {
                        if (!currentArt.getBezeichnung().equals("Abteilung IX")) continue;
                        newArt = currentArt;
                    }
                }
                if (newArt == null) {
                    this.wizardController.setProblem("Gew\u00e4hlte Art kommt in der Datenbank nicht vor");
                    return;
                }
                CidsBean sperre = LagisBroker.getInstance().isLocked(this.panChangeKind.getCurrentFlurstueckSchluessel());
                if (sperre != null) {
                    this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck ist gesperrt von Benutzer: " + (String)sperre.getProperty("user_string"));
                    return;
                }
                this.wizardData.put(KEY_CHANGE_CANDIDATE, this.panChangeKind.getCurrentFlurstueckSchluessel());
                this.wizardData.put(KEY_NEW_KIND, newArt);
                this.wizardController.setProblem(null);
                this.wizardController.setForwardNavigationMode(1);
                return;
            }
            this.wizardController.setProblem("Bitte w\u00e4hlen Sie die neue Art des Flurst\u00fccks aus");
        }
        catch (NullPointerException ex) {
            this.log.error((Object)"Flurst\u00fcck besitzt keine Art", (Throwable)ex);
            this.wizardController.setProblem("Flurst\u00fcck besitzt keine Art");
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.rbStaedtisch.getModel())) {
            if (this.rbStaedtisch.isSelected()) {
                this.lblStaedtisch.setIcon(this.icoStaedtisch);
            } else {
                this.lblStaedtisch.setIcon(this.icoStaedtischHistoric);
            }
            this.validationStateChanged(this);
        } else {
            if (this.rbAbteilungIX.isSelected()) {
                this.lblAbteilungIX.setIcon(this.icoAbteilungIX);
            } else {
                this.lblAbteilungIX.setIcon(this.icoAbteilungIXHistoric);
            }
            this.validationStateChanged(this);
        }
    }

    private void initComponents() {
        this.panChangeKind = new FlurstueckChooser();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.rbStaedtisch = new JRadioButton();
        this.rbAbteilungIX = new JRadioButton();
        this.lblStaedtisch = new JLabel();
        this.lblAbteilungIX = new JLabel();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 381, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        this.jLabel1.setText("Flurst\u00fcck:");
        this.jLabel2.setText("Neue Zuordnung:");
        this.rbStaedtisch.setText("St\u00e4dtisch");
        this.rbStaedtisch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbStaedtisch.setMargin(new Insets(0, 0, 0, 0));
        this.rbAbteilungIX.setText("Abteilung IX");
        this.rbAbteilungIX.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbAbteilungIX.setMargin(new Insets(0, 0, 0, 0));
        this.lblStaedtisch.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic.png")));
        this.lblAbteilungIX.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/lagis/ressource/icons/toolbar/historic_abteilungIX.png")));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1)).addComponent(this.panChangeKind, -2, 355, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblStaedtisch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbStaedtisch, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblAbteilungIX).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbAbteilungIX, -2, 97, -2))).addContainerGap(15, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panChangeKind, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblStaedtisch).addComponent(this.rbStaedtisch, -2, 22, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rbAbteilungIX, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.lblAbteilungIX, GroupLayout.Alignment.TRAILING))).addContainerGap(129, Short.MAX_VALUE)));
    }
}

