/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.panels;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.panels.FlurstueckChooser;
import de.cismet.lagis.validation.ValidationStateChangedListener;
import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardController;

public class SplitActionChoosePanel
extends JPanel
implements ChangeListener,
ValidationStateChangedListener {
    public static final String KEY_SPLIT_CANDIDATE = "splitCandidate";
    public static final String KEY_SPLIT_COUNT = "splitCount";
    public static final String SPLIT_ACTION_MODE = "splitAction";
    public static final String SPLIT_JOIN_ACTION_MODE = "splitJoinAction";
    private final Logger log = Logger.getLogger(this.getClass());
    private final WizardController wizardController;
    private Map wizardData;
    private final SpinnerNumberModel spinnerModel;
    private final String mode;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JLabel lblSplitResult;
    private FlurstueckChooser panSplit;
    private JSpinner spnSplitCount;

    public SplitActionChoosePanel(WizardController wizardController, Map wizardData, String mode) {
        this.initComponents();
        this.mode = mode;
        this.wizardController = wizardController;
        this.wizardData = wizardData;
        this.spinnerModel = new SpinnerNumberModel(2, 2, 100, 1);
        this.spnSplitCount.setModel(this.spinnerModel);
        if (mode.equals(SPLIT_ACTION_MODE)) {
            wizardController.setProblem("Bitte w\u00e4hlen Sie das Flurst\u00fcck aus, das gesplittet werden soll");
            this.panSplit.addValidationStateChangedListener(this);
        } else if (mode.equals(SPLIT_JOIN_ACTION_MODE)) {
            this.validationStateChanged(this);
            this.panSplit.setVisible(false);
            this.jLabel1.setVisible(false);
            this.remove(this.panSplit);
            this.remove(this.jLabel1);
        }
        this.spnSplitCount.addChangeListener(this);
        this.panSplit.requestFlurstueck(LagisBroker.getInstance().getCurrentFlurstueckSchluessel());
    }

    public void refresh(Map wizardData) {
        this.wizardData = wizardData;
        this.validationStateChanged(this);
    }

    @Override
    public void validationStateChanged(Object validatedObject) {
        int splitCount = 0;
        if (this.mode.equals(SPLIT_ACTION_MODE) && this.panSplit.getStatus() != 0) {
            this.wizardController.setProblem(this.panSplit.getValidationMessage());
            return;
        }
        String result = String.valueOf(this.spnSplitCount.getValue());
        try {
            splitCount = Integer.parseInt(result);
            if (splitCount < 2) {
                this.wizardController.setProblem("Es m\u00fcssen mindestens zwei neue Flurst\u00fccke entstehen");
                return;
            }
        }
        catch (NumberFormatException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Eingabe ist keine Zahl");
            }
            this.wizardController.setProblem("Bitte geben Sie die Anzahl der neuen Flurst\u00fccke");
            return;
        }
        if (this.mode.equals(SPLIT_ACTION_MODE)) {
            if (this.panSplit.getStatus() == 0) {
                CidsBean sperre = LagisBroker.getInstance().isLocked(this.panSplit.getCurrentFlurstueckSchluessel());
                if (sperre != null) {
                    this.wizardController.setProblem("Ausgew\u00e4hltes Flurst\u00fcck ist gesperrt von Benutzer: " + (String)sperre.getProperty("user_string"));
                    return;
                }
                this.wizardData.put(KEY_SPLIT_CANDIDATE, this.panSplit.getCurrentFlurstueckSchluessel());
                this.wizardData.put(KEY_SPLIT_COUNT, splitCount);
                this.wizardController.setProblem(null);
                this.wizardController.setForwardNavigationMode(1);
            }
        } else if (this.mode.equals(SPLIT_JOIN_ACTION_MODE)) {
            this.wizardData.put(KEY_SPLIT_COUNT, splitCount);
            this.wizardController.setProblem(null);
            this.wizardController.setForwardNavigationMode(1);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validationStateChanged(this);
    }

    private void enableChildren(Container container, boolean isEnabled) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof Container) {
                this.enableChildren((Container)components[i], isEnabled);
            }
            components[i].setEnabled(isEnabled);
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.lblSplitResult = new JLabel();
        this.spnSplitCount = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.panSplit = new FlurstueckChooser();
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 381, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        this.lblSplitResult.setText("Anzahl neuer Flurst\u00fccke:");
        this.jLabel1.setText("Flurst\u00fcck:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblSplitResult).addGap(234, 234, 234)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(324, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.spnSplitCount, -2, 120, -2).addContainerGap(231, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 361, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panSplit, -2, 355, -2).addContainerGap(16, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSplitResult).addGap(14, 14, 14).addComponent(this.spnSplitCount, -2, -1, -2).addGap(14, 14, 14).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panSplit, -2, -1, -2)));
    }
}

