/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.ActivateActionPanel;
import java.awt.EventQueue;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class ActivateActionSteps
extends WizardPanelProvider {
    public ActivateActionSteps() {
        super("Flurst\u00fcck aktivieren...", new String[]{"Flurst\u00fcck ausw\u00e4hlen"}, new String[]{"Auswahl des Flurst\u00fccks"});
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        return new ActivateActionPanel(wizardController, wizardData);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map settings) throws WizardException {
        return new BackgroundResultCreator();
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        BackgroundResultCreator() {
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WizardFinisher: Flurstueck aktivieren: ");
            }
            assert (!EventQueue.isDispatchThread());
            final FlurstueckSchluesselCustomBean activationCandidate = (FlurstueckSchluesselCustomBean)wizardData.get("activateCandidate");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fcck das aktiviert werden soll: " + activationCandidate.getKeyString()));
            }
            CidsBean sperre = null;
            try {
                CidsBean other = LagisBroker.getInstance().isLocked(activationCandidate);
                if (other == null) {
                    sperre = LagisBroker.getInstance().createFlurstueckSchluesselLock(activationCandidate);
                    if (sperre != null) {
                        progress.setBusy("Flurst\u00fcck wird aktiviert");
                        LagisBroker.getInstance().setFlurstueckActive(activationCandidate);
                        LagisBroker.getInstance().releaseLock(sperre);
                        if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() != null && FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), activationCandidate)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Aktuelles flurst\u00fcck wurde aktiviert --> update");
                            }
                            try {
                                LagisBroker.getInstance().loadFlurstueck(activationCandidate);
                            }
                            catch (Exception ex) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)"Fehler beim updaten/laden der FlurstueckSchluessel/Flurst\u00fccks", (Throwable)ex);
                                }
                            }
                        } else {
                            final boolean changeFlurstueck = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie zu dem aktivierten Flurst\u00fcck wechseln?", "Flurst\u00fcckwechsel", 0) == 0;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (changeFlurstueck) {
                                        LagisBroker.getInstance().loadFlurstueck(activationCandidate);
                                    } else {
                                        LagisBroker.getInstance().reloadFlurstueckKeys();
                                    }
                                }
                            });
                        }
                        Summary summary = Summary.create((String)("Flurst\u00fcck: \n\"" + activationCandidate.getKeyString() + " konnte erfolgreich aktiviert werden"), (Object)activationCandidate);
                        progress.finished((Object)summary);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Flurst\u00fcck konnte erfolgreich aktiviert werden: ");
                        }
                    } else {
                        progress.failed("Es war nicht m\u00f6glich die Art des Flurst\u00fccks:\n\t\"" + activationCandidate.getKeyString() + "\"\nzu \u00e4ndern, es konnte keine Sperre angelegt werden.", false);
                    }
                } else {
                    progress.failed("Es war nicht m\u00f6glich die Art des Flurst\u00fccks:\n\t\"" + activationCandidate.getKeyString() + "\"\nzu \u00e4ndern, es ist von einem anderen Benutzer gesperrt: " + (String)other.getProperty("user_string"), false);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Fehler beim renamen eines Flurst\u00fccks: ", (Throwable)e);
                try {
                    LagisBroker.getInstance().releaseLock(sperre);
                }
                catch (Exception ex) {
                    this.log.error((Object)"Fehler beim l\u00f6sen der Sperre", (Throwable)ex);
                }
                StringBuffer buffer = new StringBuffer("Flurst\u00fcck: \n\"" + activationCandidate.getKeyString() + " konnte nicht aktiviert werden. Fehler:\n");
                if (e instanceof ActionNotSuccessfulException) {
                    ActionNotSuccessfulException reason = (ActionNotSuccessfulException)e;
                    if (reason.hasNestedExceptions()) {
                        this.log.error((Object)"Nested Rename Exceptions: ", (Throwable)reason.getNestedExceptions());
                    }
                    buffer.append(reason.getMessage());
                } else {
                    this.log.error((Object)"Unbekannter Fehler: ", (Throwable)e);
                    buffer.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                }
                progress.failed(buffer.toString(), false);
            }
        }
    }
}

