/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.HistoricActionPanel;
import java.awt.EventQueue;
import java.util.Date;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class HistoricActionSteps
extends WizardPanelProvider {
    public HistoricActionSteps() {
        super("Flurst\u00fcck historisch setzen...", new String[]{"Flurst\u00fcck ausw\u00e4hlen"}, new String[]{"Auswahl des Flurst\u00fccks"});
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        return new HistoricActionPanel(wizardController, wizardData);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map settings) throws WizardException {
        return new BackgroundResultCreator();
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        BackgroundResultCreator() {
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WizardFinisher: Flurstueck historisch setzen: ");
            }
            assert (!EventQueue.isDispatchThread());
            final FlurstueckSchluesselCustomBean historicKey = (FlurstueckSchluesselCustomBean)wizardData.get("historicCandidate");
            Date histDate = (Date)wizardData.get("historicDate");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fcck das historisch gesetzt werden soll: " + historicKey.getKeyString()));
            }
            CidsBean sperre = null;
            try {
                progress.setBusy("Flurst\u00fcck wird historisch gesetzt");
                CidsBean other = LagisBroker.getInstance().isLocked(historicKey);
                if (other == null) {
                    sperre = LagisBroker.getInstance().createFlurstueckSchluesselLock(historicKey);
                    if (sperre != null) {
                        System.out.println("datum:" + histDate);
                        LagisBroker.getInstance().setFlurstueckHistoric(historicKey, histDate, true);
                        LagisBroker.getInstance().releaseLock(sperre);
                        if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() != null && FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), historicKey)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Aktuelles flurst\u00fcck wurde historisch --> update");
                            }
                            try {
                                LagisBroker.getInstance().loadFlurstueck(historicKey);
                            }
                            catch (Exception ex) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)"Fehler beim updaten/laden der FlurstueckSchluessel/Flurst\u00fccks", (Throwable)ex);
                                }
                            }
                        } else {
                            final boolean changeFlurstueck = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie zu dem Flurst\u00fcck wechseln?", "Flurst\u00fcckwechsel", 0) == 0;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (changeFlurstueck) {
                                        LagisBroker.getInstance().loadFlurstueck(historicKey);
                                    } else {
                                        LagisBroker.getInstance().reloadFlurstueckKeys();
                                    }
                                }
                            });
                        }
                        Summary summary = Summary.create((String)("Flurst\u00fcck: \n\t\"" + historicKey.getKeyString() + "\" \n\nkonnte erfolgreich historisch gesetzt werden"), (Object)historicKey);
                        progress.finished((Object)summary);
                    } else {
                        progress.failed("Es war nicht m\u00f6glich das Flurst\u00fcck:\n\t\"" + historicKey.getKeyString() + "\"\nhistorisch zu setzen, es konnte keine Sperre angelegt werden.", false);
                    }
                } else {
                    progress.failed("Es war nicht m\u00f6glich das Flurst\u00fcck:\n\t\"" + historicKey.getKeyString() + "\"\nhistorisch zu setzen, es ist von einem anderen Benutzer gesperrt: " + (String)other.getProperty("user_string"), false);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Fehler beim historischsetzen eines Flurst\u00fccks: ", (Throwable)e);
                try {
                    LagisBroker.getInstance().releaseLock(sperre);
                }
                catch (Exception ex) {
                    this.log.error((Object)"Fehler beim l\u00f6sen der Sperre", (Throwable)ex);
                }
                StringBuffer buffer = new StringBuffer("Es war nicht m\u00f6glich das Flurst\u00fcck:\n\t\"" + historicKey.getKeyString() + "\"\nhistorisch zu setzen bzw. zu l\u00f6schen. Fehler:\n");
                if (e instanceof ActionNotSuccessfulException) {
                    ActionNotSuccessfulException reason = (ActionNotSuccessfulException)e;
                    if (reason.hasNestedExceptions()) {
                        this.log.error((Object)"Nested setFlurstueckHistoric Exceptions: ", (Throwable)reason.getNestedExceptions());
                    }
                    buffer.append(reason.getMessage());
                } else {
                    this.log.error((Object)"Unbekannter Fehler: ", (Throwable)e);
                    buffer.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                }
                progress.failed(buffer.toString(), false);
            }
        }
    }
}

