/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckCustomBean;
import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.JoinActionChoosePanel;
import de.cismet.lagis.wizard.panels.ResultingPanel;
import de.cismet.lagis.wizard.panels.SummaryPanel;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class JoinActionSteps
extends WizardPanelProvider {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private ResultingPanel resultingPanel;
    private SummaryPanel summaryPanel;
    private JoinActionChoosePanel joinPanel;
    private final Map wizardData = new HashMap();

    public JoinActionSteps() {
        super("Flurst\u00fcck umbenennen...", new String[]{"Zusammenlegen", "Ergebnis", "Zusammenfassung"}, new String[]{"Auswahl der Flurst\u00fccke", "Flurst\u00fcck anlegen", "Zusammenfassung"});
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        switch (this.indexOfStep(id)) {
            case 0: {
                this.joinPanel = new JoinActionChoosePanel(wizardController, this.wizardData);
                return this.joinPanel;
            }
            case 1: {
                this.resultingPanel = new ResultingPanel(wizardController, this.wizardData, "joinAction");
                return this.resultingPanel;
            }
            case 2: {
                this.summaryPanel = new SummaryPanel();
                this.summaryPanel.refresh(this.wizardData);
                return this.summaryPanel;
            }
        }
        throw new IllegalArgumentException(id);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map settings) throws WizardException {
        return new BackgroundResultCreator(this.wizardData);
    }

    protected void recycleExistingPanel(String id, WizardController controller, Map wizardData, JComponent panel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Recycle existing panel: " + id));
        }
        controller.setProblem(null);
        controller.setBusy(false);
        if (this.joinPanel == panel) {
            this.joinPanel.refresh(this.wizardData);
        } else if (this.resultingPanel == panel) {
            this.resultingPanel.refresh(this.wizardData);
        } else if (this.summaryPanel == panel) {
            this.summaryPanel.refresh(this.wizardData);
        } else {
            this.log.warn((Object)("recycleExistingPanel(): Unknown panel " + panel));
        }
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Map wizardData;
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        public BackgroundResultCreator(Map wizardData) {
            this.wizardData = wizardData;
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                return;
            }
            wizardData = this.wizardData;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WizardFinisher: Flurstueck joinen: ");
            }
            assert (!EventQueue.isDispatchThread());
            final FlurstueckSchluesselCustomBean joinKey = (FlurstueckSchluesselCustomBean)wizardData.get("joinKey");
            final ArrayList joinKeys = (ArrayList)wizardData.get("joinCandidates");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fccke die gejoined werden sollen: " + joinKeys));
                this.log.debug((Object)("Flurst\u00fcck das entsteht : " + (joinKey == null ? "null" : joinKey.getKeyString())));
            }
            try {
                progress.setBusy("Flurst\u00fcck wird gejoined");
                joinKey.setFlurstueckArt(((FlurstueckSchluesselCustomBean)joinKeys.get(0)).getFlurstueckArt());
                FlurstueckCustomBean newFlurstueck = LagisBroker.getInstance().joinFlurstuecke(joinKeys, joinKey, LagisBroker.getInstance().getAccountName());
                StringBuffer resultString = new StringBuffer("Die Flurst\u00fccke:\n");
                Iterator it = joinKeys.iterator();
                while (it.hasNext()) {
                    resultString.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)it.next()).getKeyString()).append("\"");
                }
                resultString.append("\n\nkonnten erfolgreich zu dem Flurst\u00fcck:\n\n\t\"").append(joinKey.getKeyString()).append("\" \n\n vereinigt werden");
                if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() != null && FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), joinKey)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Das aktuelle Flurst\u00fcck ist == dem zusammengelegetn");
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LagisBroker.getInstance().loadFlurstueck(joinKey);
                        }
                    });
                } else {
                    boolean isCurrentFlurstueckChanged = false;
                    for (FlurstueckSchluesselCustomBean current : joinKeys) {
                        if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() == null || !FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), current)) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Das aktuelle Flurst\u00fcck geh\u00f6rt zu den zusammengelegten Flurst\u00fccken");
                        }
                        isCurrentFlurstueckChanged = true;
                    }
                    if (isCurrentFlurstueckChanged) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (FlurstueckSchluesselCustomBean key : joinKeys) {
                                    if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() == null || !FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), key)) continue;
                                    LagisBroker.getInstance().loadFlurstueck(key);
                                }
                            }
                        });
                    }
                    final boolean changeFlurstueck = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie zu dem neuangelegten Flurst\u00fcck wechseln?", "Flurst\u00fcckwechsel", 0) == 0;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (changeFlurstueck) {
                                LagisBroker.getInstance().loadFlurstueck(joinKey);
                            } else {
                                LagisBroker.getInstance().reloadFlurstueckKeys();
                            }
                        }
                    });
                }
                Summary summary = Summary.create((String)resultString.toString(), (Object)joinKeys);
                progress.finished((Object)summary);
            }
            catch (Exception ex) {
                StringBuffer resultString = new StringBuffer("Die Flurst\u00fccke:");
                Iterator it = joinKeys.iterator();
                while (it.hasNext()) {
                    resultString.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)it.next()).getKeyString()).append("\"");
                }
                resultString.append("\nkonnten nicht erfolgreich zu dem Flurst\u00fcck:\n\t\"").append(joinKey.getKeyString()).append("\" \n\n vereinigt werden. Fehler:\n");
                if (ex instanceof ActionNotSuccessfulException) {
                    ActionNotSuccessfulException reason = (ActionNotSuccessfulException)ex;
                    if (reason.hasNestedExceptions()) {
                        this.log.error((Object)"Nested Rename Exceptions: ", (Throwable)reason.getNestedExceptions());
                    }
                    resultString.append(reason.getMessage());
                } else {
                    this.log.error((Object)"Unbekannter Fehler: ", (Throwable)ex);
                    resultString.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                }
                progress.failed(resultString.toString(), false);
            }
        }
    }
}

