/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagis.wizard.steps;

import de.cismet.cids.custom.beans.lagis.FlurstueckSchluesselCustomBean;
import de.cismet.lagis.Exception.ActionNotSuccessfulException;
import de.cismet.lagis.broker.LagisBroker;
import de.cismet.lagis.gui.main.LagisApp;
import de.cismet.lagis.wizard.panels.JoinActionChoosePanel;
import de.cismet.lagis.wizard.panels.ResultingPanel;
import de.cismet.lagis.wizard.panels.SplitActionChoosePanel;
import de.cismet.lagis.wizard.panels.SummaryPanel;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPanelProvider;

public class JoinSplitActionSteps
extends WizardPanelProvider {
    private final Map wizardData;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private ResultingPanel resultingPanel;
    private SummaryPanel summaryPanel;
    private JoinActionChoosePanel joinPanel;
    private SplitActionChoosePanel splitPanel;

    public JoinSplitActionSteps() {
        super("Flurst\u00fcck zusammenlegen/teilen...", new String[]{"Zusammenlegen", "Teilen", "Ergebnis", "Zusammenfassung"}, new String[]{"Zusammenlegen", "Teilen", "Anlegen", "Zusammenfassung"});
        this.wizardData = new HashMap();
    }

    protected JComponent createPanel(WizardController wizardController, String id, Map wizardData) {
        switch (this.indexOfStep(id)) {
            case 0: {
                this.joinPanel = new JoinActionChoosePanel(wizardController, this.wizardData);
                return this.joinPanel;
            }
            case 1: {
                this.splitPanel = new SplitActionChoosePanel(wizardController, this.wizardData, "splitJoinAction");
                return this.splitPanel;
            }
            case 2: {
                this.resultingPanel = new ResultingPanel(wizardController, this.wizardData, "splitJoinAction");
                return this.resultingPanel;
            }
            case 3: {
                this.summaryPanel = new SummaryPanel();
                this.summaryPanel.refresh(this.wizardData);
                return this.summaryPanel;
            }
        }
        throw new IllegalArgumentException(id);
    }

    public boolean cancel(Map settings) {
        boolean dialogShouldClose = JOptionPane.showConfirmDialog(LagisApp.getInstance(), "M\u00f6chten Sie den Bearbeitungsvorgang beenden?") == 0;
        return dialogShouldClose;
    }

    protected Object finish(Map settings) throws WizardException {
        return new BackgroundResultCreator(this.wizardData);
    }

    protected void recycleExistingPanel(String id, WizardController controller, Map wizardData, JComponent panel) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Recycle existing panel: " + id));
        }
        controller.setProblem(null);
        controller.setBusy(false);
        if (this.joinPanel == panel) {
            this.joinPanel.refresh(this.wizardData);
        } else if (this.splitPanel == panel) {
            this.splitPanel.refresh(this.wizardData);
        } else if (this.resultingPanel == panel) {
            this.resultingPanel.refresh(this.wizardData);
        } else if (this.summaryPanel == panel) {
            this.summaryPanel.refresh(this.wizardData);
        } else {
            this.log.warn((Object)("recycleExistingPanel(): Unknown panel " + panel));
        }
    }

    static class BackgroundResultCreator
    extends DeferredWizardResult {
        private final Map wizardData;
        private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

        public BackgroundResultCreator(Map wizardData) {
            this.wizardData = wizardData;
        }

        public void start(Map wizardData, ResultProgressHandle progress) {
            if (!LagisBroker.getInstance().checkFlurstueckWizardUserWantsToFinish()) {
                progress.failed("Die Aktion wurde durch den Benutzer abgebrochen.", true);
                return;
            }
            wizardData = this.wizardData;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WizardFinisher: Flurstueck joinen/splitten: ");
            }
            assert (!EventQueue.isDispatchThread());
            ArrayList joinKeys = (ArrayList)wizardData.get("joinCandidates");
            ArrayList splitKeys = (ArrayList)wizardData.get("splitKeys");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flurst\u00fccke die zusammengelegt werden sollen: " + joinKeys));
                this.log.debug((Object)("Flurst\u00fcck die geteilt werden sollen: " + splitKeys));
            }
            try {
                progress.setBusy("Flurst\u00fcck wird geteilt");
                for (FlurstueckSchluesselCustomBean current : splitKeys) {
                    current.setFlurstueckArt(((FlurstueckSchluesselCustomBean)joinKeys.get(0)).getFlurstueckArt());
                }
                LagisBroker.getInstance().joinSplitFlurstuecke(joinKeys, splitKeys, LagisBroker.getInstance().getAccountName());
                StringBuffer resultString = new StringBuffer("Die Flurst\u00fccke:");
                Iterator joinIt = joinKeys.iterator();
                while (joinIt.hasNext()) {
                    resultString.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)joinIt.next()).getKeyString()).append("\"");
                }
                resultString.append("\n\nkonnten erfolgreich in die Flurst\u00fccke\n\n");
                Iterator splitIt = splitKeys.iterator();
                while (splitIt.hasNext()) {
                    resultString.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)splitIt.next()).getKeyString()).append("\"");
                }
                resultString.append("\n\n aufgeteilt werden");
                boolean isCurrentFlurstueckChanged = false;
                FlurstueckSchluesselCustomBean tmp = null;
                for (FlurstueckSchluesselCustomBean current : joinKeys) {
                    if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() == null || !FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), current)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Das aktuelle Flurst\u00fcck geh\u00f6rt zu den zusammengelegten Flurst\u00fccken");
                    }
                    isCurrentFlurstueckChanged = true;
                    tmp = current;
                    break;
                }
                if (!isCurrentFlurstueckChanged) {
                    for (FlurstueckSchluesselCustomBean current : splitKeys) {
                        if (LagisBroker.getInstance().getCurrentFlurstueckSchluessel() == null || !FlurstueckSchluesselCustomBean.FLURSTUECK_EQUALATOR.pedanticEquals(LagisBroker.getInstance().getCurrentFlurstueckSchluessel(), current)) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Das aktuelle Flurst\u00fcck geh\u00f6rt zu den gesplitteten Flurst\u00fccken");
                        }
                        isCurrentFlurstueckChanged = true;
                        tmp = current;
                        break;
                    }
                }
                final FlurstueckSchluesselCustomBean keyToReload = tmp;
                if (isCurrentFlurstueckChanged) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LagisBroker.getInstance().loadFlurstueck(keyToReload);
                        }
                    });
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LagisBroker.getInstance().reloadFlurstueckKeys();
                        }
                    });
                }
                Summary summary = Summary.create((String)resultString.toString(), (Object)splitKeys);
                progress.finished((Object)summary);
            }
            catch (Exception e) {
                this.log.error((Object)"Fehler beim joinSplit von Flurst\u00fccken: ", (Throwable)e);
                StringBuffer buffer = new StringBuffer("Die Flurst\u00fccke:");
                Iterator joinIt = joinKeys.iterator();
                while (joinIt.hasNext()) {
                    buffer.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)joinIt.next()).getKeyString()).append("\"");
                }
                buffer.append("\n\nkonnten nicht in die Flurst\u00fccke\n\n");
                Iterator splitIt = splitKeys.iterator();
                while (splitIt.hasNext()) {
                    buffer.append("\n\t\"").append(((FlurstueckSchluesselCustomBean)splitIt.next()).getKeyString()).append("\"");
                }
                buffer.append("\n\n aufgeteilt werden. Fehler:\n ");
                if (e instanceof ActionNotSuccessfulException) {
                    ActionNotSuccessfulException reason = (ActionNotSuccessfulException)e;
                    if (reason.hasNestedExceptions()) {
                        this.log.error((Object)"Nested joinSplit Exceptions: ", (Throwable)reason.getNestedExceptions());
                    }
                    buffer.append(reason.getMessage());
                } else {
                    this.log.error((Object)"Unbekannter Fehler: ", (Throwable)e);
                    buffer.append("Unbekannter Fehler bitte wenden Sie sich an Ihren Systemadministrator");
                }
                progress.failed(buffer.toString(), false);
            }
        }
    }
}

