/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.lagisEE.entity.core;

import de.cismet.cids.custom.beans.lagis.AnlageklasseCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungBuchungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungCustomBean;
import de.cismet.cids.custom.beans.lagis.NutzungsartCustomBean;
import de.cismet.lagis.Exception.BuchungNotInNutzungException;
import de.cismet.lagis.Exception.IllegalNutzungStateException;
import de.cismet.lagisEE.interfaces.Equalator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;

public interface NutzungsBuchung
extends Cloneable {
    public static final NutzungsHistoryEqualator NUTZUNG_HISTORY_EQUALATOR = new NutzungsHistoryEqualator();
    public static final Comparator<NutzungBuchungCustomBean> DATE_COMPARATOR = new Comparator<NutzungBuchungCustomBean>(){

        @Override
        public int compare(NutzungBuchungCustomBean n1, NutzungBuchungCustomBean n2) {
            if (n1.getGueltigbis() == null && n2.getGueltigbis() == null) {
                return 0;
            }
            if (n2.getGueltigbis() == null) {
                return -1;
            }
            if (n1.getGueltigbis() == null) {
                return 1;
            }
            return n1.getGueltigbis().compareTo(n2.getGueltigbis());
        }
    };

    public Integer getId();

    public void setId(Integer var1);

    public String getBemerkung();

    public void setBemerkung(String var1);

    public AnlageklasseCustomBean getAnlageklasse();

    public void setAnlageklasse(AnlageklasseCustomBean var1);

    public NutzungsartCustomBean getNutzungsart();

    public void setNutzungsart(NutzungsartCustomBean var1);

    public Integer getFlaeche();

    public void setFlaeche(Integer var1);

    public Double getQuadratmeterpreis();

    public void setQuadratmeterpreis(Double var1);

    public Date getGueltigbis();

    public void setGueltigbis(Date var1);

    public Date getGueltigvon();

    public void setGueltigvon(Date var1);

    public Double getGesamtpreis();

    public void flipBuchungsBuchwert() throws IllegalNutzungStateException, BuchungNotInNutzungException;

    public boolean isBuchwertFlippable();

    public String getPrettyString();

    public NutzungBuchungCustomBean cloneBuchung();

    public boolean getIstBuchwert();

    public void setIstBuchwert(boolean var1);

    public boolean getSollGeloeschtWerden();

    public void setSollGeloeschtWerden(boolean var1);

    public NutzungCustomBean getNutzung();

    public void setNutzung(NutzungCustomBean var1);

    public static class NutzungsHistoryEqualator
    implements Equalator<NutzungBuchungCustomBean> {
        @Override
        public boolean pedanticEquals(NutzungBuchungCustomBean n1, NutzungBuchungCustomBean n2) {
            return this.determineUnequalFields(n1, n2).isEmpty();
        }

        public Collection<NUTZUNG_BUCHUNG_FIELDS> determineUnequalFields(NutzungBuchungCustomBean n1, NutzungBuchungCustomBean n2) {
            HashSet<NUTZUNG_BUCHUNG_FIELDS> result = new HashSet<NUTZUNG_BUCHUNG_FIELDS>();
            if (n1 != null && n2 != null) {
                if (!(n1.getAnlageklasse() != null && n2.getAnlageklasse() != null && n1.getAnlageklasse().equals(n2.getAnlageklasse()) || n1.getAnlageklasse() == null && n2.getAnlageklasse() == null)) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.ANLAGEKLASSE);
                }
                if (!(n1.getNutzungsart() != null && n2.getNutzungsart() != null && n1.getNutzungsart().equals(n2.getNutzungsart()) || n1.getNutzungsart() == null && n2.getNutzungsart() == null)) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.NUTZUNGSART);
                }
                if (!(n1.getNutzung() != null && n2.getNutzung() != null && n1.getNutzung().equals(n2.getNutzung()) || n1.getNutzung() == null && n2.getNutzung() == null)) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.NUTZUNG);
                }
                if (!(n1.getFlaeche() != null && n2.getFlaeche() != null && n1.getFlaeche().equals(n2.getFlaeche()) || n1.getFlaeche() == null && n2.getFlaeche() == null)) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.FLAECHE);
                }
                if (!(n1.getQuadratmeterpreis() != null && n2.getQuadratmeterpreis() != null && n1.getQuadratmeterpreis().equals(n2.getQuadratmeterpreis()) || n1.getQuadratmeterpreis() == null && n2.getQuadratmeterpreis() == null)) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.QUADRADMETERPREIS);
                }
                if (!(n1.getBemerkung() != null && n2.getBemerkung() != null && n1.getBemerkung().equals(n2.getBemerkung()) || n1.getBemerkung() == null && n2.getBemerkung() == null)) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.BEMERKUNG);
                }
                if (result.size() > 0) {
                    System.out.println("Nutzung pedanticEquals(): Einfache Felder sind unterschiedlich");
                } else {
                    System.out.println("Nutzung pedanticEquals(): Alle einfachen Felder sind gleich");
                }
                if (result.isEmpty()) {
                    System.out.println("Nutzung pedanticEquals(): Nutzungen sind gleich");
                } else {
                    System.out.println("Nutzung pedanticEquals(): Nutzungen sind ungleich: " + Arrays.deepToString(result.toArray()));
                }
            } else if (n1 != null) {
                result.addAll(this.checkNotZeroFields(n1));
            } else if (n2 != null) {
                result.addAll(this.checkNotZeroFields(n2));
            }
            return result;
        }

        private Collection<NUTZUNG_BUCHUNG_FIELDS> checkNotZeroFields(NutzungsBuchung buchung) {
            HashSet<NUTZUNG_BUCHUNG_FIELDS> result = new HashSet<NUTZUNG_BUCHUNG_FIELDS>();
            if (buchung != null) {
                if (buchung.getAnlageklasse() != null) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.ANLAGEKLASSE);
                }
                if (buchung.getNutzung() != null) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.NUTZUNG);
                }
                if (buchung.getNutzungsart() != null) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.NUTZUNGSART);
                }
                if (buchung.getFlaeche() != null) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.FLAECHE);
                }
                if (buchung.getQuadratmeterpreis() != null) {
                    result.add(NUTZUNG_BUCHUNG_FIELDS.QUADRADMETERPREIS);
                }
            }
            return result;
        }
    }

    public static enum NUTZUNG_BUCHUNG_FIELDS {
        ANLAGEKLASSE,
        NUTZUNG,
        NUTZUNGSART,
        FLAECHE,
        GUELTIG_BIS,
        QUADRADMETERPREIS,
        BEMERKUNG;

    }
}

