/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.lagis.gui.tables;

import javax.swing.UIManager;

/**
 * DOCUMENT ME!
 *
 * @author   gbaatz
 * @version  $Revision$, $Date$
 */
public class NKFRemoveNutzungDialog extends javax.swing.JDialog {

    //~ Static fields/initializers ---------------------------------------------

    public static final int REMOVE_WITHOUT_HISTORY_OPTION = 0;
    public static final int REMOVE_WITH_HISTORY_OPTION = 1;
    public static final int CANCEL_OPTION = 2;

    //~ Instance fields --------------------------------------------------------

    private int selectedValue = CANCEL_OPTION;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnHistory;
    private javax.swing.JButton btnNoHistory;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel lblImage;
    private javax.swing.JLabel lblMessage;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form NKFRemoveNutzungDialog.
     *
     * @param  nutzungIsTeminated  DOCUMENT ME!
     */
    public NKFRemoveNutzungDialog(final boolean nutzungIsTeminated) {
        super();
        initComponents();
        // Nutzung is terminated, thus historical. Therefore the Nutzung can only be removed completely.
        btnHistory.setEnabled(!nutzungIsTeminated);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        lblMessage = new javax.swing.JLabel();
        lblImage = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        btnNoHistory = new javax.swing.JButton();
        btnHistory = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Buchung löschen?"); // NOI18N
        setMaximumSize(new java.awt.Dimension(400, 120));
        setMinimumSize(new java.awt.Dimension(400, 120));
        setModal(true);
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(lblMessage, "Wollen Sie die Buchung löschen?"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel1.add(lblMessage, gridBagConstraints);

        lblImage.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        lblImage.setMaximumSize(new java.awt.Dimension(40, 40));
        lblImage.setMinimumSize(new java.awt.Dimension(40, 40));
        lblImage.setPreferredSize(new java.awt.Dimension(40, 40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 8);
        jPanel1.add(lblImage, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridLayout(1, 0, 7, 0));

        org.openide.awt.Mnemonics.setLocalizedText(btnNoHistory, "ohne Historie"); // NOI18N
        btnNoHistory.setMaximumSize(new java.awt.Dimension(100, 25));
        btnNoHistory.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnNoHistoryActionPerformed(evt);
                }
            });
        jPanel2.add(btnNoHistory);

        org.openide.awt.Mnemonics.setLocalizedText(btnHistory, "Historie anlegen"); // NOI18N
        btnHistory.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnHistoryActionPerformed(evt);
                }
            });
        jPanel2.add(btnHistory);

        org.openide.awt.Mnemonics.setLocalizedText(btnCancel, "Abbrechen"); // NOI18N
        btnCancel.setMaximumSize(new java.awt.Dimension(90, 25));
        btnCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCancelActionPerformed(evt);
                }
            });
        jPanel2.add(btnCancel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(8, 3, 3, 3);
        jPanel1.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 6, 10);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnNoHistoryActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnNoHistoryActionPerformed
        selectedValue = REMOVE_WITHOUT_HISTORY_OPTION;
        this.dispose();
    }                                                                                //GEN-LAST:event_btnNoHistoryActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCancelActionPerformed
        this.dispose();
    }                                                                             //GEN-LAST:event_btnCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnHistoryActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnHistoryActionPerformed
        selectedValue = REMOVE_WITH_HISTORY_OPTION;
        this.dispose();
    }                                                                              //GEN-LAST:event_btnHistoryActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public int getSelectedValue() {
        return selectedValue;
    }
}
