/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client;

import com.google.gwt.user.client.rpc.RemoteService;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.CompanyDTO;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.dto.ContractDocumentDTO;
import de.cismet.projecttracker.client.dto.CostCategoryDTO;
import de.cismet.projecttracker.client.dto.EstimatedComponentCostDTO;
import de.cismet.projecttracker.client.dto.EstimatedComponentCostMonthDTO;
import de.cismet.projecttracker.client.dto.FundingDTO;
import de.cismet.projecttracker.client.dto.ProjectBodyDTO;
import de.cismet.projecttracker.client.dto.ProjectCategoryDTO;
import de.cismet.projecttracker.client.dto.ProjectComponentTagDTO;
import de.cismet.projecttracker.client.dto.ProjectCostsDTO;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.dto.ProjectShortDTO;
import de.cismet.projecttracker.client.dto.RealOverheadDTO;
import de.cismet.projecttracker.client.dto.ReportDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.TravelDTO;
import de.cismet.projecttracker.client.dto.TravelDocumentDTO;
import de.cismet.projecttracker.client.dto.WorkCategoryDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.exceptions.DataRetrievalException;
import de.cismet.projecttracker.client.exceptions.FullStopException;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.exceptions.LoginFailedException;
import de.cismet.projecttracker.client.exceptions.NoSessionException;
import de.cismet.projecttracker.client.exceptions.PermissionDenyException;
import de.cismet.projecttracker.client.exceptions.PersistentLayerException;
import de.cismet.projecttracker.client.exceptions.ReportNotFoundException;
import de.cismet.projecttracker.client.types.ActivityResponseType;
import de.cismet.projecttracker.client.types.HolidayType;
import de.cismet.projecttracker.client.types.ReportType;
import de.cismet.projecttracker.client.types.TimePeriod;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public interface ProjectService
extends RemoteService {
    public ArrayList<ProjectShortDTO> getAllOngoingProjects() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<StaffDTO> getAllEmployees() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ProjectShortDTO> getAllCompletedProjects() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<TravelDTO> getAllTravels(long var1, long var3, int var5) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public void deleteProject(long var1) throws InvalidInputValuesException, PersistentLayerException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ProjectDTO getProject(long var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ProjectShortDTO createProject() throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ProjectDTO saveProject(ProjectDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<ProjectShortDTO> getAllProjects() throws InvalidInputValuesException, DataRetrievalException, NoSessionException;

    public ArrayList<ProjectCategoryDTO> getAllProjectCategories() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public WorkPackageDTO saveWorkPackage(WorkPackageDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public WorkPackageDTO createWorkPackage(WorkPackageDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteWorkPackage(WorkPackageDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public long createStaff(StaffDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public StaffDTO saveStaff(StaffDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteStaff(StaffDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public TravelDTO createTravelExpenseReport(TravelDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public TravelDTO saveTravelExpenseReport(TravelDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteTravelExpenseReport(TravelDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<StaffDTO> getCurrentEmployees() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<StaffDTO> getAllFormerEmployees() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public void changePassword(StaffDTO var1, String var2) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<CompanyDTO> getCompanies() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public void deleteContract(ContractDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public CompanyDTO saveCompany(CompanyDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public long createCompany(CompanyDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteCompany(CompanyDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteRealOverhead(RealOverheadDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<ProjectBodyDTO> getProjectBodies() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ProjectBodyDTO saveProjectBody(ProjectBodyDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public long createProjectBody(ProjectBodyDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteProjectBody(ProjectBodyDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public long createCostCategory(CostCategoryDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public CostCategoryDTO saveCostCategory(CostCategoryDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteCostCategory(CostCategoryDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public long createProjectComponentTag(ProjectComponentTagDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteProjectComponentTag(ProjectComponentTagDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<ProjectDTO> getAllProjectsFull() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public long createActivity(ActivityDTO var1) throws FullStopException, InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ActivityDTO saveActivity(ActivityDTO var1) throws FullStopException, InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteActivity(ActivityDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public Double getAccountBalance(StaffDTO var1) throws DataRetrievalException, NoSessionException, PermissionDenyException;

    public ArrayList<ActivityDTO> getActivitiesByWeek(StaffDTO var1, int var2, int var3) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ActivityDTO> getActivites(List<WorkPackageDTO> var1, List<StaffDTO> var2, Date var3, Date var4, String var5) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public Double getHoursSumForActivites(List<WorkPackageDTO> var1, List<StaffDTO> var2, Date var3, Date var4, String var5) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public Double getHoursSumForActivites(List<WorkPackageDTO> var1, List<StaffDTO> var2, Date var3, Date var4, String var5, ActivityDTO var6) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public Double getHoursSumForActivites(List<WorkPackageDTO> var1, List<StaffDTO> var2, Date var3, Date var4, String var5, ActivityDTO var6, boolean var7) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public HashMap<String, String> getProjectUrls() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ActivityDTO> getActivityByDay(StaffDTO var1, Date var2) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ActivityResponseType getActivityDataByWeek(StaffDTO var1, int var2, int var3) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ActivityResponseType getActivityDataByWeek(StaffDTO var1, Date var2, Date var3) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ActivityDTO> getActivitiesByProject(StaffDTO var1, ProjectDTO var2) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ActivityDTO> getActivitiesByWorkPackage(StaffDTO var1, WorkPackageDTO var2) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ActivityDTO> getActivitiesByWorkCategory(StaffDTO var1, WorkCategoryDTO var2) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public List<ActivityDTO> getFavouriteActivities(StaffDTO var1) throws NoSessionException, DataRetrievalException;

    public ActivityDTO getLastActivityForUser(StaffDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public List<ActivityDTO> getLastActivitiesForUser(StaffDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public List<ActivityDTO> getLastActivitiesExceptForUser(StaffDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ProjectCategoryDTO saveProjectCategory(ProjectCategoryDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public long createProjectCategory(ProjectCategoryDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteProjectCategory(ProjectCategoryDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public WorkCategoryDTO saveWorkCategory(WorkCategoryDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public long createWorkCategory(WorkCategoryDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteWorkCategory(WorkCategoryDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<WorkCategoryDTO> getWorkCategories() throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public WorkCategoryDTO getWorkCategory(long var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public Boolean isExisitingFavouriteTask(ActivityDTO var1);

    public Boolean isDayLocked(Date var1, StaffDTO var2);

    public long createProjectCosts(ProjectCostsDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ProjectCostsDTO saveProjectCosts(ProjectCostsDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteProjectCosts(ProjectCostsDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<ProjectCostsDTO> getProjectCostsByProject(ProjectDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ReportType> getAllAvailableReports() throws PermissionDenyException, NoSessionException;

    public ReportDTO createReport(String var1, Date var2, Date var3, long var4, String var6) throws InvalidInputValuesException, ReportNotFoundException, PersistentLayerException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public String checkReport(Date var1, Date var2, long var3, String var5) throws InvalidInputValuesException, ReportNotFoundException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public void deleteReport(ReportDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public List<ReportDTO> getReportsForActivities(List<ActivityDTO> var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public List<ReportDTO> getReportsForActivity(ActivityDTO var1) throws InvalidInputValuesException, DataRetrievalException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public Double getVacationCarryOver(Date var1, StaffDTO var2);

    public Double getVacationDaysTaken(Date var1, StaffDTO var2);

    public List<ActivityDTO> getVacationActivitiesTaken(Date var1, StaffDTO var2);

    public List<ActivityDTO> getVacationActivitiesPlanned(Date var1, StaffDTO var2);

    public Double getVacationDaysPlanned(Date var1, StaffDTO var2);

    public List<Date> getUnlockedDays(StaffDTO var1);

    public void deleteContractDocument(ContractDocumentDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteTravelDocument(TravelDocumentDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public ArrayList<ReportDTO> getAllCreatedReports(String var1, StaffDTO var2, int var3) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<EstimatedComponentCostDTO> getEstimatedWorkPackageCostForWP(WorkPackageDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<ContractDocumentDTO> getContractDocuments(ContractDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<TravelDocumentDTO> getTravelDocuments(TravelDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public ArrayList<FundingDTO> getFundingsForCompany(CompanyDTO var1) throws InvalidInputValuesException, DataRetrievalException, PermissionDenyException, NoSessionException;

    public FundingDTO createFunding(FundingDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public FundingDTO saveFunding(FundingDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public EstimatedComponentCostMonthDTO saveEstimatedWorkPackageCostMonth(EstimatedComponentCostMonthDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public EstimatedComponentCostMonthDTO createEstimatedWorkPackageCostMonth(EstimatedComponentCostMonthDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public EstimatedComponentCostDTO createEstimatedWorkPackageCost(EstimatedComponentCostDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public void deleteEstimatedWorkPackageCost(EstimatedComponentCostDTO var1) throws InvalidInputValuesException, PersistentLayerException, PermissionDenyException, NoSessionException;

    public StaffDTO login(String var1, String var2) throws InvalidInputValuesException, LoginFailedException, DataRetrievalException;

    public StaffDTO checkLogin() throws DataRetrievalException;

    public Boolean checkBeginOfDayActivityExists(StaffDTO var1);

    public void logout();

    public Integer getFirstReportYear() throws InvalidInputValuesException, DataRetrievalException;

    public Integer getFirstTravelYear() throws InvalidInputValuesException, DataRetrievalException;

    public Double getHoursOfWork(StaffDTO var1, Date var2) throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException;

    public Date getStartOfWork(StaffDTO var1, Date var2) throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException;

    public TimePeriod getStartEndOfWork(StaffDTO var1, Date var2) throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException;

    public List<HolidayType> getHolidaysByWeek(int var1, int var2) throws InvalidInputValuesException, DataRetrievalException;

    public List<HolidayType> getHolidaysByWeek(Date var1) throws InvalidInputValuesException, DataRetrievalException;

    public boolean isDataChanged() throws DataRetrievalException, NoSessionException, InvalidInputValuesException, PermissionDenyException, PersistentLayerException;

    public double getTotalVacationForYear(StaffDTO var1, Date var2);
}

