/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectServiceAsync;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.LoadingPanel;
import de.cismet.projecttracker.client.common.ui.listener.MenuListener;
import de.cismet.projecttracker.client.common.ui.listener.ServerDataChangeListener;
import de.cismet.projecttracker.client.dto.ContractDTO;
import de.cismet.projecttracker.client.dto.ProjectDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.exceptions.InvalidInputValuesException;
import de.cismet.projecttracker.client.helper.DateHelper;
import de.cismet.projecttracker.client.uicomps.SheetsPanel;
import de.cismet.projecttracker.client.uicomps.TopPanel;
import de.cismet.projecttracker.client.utilities.ChangeChecker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectTrackerEntryPoint
implements EntryPoint,
ValueChangeHandler,
ResizeHandler,
HasResizeHandlers,
ClickHandler,
ServerDataChangeListener {
    public static final int ADMIN_PERMISSION = 1;
    public static final int ORDER_PERMISSION = 2;
    private static ProjectTrackerEntryPoint currentInstance;
    public static String GRAVATAR_URL_PREFIX;
    private HandlerManager handlerManager = new HandlerManager((Object)this);
    private DockPanel outer = new DockPanel();
    private StaffDTO staff;
    private StaffDTO loggedInStaff;
    private boolean admin;
    private TopPanel topPanel = new TopPanel();
    private String activePanel = "Sheets";
    private SheetsPanel sheets = new SheetsPanel();
    private List<ProjectDTO> projects;
    private HashMap<String, String> projectUrls;
    private HandlerRegistration windowResize;
    private HandlerRegistration resize;

    public ProjectTrackerEntryPoint() {
        currentInstance = this;
        Window.addResizeHandler((ResizeHandler)this);
    }

    public static ProjectTrackerEntryPoint getInstance() {
        return currentInstance;
    }

    public void onModuleLoad() {
        String dayValue = Window.Location.getParameter((String)"day");
        GWT.setUncaughtExceptionHandler((GWT.UncaughtExceptionHandler)new /* Unavailable Anonymous Inner Class!! */);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void checkLogin() {
        3 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).checkLogin((AsyncCallback)callback);
    }

    public boolean isLoggedIn() {
        return this.loggedInStaff != null;
    }

    public void login(StaffDTO staff, boolean admin) {
        this.staff = staff;
        this.loggedInStaff = staff;
        this.admin = admin;
        this.topPanel.setLoggedIn(true, staff.getUsername());
        RootPanel.get((String)"contentId").add((Widget)this.sheets);
        this.validateSize();
        4 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getAllProjectsFull((AsyncCallback)callback);
        5 urlCallback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)false).getProjectUrls((AsyncCallback)urlCallback);
        this.sheets.setLockComponents();
        this.sheets.refresh();
        this.topPanel.addMenuListener((MenuListener)this.sheets);
        this.topPanel.addChangeListener((ChangeHandler)this.sheets);
        if (staff.getEmail() != null) {
            this.topPanel.setGravatar(GRAVATAR_URL_PREFIX + ProjectTrackerEntryPoint.md5((String)staff.getEmail()) + "?s=30");
        }
        this.topPanel.fillUser();
        ChangeChecker.getInstance().addListener((ServerDataChangeListener)this);
    }

    public void checkBeginOfDayBooking() {
    }

    public String getProjectUrlByWP(WorkPackageDTO workPackage) {
        String resultUrl = null;
        if (workPackage != null && this.projectUrls != null) {
            String projectName = workPackage.getProject().getName();
            String wpName = workPackage.getName();
            resultUrl = (String)this.projectUrls.get(projectName + "->" + wpName);
            if (resultUrl == null) {
                resultUrl = (String)this.projectUrls.get(projectName);
            }
        }
        if (resultUrl != null && !resultUrl.endsWith("/")) {
            resultUrl = resultUrl + "/";
        }
        return resultUrl;
    }

    public StaffDTO getStaff() {
        return this.staff;
    }

    public void setStaff(StaffDTO staff) {
        this.staff = staff;
    }

    public StaffDTO getLoggedInStaff() {
        return this.loggedInStaff;
    }

    public void setLoggedInStaff(StaffDTO staff) {
        this.loggedInStaff = staff;
    }

    public ContractDTO getContractForStaff(Date d) throws InvalidInputValuesException {
        if (d == null) {
            throw new InvalidInputValuesException("Date must not be null!");
        }
        ArrayList contracts = ProjectTrackerEntryPoint.getInstance().getStaff().getContracts();
        ContractDTO contract = null;
        for (ContractDTO c : contracts) {
            Date contractToDate = c.getTodate();
            Date contractFromDate = c.getFromdate();
            if (contractToDate == null) {
                contractToDate = new Date(d.getTime());
                DateHelper.addDays((Date)contractToDate, (int)7);
            }
            if (d.compareTo(contractToDate) > 0 || d.compareTo(contractFromDate) < 0) continue;
            contract = c;
        }
        return contract;
    }

    public ContractDTO getContractForStaff(int week, int year) throws InvalidInputValuesException {
        return this.getContractForStaff(DateHelper.getBeginOfWeek((int)year, (int)week));
    }

    public void validateSize() {
        this.resize(Window.getClientWidth(), Window.getClientHeight());
        ResizeEvent.fire((HasResizeHandlers)this, (int)Window.getClientWidth(), (int)Window.getClientHeight());
    }

    public static ProjectServiceAsync getProjectService(boolean showProgressBar) {
        if (showProgressBar) {
            LoadingPanel.getInstance().showLoadingAnimation();
        }
        return ProjectServiceAsync.Util.getInstance();
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public int getMaxWidth() {
        return Window.getClientWidth() - 10;
    }

    public int getMaxHeight() {
        return Window.getClientHeight();
    }

    public SheetsPanel getSheetsPanel() {
        return this.sheets;
    }

    private Widget getBasicScreen() {
        SheetsPanel sheets = new SheetsPanel();
        return sheets;
    }

    public static void outputBox(String msg) {
        Window.alert((String)msg);
    }

    public static boolean outputBoxConfirm(String msg) {
        return Window.confirm((String)msg);
    }

    public static native String md5(String var0);

    public static native String toggle();

    public static native String openSlackDiaryLink(String var0);

    public void output(String msg) {
    }

    private Widget getCenterPanel() {
        for (int i = 0; i < this.outer.getWidgetCount(); ++i) {
            Widget w = this.outer.getWidget(i);
            if (!this.outer.getWidgetDirection(w).equals(DockPanel.CENTER)) continue;
            return w;
        }
        return null;
    }

    public HandlerRegistration addResizeHandler(ResizeHandler handler) {
        return this.handlerManager.addHandler(ResizeEvent.getType(), (EventHandler)handler);
    }

    public void fireEvent(GwtEvent<?> event) {
        this.handlerManager.fireEvent(event);
    }

    public void onResize(ResizeEvent event) {
        this.resize(event.getWidth(), event.getHeight());
        this.validateSize();
    }

    private void resize(int width, int height) {
        Widget centerPanel = this.getCenterPanel();
        if (centerPanel != null) {
            int panelHeight = height - centerPanel.getAbsoluteTop() - 80;
            if (panelHeight < 1) {
                panelHeight = 1;
            }
            centerPanel.setHeight(panelHeight + "px");
        }
        int outerWidth = width - 20;
        this.outer.setWidth(outerWidth + "px");
        RootPanel p = RootPanel.get((String)"contentId");
        int newHeight = height - p.getAbsoluteTop() - 85;
        if (newHeight < 150) {
            newHeight = 150;
        }
        p.setHeight(newHeight + "px");
    }

    public void onClick(ClickEvent event) {
    }

    public void logout() {
        this.topPanel.setLoggedIn(false, "");
        RootPanel.get((String)"contentId").clear();
        this.topPanel.removeMenuListener((MenuListener)this.sheets);
        this.topPanel.removeUserList();
        this.windowResize.removeHandler();
        this.resize.removeHandler();
        this.sheets = new SheetsPanel();
        this.loggedInStaff = null;
        this.windowResize = Window.addResizeHandler((ResizeHandler)this.sheets);
        this.resize = this.addResizeHandler((ResizeHandler)this.sheets);
    }

    public void onValueChange(ValueChangeEvent event) {
        this.changePage(History.getToken());
    }

    private void changePage(String token) {
        RootPanel pan = RootPanel.get((String)(this.activePanel + "Id"));
        if (pan != null) {
            pan.setStyleName("inactive");
        }
        if ((pan = RootPanel.get((String)(token + "Id"))) != null) {
            pan.setStyleName("active");
        }
        ProjectTrackerEntryPoint.outputBox((String)token);
    }

    public List<ProjectDTO> getProjects() {
        return this.projects;
    }

    public void setProjects(List<ProjectDTO> projects) {
        this.projects = projects;
    }

    public void dataChanged() {
        this.checkBeginOfDayBooking();
        this.sheets.refresh();
    }

    static /* synthetic */ TopPanel access$000(ProjectTrackerEntryPoint x0) {
        return x0.topPanel;
    }

    static /* synthetic */ HandlerRegistration access$102(ProjectTrackerEntryPoint x0, HandlerRegistration x1) {
        x0.windowResize = x1;
        return x0.windowResize;
    }

    static /* synthetic */ SheetsPanel access$200(ProjectTrackerEntryPoint x0) {
        return x0.sheets;
    }

    static /* synthetic */ HandlerRegistration access$302(ProjectTrackerEntryPoint x0, HandlerRegistration x1) {
        x0.resize = x1;
        return x0.resize;
    }

    static /* synthetic */ List access$402(ProjectTrackerEntryPoint x0, List x1) {
        x0.projects = x1;
        return x0.projects;
    }

    static /* synthetic */ HashMap access$502(ProjectTrackerEntryPoint x0, HashMap x1) {
        x0.projectUrls = x1;
        return x0.projectUrls;
    }

    static {
        GRAVATAR_URL_PREFIX = "https://www.gravatar.com/avatar/";
    }
}

