/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.common.ui.DailyHoursOfWork;
import de.cismet.projecttracker.client.common.ui.Story;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.common.ui.event.TaskStoryEvent;
import de.cismet.projecttracker.client.common.ui.event.TimeStoryEvent;
import de.cismet.projecttracker.client.common.ui.listener.TaskStoryListener;
import de.cismet.projecttracker.client.common.ui.listener.TimeStoryListener;
import de.cismet.projecttracker.client.helper.DateHelper;
import java.util.Date;
import java.util.List;

public class DailyHoursOfWork
extends Composite
implements TimeStoryListener,
TaskStoryListener {
    private static DailyHoursOfWorkUiBinder uiBinder = (DailyHoursOfWorkUiBinder)GWT.create(DailyHoursOfWorkUiBinder.class);
    @UiField
    HTML monday;
    @UiField
    HTML tuesday;
    @UiField
    HTML wednesday;
    @UiField
    HTML thursday;
    @UiField
    HTML friday;
    @UiField
    HTML saturday;
    @UiField
    HTML sunday;
    @UiField
    AbsolutePanel boundaryPanel;
    private Date firstDayOfWeek = new Date();
    private Story story;
    private TaskStory taskStory;
    private HTML[] days;
    private boolean initialised = false;

    public DailyHoursOfWork() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.days = new HTML[7];
        this.days[0] = this.sunday;
        this.days[1] = this.monday;
        this.days[2] = this.tuesday;
        this.days[3] = this.wednesday;
        this.days[4] = this.thursday;
        this.days[5] = this.friday;
        this.days[6] = this.saturday;
    }

    public void timeNoticeCreated(TimeStoryEvent e) {
        this.fillLabel(e.getDay().getDay());
    }

    public void timeNoticeChanged(TimeStoryEvent e) {
        this.fillLabel(e.getDay().getDay());
    }

    public void timeNoticeDeleted(TimeStoryEvent e) {
        this.fillLabel(e.getDay().getDay());
    }

    public void taskNoticeCreated(TaskStoryEvent e) {
        this.fillLabel(e.getDay().getDay());
    }

    public void taskNoticeChanged(TaskStoryEvent e) {
        this.fillLabel(e.getDay().getDay());
    }

    public void taskNoticeDeleted(TaskStoryEvent e) {
        this.fillLabel(e.getDay().getDay());
    }

    public void initialise(Date firstDayOfWeek, Story time, TaskStory taskStory) {
        this.firstDayOfWeek = firstDayOfWeek;
        this.story = time;
        this.taskStory = taskStory;
        Date day = (Date)firstDayOfWeek.clone();
        this.monday.setHTML(this.getText(day.getDay()));
        DateHelper.addDays((Date)day, (int)1);
        this.tuesday.setHTML(this.getText(day.getDay()));
        DateHelper.addDays((Date)day, (int)1);
        this.wednesday.setHTML(this.getText(day.getDay()));
        DateHelper.addDays((Date)day, (int)1);
        this.thursday.setHTML(this.getText(day.getDay()));
        DateHelper.addDays((Date)day, (int)1);
        this.friday.setHTML(this.getText(day.getDay()));
        DateHelper.addDays((Date)day, (int)1);
        this.saturday.setHTML(this.getText(day.getDay()));
        DateHelper.addDays((Date)day, (int)1);
        this.sunday.setHTML(this.getText(day.getDay()));
        if (!this.initialised) {
            this.story.addTimeStoryListener((TimeStoryListener)this);
            taskStory.addTaskStoryListener((TaskStoryListener)this);
            this.initialised = true;
        }
    }

    private void fillLabel(int day) {
        this.days[day].setHTML(this.getText(day));
    }

    private String getText(int day) {
        double hours = this.story.getTimeForDay(day);
        double hoursWorked = 0.0;
        List tasks = this.taskStory.getTasksForDay(day);
        for (TaskNotice tmp : tasks) {
            if (tmp.getActivity() == null || tmp.getActivity().getWorkPackage() == null || tmp.getActivity().getWorkPackage().getProject() == null) continue;
            if (tmp.getActivity().getWorkPackage().getId() == 408L || tmp.getActivity().getWorkPackage().getId() == 407L) {
                hours -= tmp.getActivity().getWorkinghours();
                continue;
            }
            if (tmp.getActivity().getWorkPackage().getId() == 409L || tmp.getActivity().getWorkPackage().getId() == 410L || tmp.getActivity().getWorkPackage().getId() == 411L || tmp.getActivity().getWorkPackage().getId() == 419L || tmp.getActivity().getWorkPackage().getId() == 414L) continue;
            hoursWorked += tmp.getActivity().getWorkinghours();
        }
        return DateHelper.doubleToHours((double)hours) + " (" + DateHelper.doubleToHours((double)(hours - hoursWorked)) + ")";
    }
}

