/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.projecttracker.client.common.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimpleCheckBox;
import com.google.gwt.user.client.ui.Widget;
import de.cismet.projecttracker.client.ProjectTrackerEntryPoint;
import de.cismet.projecttracker.client.common.ui.LockPanel;
import de.cismet.projecttracker.client.common.ui.Story;
import de.cismet.projecttracker.client.common.ui.TaskNotice;
import de.cismet.projecttracker.client.common.ui.TaskStory;
import de.cismet.projecttracker.client.common.ui.TimeNotice;
import de.cismet.projecttracker.client.dto.ActivityDTO;
import de.cismet.projecttracker.client.dto.StaffDTO;
import de.cismet.projecttracker.client.dto.WorkPackageDTO;
import de.cismet.projecttracker.client.dto.WorkPackagePeriodDTO;
import de.cismet.projecttracker.client.helper.DateHelper;
import de.cismet.projecttracker.client.listener.BasicAsyncCallback;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LockPanel
extends Composite
implements ClickHandler {
    private static LockPanelUiBinder uiBinder = (LockPanelUiBinder)GWT.create(LockPanelUiBinder.class);
    private static final String CHECKBOX_TOOLTIP = "Select this box to lock the corresponding day. If you lock a day, you cannot change the activities of this day until an administrator unlocks the day.";
    @UiField
    SimpleCheckBox monday;
    @UiField
    SimpleCheckBox tuesday;
    @UiField
    SimpleCheckBox wednesday;
    @UiField
    SimpleCheckBox thursday;
    @UiField
    SimpleCheckBox friday;
    @UiField
    SimpleCheckBox saturday;
    @UiField
    SimpleCheckBox sunday;
    @UiField
    AbsolutePanel boundaryPanel;
    private SimpleCheckBox[] days = new SimpleCheckBox[7];
    private TaskStory taskStory;
    private Date firstDayOfWeek;
    private Story times;
    private SimpleCheckBox weekLockCB;
    private ArrayList<SimpleCheckBox> lockedDays = new ArrayList();
    private Button prevWeekBtn;
    private Button nextWeekBtn;

    public LockPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.days[0] = this.sunday;
        this.days[1] = this.monday;
        this.days[2] = this.tuesday;
        this.days[3] = this.wednesday;
        this.days[4] = this.thursday;
        this.days[5] = this.friday;
        this.days[6] = this.saturday;
        this.monday.addClickHandler((ClickHandler)this);
        this.tuesday.addClickHandler((ClickHandler)this);
        this.wednesday.addClickHandler((ClickHandler)this);
        this.thursday.addClickHandler((ClickHandler)this);
        this.friday.addClickHandler((ClickHandler)this);
        this.saturday.addClickHandler((ClickHandler)this);
        this.sunday.addClickHandler((ClickHandler)this);
        this.monday.setTitle(CHECKBOX_TOOLTIP);
        this.tuesday.setTitle(CHECKBOX_TOOLTIP);
        this.wednesday.setTitle(CHECKBOX_TOOLTIP);
        this.thursday.setTitle(CHECKBOX_TOOLTIP);
        this.friday.setTitle(CHECKBOX_TOOLTIP);
        this.saturday.setTitle(CHECKBOX_TOOLTIP);
        this.sunday.setTitle(CHECKBOX_TOOLTIP);
    }

    public void onClick(ClickEvent event) {
        int offset = 0;
        Date day = new Date(this.firstDayOfWeek.getTime());
        if (event.getSource() == this.monday) {
            offset = 0;
        } else if (event.getSource() == this.tuesday) {
            offset = 1;
        } else if (event.getSource() == this.wednesday) {
            offset = 2;
        } else if (event.getSource() == this.thursday) {
            offset = 3;
        } else if (event.getSource() == this.friday) {
            offset = 4;
        } else if (event.getSource() == this.saturday) {
            offset = 5;
        } else if (event.getSource() == this.sunday) {
            offset = 6;
        }
        DateHelper.addDays((Date)day, (int)offset);
        this.handleClick(day);
    }

    private void unlockDay(Date day) {
        SimpleCheckBox lockCB = this.days[day.getDay()];
        this.setDisabledStatusVisible(day, false);
        lockCB.setEnabled(true);
        StaffDTO staff = ProjectTrackerEntryPoint.getInstance().getStaff();
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        ProjectTrackerEntryPoint.getProjectService((boolean)true).getActivityByDay(staff, day, (AsyncCallback)callback);
    }

    public void refuseLock(Date day) {
        SimpleCheckBox lockCB = this.days[day.getDay()];
        lockCB.setValue(Boolean.valueOf(false));
        this.lockedDays.remove(lockCB);
        this.weekLockCB.setValue(Boolean.valueOf(false));
        this.weekLockCB.setEnabled(true);
        this.unlockDay(day);
        ProjectTrackerEntryPoint.outputBox((String)"Pause Policy is not fulfilled! Can not lock this day.");
    }

    private void setWeekButtonsEnabled(Boolean flag) {
        this.prevWeekBtn.setEnabled(flag.booleanValue());
        this.nextWeekBtn.setEnabled(flag.booleanValue());
    }

    private void handleClick(Date day) {
        SimpleCheckBox lockCB = this.days[day.getDay()];
        lockCB.setEnabled(false);
        if (!lockCB.getValue().booleanValue()) {
            if (ProjectTrackerEntryPoint.getInstance().isAdmin()) {
                this.lockedDays.remove(lockCB);
                this.weekLockCB.setValue(Boolean.valueOf(false));
                this.weekLockCB.setEnabled(true);
                this.unlockDay(day);
            }
        } else {
            if (!this.checkWorkpackagePeriods(day)) {
                lockCB.setEnabled(true);
                lockCB.setValue(Boolean.valueOf(false));
                return;
            }
            if (!this.checkTimeSlots(day)) {
                ProjectTrackerEntryPoint.outputBox((String)"The working time of the activites does not match the time for this day. You have to correct in order to lock this day");
                lockCB.setEnabled(true);
                lockCB.setValue(Boolean.valueOf(false));
            } else {
                this.performLock(day);
            }
        }
    }

    private boolean checkTimeSlots(Date day) {
        double hours = this.times.getTimeForDay(day.getDay());
        double hoursWorked = 0.0;
        List tasks = this.taskStory.getTasksForDay(day.getDay());
        boolean justAbsenceTasks = true;
        for (TaskNotice tmp : tasks) {
            if (tmp.getActivity() == null || tmp.getActivity().getWorkPackage() == null || tmp.getActivity().getWorkPackage().getProject() == null) continue;
            if (tmp.getActivity().getWorkPackage().getId() == 408L || tmp.getActivity().getWorkPackage().getId() == 407L) {
                hours -= tmp.getActivity().getWorkinghours();
                justAbsenceTasks = false;
                continue;
            }
            if (tmp.getActivity().getWorkPackage().getId() == 409L || tmp.getActivity().getWorkPackage().getId() == 410L || tmp.getActivity().getWorkPackage().getId() == 419L || tmp.getActivity().getWorkPackage().getId() == 411L) continue;
            hoursWorked += tmp.getActivity().getWorkinghours();
            justAbsenceTasks = false;
        }
        return justAbsenceTasks || !(Math.abs(hours - hoursWorked) > 0.016666666666666666);
    }

    private void performLock(Date day) {
        SimpleCheckBox lockCB = this.days[day.getDay()];
        ActivityDTO lockedDayActivity = new ActivityDTO();
        lockedDayActivity.setKindofactivity(3);
        Date d = new Date(day.getTime());
        d.setHours(5);
        lockedDayActivity.setDay(d);
        lockedDayActivity.setStaff(ProjectTrackerEntryPoint.getInstance().getStaff());
        lockedDayActivity.setCommitted(false);
        BasicAsyncCallback callback = new BasicAsyncCallback();
        ProjectTrackerEntryPoint.getProjectService((boolean)true).createActivity(lockedDayActivity, (AsyncCallback)callback);
        this.lockedDays.add(lockCB);
        if (this.lockedDays.size() == this.days.length) {
            this.weekLockCB.setValue(Boolean.valueOf(true));
            if (!ProjectTrackerEntryPoint.getInstance().isAdmin()) {
                this.weekLockCB.setEnabled(false);
            }
        }
        lockCB.setValue(Boolean.TRUE);
        if (!ProjectTrackerEntryPoint.getInstance().isAdmin()) {
            lockCB.setEnabled(false);
        } else {
            lockCB.setEnabled(true);
        }
        this.setDisabledStatusVisible(day, true);
    }

    public void setLocked(Date day, Boolean aFlag) {
        SimpleCheckBox lockCB = this.days[day.getDay()];
        if (aFlag.booleanValue()) {
            this.lockedDays.add(lockCB);
            if (this.lockedDays.size() == this.days.length) {
                this.weekLockCB.setValue(Boolean.valueOf(true));
                if (!ProjectTrackerEntryPoint.getInstance().isAdmin()) {
                    this.weekLockCB.setEnabled(false);
                }
            }
            lockCB.setValue(aFlag);
            if (!ProjectTrackerEntryPoint.getInstance().isAdmin()) {
                lockCB.setEnabled(false);
            }
            this.setDisabledStatusVisible(day, true);
        } else {
            this.lockedDays.remove(lockCB);
            this.weekLockCB.setValue(Boolean.valueOf(false));
            this.weekLockCB.setEnabled(true);
            lockCB.setValue(Boolean.valueOf(false));
            lockCB.setEnabled(true);
            this.setDisabledStatusVisible(day, false);
        }
    }

    public void initialise(Date firstDayOfWeek, TaskStory story, Story times, SimpleCheckBox weekLockCB, Button prevWeek, Button nextWeek) {
        this.taskStory = story;
        this.times = times;
        this.firstDayOfWeek = firstDayOfWeek;
        this.weekLockCB = weekLockCB;
        this.prevWeekBtn = prevWeek;
        this.nextWeekBtn = nextWeek;
    }

    private boolean checkWorkpackagePeriods(Date d) {
        List tasks = this.taskStory.getTasksForDay(d.getDay());
        for (TaskNotice tn : tasks) {
            WorkPackagePeriodDTO period;
            WorkPackageDTO tmp = tn.getActivity().getWorkPackage();
            if (tmp == null || (period = tmp.determineMostRecentPeriod()) == null || DateHelper.isDayInWorkPackagePeriod((Date)d, (WorkPackagePeriodDTO)period)) continue;
            if (tmp.getExpirationDescription() != null && !tmp.getExpirationDescription().equals("")) {
                ProjectTrackerEntryPoint.outputBox((String)("The workpackage \"" + tmp.getName() + "\" for the task: \"" + tn.getActivity().getDescription() + "\" is expired. The administrators adice is: " + tmp.getExpirationDescription()));
            } else {
                ProjectTrackerEntryPoint.outputBox((String)("The workpackage \"" + tmp.getName() + "\" for the task: \"" + tn.getActivity().getDescription() + "\" is expired. Please contact the administrator for further instructions."));
            }
            return false;
        }
        return true;
    }

    public void lockAllDaysInWeek() {
        this.setWeekButtonsEnabled(Boolean.valueOf(false));
        Date d = new Date(this.firstDayOfWeek.getTime());
        Date sunday = new Date(d.getTime());
        ArrayList<Date> faultyTimeSlotsDays = new ArrayList<Date>();
        DateHelper.addDays((Date)sunday, (int)6);
        for (int i = 0; i < this.days.length; ++i) {
            if (!this.checkWorkpackagePeriods(i == 0 ? sunday : d)) {
                this.weekLockCB.setValue(Boolean.valueOf(false));
                this.weekLockCB.setEnabled(true);
                this.setWeekButtonsEnabled(Boolean.valueOf(true));
                return;
            }
            if (i == 0) {
                if (this.checkTimeSlots(sunday)) continue;
                faultyTimeSlotsDays.add(sunday);
                continue;
            }
            if (!this.checkTimeSlots(d)) {
                faultyTimeSlotsDays.add(new Date(d.getTime()));
            }
            DateHelper.addDays((Date)d, (int)1);
        }
        if (!faultyTimeSlotsDays.isEmpty()) {
            String timeSlotNotCorrectDays = "";
            for (Date tmp : faultyTimeSlotsDays) {
                if (faultyTimeSlotsDays.indexOf(tmp) == faultyTimeSlotsDays.size() - 1) {
                    timeSlotNotCorrectDays = timeSlotNotCorrectDays + DateHelper.getDayAbbreviation((Date)tmp) + ".";
                    continue;
                }
                timeSlotNotCorrectDays = timeSlotNotCorrectDays + DateHelper.getDayAbbreviation((Date)tmp) + ", ";
            }
            ProjectTrackerEntryPoint.outputBox((String)("Can not lock the week. For the following days the times have to be corrected: " + timeSlotNotCorrectDays));
            this.weekLockCB.setValue(Boolean.valueOf(false));
            this.weekLockCB.setEnabled(true);
            this.setWeekButtonsEnabled(Boolean.valueOf(true));
            return;
        }
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        Date lastDayOfWeek = new Date(this.firstDayOfWeek.getTime());
        DateHelper.addDays((Date)lastDayOfWeek, (int)7);
        Date day = new Date(this.firstDayOfWeek.getTime());
        Date startSunday = new Date(day.getTime());
        DateHelper.addDays((Date)startSunday, (int)6);
        for (int i = 0; i < this.days.length; ++i) {
            SimpleCheckBox cb = this.days[i];
            if (i == 0) {
                if (cb.getValue().booleanValue()) continue;
                this.performLock(startSunday);
                continue;
            }
            if (!cb.getValue().booleanValue()) {
                this.performLock(day);
            }
            DateHelper.addDays((Date)day, (int)1);
        }
        if (!ProjectTrackerEntryPoint.getInstance().isAdmin()) {
            this.weekLockCB.setEnabled(false);
        } else {
            this.weekLockCB.setEnabled(true);
        }
        this.setWeekButtonsEnabled(Boolean.valueOf(true));
    }

    public void unlockAllDaysInWeek() {
        this.setWeekButtonsEnabled(Boolean.valueOf(false));
        Date d = new Date(this.firstDayOfWeek.getTime());
        Date sunday = new Date(d.getTime());
        DateHelper.addDays((Date)sunday, (int)6);
        this.lockedDays.removeAll(this.lockedDays);
        this.weekLockCB.setValue(Boolean.valueOf(false));
        for (int i = 0; i < this.days.length; ++i) {
            SimpleCheckBox cb = this.days[i];
            cb.setValue(Boolean.valueOf(false));
            if (i == 0) {
                this.unlockDay(sunday);
                continue;
            }
            this.unlockDay(d);
            DateHelper.addDays((Date)d, (int)1);
        }
        this.setWeekButtonsEnabled(Boolean.valueOf(true));
        this.weekLockCB.setEnabled(true);
    }

    private void setDisabledStatusVisible(Date day, boolean disabledStatus) {
        ArrayList tasks = (ArrayList)this.taskStory.getTasksForDay(day.getDay());
        for (TaskNotice tn : tasks) {
            tn.setCloseButtonVisible(!disabledStatus);
            if (disabledStatus) {
                tn.addStyleName("lockedDay");
                continue;
            }
            tn.removeStyleName("lockedDay");
        }
        List timeSlots = this.times.getTimeNoticesForDay(day.getDay());
        for (TimeNotice slot : timeSlots) {
            slot.setEnabled(!disabledStatus);
            if (disabledStatus) {
                slot.addStyleName("lockedDay");
                continue;
            }
            slot.removeStyleName("lockedDay");
        }
    }

    static /* synthetic */ Date access$000(LockPanel x0) {
        return x0.firstDayOfWeek;
    }

    static /* synthetic */ SimpleCheckBox[] access$100(LockPanel x0) {
        return x0.days;
    }

    static /* synthetic */ void access$200(LockPanel x0, Date x1) {
        x0.performLock(x1);
    }

    static /* synthetic */ SimpleCheckBox access$300(LockPanel x0) {
        return x0.weekLockCB;
    }

    static /* synthetic */ void access$400(LockPanel x0, Boolean x1) {
        x0.setWeekButtonsEnabled(x1);
    }
}

